/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

public class StringSet {
    public String[] values;
    public int elementSize = 0;
    public int threshold;

    public StringSet(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.5f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.values = new String[n2];
    }

    public boolean add(String string) {
        String string2;
        int n = this.values.length;
        int n2 = (string.hashCode() & Integer.MAX_VALUE) % n;
        while ((string2 = this.values[n2]) != null) {
            if (string.equals(string2)) {
                return false;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.values[n2] = string;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return true;
    }

    public void clear() {
        int n = this.values.length;
        while (--n >= 0) {
            this.values[n] = null;
        }
        this.elementSize = 0;
    }

    public boolean includes(String string) {
        String string2;
        int n = this.values.length;
        int n2 = (string.hashCode() & Integer.MAX_VALUE) % n;
        while ((string2 = this.values[n2]) != null) {
            if (string.equals(string2)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    private void rehash() {
        StringSet stringSet = new StringSet(this.elementSize * 2);
        int n = this.values.length;
        while (--n >= 0) {
            String string = this.values[n];
            if (string == null) continue;
            stringSet.add(string);
        }
        this.values = stringSet.values;
        this.elementSize = stringSet.elementSize;
        this.threshold = stringSet.threshold;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.values.length;
        while (n < n2) {
            String string2 = this.values[n];
            if (string2 != null) {
                string = String.valueOf(string) + string2 + "\n";
            }
            ++n;
        }
        return string;
    }
}

