/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;

public abstract class LineInformation {
    public static LineInformation create(final IDocument iDocument) {
        return new LineInformation(){

            public int getLineOfOffset(int n) {
                try {
                    return iDocument.getLineOfOffset(n);
                }
                catch (BadLocationException badLocationException) {
                    return -1;
                }
            }

            public int getLineOffset(int n) {
                try {
                    return iDocument.getLineOffset(n);
                }
                catch (BadLocationException badLocationException) {
                    return -1;
                }
            }
        };
    }

    public static LineInformation create(final CompilationUnit compilationUnit) {
        return new LineInformation(){

            public int getLineOfOffset(int n) {
                return compilationUnit.getLineNumber(n) - 1;
            }

            public int getLineOffset(int n) {
                return compilationUnit.getPosition(n + 1, 0);
            }
        };
    }

    public abstract int getLineOfOffset(int var1);

    public abstract int getLineOffset(int var1);
}

