/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.SimpleDelta;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;

public class ChangeCollector {
    HashMap changes = new HashMap();
    TypeHierarchy hierarchy;

    public ChangeCollector(TypeHierarchy typeHierarchy) {
        this.hierarchy = typeHierarchy;
    }

    private void addAffectedChildren(IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        IJavaElementDelta[] iJavaElementDeltaArray = iJavaElementDelta.getAffectedChildren();
        int n = 0;
        int n2 = iJavaElementDeltaArray.length;
        while (n < n2) {
            IJavaElementDelta iJavaElementDelta2 = iJavaElementDeltaArray[n];
            IJavaElement iJavaElement = iJavaElementDelta2.getElement();
            switch (iJavaElement.getElementType()) {
                case 12: {
                    this.addChange((IImportContainer)iJavaElement, iJavaElementDelta2);
                    break;
                }
                case 13: {
                    this.addChange((IImportDeclaration)iJavaElement, iJavaElementDelta2);
                    break;
                }
                case 7: {
                    this.addChange((IType)iJavaElement, iJavaElementDelta2);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.addChange((IMember)iJavaElement, iJavaElementDelta2);
                }
            }
            ++n;
        }
    }

    public void addChange(ICompilationUnit iCompilationUnit, IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        int n = iJavaElementDelta.getKind();
        switch (n) {
            case 1: {
                ArrayList arrayList = new ArrayList();
                this.getAllTypesFromElement(iCompilationUnit, arrayList);
                int n2 = 0;
                int n3 = arrayList.size();
                while (n2 < n3) {
                    IType iType = (IType)arrayList.get(n2);
                    this.addTypeAddition(iType, (SimpleDelta)this.changes.get(iType));
                    ++n2;
                }
                break;
            }
            case 2: {
                ArrayList arrayList = new ArrayList();
                this.getAllTypesFromHierarchy((JavaElement)((Object)iCompilationUnit), arrayList);
                int n4 = 0;
                int n5 = arrayList.size();
                while (n4 < n5) {
                    IType iType = (IType)arrayList.get(n4);
                    this.addTypeRemoval(iType, (SimpleDelta)this.changes.get(iType));
                    ++n4;
                }
                break;
            }
            case 4: {
                this.addAffectedChildren(iJavaElementDelta);
            }
        }
    }

    private void addChange(IImportContainer iImportContainer, IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        block14: {
            int n;
            block13: {
                n = iJavaElementDelta.getKind();
                if (n == 4) {
                    this.addAffectedChildren(iJavaElementDelta);
                    return;
                }
                SimpleDelta simpleDelta = (SimpleDelta)this.changes.get(iImportContainer);
                if (simpleDelta == null) break block13;
                switch (n) {
                    case 1: {
                        if (simpleDelta.getKind() == 2) {
                            this.changes.remove(iImportContainer);
                            break;
                        }
                        break block14;
                    }
                    case 2: {
                        if (simpleDelta.getKind() != 1) break block14;
                        this.changes.remove(iImportContainer);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block14;
            }
            SimpleDelta simpleDelta = new SimpleDelta();
            switch (n) {
                case 1: {
                    simpleDelta.added();
                    break;
                }
                case 2: {
                    simpleDelta.removed();
                }
            }
            this.changes.put(iImportContainer, simpleDelta);
        }
    }

    private void addChange(IImportDeclaration iImportDeclaration, IJavaElementDelta iJavaElementDelta) {
        block13: {
            int n;
            block12: {
                SimpleDelta simpleDelta = (SimpleDelta)this.changes.get(iImportDeclaration);
                n = iJavaElementDelta.getKind();
                if (simpleDelta == null) break block12;
                switch (n) {
                    case 1: {
                        if (simpleDelta.getKind() == 2) {
                            this.changes.remove(iImportDeclaration);
                            break;
                        }
                        break block13;
                    }
                    case 2: {
                        if (simpleDelta.getKind() != 1) break block13;
                        this.changes.remove(iImportDeclaration);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block13;
            }
            SimpleDelta simpleDelta = new SimpleDelta();
            switch (n) {
                case 1: {
                    simpleDelta.added();
                    break;
                }
                case 2: {
                    simpleDelta.removed();
                }
            }
            this.changes.put(iImportDeclaration, simpleDelta);
        }
    }

    private void addChange(IMember iMember, IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        int n = iJavaElementDelta.getKind();
        switch (n) {
            case 1: {
                ArrayList arrayList = new ArrayList();
                this.getAllTypesFromElement(iMember, arrayList);
                int n2 = 0;
                int n3 = arrayList.size();
                while (n2 < n3) {
                    IType iType = (IType)arrayList.get(n2);
                    this.addTypeAddition(iType, (SimpleDelta)this.changes.get(iType));
                    ++n2;
                }
                break;
            }
            case 2: {
                ArrayList arrayList = new ArrayList();
                this.getAllTypesFromHierarchy((JavaElement)((Object)iMember), arrayList);
                int n4 = 0;
                int n5 = arrayList.size();
                while (n4 < n5) {
                    IType iType = (IType)arrayList.get(n4);
                    this.addTypeRemoval(iType, (SimpleDelta)this.changes.get(iType));
                    ++n4;
                }
                break;
            }
            case 4: {
                this.addAffectedChildren(iJavaElementDelta);
            }
        }
    }

    private void addChange(IType iType, IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        int n = iJavaElementDelta.getKind();
        SimpleDelta simpleDelta = (SimpleDelta)this.changes.get(iType);
        switch (n) {
            case 1: {
                this.addTypeAddition(iType, simpleDelta);
                ArrayList arrayList = new ArrayList();
                this.getAllTypesFromElement(iType, arrayList);
                int n2 = 0;
                int n3 = arrayList.size();
                while (n2 < n3) {
                    IType iType2 = (IType)arrayList.get(n2);
                    this.addTypeAddition(iType2, (SimpleDelta)this.changes.get(iType2));
                    ++n2;
                }
                break;
            }
            case 2: {
                this.addTypeRemoval(iType, simpleDelta);
                ArrayList arrayList = new ArrayList();
                this.getAllTypesFromHierarchy((JavaElement)((Object)iType), arrayList);
                int n4 = 0;
                int n5 = arrayList.size();
                while (n4 < n5) {
                    IType iType3 = (IType)arrayList.get(n4);
                    this.addTypeRemoval(iType3, (SimpleDelta)this.changes.get(iType3));
                    ++n4;
                }
                break;
            }
            case 4: {
                this.addTypeChange(iType, iJavaElementDelta.getFlags(), simpleDelta);
                this.addAffectedChildren(iJavaElementDelta);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addTypeAddition(IType iType, SimpleDelta simpleDelta) throws JavaModelException {
        if (simpleDelta != null) {
            switch (simpleDelta.getKind()) {
                case 2: {
                    boolean bl = false;
                    if (this.hasSuperTypeChange(iType)) {
                        simpleDelta.superTypes();
                        bl = true;
                    }
                    if (this.hasVisibilityChange(iType)) {
                        simpleDelta.modifiers();
                        return;
                    }
                    if (bl) return;
                    this.changes.remove(iType);
                }
                default: {
                    return;
                }
            }
        } else {
            String string = iType.getElementName();
            if (!this.hierarchy.hasSupertype(string) && !this.hierarchy.subtypesIncludeSupertypeOf(iType)) {
                if (!this.hierarchy.missingTypes.contains(string)) return;
            }
            SimpleDelta simpleDelta2 = new SimpleDelta();
            simpleDelta2.added();
            this.changes.put(iType, simpleDelta2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addTypeChange(IType iType, int n, SimpleDelta simpleDelta) throws JavaModelException {
        if (simpleDelta != null) {
            switch (simpleDelta.getKind()) {
                case 4: {
                    int n2 = simpleDelta.getFlags();
                    boolean bl = false;
                    if ((n2 & 0x800) != 0 && this.hasSuperTypeChange(iType)) {
                        simpleDelta.superTypes();
                        bl = true;
                    }
                    if ((n2 & 2) != 0 && this.hasVisibilityChange(iType)) {
                        simpleDelta.modifiers();
                        return;
                    }
                    if (bl) return;
                    this.changes.remove(iType);
                }
                default: {
                    return;
                }
            }
        } else {
            SimpleDelta simpleDelta2 = null;
            if ((n & 0x800) != 0 && this.hierarchy.includesTypeOrSupertype(iType)) {
                simpleDelta2 = new SimpleDelta();
                simpleDelta2.superTypes();
            }
            if ((n & 2) != 0 && (this.hierarchy.hasSupertype(iType.getElementName()) || iType.equals(this.hierarchy.focusType))) {
                if (simpleDelta2 == null) {
                    simpleDelta2 = new SimpleDelta();
                }
                simpleDelta2.modifiers();
            }
            if (simpleDelta2 == null) return;
            this.changes.put(iType, simpleDelta2);
        }
    }

    private void addTypeRemoval(IType iType, SimpleDelta simpleDelta) {
        if (simpleDelta != null) {
            switch (simpleDelta.getKind()) {
                case 1: {
                    this.changes.remove(iType);
                    break;
                }
                case 4: {
                    simpleDelta.removed();
                }
            }
        } else if (this.hierarchy.contains(iType)) {
            SimpleDelta simpleDelta2 = new SimpleDelta();
            simpleDelta2.removed();
            this.changes.put(iType, simpleDelta2);
        }
    }

    private void getAllTypesFromElement(IJavaElement iJavaElement, ArrayList arrayList) throws JavaModelException {
        switch (iJavaElement.getElementType()) {
            case 5: {
                IType[] iTypeArray = ((ICompilationUnit)iJavaElement).getTypes();
                int n = 0;
                int n2 = iTypeArray.length;
                while (n < n2) {
                    IType iType = iTypeArray[n];
                    arrayList.add(iType);
                    this.getAllTypesFromElement(iType, arrayList);
                    ++n;
                }
                break;
            }
            case 7: {
                IType[] iTypeArray = ((IType)iJavaElement).getTypes();
                int n = 0;
                int n3 = iTypeArray.length;
                while (n < n3) {
                    IType iType = iTypeArray[n];
                    arrayList.add(iType);
                    this.getAllTypesFromElement(iType, arrayList);
                    ++n;
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                IJavaElement[] iJavaElementArray = ((IMember)iJavaElement).getChildren();
                int n = 0;
                int n4 = iJavaElementArray.length;
                while (n < n4) {
                    IType iType = (IType)iJavaElementArray[n];
                    arrayList.add(iType);
                    this.getAllTypesFromElement(iType, arrayList);
                    ++n;
                }
                break;
            }
        }
    }

    private void getAllTypesFromHierarchy(JavaElement javaElement, ArrayList arrayList) {
        switch (javaElement.getElementType()) {
            case 5: {
                ArrayList arrayList2 = (ArrayList)this.hierarchy.files.get(javaElement);
                if (arrayList2 == null) break;
                arrayList.addAll(arrayList2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                ArrayList arrayList3 = (ArrayList)this.hierarchy.files.get(((IMember)((Object)javaElement)).getCompilationUnit());
                if (arrayList3 == null) break;
                int n = 0;
                int n2 = arrayList3.size();
                while (n < n2) {
                    IType iType = (IType)arrayList3.get(n);
                    if (javaElement.isAncestorOf(iType)) {
                        arrayList.add(iType);
                    }
                    ++n;
                }
                break;
            }
        }
    }

    private boolean hasSuperTypeChange(IType iType) throws JavaModelException {
        String[] stringArray;
        IType iType2 = this.hierarchy.getSuperclass(iType);
        String string = iType2 == null ? null : iType2.getElementName();
        String string2 = iType.getSuperclassName();
        if (string != null && !string.equals(string2)) {
            return true;
        }
        IType[] iTypeArray = this.hierarchy.getSuperInterfaces(iType);
        if (iTypeArray.length != (stringArray = iType.getSuperInterfaceNames()).length) {
            return true;
        }
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String string3 = stringArray[n];
            if (!string3.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasVisibilityChange(IType iType) throws JavaModelException {
        int n;
        int n2 = this.hierarchy.getCachedFlags(iType);
        return n2 != (n = iType.getFlags());
    }

    public boolean needsRefresh() {
        return this.changes.size() != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.changes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(((JavaElement)entry.getKey()).toDebugString());
            stringBuffer.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

