/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.IGenericType;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryType;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyType;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.util.ResourceCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public abstract class HierarchyBuilder {
    protected TypeHierarchy hierarchy;
    protected NameLookup nameLookup;
    protected HierarchyResolver hierarchyResolver;
    protected Map infoToHandle;
    protected String focusQualifiedName;

    public HierarchyBuilder(TypeHierarchy typeHierarchy) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray;
        this.hierarchy = typeHierarchy;
        JavaProject javaProject = (JavaProject)typeHierarchy.javaProject();
        IType iType = typeHierarchy.getType();
        ICompilationUnit iCompilationUnit = iType == null ? null : iType.getCompilationUnit();
        ICompilationUnit[] iCompilationUnitArray2 = this.hierarchy.workingCopies;
        if (iCompilationUnit != null) {
            int n;
            int n2 = n = iCompilationUnitArray2 == null ? 0 : iCompilationUnitArray2.length;
            if (n == 0) {
                iCompilationUnitArray = new ICompilationUnit[]{iCompilationUnit};
            } else {
                iCompilationUnitArray = new ICompilationUnit[n + 1];
                iCompilationUnitArray[0] = iCompilationUnit;
                System.arraycopy(iCompilationUnitArray2, 0, iCompilationUnitArray, 1, n);
            }
        } else {
            iCompilationUnitArray = iCompilationUnitArray2;
        }
        if (javaProject != null) {
            SearchableEnvironment searchableEnvironment = javaProject.newSearchableNameEnvironment(iCompilationUnitArray);
            this.nameLookup = searchableEnvironment.nameLookup;
            this.hierarchyResolver = new HierarchyResolver(searchableEnvironment, javaProject.getOptions(true), this, new DefaultProblemFactory());
        }
        this.infoToHandle = new HashMap(5);
        this.focusQualifiedName = iType == null ? null : iType.getFullyQualifiedName();
    }

    public abstract void build(boolean var1) throws JavaModelException, CoreException;

    protected void buildSupertypes() {
        IGenericType iGenericType;
        IType iType = this.getType();
        if (iType == null) {
            return;
        }
        try {
            iGenericType = (IGenericType)((JavaElement)((Object)iType)).getElementInfo();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        this.hierarchyResolver.resolve(iGenericType);
        if (!this.hierarchy.contains(iType)) {
            this.hierarchy.addRootClass(iType);
        }
    }

    public void connect(IGenericType iGenericType, IType iType, IType iType2, IType[] iTypeArray) {
        if (iType == null) {
            return;
        }
        if (TypeHierarchy.DEBUG) {
            System.out.println("Connecting: " + ((JavaElement)((Object)iType)).toStringWithAncestors());
            System.out.println("  to superclass: " + (iType2 == null ? "<None>" : ((JavaElement)((Object)iType2)).toStringWithAncestors()));
            System.out.print("  and superinterfaces:");
            if (iTypeArray == null || iTypeArray.length == 0) {
                System.out.println(" <None>");
            } else {
                System.out.println();
                int n = 0;
                int n2 = iTypeArray.length;
                while (n < n2) {
                    if (iTypeArray[n] != null) {
                        System.out.println("    " + ((JavaElement)((Object)iTypeArray[n])).toStringWithAncestors());
                    }
                    ++n;
                }
            }
        }
        switch (TypeDeclaration.kind(iGenericType.getModifiers())) {
            case 1: 
            case 3: {
                if (iType2 == null) {
                    this.hierarchy.addRootClass(iType);
                    break;
                }
                this.hierarchy.cacheSuperclass(iType, iType2);
                break;
            }
            case 2: 
            case 4: {
                this.hierarchy.addInterface(iType);
            }
        }
        if (iTypeArray == null) {
            iTypeArray = TypeHierarchy.NO_TYPE;
        }
        this.hierarchy.cacheSuperInterfaces(iType, iTypeArray);
        this.hierarchy.cacheFlags(iType, iGenericType.getModifiers());
    }

    protected IType getHandle(IGenericType iGenericType, ReferenceBinding referenceBinding) {
        if (iGenericType == null) {
            return null;
        }
        if (iGenericType instanceof HierarchyType) {
            IType iType = (IType)this.infoToHandle.get(iGenericType);
            if (iType == null) {
                iType = ((HierarchyType)iGenericType).typeHandle;
                iType = (IType)((Object)((JavaElement)((Object)iType)).resolved(referenceBinding));
                this.infoToHandle.put(iGenericType, iType);
            }
            return iType;
        }
        if (iGenericType.isBinaryType()) {
            ClassFile classFile = (ClassFile)this.infoToHandle.get(iGenericType);
            if (classFile == null) {
                IType iType = this.lookupBinaryHandle((ISourceType)iGenericType);
                if (iType == null) {
                    return null;
                }
                classFile = (ClassFile)iType.getParent();
                this.infoToHandle.put(iGenericType, classFile);
            }
            return new ResolvedBinaryType(classFile, classFile.getTypeName(), new String(referenceBinding.computeUniqueKey()));
        }
        if (iGenericType instanceof SourceTypeElementInfo) {
            IType iType = ((SourceTypeElementInfo)iGenericType).getHandle();
            return (IType)((Object)((JavaElement)((Object)iType)).resolved(referenceBinding));
        }
        return null;
    }

    protected IType getType() {
        return this.hierarchy.getType();
    }

    protected IType lookupBinaryHandle(ISourceType iSourceType) {
        int n;
        switch (TypeDeclaration.kind(iSourceType.getModifiers())) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 8;
                break;
            }
            default: {
                n = 16;
            }
        }
        char[] cArray = iSourceType.getName();
        String string = new String(ClassFile.translatedName(cArray));
        if (string.equals(this.focusQualifiedName)) {
            return this.getType();
        }
        NameLookup.Answer answer = this.nameLookup.findType(string, false, n, true, false, false, null);
        return answer == null || answer.type == null || !answer.type.isBinary() ? null : answer.type;
    }

    protected void worked(IProgressMonitor iProgressMonitor, int n) {
        if (iProgressMonitor != null) {
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            iProgressMonitor.worked(n);
        }
    }

    protected org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit createCompilationUnitFromPath(Openable openable, IFile iFile) {
        final char[] cArray = openable.getElementName().toCharArray();
        return new ResourceCompilationUnit(iFile, iFile.getLocationURI()){

            public char[] getFileName() {
                return cArray;
            }
        };
    }

    protected IBinaryType createInfoFromClassFile(Openable openable, IResource iResource) {
        ClassFileReader classFileReader = null;
        try {
            classFileReader = Util.newClassFileReader(iResource);
        }
        catch (ClassFormatException classFormatException) {
            if (TypeHierarchy.DEBUG) {
                classFormatException.printStackTrace();
            }
            return null;
        }
        catch (IOException iOException) {
            if (TypeHierarchy.DEBUG) {
                iOException.printStackTrace();
            }
            return null;
        }
        catch (CoreException coreException) {
            if (TypeHierarchy.DEBUG) {
                coreException.printStackTrace();
            }
            return null;
        }
        this.infoToHandle.put(classFileReader, openable);
        return classFileReader;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IBinaryType createInfoFromClassFileInJar(Openable openable) {
        PackageFragment packageFragment = (PackageFragment)openable.getParent();
        String string = Util.concatWith(packageFragment.names, openable.getElementName(), '/');
        ClassFileReader classFileReader = null;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = ((JarPackageFragmentRoot)packageFragment.getParent()).getJar();
                classFileReader = ClassFileReader.read(zipFile, string);
            }
            catch (ClassFormatException classFormatException) {
                block9: {
                    if (TypeHierarchy.DEBUG) {
                        classFormatException.printStackTrace();
                    }
                    break block9;
                    catch (IOException iOException) {
                        if (TypeHierarchy.DEBUG) {
                            iOException.printStackTrace();
                        }
                        break block9;
                    }
                    catch (CoreException coreException) {
                        if (!TypeHierarchy.DEBUG) break block9;
                        coreException.printStackTrace();
                    }
                }
                Object var7_9 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return null;
            }
            Object var7_11 = null;
            JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
            this.infoToHandle.put(classFileReader, openable);
            return classFileReader;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
            throw throwable;
        }
    }
}

