/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class AddFolderToIndex
extends IndexRequest {
    IPath folderPath;
    IProject project;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;

    public AddFolderToIndex(IPath iPath, IProject iProject, char[][] cArray, char[][] cArray2, IndexManager indexManager) {
        super(iProject.getFullPath(), indexManager);
        this.folderPath = iPath;
        this.project = iProject;
        this.inclusionPatterns = cArray;
        this.exclusionPatterns = cArray2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (this.isCancelled) return true;
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return true;
        }
        if (!this.project.isAccessible()) {
            return true;
        }
        IResource iResource = this.project.getParent().findMember(this.folderPath);
        if (iResource == null) return true;
        if (iResource.getType() == 1) {
            return true;
        }
        Index index = this.manager.getIndex(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor readWriteMonitor = index.monitor;
        if (readWriteMonitor == null) {
            return true;
        }
        try {
            try {
                readWriteMonitor.enterRead();
                final IPath iPath = this.containerPath;
                final IndexManager indexManager = this.manager;
                final SourceElementParser sourceElementParser = indexManager.getSourceElementParser(JavaCore.create(this.project), null);
                if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                    iResource.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy iResourceProxy) {
                            if (iResourceProxy.getType() == 1) {
                                if (Util.isJavaLikeFileName(iResourceProxy.getName())) {
                                    indexManager.addSource((IFile)iResourceProxy.requestResource(), iPath, sourceElementParser);
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                } else {
                    iResource.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy iResourceProxy) {
                            switch (iResourceProxy.getType()) {
                                case 1: {
                                    IResource iResource;
                                    if (Util.isJavaLikeFileName(iResourceProxy.getName()) && !Util.isExcluded(iResource = iResourceProxy.requestResource(), AddFolderToIndex.this.inclusionPatterns, AddFolderToIndex.this.exclusionPatterns)) {
                                        indexManager.addSource((IFile)iResource, iPath, sourceElementParser);
                                    }
                                    return false;
                                }
                                case 2: {
                                    if (AddFolderToIndex.this.exclusionPatterns == null || AddFolderToIndex.this.inclusionPatterns != null || !Util.isExcluded(iResourceProxy.requestFullPath(), AddFolderToIndex.this.inclusionPatterns, AddFolderToIndex.this.exclusionPatterns, true)) break;
                                    return false;
                                }
                            }
                            return true;
                        }
                    }, 0);
                }
            }
            catch (CoreException coreException) {
                if (JobManager.VERBOSE) {
                    Util.verbose("-> failed to add " + this.folderPath + " to index because of the following exception:", System.err);
                    coreException.printStackTrace();
                }
                Object var8_9 = null;
                readWriteMonitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            readWriteMonitor.exitRead();
            throw throwable;
        }
        {
            Object var8_11 = null;
            readWriteMonitor.exitRead();
            return true;
        }
    }

    public String toString() {
        return "adding " + this.folderPath + " to index " + this.containerPath;
    }
}

