/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.core.util.ResourceCompilationUnit;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ClasspathSourceDirectory
extends ClasspathLocation {
    IContainer sourceFolder;
    SimpleLookupTable directoryCache;
    SimpleLookupTable missingPackageHolder = new SimpleLookupTable();
    char[][] fullExclusionPatternChars;
    char[][] fulInclusionPatternChars;

    ClasspathSourceDirectory(IContainer iContainer, char[][] cArray, char[][] cArray2) {
        this.sourceFolder = iContainer;
        this.directoryCache = new SimpleLookupTable(5);
        this.fullExclusionPatternChars = cArray;
        this.fulInclusionPatternChars = cArray2;
    }

    public void cleanup() {
        this.directoryCache = null;
    }

    SimpleLookupTable directoryTable(String string) {
        SimpleLookupTable simpleLookupTable = (SimpleLookupTable)this.directoryCache.get(string);
        if (simpleLookupTable == this.missingPackageHolder) {
            return null;
        }
        if (simpleLookupTable != null) {
            return simpleLookupTable;
        }
        try {
            IResource iResource = this.sourceFolder.findMember(string);
            if (iResource instanceof IContainer) {
                IResource[] iResourceArray = ((IContainer)iResource).members();
                simpleLookupTable = new SimpleLookupTable();
                int n = 0;
                int n2 = iResourceArray.length;
                while (n < n2) {
                    String string2;
                    String string3;
                    int n3;
                    IResource iResource2 = iResourceArray[n];
                    if (iResource2.getType() == 1 && (n3 = Util.indexOfJavaLikeExtension(string3 = iResource2.getName())) >= 0 && !org.eclipse.wst.jsdt.internal.compiler.util.Util.isExcluded((string2 = iResource2.getFullPath().toString()).toCharArray(), this.fulInclusionPatternChars, this.fullExclusionPatternChars, false)) {
                        simpleLookupTable.put(string3.substring(0, n3), iResource2);
                    }
                    ++n;
                }
                this.directoryCache.put(string, simpleLookupTable);
                return simpleLookupTable;
            }
        }
        catch (CoreException coreException) {}
        this.directoryCache.put(string, this.missingPackageHolder);
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClasspathSourceDirectory)) {
            return false;
        }
        return this.sourceFolder.equals((Object)((ClasspathSourceDirectory)object).sourceFolder);
    }

    public NameEnvironmentAnswer findClass(String string, String string2, String string3) {
        IFile iFile;
        SimpleLookupTable simpleLookupTable = this.directoryTable(string2);
        if (simpleLookupTable != null && simpleLookupTable.elementSize > 0 && (iFile = (IFile)simpleLookupTable.get(string)) != null) {
            return new NameEnvironmentAnswer(new ResourceCompilationUnit(iFile, iFile.getLocationURI()), null);
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        return this.sourceFolder.getProjectRelativePath();
    }

    public boolean isPackage(String string) {
        return this.directoryTable(string) != null;
    }

    public void reset() {
        this.directoryCache = new SimpleLookupTable(5);
    }

    public String toString() {
        return "Source classpath directory " + this.sourceFolder.getFullPath().toString();
    }

    public String debugPathString() {
        return this.sourceFolder.getFullPath().toString();
    }
}

