/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.util.HashMap;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathJar;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.core.search.matching.ClasspathSourceDirectory;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaSearchNameEnvironment
implements INameEnvironment,
SuffixConstants {
    ClasspathLocation[] locations;
    HashMap workingCopies;

    public JavaSearchNameEnvironment(IJavaProject iJavaProject, ICompilationUnit[] iCompilationUnitArray) {
        this.computeClasspathLocations(iJavaProject.getProject().getWorkspace().getRoot(), (JavaProject)iJavaProject);
        try {
            int n = iCompilationUnitArray == null ? 0 : iCompilationUnitArray.length;
            this.workingCopies = new HashMap(n);
            if (iCompilationUnitArray != null) {
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit iCompilationUnit = iCompilationUnitArray[n2];
                    IPackageDeclaration[] iPackageDeclarationArray = iCompilationUnit.getPackageDeclarations();
                    String string = iPackageDeclarationArray.length > 0 ? iPackageDeclarationArray[0].getElementName() : "";
                    String string2 = iCompilationUnit.getElementName();
                    String string3 = Util.getNameWithoutJavaLikeExtension(string2);
                    String string4 = string.length() == 0 ? string3 : String.valueOf(string.replace('.', '/')) + '/' + string3;
                    this.workingCopies.put(string4, iCompilationUnit);
                    ++n2;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public void cleanup() {
        int n = 0;
        int n2 = this.locations.length;
        while (n < n2) {
            this.locations[n].cleanup();
            ++n;
        }
    }

    private void computeClasspathLocations(IWorkspaceRoot iWorkspaceRoot, JavaProject javaProject) {
        IPackageFragmentRoot[] iPackageFragmentRootArray = null;
        try {
            iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
        }
        catch (JavaModelException javaModelException) {
            this.locations = new ClasspathLocation[0];
            return;
        }
        int n = iPackageFragmentRootArray.length;
        ClasspathLocation[] classpathLocationArray = new ClasspathLocation[n];
        int n2 = 0;
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        int n3 = 0;
        while (n3 < n) {
            PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)iPackageFragmentRootArray[n3];
            IPath iPath = packageFragmentRoot.getPath();
            try {
                Object object;
                if (packageFragmentRoot.isArchive()) {
                    object = javaModelManager.getZipFile(iPath);
                    classpathLocationArray[n2++] = new ClasspathJar((ZipFile)object, ((ClasspathEntry)packageFragmentRoot.getRawClasspathEntry()).getAccessRuleSet());
                } else {
                    object = JavaModel.getTarget((IContainer)iWorkspaceRoot, iPath, false);
                    if (object == null) {
                        ClasspathLocation[] classpathLocationArray2 = classpathLocationArray;
                        classpathLocationArray = new ClasspathLocation[classpathLocationArray.length - 1];
                        System.arraycopy(classpathLocationArray2, 0, classpathLocationArray, 0, n2);
                    } else {
                        classpathLocationArray[n2++] = packageFragmentRoot.getKind() == 1 ? new ClasspathSourceDirectory((IContainer)object, packageFragmentRoot.fullExclusionPatternChars(), packageFragmentRoot.fullInclusionPatternChars()) : (object instanceof IContainer ? ClasspathLocation.forBinaryFolder((IContainer)object, false, ((ClasspathEntry)packageFragmentRoot.getRawClasspathEntry()).getAccessRuleSet()) : ClasspathLocation.forLibrary(iPath.toOSString(), ((ClasspathEntry)packageFragmentRoot.getRawClasspathEntry()).getAccessRuleSet()));
                    }
                }
            }
            catch (CoreException coreException) {
                ClasspathLocation[] classpathLocationArray3 = classpathLocationArray;
                classpathLocationArray = new ClasspathLocation[classpathLocationArray.length - 1];
                System.arraycopy(classpathLocationArray3, 0, classpathLocationArray, 0, n2);
            }
            ++n3;
        }
        this.locations = classpathLocationArray;
    }

    private NameEnvironmentAnswer findClass(String string, char[] cArray) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        NameEnvironmentAnswer nameEnvironmentAnswer = null;
        int n = 0;
        int n2 = this.locations.length;
        while (n < n2) {
            NameEnvironmentAnswer nameEnvironmentAnswer2;
            ClasspathLocation classpathLocation = this.locations[n];
            if (classpathLocation instanceof ClasspathSourceDirectory) {
                org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit iCompilationUnit;
                if (string4 == null) {
                    string4 = string5 = string;
                    string6 = "";
                    if (string.length() > cArray.length) {
                        int n3 = string5.length() - cArray.length;
                        string6 = string5.substring(0, n3 - 1);
                        string4 = string5.substring(n3);
                    }
                }
                nameEnvironmentAnswer2 = (iCompilationUnit = (org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit)this.workingCopies.get(string)) != null ? new NameEnvironmentAnswer(iCompilationUnit, null) : classpathLocation.findClass(string4, string6, string5);
            } else {
                if (string2 == null) {
                    string2 = string3 = String.valueOf(string) + ".js";
                    string6 = "";
                    if (string.length() > cArray.length) {
                        int n4 = string3.length() - cArray.length - 6;
                        string6 = string3.substring(0, n4 - 1);
                        string2 = string3.substring(n4);
                    }
                }
                nameEnvironmentAnswer2 = classpathLocation.findClass(string2, string6, string3);
            }
            if (nameEnvironmentAnswer2 != null) {
                if (!nameEnvironmentAnswer2.ignoreIfBetter()) {
                    if (nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) {
                        return nameEnvironmentAnswer2;
                    }
                } else if (nameEnvironmentAnswer2.isBetter(nameEnvironmentAnswer)) {
                    nameEnvironmentAnswer = nameEnvironmentAnswer2;
                }
            }
            ++n;
        }
        if (nameEnvironmentAnswer != null) {
            return nameEnvironmentAnswer;
        }
        return null;
    }

    public NameEnvironmentAnswer findBinding(char[] cArray, char[][] cArray2, int n, ITypeRequestor iTypeRequestor, boolean bl, String string) {
        throw new UnimplementedException();
    }

    public NameEnvironmentAnswer findType(char[] cArray, char[][] cArray2, ITypeRequestor iTypeRequestor) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray2, cArray, '/')), cArray);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] cArray, ITypeRequestor iTypeRequestor) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray, '/')), cArray[cArray.length - 1]);
        }
        return null;
    }

    public boolean isPackage(char[][] cArray, char[] cArray2) {
        return this.isPackage(new String(CharOperation.concatWith(cArray, cArray2, '/')));
    }

    public boolean isPackage(String string) {
        int n = 0;
        int n2 = this.locations.length;
        while (n < n2) {
            if (this.locations[n].isPackage(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

