/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class MethodPattern
extends JavaSearchPattern {
    protected boolean findDeclarations;
    protected boolean findReferences;
    public char[] selector;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[] returnQualification;
    public char[] returnSimpleName;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public int parameterCount;
    public boolean varargs = false;
    protected boolean isFunction;
    protected IType declaringType;
    char[][] returnTypeSignatures;
    char[][][] returnTypeArguments;
    char[][][] parametersTypeSignatures;
    char[][][][] parametersTypeArguments;
    boolean methodParameters = false;
    char[][] methodArguments;
    protected static char[][] REF_CATEGORIES = new char[][]{METHOD_REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{METHOD_REF, METHOD_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{METHOD_DECL};
    protected static char[][] FUNCTION_REF_AND_DECL_CATEGORIES = new char[][]{METHOD_REF, FUNCTION_DECL};
    protected static char[][] FUNCTION_DECL_CATEGORIES = new char[][]{FUNCTION_DECL};

    public static char[] createIndexKey(char[] cArray, int n) {
        char[] cArray2 = n < 10 ? COUNTS[n] : ("/" + String.valueOf(n)).toCharArray();
        return CharOperation.concat(cArray, cArray2);
    }

    MethodPattern(int n, boolean bl) {
        super(128, n);
        this.isFunction = bl;
    }

    public MethodPattern(boolean bl, boolean bl2, boolean bl3, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, char[] cArray5, char[][] cArray6, char[][] cArray7, IType iType, int n) {
        this(n, bl3);
        this.findDeclarations = bl;
        this.findReferences = bl2;
        this.selector = this.isCaseSensitive() || this.isCamelCase() ? cArray : CharOperation.toLowerCase(cArray);
        this.declaringQualification = this.isCaseSensitive() ? cArray2 : CharOperation.toLowerCase(cArray2);
        this.declaringSimpleName = this.isCaseSensitive() ? cArray3 : CharOperation.toLowerCase(cArray3);
        this.returnQualification = this.isCaseSensitive() ? cArray4 : CharOperation.toLowerCase(cArray4);
        char[] cArray8 = this.returnSimpleName = this.isCaseSensitive() ? cArray5 : CharOperation.toLowerCase(cArray5);
        if (cArray7 != null) {
            this.parameterCount = cArray7.length;
            this.parameterQualifications = new char[this.parameterCount][];
            this.parameterSimpleNames = new char[this.parameterCount][];
            int n2 = 0;
            while (n2 < this.parameterCount) {
                this.parameterQualifications[n2] = this.isCaseSensitive() ? cArray6[n2] : CharOperation.toLowerCase(cArray6[n2]);
                this.parameterSimpleNames[n2] = this.isCaseSensitive() ? cArray7[n2] : CharOperation.toLowerCase(cArray7[n2]);
                ++n2;
            }
        } else {
            this.parameterCount = -1;
        }
        this.declaringType = iType;
        this.mustResolve = this.mustResolve();
    }

    public MethodPattern(boolean bl, boolean bl2, boolean bl3, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, char[] cArray5, String string, char[][] cArray6, char[][] cArray7, String[] stringArray, IMethod iMethod, int n) {
        this(bl, bl2, bl3, cArray, cArray2, cArray3, cArray4, cArray5, cArray6, cArray7, iMethod.getDeclaringType(), n);
        int n2;
        String string2;
        try {
            this.varargs = (iMethod.getFlags() & 0x80) != 0;
        }
        catch (JavaModelException javaModelException) {}
        String string3 = null;
        if (iMethod.isResolved() && new BindingKey(string2 = iMethod.getKey()).isParameterizedType()) {
            string3 = Util.getDeclaringTypeSignature(string2);
        } else {
            this.methodParameters = true;
        }
        if (this.declaringType != null) {
            if (string3 != null) {
                this.typeSignatures = Util.splitTypeLevelsSignature(string3);
                this.setTypeArguments(Util.getAllTypeArguments(this.typeSignatures));
            } else {
                this.storeTypeSignaturesAndArguments(this.declaringType);
            }
        }
        if (string != null) {
            this.returnTypeSignatures = Util.splitTypeLevelsSignature(string);
            this.returnTypeArguments = Util.getAllTypeArguments(this.returnTypeSignatures);
        }
        if (stringArray != null && (n2 = stringArray.length) > 0) {
            this.parametersTypeSignatures = new char[n2][][];
            this.parametersTypeArguments = new char[n2][][][];
            int n3 = 0;
            while (n3 < n2) {
                this.parametersTypeSignatures[n3] = Util.splitTypeLevelsSignature(stringArray[n3]);
                this.parametersTypeArguments[n3] = Util.getAllTypeArguments(this.parametersTypeSignatures[n3]);
                ++n3;
            }
        }
        this.methodArguments = this.extractMethodArguments(iMethod);
        if (this.hasMethodArguments()) {
            this.mustResolve = true;
        }
    }

    public MethodPattern(boolean bl, boolean bl2, boolean bl3, char[] cArray, char[] cArray2, char[] cArray3, String string, char[] cArray4, char[] cArray5, String string2, char[][] cArray6, char[][] cArray7, String[] stringArray, char[][] cArray8, int n) {
        this(bl, bl2, bl3, cArray, cArray2, cArray3, cArray4, cArray5, cArray6, cArray7, null, n);
        int n2;
        if (string != null) {
            this.typeSignatures = Util.splitTypeLevelsSignature(string);
            this.setTypeArguments(Util.getAllTypeArguments(this.typeSignatures));
        }
        if (string2 != null) {
            this.returnTypeSignatures = Util.splitTypeLevelsSignature(string2);
            this.returnTypeArguments = Util.getAllTypeArguments(this.returnTypeSignatures);
        }
        if (stringArray != null && (n2 = stringArray.length) > 0) {
            this.parametersTypeSignatures = new char[n2][][];
            this.parametersTypeArguments = new char[n2][][][];
            int n3 = 0;
            while (n3 < n2) {
                this.parametersTypeSignatures[n3] = Util.splitTypeLevelsSignature(stringArray[n3]);
                this.parametersTypeArguments[n3] = Util.getAllTypeArguments(this.parametersTypeSignatures[n3]);
                ++n3;
            }
        }
        this.methodArguments = cArray8;
        if (this.hasMethodArguments()) {
            this.mustResolve = true;
        }
    }

    public void decodeIndexKey(char[] cArray) {
        int n = cArray.length - 1;
        this.parameterCount = 0;
        this.selector = null;
        int n2 = 1;
        int n3 = n;
        while (n3 >= 0) {
            if (cArray[n3] == '/') {
                this.selector = new char[n3];
                System.arraycopy(cArray, 0, this.selector, 0, n3);
                break;
            }
            this.parameterCount = n3 == n ? cArray[n3] - 48 : (this.parameterCount += (n2 *= 10) * (cArray[n3] - 48));
            --n3;
        }
    }

    public SearchPattern getBlankPattern() {
        return new MethodPattern(8, this.isFunction);
    }

    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? (this.isFunction ? FUNCTION_REF_AND_DECL_CATEGORIES : REF_AND_DECL_CATEGORIES) : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return this.isFunction ? FUNCTION_DECL_CATEGORIES : DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    boolean hasMethodArguments() {
        return this.methodArguments != null && this.methodArguments.length > 0;
    }

    boolean hasMethodParameters() {
        return this.methodParameters;
    }

    boolean isPolymorphicSearch() {
        return this.findReferences;
    }

    public boolean matchesDecodedKey(SearchPattern searchPattern) {
        MethodPattern methodPattern = (MethodPattern)searchPattern;
        return (this.parameterCount == methodPattern.parameterCount || this.parameterCount == -1 || this.varargs) && this.matchesName(this.selector, methodPattern.selector);
    }

    protected boolean mustResolve() {
        if (this.declaringSimpleName != null || this.declaringQualification != null) {
            return true;
        }
        if (this.returnSimpleName != null || this.returnQualification != null) {
            return true;
        }
        if (this.parameterSimpleNames != null) {
            int n = 0;
            int n2 = this.parameterSimpleNames.length;
            while (n < n2) {
                if (this.parameterQualifications[n] != null) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] cArray = this.selector;
        int n = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.isCamelCase) break;
                if (this.selector != null && this.parameterCount >= 0 && !this.varargs) {
                    cArray = MethodPattern.createIndexKey(this.selector, this.parameterCount);
                    break;
                }
                n &= 0xFFFFFFFF;
                n |= 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.parameterCount >= 0 && !this.varargs) {
                    cArray = MethodPattern.createIndexKey(this.selector == null ? ONE_STAR : this.selector, this.parameterCount);
                    break;
                }
                if (this.selector == null || this.selector[this.selector.length - 1] == '*') break;
                cArray = CharOperation.concat(this.selector, ONE_STAR, '/');
                break;
            }
        }
        return index.query(this.getIndexCategories(), cArray, n);
    }

    protected StringBuffer print(StringBuffer stringBuffer) {
        if (this.findDeclarations) {
            stringBuffer.append(this.findReferences ? "MethodCombinedPattern: " : "MethodDeclarationPattern: ");
        } else {
            stringBuffer.append("MethodReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            stringBuffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            stringBuffer.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            stringBuffer.append("*.");
        }
        if (this.selector != null) {
            stringBuffer.append(this.selector);
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append('(');
        if (this.parameterSimpleNames == null) {
            stringBuffer.append("...");
        } else {
            int n = 0;
            int n2 = this.parameterSimpleNames.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                if (this.parameterQualifications[n] != null) {
                    stringBuffer.append(this.parameterQualifications[n]).append('.');
                }
                if (this.parameterSimpleNames[n] == null) {
                    stringBuffer.append('*');
                } else {
                    stringBuffer.append(this.parameterSimpleNames[n]);
                }
                ++n;
            }
        }
        stringBuffer.append(')');
        if (this.returnQualification != null) {
            stringBuffer.append(" --> ").append(this.returnQualification).append('.');
        } else if (this.returnSimpleName != null) {
            stringBuffer.append(" --> ");
        }
        if (this.returnSimpleName != null) {
            stringBuffer.append(this.returnSimpleName);
        } else if (this.returnQualification != null) {
            stringBuffer.append("*");
        }
        return super.print(stringBuffer);
    }
}

