/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.TypeDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.TypeReferenceMatch;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.PackageReferenceLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeReferencePattern;

public class TypeReferenceLocator
extends PatternLocator {
    protected TypeReferencePattern pattern;
    protected boolean isDeclarationOfReferencedTypesPattern;

    public TypeReferenceLocator(TypeReferencePattern typeReferencePattern) {
        super(typeReferencePattern);
        this.pattern = typeReferencePattern;
        this.isDeclarationOfReferencedTypesPattern = this.pattern instanceof DeclarationOfReferencedTypesPattern;
    }

    protected IJavaElement findElement(IJavaElement iJavaElement, int n) {
        if (n != 0) {
            return null;
        }
        DeclarationOfReferencedTypesPattern declarationOfReferencedTypesPattern = (DeclarationOfReferencedTypesPattern)this.pattern;
        while (iJavaElement != null && !declarationOfReferencedTypesPattern.enclosingElement.equals(iJavaElement)) {
            iJavaElement = iJavaElement.getParent();
        }
        return iJavaElement;
    }

    public int match(Annotation annotation, MatchingNodeSet matchingNodeSet) {
        return this.match(annotation.type, matchingNodeSet);
    }

    public int match(ASTNode aSTNode, MatchingNodeSet matchingNodeSet) {
        if (!(aSTNode instanceof ImportReference)) {
            return 0;
        }
        return matchingNodeSet.addMatch(aSTNode, this.matchLevel((ImportReference)aSTNode));
    }

    public int match(Reference reference, MatchingNodeSet matchingNodeSet) {
        if (!(reference instanceof NameReference)) {
            return 0;
        }
        if (this.pattern.simpleName == null) {
            return matchingNodeSet.addMatch(reference, this.pattern.mustResolve ? 2 : 3);
        }
        if (reference instanceof SingleNameReference) {
            if (this.matchesName(this.pattern.simpleName, ((SingleNameReference)reference).token)) {
                return matchingNodeSet.addMatch(reference, 2);
            }
        } else {
            char[][] cArray = ((QualifiedNameReference)reference).tokens;
            int n = 0;
            int n2 = cArray.length;
            while (n < n2) {
                if (this.matchesName(this.pattern.simpleName, cArray[n])) {
                    return matchingNodeSet.addMatch(reference, 2);
                }
                ++n;
            }
        }
        return 0;
    }

    public int match(TypeReference typeReference, MatchingNodeSet matchingNodeSet) {
        if (this.pattern.simpleName == null) {
            return matchingNodeSet.addMatch(typeReference, this.pattern.mustResolve ? 2 : 3);
        }
        if (typeReference instanceof SingleTypeReference) {
            if (this.matchesName(this.pattern.simpleName, ((SingleTypeReference)typeReference).token)) {
                return matchingNodeSet.addMatch(typeReference, this.pattern.mustResolve ? 2 : 3);
            }
        } else {
            char[][] cArray = ((QualifiedTypeReference)typeReference).tokens;
            int n = 0;
            int n2 = cArray.length;
            while (n < n2) {
                if (this.matchesName(this.pattern.simpleName, cArray[n])) {
                    return matchingNodeSet.addMatch(typeReference, 2);
                }
                ++n;
            }
        }
        return 0;
    }

    protected int matchLevel(ImportReference importReference) {
        if (this.pattern.qualification == null) {
            if (this.pattern.simpleName == null) {
                return 3;
            }
            char[][] cArray = importReference.tokens;
            if (this.matchesName(this.pattern.simpleName, cArray[cArray.length - 1])) {
                return 3;
            }
        } else {
            boolean bl;
            char[][] cArray = importReference.tokens;
            char[] cArray2 = this.pattern.simpleName == null ? this.pattern.qualification : CharOperation.concat(this.pattern.qualification, this.pattern.simpleName, '.');
            char[] cArray3 = CharOperation.concatWith(cArray, '.');
            if (cArray2 == null) {
                return 3;
            }
            if (cArray3 == null) {
                return 0;
            }
            if (cArray3.length == 0) {
                if (cArray2.length == 0) {
                    return 3;
                }
                return 0;
            }
            boolean bl2 = bl = !this.isCaseSensitive || cArray2[0] == cArray3[0];
            if (this.isCamelCase && bl && CharOperation.camelCaseMatch(cArray2, cArray3)) {
                return 2;
            }
            switch (this.matchMode) {
                case 0: 
                case 1: {
                    if (!CharOperation.prefixEquals(cArray2, cArray3, this.isCaseSensitive)) break;
                    return 2;
                }
                case 2: {
                    if (!CharOperation.match(cArray2, cArray3, this.isCaseSensitive)) break;
                    return 2;
                }
            }
        }
        return 0;
    }

    protected void matchLevelAndReportImportRef(ImportReference importReference, Binding binding, MatchLocator matchLocator) throws CoreException {
        Binding binding2 = binding;
        if (importReference.isStatic()) {
            Binding binding3;
            if (binding instanceof FieldBinding) {
                binding3 = (FieldBinding)binding;
                if (!((FieldBinding)binding3).isStatic()) {
                    return;
                }
                binding2 = ((FieldBinding)binding3).declaringClass;
            } else if (binding instanceof MethodBinding) {
                binding3 = (MethodBinding)binding;
                if (!((MethodBinding)binding3).isStatic()) {
                    return;
                }
                binding2 = ((MethodBinding)binding3).declaringClass;
            } else if (binding instanceof MemberTypeBinding && !((ReferenceBinding)(binding3 = (MemberTypeBinding)binding)).isStatic()) {
                return;
            }
            int n = this.resolveLevel(binding2);
            if (n >= 1) {
                this.matchReportImportRef(importReference, binding, matchLocator.createImportHandle(importReference), n == 3 ? 0 : 1, matchLocator);
            }
            return;
        }
        super.matchLevelAndReportImportRef(importReference, binding2, matchLocator);
    }

    protected void matchReportImportRef(ImportReference importReference, Binding binding, IJavaElement iJavaElement, int n, MatchLocator matchLocator) throws CoreException {
        if (this.isDeclarationOfReferencedTypesPattern) {
            if ((iJavaElement = this.findElement(iJavaElement, n)) != null) {
                SimpleSet simpleSet = ((DeclarationOfReferencedTypesPattern)this.pattern).knownTypes;
                while (binding instanceof ReferenceBinding) {
                    ReferenceBinding referenceBinding = (ReferenceBinding)binding;
                    this.reportDeclaration(referenceBinding, 1, matchLocator, simpleSet);
                    binding = referenceBinding.enclosingType();
                }
            }
            return;
        }
        if (this.pattern.hasTypeArguments() && !this.isEquivalentMatch && !this.isErasureMatch) {
            return;
        }
        this.match = matchLocator.newTypeReferenceMatch(iJavaElement, binding, n, importReference);
        this.match.setRaw(true);
        if (this.pattern.hasTypeArguments()) {
            this.match.setRule(this.match.getRule() & 0xFFFFFFBF);
        }
        ReferenceBinding referenceBinding = null;
        boolean bl = false;
        if (binding instanceof ReferenceBinding) {
            referenceBinding = (ReferenceBinding)binding;
        } else if (binding instanceof FieldBinding) {
            referenceBinding = ((FieldBinding)binding).declaringClass;
            bl = importReference.isStatic() && (importReference.bits & 0x20000) == 0;
        } else if (binding instanceof MethodBinding) {
            referenceBinding = ((MethodBinding)binding).declaringClass;
            boolean bl2 = bl = importReference.isStatic() && (importReference.bits & 0x20000) == 0;
        }
        if (referenceBinding != null) {
            Object object;
            int n2 = importReference.tokens.length - 1;
            if (bl) {
                --n2;
            }
            if (referenceBinding instanceof ProblemReferenceBinding) {
                object = (ProblemReferenceBinding)referenceBinding;
                referenceBinding = ((ProblemReferenceBinding)object).closestMatch();
                n2 = ((ProblemReferenceBinding)object).compoundName.length - 1;
            }
            while (referenceBinding != null && n2 >= 0) {
                if (this.resolveLevelForType(referenceBinding) != 0) {
                    if (matchLocator.encloses(iJavaElement)) {
                        object = importReference.sourcePositions;
                        int n3 = n2;
                        if (this.pattern.qualification != null) {
                            n3 = n2 - this.pattern.segmentsSize;
                        }
                        if (n3 < 0) {
                            n3 = 0;
                        }
                        int n4 = (int)(object[n3] >>> 32);
                        int n5 = (int)object[n2];
                        this.match.setOffset(n4);
                        this.match.setLength(n5 - n4 + 1);
                        matchLocator.report(this.match);
                    }
                    return;
                }
                --n2;
                referenceBinding = referenceBinding.enclosingType();
            }
        }
        matchLocator.reportAccurateTypeReference(this.match, importReference, this.pattern.simpleName);
    }

    protected void matchReportReference(ArrayTypeReference arrayTypeReference, IJavaElement iJavaElement, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        if (this.pattern.simpleName == null && matchLocator.encloses(iJavaElement)) {
            int n2 = arrayTypeReference.sourceStart;
            int n3 = arrayTypeReference.sourceEnd - n2 + 1;
            if (this.match == null) {
                this.match = matchLocator.newTypeReferenceMatch(iJavaElement, binding, n, n2, n3, arrayTypeReference);
            } else {
                this.match.setOffset(n2);
                this.match.setLength(n3);
            }
            matchLocator.report(this.match);
            return;
        }
        this.match = matchLocator.newTypeReferenceMatch(iJavaElement, binding, n, arrayTypeReference);
        if (arrayTypeReference.resolvedType != null) {
            this.matchReportReference(arrayTypeReference, -1, arrayTypeReference.resolvedType.leafComponentType(), matchLocator);
            return;
        }
        matchLocator.reportAccurateTypeReference(this.match, arrayTypeReference, this.pattern.simpleName);
    }

    protected void matchReportReference(ASTNode aSTNode, IJavaElement iJavaElement, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        this.matchReportReference(aSTNode, iJavaElement, null, null, binding, n, matchLocator);
    }

    protected void matchReportReference(ASTNode aSTNode, IJavaElement iJavaElement, IJavaElement iJavaElement2, IJavaElement[] iJavaElementArray, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        if (this.isDeclarationOfReferencedTypesPattern) {
            if ((iJavaElement = this.findElement(iJavaElement, n)) != null) {
                this.reportDeclaration(aSTNode, iJavaElement, matchLocator, ((DeclarationOfReferencedTypesPattern)this.pattern).knownTypes);
            }
            return;
        }
        TypeReferenceMatch typeReferenceMatch = matchLocator.newTypeReferenceMatch(iJavaElement, binding, n, aSTNode);
        typeReferenceMatch.setLocalElement(iJavaElement2);
        typeReferenceMatch.setOtherElements(iJavaElementArray);
        this.match = typeReferenceMatch;
        if (aSTNode instanceof QualifiedNameReference) {
            this.matchReportReference((QualifiedNameReference)aSTNode, iJavaElement, binding, n, matchLocator);
        } else if (aSTNode instanceof QualifiedTypeReference) {
            this.matchReportReference((QualifiedTypeReference)aSTNode, iJavaElement, binding, n, matchLocator);
        } else if (aSTNode instanceof ArrayTypeReference) {
            this.matchReportReference((ArrayTypeReference)aSTNode, iJavaElement, binding, n, matchLocator);
        } else {
            TypeBinding typeBinding;
            TypeBinding typeBinding2 = typeBinding = aSTNode instanceof Expression ? ((Expression)aSTNode).resolvedType : null;
            if (typeBinding != null) {
                this.matchReportReference((Expression)aSTNode, -1, typeBinding, matchLocator);
                return;
            }
            matchLocator.report(this.match);
        }
    }

    protected void matchReportReference(ASTNode aSTNode, IJavaElement iJavaElement, Binding binding, Scope scope, int n, MatchLocator matchLocator) throws CoreException {
        if (scope == null || scope.kind != 1 && scope.kind != 2) {
            this.matchReportReference(aSTNode, iJavaElement, binding, n, matchLocator);
            return;
        }
        BlockScope blockScope = (BlockScope)scope;
        LocalDeclaration[] localDeclarationArray = blockScope.findLocalVariableDeclarations(aSTNode.sourceStart);
        IJavaElement iJavaElement2 = null;
        IJavaElement[] iJavaElementArray = null;
        if (localDeclarationArray != null) {
            int n2 = localDeclarationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (localDeclarationArray[n3] == null) break;
                if (aSTNode.sourceStart == localDeclarationArray[n3].declarationSourceStart) {
                    iJavaElement2 = matchLocator.createHandle(localDeclarationArray[n3], iJavaElement);
                    break;
                }
                if (n3 > 0 && localDeclarationArray[n3].sourceStart > aSTNode.sourceStart) {
                    iJavaElement2 = matchLocator.createHandle(localDeclarationArray[n3 - 1], iJavaElement);
                    break;
                }
                ++n3;
            }
            if (iJavaElement2 == null && n3 > 0 && aSTNode.sourceEnd < localDeclarationArray[n3 - 1].declarationEnd) {
                iJavaElement2 = matchLocator.createHandle(localDeclarationArray[n3 - 1], iJavaElement);
            }
            int n4 = 0;
            int n5 = 1;
            while (n5 < n2) {
                if (localDeclarationArray[n5] == null) break;
                if (aSTNode.sourceStart == localDeclarationArray[n5].declarationSourceStart) {
                    if (iJavaElementArray == null) {
                        iJavaElementArray = new IJavaElement[n2 - n5];
                    }
                    iJavaElementArray[n4++] = matchLocator.createHandle(localDeclarationArray[n5], iJavaElement);
                }
                ++n5;
            }
            if (n4 > 0 && n4 != n2 - 1) {
                IJavaElement[] iJavaElementArray2 = iJavaElementArray;
                iJavaElementArray = new IJavaElement[n4];
                System.arraycopy(iJavaElementArray2, 0, iJavaElementArray, 0, n4);
            }
        }
        this.matchReportReference(aSTNode, iJavaElement, iJavaElement2, iJavaElementArray, binding, n, matchLocator);
    }

    protected void matchReportReference(QualifiedNameReference qualifiedNameReference, IJavaElement iJavaElement, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        ReferenceBinding referenceBinding;
        Binding binding2 = qualifiedNameReference.binding;
        TypeBinding typeBinding = null;
        int n2 = qualifiedNameReference.tokens.length - 1;
        switch (qualifiedNameReference.bits & 0xF) {
            case 1: {
                typeBinding = qualifiedNameReference.actualReceiverType;
                n2 -= qualifiedNameReference.otherBindings == null ? 1 : qualifiedNameReference.otherBindings.length + 1;
                break;
            }
            case 4: {
                if (!(binding2 instanceof TypeBinding)) break;
                typeBinding = (TypeBinding)binding2;
                break;
            }
            case 3: 
            case 7: {
                if (binding2 instanceof ProblemReferenceBinding) {
                    typeBinding = (TypeBinding)binding2;
                    break;
                }
                if (binding2 instanceof ProblemFieldBinding) {
                    typeBinding = qualifiedNameReference.actualReceiverType;
                    n2 -= qualifiedNameReference.otherBindings == null ? 1 : qualifiedNameReference.otherBindings.length + 1;
                    break;
                }
                if (!(binding2 instanceof ProblemBinding)) break;
                typeBinding = ((ProblemBinding)binding2).searchType;
            }
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            referenceBinding = (ProblemReferenceBinding)typeBinding;
            typeBinding = ((ProblemReferenceBinding)referenceBinding).closestMatch();
            n2 = ((ProblemReferenceBinding)referenceBinding).compoundName.length - 1;
        }
        if (this.match == null) {
            this.match = matchLocator.newTypeReferenceMatch(iJavaElement, binding, n, qualifiedNameReference);
        }
        if (typeBinding instanceof ReferenceBinding) {
            referenceBinding = (ReferenceBinding)typeBinding;
            while (referenceBinding != null && n2 >= 0) {
                if (this.resolveLevelForType(referenceBinding) == 3) {
                    if (matchLocator.encloses(iJavaElement)) {
                        long[] lArray = qualifiedNameReference.sourcePositions;
                        int n3 = n2;
                        if (this.pattern.qualification != null) {
                            n3 = n2 - this.pattern.segmentsSize;
                        }
                        if (n3 < 0) {
                            n3 = 0;
                        }
                        int n4 = (int)(lArray[n3] >>> 32);
                        int n5 = (int)lArray[n2];
                        this.match.setOffset(n4);
                        this.match.setLength(n5 - n4 + 1);
                        this.matchReportReference(qualifiedNameReference, n2, referenceBinding, matchLocator);
                    }
                    return;
                }
                --n2;
                referenceBinding = referenceBinding.enclosingType();
            }
        }
        matchLocator.reportAccurateTypeReference(this.match, qualifiedNameReference, this.pattern.simpleName);
    }

    protected void matchReportReference(QualifiedTypeReference qualifiedTypeReference, IJavaElement iJavaElement, Binding binding, int n, MatchLocator matchLocator) throws CoreException {
        ReferenceBinding referenceBinding;
        TypeBinding typeBinding = qualifiedTypeReference.resolvedType;
        int n2 = qualifiedTypeReference.tokens.length - 1;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            referenceBinding = (ProblemReferenceBinding)typeBinding;
            typeBinding = ((ProblemReferenceBinding)referenceBinding).closestMatch();
            n2 = ((ProblemReferenceBinding)referenceBinding).compoundName.length - 1;
        }
        if (this.match == null) {
            this.match = matchLocator.newTypeReferenceMatch(iJavaElement, binding, n, qualifiedTypeReference);
        }
        if (typeBinding instanceof ReferenceBinding) {
            referenceBinding = (ReferenceBinding)typeBinding;
            while (referenceBinding != null && n2 >= 0) {
                if (this.resolveLevelForType(referenceBinding) != 0) {
                    if (matchLocator.encloses(iJavaElement)) {
                        long[] lArray = qualifiedTypeReference.sourcePositions;
                        int n3 = n2;
                        if (this.pattern.qualification != null) {
                            n3 = n2 - this.pattern.segmentsSize;
                        }
                        if (n3 < 0) {
                            n3 = 0;
                        }
                        int n4 = (int)(lArray[n3] >>> 32);
                        int n5 = (int)lArray[n2];
                        this.match.setOffset(n4);
                        this.match.setLength(n5 - n4 + 1);
                        this.matchReportReference(qualifiedTypeReference, n2, referenceBinding, matchLocator);
                    }
                    return;
                }
                --n2;
                referenceBinding = referenceBinding.enclosingType();
            }
        }
        matchLocator.reportAccurateTypeReference(this.match, qualifiedTypeReference, this.pattern.simpleName);
    }

    void matchReportReference(Expression expression, int n, TypeBinding typeBinding, MatchLocator matchLocator) throws CoreException {
        Object object;
        ReferenceBinding referenceBinding;
        if (typeBinding.isParameterizedType() || typeBinding.isRawType()) {
            boolean bl;
            referenceBinding = (ParameterizedTypeBinding)typeBinding;
            this.updateMatch((ParameterizedTypeBinding)referenceBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, matchLocator);
            if (this.match.getRule() == 0) {
                return;
            }
            boolean bl2 = bl = this.isErasureMatch && this.match.isErasure() || this.isEquivalentMatch && this.match.isEquivalent() || this.match.isExact();
            if (!bl) {
                return;
            }
            if (typeBinding.isParameterizedType() && this.pattern.hasTypeArguments()) {
                object = null;
                TypeReference[] typeReferenceArray = null;
                if (expression instanceof ParameterizedQualifiedTypeReference) {
                    object = (ParameterizedQualifiedTypeReference)expression;
                    typeReferenceArray = ((ParameterizedQualifiedTypeReference)expression).typeArguments[n];
                } else if (expression instanceof ParameterizedSingleTypeReference) {
                    object = (ParameterizedSingleTypeReference)expression;
                    typeReferenceArray = ((ParameterizedSingleTypeReference)expression).typeArguments;
                }
                if (object != null) {
                    matchLocator.reportAccurateParameterizedTypeReference(this.match, (TypeReference)object, n, typeReferenceArray);
                    return;
                }
            }
        } else if (this.pattern.hasTypeArguments()) {
            this.match.setRule(16);
        }
        if (expression instanceof ArrayTypeReference) {
            matchLocator.reportAccurateTypeReference(this.match, expression, this.pattern.simpleName);
            return;
        }
        if (typeBinding.isLocalType()) {
            referenceBinding = (LocalTypeBinding)typeBinding;
            IJavaElement iJavaElement = this.pattern.focus;
            if (iJavaElement != null && ((LocalTypeBinding)referenceBinding).enclosingMethod != null && iJavaElement.getParent().getElementType() == 9 && !CharOperation.equals(((LocalTypeBinding)referenceBinding).enclosingMethod.selector, (object = (IMethod)iJavaElement.getParent()).getElementName().toCharArray())) {
                return;
            }
        }
        matchLocator.report(this.match);
    }

    protected int referenceType() {
        return 7;
    }

    protected void reportDeclaration(ASTNode aSTNode, IJavaElement iJavaElement, MatchLocator matchLocator, SimpleSet simpleSet) throws CoreException {
        Object object;
        Object object2;
        int n;
        block15: {
            block16: {
                block14: {
                    n = -1;
                    object2 = null;
                    if (!(aSTNode instanceof TypeReference)) break block14;
                    object2 = ((TypeReference)aSTNode).resolvedType;
                    n = Integer.MAX_VALUE;
                    break block15;
                }
                if (!(aSTNode instanceof QualifiedNameReference)) break block16;
                object = (QualifiedNameReference)aSTNode;
                Binding binding = ((QualifiedNameReference)object).binding;
                n = ((QualifiedNameReference)object).tokens.length - 1;
                switch (((QualifiedNameReference)object).bits & 0xF) {
                    case 1: {
                        object2 = ((QualifiedNameReference)object).actualReceiverType;
                        n -= ((QualifiedNameReference)object).otherBindings == null ? 1 : ((QualifiedNameReference)object).otherBindings.length + 1;
                        break;
                    }
                    case 4: {
                        if (binding instanceof TypeBinding) {
                            object2 = (TypeBinding)binding;
                            break;
                        }
                        break block15;
                    }
                    case 3: 
                    case 7: {
                        if (binding instanceof ProblemFieldBinding) {
                            object2 = ((QualifiedNameReference)object).actualReceiverType;
                            n -= ((QualifiedNameReference)object).otherBindings == null ? 1 : ((QualifiedNameReference)object).otherBindings.length + 1;
                            break;
                        }
                        if (binding instanceof ProblemBinding) {
                            ProblemBinding problemBinding = (ProblemBinding)binding;
                            object2 = problemBinding.searchType;
                            char[] cArray = problemBinding.name;
                            n = CharOperation.occurencesOf('.', cArray) - 1;
                            if (object2 == null || n < 0) {
                                return;
                            }
                        }
                        break block15;
                    }
                }
                break block15;
            }
            if (aSTNode instanceof SingleNameReference) {
                object2 = (TypeBinding)((SingleNameReference)aSTNode).binding;
                n = 1;
            }
        }
        if (object2 instanceof ArrayBinding) {
            object2 = ((ArrayBinding)object2).leafComponentType;
        }
        if (object2 == null || object2 instanceof BaseTypeBinding) {
            return;
        }
        if (object2 instanceof ProblemReferenceBinding) {
            object = ((ProblemReferenceBinding)object2).closestMatch();
            if (object == null) {
                return;
            }
            object2 = object;
        }
        object2 = ((TypeBinding)object2).erasure();
        this.reportDeclaration((ReferenceBinding)object2, n, matchLocator, simpleSet);
    }

    protected void reportDeclaration(ReferenceBinding referenceBinding, int n, MatchLocator matchLocator, SimpleSet simpleSet) throws CoreException {
        IType iType = matchLocator.lookupType(referenceBinding);
        if (iType == null) {
            return;
        }
        IResource iResource = iType.getResource();
        boolean bl = iType.isBinary();
        IBinaryType iBinaryType = null;
        if (bl) {
            if (iResource == null) {
                iResource = iType.getJavaProject().getProject();
            }
            iBinaryType = matchLocator.getBinaryInfo((ClassFile)iType.getClassFile(), iResource);
        }
        while (n >= 0 && iType != null) {
            Object object;
            if (!simpleSet.includes(iType)) {
                if (bl) {
                    matchLocator.reportBinaryMemberDeclaration(iResource, iType, referenceBinding, iBinaryType, 0);
                } else {
                    if (referenceBinding instanceof ParameterizedTypeBinding) {
                        referenceBinding = ((ParameterizedTypeBinding)referenceBinding).genericType();
                    }
                    if ((object = (ClassScope)((SourceTypeBinding)referenceBinding).scope) != null) {
                        TypeDeclaration typeDeclaration = ((ClassScope)object).referenceContext;
                        int n2 = typeDeclaration.sourceStart;
                        this.match = new TypeDeclarationMatch(((JavaElement)((Object)iType)).resolved(referenceBinding), 0, n2, typeDeclaration.sourceEnd - n2 + 1, matchLocator.getParticipant(), iResource);
                        matchLocator.report(this.match);
                    }
                }
                simpleSet.add(iType);
            }
            referenceBinding = referenceBinding.enclosingType();
            object = iType.getParent();
            iType = object instanceof IType ? (IType)object : null;
            --n;
        }
    }

    public int resolveLevel(ASTNode aSTNode) {
        if (aSTNode instanceof TypeReference) {
            return this.resolveLevel((TypeReference)aSTNode);
        }
        if (aSTNode instanceof NameReference) {
            return this.resolveLevel((NameReference)aSTNode);
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        IPackageFragment iPackageFragment;
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof TypeBinding)) {
            return 0;
        }
        TypeBinding typeBinding = (TypeBinding)binding;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            typeBinding = ((ProblemReferenceBinding)typeBinding).closestMatch();
        }
        if (this.pattern.focus instanceof IType && typeBinding instanceof ReferenceBinding && !PackageReferenceLocator.isDeclaringPackageFragment(iPackageFragment = ((IType)this.pattern.focus).getPackageFragment(), (ReferenceBinding)typeBinding)) {
            return 0;
        }
        return this.resolveLevelForTypeOrEnclosingTypes(this.pattern.simpleName, this.pattern.qualification, typeBinding);
    }

    protected int resolveLevel(NameReference nameReference) {
        Binding binding = nameReference.binding;
        if (nameReference instanceof SingleNameReference) {
            if (binding instanceof ProblemReferenceBinding) {
                binding = ((ProblemReferenceBinding)binding).closestMatch();
            }
            if (binding instanceof ReferenceBinding) {
                return this.resolveLevelForType((ReferenceBinding)binding);
            }
            return binding == null || binding instanceof ProblemBinding ? 1 : 0;
        }
        TypeBinding typeBinding = null;
        QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)nameReference;
        switch (qualifiedNameReference.bits & 0xF) {
            case 1: {
                if (qualifiedNameReference.tokens.length < (qualifiedNameReference.otherBindings == null ? 2 : qualifiedNameReference.otherBindings.length + 2)) {
                    return 0;
                }
                typeBinding = nameReference.actualReceiverType;
                break;
            }
            case 2: {
                return 0;
            }
            case 4: {
                if (!(binding instanceof TypeBinding)) break;
                typeBinding = (TypeBinding)binding;
                break;
            }
            case 3: 
            case 7: {
                if (binding instanceof ProblemReferenceBinding) {
                    typeBinding = (TypeBinding)binding;
                    break;
                }
                if (binding instanceof ProblemFieldBinding) {
                    if (qualifiedNameReference.tokens.length < (qualifiedNameReference.otherBindings == null ? 2 : qualifiedNameReference.otherBindings.length + 2)) {
                        return 0;
                    }
                    typeBinding = nameReference.actualReceiverType;
                    break;
                }
                if (!(binding instanceof ProblemBinding)) break;
                ProblemBinding problemBinding = (ProblemBinding)binding;
                if (CharOperation.occurencesOf('.', problemBinding.name) <= 0) {
                    return 1;
                }
                typeBinding = problemBinding.searchType;
            }
        }
        return this.resolveLevel(typeBinding);
    }

    protected int resolveLevel(TypeReference typeReference) {
        TypeBinding typeBinding = typeReference.resolvedType;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            typeBinding = ((ProblemReferenceBinding)typeBinding).closestMatch();
        }
        if (typeReference instanceof SingleTypeReference) {
            return this.resolveLevelForType(typeBinding);
        }
        return this.resolveLevelForTypeOrEnclosingTypes(this.pattern.simpleName, this.pattern.qualification, typeBinding);
    }

    protected int resolveLevelForType(TypeBinding typeBinding) {
        return this.resolveLevelForType(this.pattern.simpleName, this.pattern.qualification, this.pattern.getTypeArguments(), 0, typeBinding);
    }

    protected int resolveLevelForTypeOrEnclosingTypes(char[] cArray, char[] cArray2, TypeBinding typeBinding) {
        if (typeBinding == null) {
            return 1;
        }
        if (typeBinding instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
            while (referenceBinding != null) {
                int n = this.resolveLevelForType(referenceBinding);
                if (n != 0) {
                    return n;
                }
                referenceBinding = referenceBinding.enclosingType();
            }
        }
        return 0;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

