/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.AndPattern;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class TypeReferencePattern
extends AndPattern {
    protected char[] qualification;
    protected char[] simpleName;
    protected char[] currentCategory;
    public int segmentsSize;
    protected char[][] segments;
    protected int currentSegment;
    protected static char[][] CATEGORIES = new char[][]{REF};

    public TypeReferencePattern(char[] cArray, char[] cArray2, int n) {
        this(n);
        this.qualification = this.isCaseSensitive() ? cArray : CharOperation.toLowerCase(cArray);
        char[] cArray3 = this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? cArray2 : CharOperation.toLowerCase(cArray2);
        this.segments = (char[][])(cArray2 == null ? (this.qualification == null ? ONE_STAR_CHAR : CharOperation.splitOn('.', this.qualification)) : null);
        this.segmentsSize = this.segments == null ? (this.qualification == null ? 0 : CharOperation.occurencesOf('.', this.qualification) + 1) : this.segments.length;
        this.mustResolve = true;
    }

    public TypeReferencePattern(char[] cArray, char[] cArray2, String string, int n) {
        this(cArray, cArray2, n);
        if (string != null) {
            this.typeSignatures = Util.splitTypeLevelsSignature(string);
            this.setTypeArguments(Util.getAllTypeArguments(this.typeSignatures));
            if (this.hasTypeArguments()) {
                this.segmentsSize = this.getTypeArguments().length + CharOperation.occurencesOf('/', this.typeSignatures[0]) - 1;
            }
        }
    }

    public TypeReferencePattern(char[] cArray, char[] cArray2, IType iType, int n) {
        this(cArray, cArray2, n);
        this.storeTypeSignaturesAndArguments(iType);
    }

    TypeReferencePattern(int n) {
        super(4, n);
    }

    public void decodeIndexKey(char[] cArray) {
        this.simpleName = cArray;
    }

    public SearchPattern getBlankPattern() {
        return new TypeReferencePattern(8);
    }

    public char[] getIndexKey() {
        if (this.simpleName != null) {
            return this.simpleName;
        }
        if (this.currentSegment >= 0) {
            return this.segments[this.currentSegment];
        }
        return null;
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    protected boolean hasNextQuery() {
        if (this.segments == null) {
            return false;
        }
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    public boolean matchesDecodedKey(SearchPattern searchPattern) {
        return true;
    }

    protected void resetQuery() {
        if (this.segments != null) {
            this.currentSegment = this.segments.length - 1;
        }
    }

    protected StringBuffer print(StringBuffer stringBuffer) {
        stringBuffer.append("TypeReferencePattern: qualification<");
        if (this.qualification != null) {
            stringBuffer.append(this.qualification);
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append(">, type<");
        if (this.simpleName != null) {
            stringBuffer.append(this.simpleName);
        } else {
            stringBuffer.append("*");
        }
        stringBuffer.append(">");
        return super.print(stringBuffer);
    }
}

