/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.Compiler;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.CastExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.wst.jsdt.internal.core.util.BindingKeyParser;
import org.eclipse.wst.jsdt.internal.core.util.BindingKeyResolver;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class BindingKeyResolver
extends BindingKeyParser {
    Compiler compiler;
    Binding compilerBinding;
    char[][] compoundName;
    int dimension;
    LookupEnvironment environment;
    ReferenceBinding genericType;
    MethodBinding methodBinding;
    char[] secondarySimpleName;
    CompilationUnitDeclaration parsedUnit;
    BlockScope scope;
    TypeBinding typeBinding;
    TypeDeclaration typeDeclaration;
    ArrayList types = new ArrayList();
    int rank = 0;
    int wildcardRank;
    CompilationUnitDeclaration outerMostParsedUnit;

    private BindingKeyResolver(BindingKeyParser bindingKeyParser, Compiler compiler, LookupEnvironment lookupEnvironment, int n, CompilationUnitDeclaration compilationUnitDeclaration) {
        super(bindingKeyParser);
        this.compiler = compiler;
        this.environment = lookupEnvironment;
        this.wildcardRank = n;
        this.outerMostParsedUnit = compilationUnitDeclaration;
    }

    public BindingKeyResolver(String string) {
        this(string, null, null);
    }

    public BindingKeyResolver(String string, Compiler compiler, LookupEnvironment lookupEnvironment) {
        super(string);
        this.compiler = compiler;
        this.environment = lookupEnvironment;
    }

    public char[][] compoundName() {
        return this.compoundName;
    }

    public void consumeArrayDimension(char[] cArray) {
        this.dimension = cArray.length;
    }

    public void consumeBaseType(char[] cArray) {
        this.compoundName = new char[][]{this.getKey().toCharArray()};
        TypeBinding typeBinding = this.getBaseTypeBinding(cArray);
        if (typeBinding != null) {
            this.typeBinding = typeBinding;
        }
    }

    public void consumeCapture(int n) {
        CompilationUnitDeclaration compilationUnitDeclaration;
        CompilationUnitDeclaration compilationUnitDeclaration2 = compilationUnitDeclaration = this.outerMostParsedUnit == null ? this.parsedUnit : this.outerMostParsedUnit;
        if (compilationUnitDeclaration == null) {
            return;
        }
        Binding binding = ((BindingKeyResolver)this.types.get((int)0)).compilerBinding;
        class CaptureFinder
        extends ASTVisitor {
            CaptureBinding capture;
            final /* synthetic */ BindingKeyResolver this$0;
            private final /* synthetic */ int val$position;
            private final /* synthetic */ Binding val$wildcardBinding;

            CaptureFinder(BindingKeyResolver bindingKeyResolver, int n, Binding binding) {
                this.this$0 = bindingKeyResolver;
                this.val$position = n;
                this.val$wildcardBinding = binding;
            }

            boolean checkType(TypeBinding typeBinding) {
                if (typeBinding == null) {
                    return false;
                }
                switch (typeBinding.kind()) {
                    case 260: {
                        TypeBinding[] typeBindingArray = ((ParameterizedTypeBinding)typeBinding).arguments;
                        if (typeBindingArray == null) {
                            return false;
                        }
                        int n = 0;
                        int n2 = typeBindingArray.length;
                        while (n < n2) {
                            if (this.checkType(typeBindingArray[n])) {
                                return true;
                            }
                            ++n;
                        }
                        break;
                    }
                    case 516: {
                        return this.checkType(((WildcardBinding)typeBinding).bound);
                    }
                    case 68: {
                        return this.checkType(((ArrayBinding)typeBinding).leafComponentType);
                    }
                    case 4100: {
                        if (!typeBinding.isCapture()) break;
                        CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                        if (captureBinding.position != this.val$position || captureBinding.wildcard != this.val$wildcardBinding) break;
                        this.capture = captureBinding;
                        return true;
                    }
                }
                return false;
            }

            public boolean visit(SingleNameReference singleNameReference, BlockScope blockScope) {
                if (this.checkType(singleNameReference.resolvedType)) {
                    return false;
                }
                return super.visit(singleNameReference, blockScope);
            }

            public boolean visit(QualifiedNameReference qualifiedNameReference, BlockScope blockScope) {
                if (this.checkType(qualifiedNameReference.resolvedType)) {
                    return false;
                }
                return super.visit(qualifiedNameReference, blockScope);
            }

            public boolean visit(MessageSend messageSend, BlockScope blockScope) {
                if (this.checkType(messageSend.resolvedType)) {
                    return false;
                }
                return super.visit(messageSend, blockScope);
            }

            public boolean visit(FieldReference fieldReference, BlockScope blockScope) {
                if (this.checkType(fieldReference.resolvedType)) {
                    return false;
                }
                return super.visit(fieldReference, blockScope);
            }

            public boolean visit(ConditionalExpression conditionalExpression, BlockScope blockScope) {
                if (this.checkType(conditionalExpression.resolvedType)) {
                    return false;
                }
                return super.visit(conditionalExpression, blockScope);
            }

            public boolean visit(CastExpression castExpression, BlockScope blockScope) {
                if (this.checkType(castExpression.resolvedType)) {
                    return false;
                }
                return super.visit(castExpression, blockScope);
            }

            public boolean visit(Assignment assignment, BlockScope blockScope) {
                if (this.checkType(assignment.resolvedType)) {
                    return false;
                }
                return super.visit(assignment, blockScope);
            }

            public boolean visit(ArrayReference arrayReference, BlockScope blockScope) {
                if (this.checkType(arrayReference.resolvedType)) {
                    return false;
                }
                return super.visit(arrayReference, blockScope);
            }
        }
        CaptureFinder captureFinder = new CaptureFinder(this, n, binding);
        compilationUnitDeclaration.traverse((ASTVisitor)captureFinder, compilationUnitDeclaration.scope);
        this.typeBinding = captureFinder.capture;
    }

    public void consumeException() {
        this.types = new ArrayList();
    }

    public void consumeField(char[] cArray) {
        FieldBinding[] fieldBindingArray = ((ReferenceBinding)this.typeBinding).availableFields();
        int n = 0;
        int n2 = fieldBindingArray.length;
        while (n < n2) {
            FieldBinding fieldBinding = fieldBindingArray[n];
            if (CharOperation.equals(cArray, fieldBinding.name)) {
                this.typeBinding = null;
                this.compilerBinding = fieldBinding;
                return;
            }
            ++n;
        }
    }

    public void consumeParameterizedGenericMethod() {
        if (this.methodBinding == null) {
            return;
        }
        TypeBinding[] typeBindingArray = this.getTypeBindingArguments();
        this.methodBinding = typeBindingArray.length != this.methodBinding.typeVariables().length ? this.environment.createParameterizedGenericMethod(this.methodBinding, (RawTypeBinding)null) : this.environment.createParameterizedGenericMethod(this.methodBinding, typeBindingArray);
        this.compilerBinding = this.methodBinding;
    }

    public void consumeLocalType(char[] cArray) {
        LocalTypeBinding[] localTypeBindingArray = this.parsedUnit.localTypes;
        int n = 0;
        while (n < this.parsedUnit.localTypeCount) {
            if (CharOperation.equals(cArray, localTypeBindingArray[n].computeUniqueKey(false))) {
                this.typeBinding = localTypeBindingArray[n];
                return;
            }
            ++n;
        }
    }

    public void consumeLocalVar(char[] cArray) {
        if (this.scope == null) {
            this.scope = this.methodBinding.sourceMethod().scope;
        }
        int n = 0;
        while (n < this.scope.localIndex) {
            LocalVariableBinding localVariableBinding = this.scope.locals[n];
            if (CharOperation.equals(cArray, localVariableBinding.name)) {
                this.methodBinding = null;
                this.compilerBinding = localVariableBinding;
                return;
            }
            ++n;
        }
    }

    public void consumeMethod(char[] cArray, char[] cArray2) {
        MethodBinding[] methodBindingArray = ((ReferenceBinding)this.typeBinding).availableMethods();
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            MethodBinding methodBinding = methodBindingArray[n];
            if (CharOperation.equals(cArray, methodBinding.selector) || cArray.length == 0 && methodBinding.isConstructor()) {
                char[] cArray3 = methodBinding.genericSignature();
                if (cArray3 == null) {
                    cArray3 = methodBinding.signature();
                }
                if (CharOperation.equals(cArray2, cArray3)) {
                    this.typeBinding = null;
                    this.methodBinding = methodBinding;
                    this.compilerBinding = this.methodBinding;
                    return;
                }
            }
            ++n;
        }
    }

    public void consumeMemberType(char[] cArray) {
        this.typeBinding = this.getTypeBinding(cArray);
    }

    public void consumePackage(char[] cArray) {
        this.compoundName = CharOperation.splitOn('/', cArray);
        this.compilerBinding = new PackageBinding(this.compoundName, null, this.environment);
    }

    public void consumeParameterizedType(char[] cArray, boolean bl) {
        TypeBinding[] typeBindingArray = this.getTypeBindingArguments();
        if (cArray != null) {
            this.genericType = this.genericType == null ? ((ReferenceBinding)this.typeBinding).getMemberType(cArray) : this.genericType.getMemberType(cArray);
            this.typeBinding = !bl ? this.environment.createParameterizedType(this.genericType, typeBindingArray, (ReferenceBinding)this.typeBinding) : this.environment.createRawType(this.genericType, (ReferenceBinding)this.typeBinding);
        } else {
            this.genericType = (ReferenceBinding)this.typeBinding;
            ReferenceBinding referenceBinding = this.genericType.enclosingType();
            if (referenceBinding != null) {
                referenceBinding = (ReferenceBinding)this.environment.convertToRawType(referenceBinding);
            }
            this.typeBinding = this.environment.createParameterizedType(this.genericType, typeBindingArray, referenceBinding);
        }
    }

    public void consumeParser(BindingKeyParser bindingKeyParser) {
        this.types.add(bindingKeyParser);
        if (((BindingKeyResolver)bindingKeyParser).compilerBinding instanceof WildcardBinding) {
            ++this.rank;
        }
    }

    public void consumeScope(int n) {
        if (this.scope == null) {
            this.scope = this.methodBinding.sourceMethod().scope;
        }
        if (n >= this.scope.subscopeCount) {
            return;
        }
        this.scope = (BlockScope)this.scope.subscopes[n];
    }

    public void consumeRawType() {
        if (this.typeBinding == null) {
            return;
        }
        this.typeBinding = this.environment.convertToRawType(this.typeBinding);
    }

    public void consumeSecondaryType(char[] cArray) {
        this.secondarySimpleName = cArray;
    }

    public void consumeFullyQualifiedName(char[] cArray) {
        this.compoundName = CharOperation.splitOn('/', cArray);
    }

    public void consumeTopLevelType() {
        this.parsedUnit = this.getCompilationUnitDeclaration();
        if (this.parsedUnit != null && this.compiler != null) {
            this.compiler.process(this.parsedUnit, this.compiler.totalUnits + 1);
        }
        if (this.parsedUnit == null) {
            this.typeBinding = this.getBinaryBinding();
        } else {
            char[] cArray = this.secondarySimpleName == null ? this.compoundName[this.compoundName.length - 1] : this.secondarySimpleName;
            this.typeBinding = this.getTypeBinding(cArray);
        }
    }

    public void consumeKey() {
        if (this.typeBinding != null) {
            this.typeBinding = this.getArrayBinding(this.dimension, this.typeBinding);
            this.compilerBinding = this.typeBinding;
        }
    }

    public void consumeTypeVariable(char[] cArray, char[] cArray2) {
        if (cArray.length > 0) {
            int n = Integer.parseInt(new String(cArray));
            MethodBinding[] methodBindingArray = ((ReferenceBinding)this.typeBinding).availableMethods();
            if (methodBindingArray != null && n < methodBindingArray.length) {
                this.methodBinding = methodBindingArray[n];
            }
        }
        TypeVariableBinding[] typeVariableBindingArray = this.methodBinding != null ? this.methodBinding.typeVariables() : this.typeBinding.typeVariables();
        int n = 0;
        int n2 = typeVariableBindingArray.length;
        while (n < n2) {
            TypeVariableBinding typeVariableBinding = typeVariableBindingArray[n];
            if (CharOperation.equals(cArray2, typeVariableBinding.sourceName())) {
                this.typeBinding = typeVariableBinding;
                return;
            }
            ++n;
        }
    }

    public void consumeTypeWithCapture() {
        BindingKeyResolver bindingKeyResolver = (BindingKeyResolver)this.types.get(0);
        this.typeBinding = (TypeBinding)bindingKeyResolver.compilerBinding;
    }

    public void consumeWildCard(int n) {
        switch (n) {
            case 1: 
            case 2: {
                BindingKeyResolver bindingKeyResolver = (BindingKeyResolver)this.types.get(0);
                this.typeBinding = this.environment.createWildcard((ReferenceBinding)this.typeBinding, this.wildcardRank, (TypeBinding)bindingKeyResolver.compilerBinding, null, n);
                break;
            }
            case 0: {
                this.typeBinding = this.environment.createWildcard((ReferenceBinding)this.typeBinding, this.rank++, null, null, n);
            }
        }
    }

    private TypeBinding getArrayBinding(int n, TypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        if (n == 0) {
            return typeBinding;
        }
        return this.environment.createArrayType(typeBinding, n);
    }

    private TypeBinding getBaseTypeBinding(char[] cArray) {
        switch (cArray[0]) {
            case 'I': {
                return TypeBinding.INT;
            }
            case 'Z': {
                return TypeBinding.BOOLEAN;
            }
            case 'V': {
                return TypeBinding.VOID;
            }
            case 'C': {
                return TypeBinding.CHAR;
            }
            case 'D': {
                return TypeBinding.DOUBLE;
            }
            case 'B': {
                return TypeBinding.BYTE;
            }
            case 'F': {
                return TypeBinding.FLOAT;
            }
            case 'J': {
                return TypeBinding.LONG;
            }
            case 'S': {
                return TypeBinding.SHORT;
            }
            case 'N': {
                return TypeBinding.NULL;
            }
        }
        return null;
    }

    private TypeBinding getBinaryBinding() {
        if (this.compoundName.length == 0) {
            return null;
        }
        return this.environment.getType(this.compoundName);
    }

    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        Object object = this.compoundName;
        if (((char[][])object).length == 0) {
            return null;
        }
        if (this.environment == null) {
            return null;
        }
        ReferenceBinding referenceBinding = this.environment.getType((char[][])object);
        if (!(referenceBinding instanceof SourceTypeBinding)) {
            if (this.secondarySimpleName == null) {
                return null;
            }
            int n = ((char[][])object).length;
            char[][] cArray = object;
            char[][] cArrayArray = new char[n][];
            object = cArrayArray;
            System.arraycopy(cArray, 0, cArrayArray, 0, n - 1);
            object[n - 1] = this.secondarySimpleName;
            referenceBinding = this.environment.getType((char[][])object);
            if (!(referenceBinding instanceof SourceTypeBinding)) {
                return null;
            }
        }
        SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)referenceBinding;
        if (sourceTypeBinding.scope == null) {
            return null;
        }
        return sourceTypeBinding.scope.compilationUnitScope().referenceContext;
    }

    public Binding getCompilerBinding() {
        try {
            this.parse();
            return this.compilerBinding;
        }
        catch (RuntimeException runtimeException) {
            Util.log(runtimeException, "Could not create binding from binding key: " + this.getKey());
            return null;
        }
    }

    private TypeBinding getTypeBinding(char[] cArray) {
        TypeDeclaration[] typeDeclarationArray;
        if (this.typeBinding instanceof BinaryTypeBinding) {
            return ((BinaryTypeBinding)this.typeBinding).getMemberType(cArray);
        }
        Object object = this.typeDeclaration == null ? (this.parsedUnit == null ? null : this.parsedUnit.types) : (typeDeclarationArray = this.typeDeclaration.memberTypes);
        if (typeDeclarationArray == null) {
            return null;
        }
        int n = 0;
        int n2 = typeDeclarationArray.length;
        while (n < n2) {
            TypeDeclaration typeDeclaration = typeDeclarationArray[n];
            if (CharOperation.equals(cArray, typeDeclaration.name)) {
                this.typeDeclaration = typeDeclaration;
                return typeDeclaration.binding;
            }
            ++n;
        }
        return null;
    }

    private TypeBinding[] getTypeBindingArguments() {
        int n = this.types.size();
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        int n2 = 0;
        while (n2 < n) {
            BindingKeyResolver bindingKeyResolver = (BindingKeyResolver)this.types.get(n2);
            TypeBinding typeBinding = (TypeBinding)bindingKeyResolver.compilerBinding;
            if (typeBinding == null) {
                throw new IllegalArgumentException();
            }
            typeBindingArray[n2] = typeBinding;
            ++n2;
        }
        this.types = new ArrayList();
        return typeBindingArray;
    }

    public void malformedKey() {
        this.compoundName = CharOperation.NO_CHAR_CHAR;
    }

    public BindingKeyParser newParser() {
        return new BindingKeyResolver(this, this.compiler, this.environment, this.rank, this.outerMostParsedUnit == null ? this.parsedUnit : this.outerMostParsedUnit);
    }

    public String toString() {
        return this.getKey();
    }
}

