/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.internal.core.util.Util;

public final class HashtableOfArrayToObject
implements Cloneable {
    public Object[][] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfArrayToObject() {
        this(13);
    }

    public HashtableOfArrayToObject(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new Object[n2][];
        this.valueTable = new Object[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        HashtableOfArrayToObject hashtableOfArrayToObject = (HashtableOfArrayToObject)super.clone();
        hashtableOfArrayToObject.elementSize = this.elementSize;
        hashtableOfArrayToObject.threshold = this.threshold;
        int n = this.keyTable.length;
        hashtableOfArrayToObject.keyTable = new Object[n][];
        System.arraycopy(this.keyTable, 0, hashtableOfArrayToObject.keyTable, 0, n);
        n = this.valueTable.length;
        hashtableOfArrayToObject.valueTable = new Object[n];
        System.arraycopy(this.valueTable, 0, hashtableOfArrayToObject.valueTable, 0, n);
        return hashtableOfArrayToObject;
    }

    public boolean containsKey(Object[] objectArray) {
        Object[] objectArray2;
        int n = this.keyTable.length;
        int n2 = this.hashCode(objectArray) % n;
        int n3 = objectArray.length;
        while ((objectArray2 = this.keyTable[n2]) != null) {
            if (objectArray2.length == n3 && Util.equalArraysOrNull(objectArray2, objectArray)) {
                return true;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return false;
    }

    public Object get(Object[] objectArray) {
        Object[] objectArray2;
        int n = this.keyTable.length;
        int n2 = this.hashCode(objectArray) % n;
        int n3 = objectArray.length;
        while ((objectArray2 = this.keyTable[n2]) != null) {
            if (objectArray2.length == n3 && Util.equalArraysOrNull(objectArray2, objectArray)) {
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public Object[] getKey(Object[] objectArray, int n) {
        Object[] objectArray2;
        int n2 = this.keyTable.length;
        int n3 = this.hashCode(objectArray, n) % n2;
        while ((objectArray2 = this.keyTable[n3]) != null) {
            if (objectArray2.length == n && Util.equalArrays(objectArray2, objectArray, n)) {
                return objectArray2;
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        return null;
    }

    private int hashCode(Object[] objectArray) {
        return this.hashCode(objectArray, objectArray.length);
    }

    private int hashCode(Object[] objectArray, int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            n2 = Util.combineHashCodes(n2, objectArray[n3].hashCode());
            --n3;
        }
        return n2 & Integer.MAX_VALUE;
    }

    public Object put(Object[] objectArray, Object object) {
        Object[] objectArray2;
        int n = this.keyTable.length;
        int n2 = this.hashCode(objectArray) % n;
        int n3 = objectArray.length;
        while ((objectArray2 = this.keyTable[n2]) != null) {
            if (objectArray2.length == n3 && Util.equalArraysOrNull(objectArray2, objectArray)) {
                this.valueTable[n2] = object;
                return this.valueTable[n2];
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.keyTable[n2] = objectArray;
        this.valueTable[n2] = object;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object;
    }

    public Object removeKey(Object[] objectArray) {
        Object[] objectArray2;
        int n = this.keyTable.length;
        int n2 = this.hashCode(objectArray) % n;
        int n3 = objectArray.length;
        while ((objectArray2 = this.keyTable[n2]) != null) {
            if (objectArray2.length == n3 && Util.equalArraysOrNull(objectArray2, objectArray)) {
                Object object = this.valueTable[n2];
                --this.elementSize;
                this.keyTable[n2] = null;
                this.valueTable[n2] = null;
                this.rehash();
                return object;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    private void rehash() {
        HashtableOfArrayToObject hashtableOfArrayToObject = new HashtableOfArrayToObject(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            Object[] objectArray = this.keyTable[n];
            if (objectArray == null) continue;
            hashtableOfArrayToObject.put(objectArray, this.valueTable[n]);
        }
        this.keyTable = hashtableOfArrayToObject.keyTable;
        this.valueTable = hashtableOfArrayToObject.valueTable;
        this.threshold = hashtableOfArrayToObject.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.keyTable.length;
        while (n < n2) {
            Object[] objectArray = this.keyTable[n];
            if (objectArray != null) {
                stringBuffer.append('{');
                int n3 = 0;
                int n4 = objectArray.length;
                while (n3 < n4) {
                    stringBuffer.append(objectArray[n3]);
                    if (n3 != n4 - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n3;
                }
                stringBuffer.append("} -> ");
                stringBuffer.append(this.valueTable[n]);
                if (n != n2 - 1) {
                    stringBuffer.append('\n');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

