/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;

public class WeakHashSetOfCharArray {
    HashableWeakReference[] values;
    public int elementSize = 0;
    int threshold;
    ReferenceQueue referenceQueue = new ReferenceQueue();

    public WeakHashSetOfCharArray() {
        this(5);
    }

    public WeakHashSetOfCharArray(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.values = new HashableWeakReference[n2];
    }

    public char[] add(char[] cArray) {
        HashableWeakReference hashableWeakReference;
        this.cleanupGarbageCollectedValues();
        int n = this.values.length;
        int n2 = (CharOperation.hashCode(cArray) & Integer.MAX_VALUE) % n;
        while ((hashableWeakReference = this.values[n2]) != null) {
            char[] cArray2 = (char[])hashableWeakReference.get();
            if (CharOperation.equals(cArray, cArray2)) {
                return cArray2;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.values[n2] = new HashableWeakReference(cArray, this.referenceQueue);
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return cArray;
    }

    private void addValue(HashableWeakReference hashableWeakReference) {
        HashableWeakReference hashableWeakReference2;
        char[] cArray = (char[])hashableWeakReference.get();
        if (cArray == null) {
            return;
        }
        int n = this.values.length;
        int n2 = (hashableWeakReference.hashCode & Integer.MAX_VALUE) % n;
        while ((hashableWeakReference2 = this.values[n2]) != null) {
            if (CharOperation.equals(cArray, (char[])hashableWeakReference2.get())) {
                return;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        this.values[n2] = hashableWeakReference;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
    }

    private void cleanupGarbageCollectedValues() {
        HashableWeakReference hashableWeakReference;
        block0: while ((hashableWeakReference = (HashableWeakReference)this.referenceQueue.poll()) != null) {
            HashableWeakReference hashableWeakReference2;
            int n = hashableWeakReference.hashCode;
            int n2 = this.values.length;
            int n3 = (n & Integer.MAX_VALUE) % n2;
            while ((hashableWeakReference2 = this.values[n3]) != null) {
                if (hashableWeakReference2 == hashableWeakReference) {
                    int n4;
                    int n5 = n3;
                    while ((hashableWeakReference2 = this.values[n4 = (n5 + 1) % n2]) != null && hashableWeakReference2.hashCode == n) {
                        n5 = n4;
                    }
                    this.values[n3] = this.values[n5];
                    this.values[n5] = null;
                    --this.elementSize;
                    continue block0;
                }
                if (++n3 != n2) continue;
                n3 = 0;
            }
        }
    }

    public boolean contains(char[] cArray) {
        return this.get(cArray) != null;
    }

    public char[] get(char[] cArray) {
        HashableWeakReference hashableWeakReference;
        this.cleanupGarbageCollectedValues();
        int n = this.values.length;
        int n2 = (CharOperation.hashCode(cArray) & Integer.MAX_VALUE) % n;
        while ((hashableWeakReference = this.values[n2]) != null) {
            char[] cArray2 = (char[])hashableWeakReference.get();
            if (CharOperation.equals(cArray, cArray2)) {
                return cArray2;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    private void rehash() {
        WeakHashSetOfCharArray weakHashSetOfCharArray = new WeakHashSetOfCharArray(this.elementSize * 2);
        weakHashSetOfCharArray.referenceQueue = this.referenceQueue;
        int n = 0;
        int n2 = this.values.length;
        while (n < n2) {
            HashableWeakReference hashableWeakReference = this.values[n];
            if (hashableWeakReference != null) {
                weakHashSetOfCharArray.addValue(hashableWeakReference);
            }
            ++n;
        }
        this.values = weakHashSetOfCharArray.values;
        this.threshold = weakHashSetOfCharArray.threshold;
        this.elementSize = weakHashSetOfCharArray.elementSize;
    }

    public char[] remove(char[] cArray) {
        HashableWeakReference hashableWeakReference;
        this.cleanupGarbageCollectedValues();
        int n = this.values.length;
        int n2 = (CharOperation.hashCode(cArray) & Integer.MAX_VALUE) % n;
        while ((hashableWeakReference = this.values[n2]) != null) {
            char[] cArray2 = (char[])hashableWeakReference.get();
            if (CharOperation.equals(cArray, cArray2)) {
                --this.elementSize;
                this.values[n2] = null;
                this.rehash();
                return cArray2;
            }
            if (++n2 != n) continue;
            n2 = 0;
        }
        return null;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = 0;
        int n2 = this.values.length;
        while (n < n2) {
            char[] cArray;
            HashableWeakReference hashableWeakReference = this.values[n];
            if (hashableWeakReference != null && (cArray = (char[])hashableWeakReference.get()) != null) {
                stringBuffer.append('\"');
                stringBuffer.append(cArray);
                stringBuffer.append("\", ");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static class HashableWeakReference
    extends WeakReference {
        public int hashCode;

        public HashableWeakReference(char[] cArray, ReferenceQueue referenceQueue) {
            super(cArray, referenceQueue);
            this.hashCode = CharOperation.hashCode(cArray);
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashableWeakReference)) {
                return false;
            }
            char[] cArray = (char[])this.get();
            char[] cArray2 = (char[])((HashableWeakReference)object).get();
            if (cArray == null) {
                return cArray2 == null;
            }
            return CharOperation.equals(cArray, cArray2);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            char[] cArray = (char[])this.get();
            if (cArray == null) {
                return "[hashCode=" + this.hashCode + "] <referent was garbage collected>";
            }
            return "[hashCode=" + this.hashCode + "] \"" + new String(cArray) + '\"';
        }
    }
}

