/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter.align;

import org.eclipse.wst.jsdt.internal.formatter.Location;
import org.eclipse.wst.jsdt.internal.formatter.Scribe;
import org.eclipse.wst.jsdt.internal.formatter.align.AlignmentException;

public class Alignment {
    public String name;
    public Alignment enclosing;
    public Location location;
    public int fragmentIndex;
    public int fragmentCount;
    public int[] fragmentIndentations;
    public boolean needRedoColumnAlignment;
    public int chunkStartIndex;
    public int chunkKind;
    public int originalIndentationLevel;
    public int breakIndentationLevel;
    public int shiftBreakIndentationLevel;
    public int[] fragmentBreaks;
    public boolean wasSplit;
    public Scribe scribe;
    public static final int M_FORCE = 1;
    public static final int M_INDENT_ON_COLUMN = 2;
    public static final int M_INDENT_BY_ONE = 4;
    public static final int M_COMPACT_SPLIT = 16;
    public static final int M_COMPACT_FIRST_BREAK_SPLIT = 32;
    public static final int M_ONE_PER_LINE_SPLIT = 48;
    public static final int M_NEXT_SHIFTED_SPLIT = 64;
    public static final int M_NEXT_PER_LINE_SPLIT = 80;
    public static final int M_MULTICOLUMN = 256;
    public static final int M_NO_ALIGNMENT = 0;
    public int mode;
    public static final int SPLIT_MASK = 112;
    public static final int R_OUTERMOST = 1;
    public static final int R_INNERMOST = 2;
    public int tieBreakRule;
    public static final int NONE = 0;
    public static final int BREAK = 1;
    public static final int CHUNK_FIELD = 1;
    public static final int CHUNK_METHOD = 2;
    public static final int CHUNK_TYPE = 3;
    public static final int CHUNK_ENUM = 4;

    public Alignment(String string, int n, int n2, Scribe scribe, int n3, int n4, int n5) {
        this.name = string;
        this.location = new Location(scribe, n4);
        this.mode = n;
        this.tieBreakRule = n2;
        this.fragmentCount = n3;
        this.scribe = scribe;
        this.originalIndentationLevel = this.scribe.indentationLevel;
        this.wasSplit = false;
        int n6 = this.scribe.indentationSize;
        int n7 = this.location.outputColumn;
        if (n7 == 1) {
            n7 = this.location.outputIndentationLevel + 1;
        }
        if ((n & 2) != 0) {
            this.breakIndentationLevel = this.scribe.getNextIndentationLevel(n7);
            if (this.breakIndentationLevel == this.location.outputIndentationLevel) {
                this.breakIndentationLevel += n5 * n6;
            }
        } else {
            this.breakIndentationLevel = (n & 4) != 0 ? this.location.outputIndentationLevel + n6 : this.location.outputIndentationLevel + n5 * n6;
        }
        this.shiftBreakIndentationLevel = this.breakIndentationLevel + n6;
        this.fragmentIndentations = new int[this.fragmentCount];
        this.fragmentBreaks = new int[this.fragmentCount];
        if ((this.mode & 1) != 0) {
            this.couldBreak();
        }
    }

    public boolean checkChunkStart(int n, int n2, int n3) {
        if (this.chunkKind != n) {
            this.chunkKind = n;
            if (n2 != this.chunkStartIndex) {
                this.chunkStartIndex = n2;
                this.location.update(this.scribe, n3);
                this.reset();
            }
            return true;
        }
        return false;
    }

    public void checkColumn() {
        if ((this.mode & 0x100) != 0) {
            int n;
            int n2;
            int n3 = this.scribe.getNextIndentationLevel(this.scribe.column + (this.scribe.needSpace ? 1 : 0));
            if (n3 > (n2 = this.fragmentIndentations[this.fragmentIndex])) {
                this.fragmentIndentations[this.fragmentIndex] = n3;
                if (n2 != 0) {
                    n = this.fragmentIndex + 1;
                    while (n < this.fragmentCount) {
                        this.fragmentIndentations[n] = 0;
                        ++n;
                    }
                    this.needRedoColumnAlignment = true;
                }
            }
            if (this.needRedoColumnAlignment && this.fragmentIndex == this.fragmentCount - 1) {
                this.needRedoColumnAlignment = false;
                n = 0;
                Alignment alignment = this.scribe.memberAlignment;
                while (alignment != null) {
                    if (alignment == this) {
                        throw new AlignmentException(2, n);
                    }
                    alignment = alignment.enclosing;
                    ++n;
                }
            }
        }
    }

    public boolean couldBreak() {
        switch (this.mode & 0x70) {
            case 32: {
                if (this.fragmentBreaks[0] == 0) {
                    this.fragmentBreaks[0] = 1;
                    this.fragmentIndentations[0] = this.breakIndentationLevel;
                    this.wasSplit = true;
                    return true;
                }
                int n = this.fragmentIndex;
                do {
                    if (this.fragmentBreaks[n] != 0) continue;
                    this.fragmentBreaks[n] = 1;
                    this.fragmentIndentations[n] = this.breakIndentationLevel;
                    this.wasSplit = true;
                    return true;
                } while (--n >= 0);
                break;
            }
            case 16: {
                int n = this.fragmentIndex;
                do {
                    if (this.fragmentBreaks[n] != 0) continue;
                    this.fragmentBreaks[n] = 1;
                    this.fragmentIndentations[n] = this.breakIndentationLevel;
                    this.wasSplit = true;
                    return true;
                } while (--n >= 0);
                break;
            }
            case 64: {
                if (this.fragmentBreaks[0] != 0) break;
                this.fragmentBreaks[0] = 1;
                this.fragmentIndentations[0] = this.breakIndentationLevel;
                int n = 1;
                while (n < this.fragmentCount) {
                    this.fragmentBreaks[n] = 1;
                    this.fragmentIndentations[n] = this.shiftBreakIndentationLevel;
                    ++n;
                }
                this.wasSplit = true;
                return true;
            }
            case 48: {
                if (this.fragmentBreaks[0] == 0) {
                    int n = 0;
                    while (n < this.fragmentCount) {
                        this.fragmentBreaks[n] = 1;
                        this.fragmentIndentations[n] = this.breakIndentationLevel;
                        ++n;
                    }
                    this.wasSplit = true;
                    return true;
                }
            }
            case 80: {
                if (this.fragmentBreaks[0] != 0 || this.fragmentCount <= 1 || this.fragmentBreaks[1] != 0) break;
                if ((this.mode & 2) != 0) {
                    this.fragmentIndentations[0] = this.breakIndentationLevel;
                }
                int n = 1;
                while (n < this.fragmentCount) {
                    this.fragmentBreaks[n] = 1;
                    this.fragmentIndentations[n] = this.breakIndentationLevel;
                    ++n;
                }
                this.wasSplit = true;
                return true;
            }
        }
        return false;
    }

    public Alignment getAlignment(String string) {
        if (string.equals(this.name)) {
            return this;
        }
        if (this.enclosing == null) {
            return null;
        }
        return this.enclosing.getAlignment(string);
    }

    public void performFragmentEffect() {
        if ((this.mode & 0x100) == 0) {
            switch (this.mode & 0x70) {
                case 16: 
                case 32: 
                case 48: 
                case 64: 
                case 80: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (this.fragmentBreaks[this.fragmentIndex] == 1) {
            this.scribe.printNewLine();
        }
        if (this.fragmentIndentations[this.fragmentIndex] > 0) {
            this.scribe.indentationLevel = this.fragmentIndentations[this.fragmentIndex];
        }
    }

    public void reset() {
        if (this.fragmentCount > 0) {
            this.fragmentIndentations = new int[this.fragmentCount];
            this.fragmentBreaks = new int[this.fragmentCount];
        }
        if ((this.mode & 1) != 0) {
            this.couldBreak();
        }
    }

    public void toFragmentsString(StringBuffer stringBuffer) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.getClass().getName()).append(':').append("<name: ").append(this.name).append(">");
        if (this.enclosing != null) {
            stringBuffer.append("<enclosingName: ").append(this.enclosing.name).append('>');
        }
        stringBuffer.append('\n');
        int n = 0;
        while (n < this.fragmentCount) {
            stringBuffer.append(" - fragment ").append(n).append(": ").append("<break: ").append(this.fragmentBreaks[n] > 0 ? "YES" : "NO").append(">").append("<indent: ").append(this.fragmentIndentations[n]).append(">\n");
            ++n;
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public void update() {
        int n = 1;
        while (n < this.fragmentCount) {
            if (this.fragmentBreaks[n] == 1) {
                this.fragmentIndentations[n] = this.breakIndentationLevel;
            }
            ++n;
        }
    }

    public boolean isWrapped() {
        int n = 0;
        int n2 = this.fragmentCount;
        while (n < n2) {
            if (this.fragmentBreaks[n] == 1) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

