/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter.comment;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CommentFormatterUtil {
    public static String evaluateFormatterEdit(String string, TextEdit textEdit, Position[] positionArray) {
        try {
            Document document = CommentFormatterUtil.createDocument(string, positionArray);
            textEdit.apply((IDocument)document, 0);
            if (positionArray != null) {
                int n = 0;
                while (n < positionArray.length) {
                    Assert.isTrue((!positionArray[n].isDeleted ? 1 : 0) != 0, (String)"Position got deleted");
                    ++n;
                }
            }
            return document.get();
        }
        catch (BadLocationException badLocationException) {
            CommentFormatterUtil.log(badLocationException);
            Assert.isTrue((boolean)false, (String)("Formatter created edits with wrong positions: " + badLocationException.getMessage()));
            return null;
        }
    }

    public static TextEdit format2(int n, String string, int n2, String string2, Map map) {
        int n3 = string.length();
        if (n3 < 0 || 0 + n3 > string.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: 0, length: " + n3 + ", string size: " + string.length());
        }
        return ToolFactory.createCodeFormatter(map).format(n, string, 0, n3, n2, string2);
    }

    private static Document createDocument(String string, Position[] positionArray) throws IllegalArgumentException {
        Document document;
        block5: {
            document = new Document(string);
            try {
                if (positionArray == null) break block5;
                document.addPositionCategory("myCategory");
                document.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("myCategory"){

                    protected boolean notDeleted() {
                        if (this.fOffset < this.fPosition.offset && this.fPosition.offset + this.fPosition.length < this.fOffset + this.fLength) {
                            this.fPosition.offset = this.fOffset + this.fLength;
                            return false;
                        }
                        return true;
                    }
                });
                int n = 0;
                while (n < positionArray.length) {
                    try {
                        document.addPosition("myCategory", positionArray[n]);
                    }
                    catch (BadLocationException badLocationException) {
                        throw new IllegalArgumentException("Position outside of string. offset: " + positionArray[n].offset + ", length: " + positionArray[n].length + ", string size: " + string.length());
                    }
                    ++n;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        return document;
    }

    public static void log(Throwable throwable) {
        Util.log(throwable, "Exception occured while formatting comments");
    }
}

