/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter.comment;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.formatter.comment.SubstitutionTextReader;

public class HTMLEntity2JavaReader
extends SubstitutionTextReader {
    private static final Map fgEntityLookup = new HashMap(7);

    static {
        fgEntityLookup.put("lt", "<");
        fgEntityLookup.put("gt", ">");
        fgEntityLookup.put("nbsp", " ");
        fgEntityLookup.put("amp", "&");
        fgEntityLookup.put("circ", "^");
        fgEntityLookup.put("tilde", "~");
        fgEntityLookup.put("quot", "\"");
    }

    public HTMLEntity2JavaReader(Reader reader) {
        super(reader);
        this.setSkipWhitespace(false);
    }

    protected String computeSubstitution(int n) throws IOException {
        if (n == 38) {
            return this.processEntity();
        }
        return null;
    }

    protected String entity2Text(String string) {
        if (string.length() > 1 && string.charAt(0) == '#') {
            try {
                int n = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1), 10);
                return " " + (char)n;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String string2 = (String)fgEntityLookup.get(string);
            if (string2 != null) {
                return string2;
            }
        }
        return "&" + string;
    }

    private String processEntity() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.nextChar();
        while (ScannerHelper.isLetterOrDigit((char)n) || n == 35) {
            stringBuffer.append((char)n);
            n = this.nextChar();
        }
        if (n == 59) {
            return this.entity2Text(stringBuffer.toString());
        }
        stringBuffer.insert(0, '&');
        if (n != -1) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }
}

