/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.infer;

import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.infer.InferredMember;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class InferredMethod
extends InferredMember {
    public MethodDeclaration methodDeclaration;
    public boolean isConstructor;
    public MethodBinding methodBinding;

    public InferredMethod(char[] cArray, MethodDeclaration methodDeclaration, InferredType inferredType) {
        this.methodDeclaration = methodDeclaration;
        this.name = cArray;
        this.inType = inferredType;
        this.sourceStart = methodDeclaration.sourceStart;
        this.sourceEnd = methodDeclaration.sourceEnd;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        String string = this.isStatic ? "static " : "";
        InferredMethod.printIndent(n, stringBuffer).append(string);
        if (!this.isConstructor) {
            if (this.methodDeclaration.inferredType != null) {
                this.methodDeclaration.inferredType.dumpReference(stringBuffer);
            } else {
                stringBuffer.append("??");
            }
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.name).append("(");
        if (this.methodDeclaration.arguments != null) {
            int n2 = 0;
            while (n2 < this.methodDeclaration.arguments.length) {
                InferredType inferredType;
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                if ((inferredType = this.methodDeclaration.arguments[n2].inferredType) != null) {
                    stringBuffer.append(inferredType.name).append(" ");
                }
                stringBuffer.append(this.methodDeclaration.arguments[n2].name);
                ++n2;
            }
        }
        stringBuffer.append(")");
        return stringBuffer;
    }
}

