/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.infer;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.internal.infer.InferEngine;
import org.eclipse.wst.jsdt.internal.infer.InferrenceSupportExtension;

public class InferrenceManager {
    public static final String EXTENSION_POINT = "inferrenceSupport";
    protected static final String TAG_INFERENGINE = "inferenceEngine";
    protected static final String ATTR_INFERENGINE_CLASS = "class";
    private static InferrenceManager instance = null;
    private InferrenceSupportExtension[] extensions;

    public static InferrenceManager getInstance() {
        if (instance == null) {
            instance = new InferrenceManager();
        }
        return instance;
    }

    public InferEngine[] getInferenceEngines() {
        if (this.extensions == null) {
            this.loadInferenceExtensions();
        }
        ArrayList<InferEngine> arrayList = new ArrayList<InferEngine>();
        arrayList.add(new InferEngine());
        int n = 0;
        while (n < this.extensions.length) {
            if (this.extensions[n].inferEngine != null) {
                arrayList.add(this.extensions[n].inferEngine);
            }
            ++n;
        }
        return arrayList.toArray(new InferEngine[arrayList.size()]);
    }

    protected void loadInferenceExtensions() {
        IExtensionPoint iExtensionPoint;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        ArrayList<InferrenceSupportExtension> arrayList = new ArrayList<InferrenceSupportExtension>();
        if (iExtensionRegistry != null && (iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.wst.jsdt.core", EXTENSION_POINT)) != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    try {
                        InferEngine inferEngine = null;
                        if (iConfigurationElementArray[n2].getName().equals(TAG_INFERENGINE)) {
                            inferEngine = (InferEngine)iConfigurationElementArray[n2].createExecutableExtension(ATTR_INFERENGINE_CLASS);
                        }
                        InferrenceSupportExtension inferrenceSupportExtension = new InferrenceSupportExtension();
                        inferrenceSupportExtension.inferEngine = inferEngine;
                        arrayList.add(inferrenceSupportExtension);
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this.extensions = arrayList.toArray(new InferrenceSupportExtension[arrayList.size()]);
    }
}

