/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.AssertStatement;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.MethodRefParameter;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.SynchronizedStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;

public class ValidBreakpointLocationLocator
extends ASTVisitor {
    public static final int LOCATION_NOT_FOUND = 0;
    public static final int LOCATION_LINE = 1;
    public static final int LOCATION_METHOD = 2;
    public static final int LOCATION_FIELD = 3;
    private CompilationUnit fCompilationUnit;
    private int fLineNumber;
    private boolean fBindingsResolved;
    private boolean fNeedBindings = false;
    private boolean fBestMatch;
    private int fLocationType;
    private boolean fLocationFound;
    private String fTypeName;
    private int fLineLocation;
    private int fMemberOffset;
    private List fLabels;

    public ValidBreakpointLocationLocator(CompilationUnit compilationUnit, int n, boolean bl, boolean bl2) {
        this.fCompilationUnit = compilationUnit;
        this.fLineNumber = n;
        this.fBindingsResolved = bl;
        this.fBestMatch = bl2;
        this.fLocationFound = false;
    }

    public boolean isBindingsRequired() {
        return this.fNeedBindings;
    }

    public int getLocationType() {
        return this.fLocationType;
    }

    public String getFullyQualifiedTypeName() {
        return this.fTypeName;
    }

    public int getLineLocation() {
        if (this.fLocationType == 1) {
            return this.fLineLocation;
        }
        return -1;
    }

    public int getMemberOffset() {
        return this.fMemberOffset;
    }

    protected static String computeTypeName(ASTNode aSTNode) {
        Object object;
        Object object2 = null;
        while (!(aSTNode instanceof CompilationUnit)) {
            if (aSTNode instanceof AbstractTypeDeclaration) {
                object = ((AbstractTypeDeclaration)aSTNode).getName().getIdentifier();
                object2 = object2 == null ? object : String.valueOf(object) + "$" + (String)object2;
            } else {
                object2 = null;
            }
            aSTNode = aSTNode.getParent();
        }
        object = ((CompilationUnit)aSTNode).getPackage();
        String string = "";
        if (object != null) {
            Name name = object.getName();
            while (name.isQualifiedName()) {
                QualifiedName qualifiedName = (QualifiedName)name;
                string = String.valueOf(qualifiedName.getName().getIdentifier()) + "." + string;
                name = qualifiedName.getQualifier();
            }
            string = String.valueOf(((SimpleName)name).getIdentifier()) + "." + string;
        }
        return String.valueOf(string) + (String)object2;
    }

    private boolean visit(ASTNode aSTNode, boolean bl) {
        if (this.fLocationFound) {
            return false;
        }
        int n = aSTNode.getStartPosition();
        int n2 = this.lineNumber(n + aSTNode.getLength() - 1);
        if (n2 < this.fLineNumber) {
            return false;
        }
        int n3 = this.lineNumber(n);
        if (bl && this.fLineNumber <= n3) {
            this.fLineLocation = n3;
            this.fLocationFound = true;
            this.fLocationType = 1;
            this.fTypeName = ValidBreakpointLocationLocator.computeTypeName(aSTNode);
            return false;
        }
        return true;
    }

    private boolean isReplacedByConstantValue(Expression expression) {
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 34: 
            case 45: {
                return true;
            }
            case 40: 
            case 42: {
                return this.isReplacedByConstantValue((Name)expression);
            }
            case 22: {
                return this.isReplacedByConstantValue((FieldAccess)expression);
            }
            case 47: {
                return this.isReplacedByConstantValue((SuperFieldAccess)expression);
            }
            case 27: {
                return this.isReplacedByConstantValue((InfixExpression)expression);
            }
            case 38: {
                return this.isReplacedByConstantValue((PrefixExpression)expression);
            }
            case 11: {
                return this.isReplacedByConstantValue(((CastExpression)expression).getExpression());
            }
        }
        return false;
    }

    private boolean isReplacedByConstantValue(InfixExpression infixExpression) {
        if (!this.isReplacedByConstantValue(infixExpression.getLeftOperand()) || !this.isReplacedByConstantValue(infixExpression.getRightOperand())) {
            return false;
        }
        if (infixExpression.hasExtendedOperands()) {
            Iterator iterator = infixExpression.extendedOperands().iterator();
            while (iterator.hasNext()) {
                if (this.isReplacedByConstantValue((Expression)iterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isReplacedByConstantValue(PrefixExpression prefixExpression) {
        PrefixExpression.Operator operator = prefixExpression.getOperator();
        if (operator != PrefixExpression.Operator.INCREMENT && operator != PrefixExpression.Operator.DECREMENT) {
            return this.isReplacedByConstantValue(prefixExpression.getOperand());
        }
        return false;
    }

    private boolean isReplacedByConstantValue(Name name) {
        if (!this.fBindingsResolved) {
            this.fNeedBindings = true;
            return false;
        }
        IBinding iBinding = name.resolveBinding();
        if (iBinding != null && iBinding.getKind() == 3) {
            return ((IVariableBinding)iBinding).getConstantValue() != null;
        }
        return false;
    }

    private boolean isReplacedByConstantValue(FieldAccess fieldAccess) {
        if (!this.fBindingsResolved) {
            this.fNeedBindings = true;
            return false;
        }
        Expression expression = fieldAccess.getExpression();
        IVariableBinding iVariableBinding = fieldAccess.resolveFieldBinding();
        if (iVariableBinding != null && expression.getNodeType() == 52) {
            return iVariableBinding.getConstantValue() != null;
        }
        return false;
    }

    private boolean isReplacedByConstantValue(SuperFieldAccess superFieldAccess) {
        if (!this.fBindingsResolved) {
            this.fNeedBindings = true;
            return false;
        }
        IVariableBinding iVariableBinding = superFieldAccess.resolveFieldBinding();
        if (iVariableBinding != null) {
            return iVariableBinding.getConstantValue() != null;
        }
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        return false;
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        return this.visit((ASTNode)anonymousClassDeclaration, false);
    }

    public boolean visit(ArrayAccess arrayAccess) {
        return this.visit((ASTNode)arrayAccess, true);
    }

    public boolean visit(ArrayCreation arrayCreation) {
        return this.visit((ASTNode)arrayCreation, arrayCreation.getInitializer() == null);
    }

    public boolean visit(ArrayInitializer arrayInitializer) {
        return this.visit((ASTNode)arrayInitializer, true);
    }

    public boolean visit(ArrayType arrayType) {
        return false;
    }

    public boolean visit(AssertStatement assertStatement) {
        return this.visit((ASTNode)assertStatement, true);
    }

    public boolean visit(Assignment assignment) {
        if (this.visit((ASTNode)assignment, false)) {
            int n;
            Expression expression = assignment.getLeftHandSide();
            if (expression instanceof Name && this.fLineNumber < (n = this.lineNumber(assignment.getStartPosition()))) {
                if (this.fBindingsResolved) {
                    IVariableBinding iVariableBinding = (IVariableBinding)((Name)expression).resolveBinding();
                    if (iVariableBinding != null && (!iVariableBinding.isField() || Modifier.isStatic((int)iVariableBinding.getModifiers()))) {
                        assignment.getRightHandSide().accept((ASTVisitor)this);
                    }
                } else {
                    this.fNeedBindings = true;
                }
            }
            return true;
        }
        return false;
    }

    public boolean visit(Block block) {
        if (this.visit((ASTNode)block, false)) {
            if (block.statements().isEmpty() && block.getParent().getNodeType() == 31) {
                this.fLineLocation = this.lineNumber(block.getStartPosition() + block.getLength() - 1);
                this.fLocationFound = true;
                this.fLocationType = 1;
                this.fTypeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)block);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean visit(BlockComment blockComment) {
        return false;
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        return this.visit((ASTNode)booleanLiteral, true);
    }

    public boolean visit(BreakStatement breakStatement) {
        return this.visit((ASTNode)breakStatement, true);
    }

    public boolean visit(CastExpression castExpression) {
        return this.visit((ASTNode)castExpression, true);
    }

    public boolean visit(CatchClause catchClause) {
        return this.visit((ASTNode)catchClause, false);
    }

    public boolean visit(CharacterLiteral characterLiteral) {
        return this.visit((ASTNode)characterLiteral, true);
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        return this.visit((ASTNode)classInstanceCreation, true);
    }

    public boolean visit(CompilationUnit compilationUnit) {
        return this.visit((ASTNode)compilationUnit, false);
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        return this.visit((ASTNode)conditionalExpression, true);
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        return this.visit((ASTNode)constructorInvocation, true);
    }

    public boolean visit(ContinueStatement continueStatement) {
        return this.visit((ASTNode)continueStatement, true);
    }

    public boolean visit(DoStatement doStatement) {
        return this.visit((ASTNode)doStatement, false);
    }

    public boolean visit(EmptyStatement emptyStatement) {
        return false;
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        if (this.visit((ASTNode)enhancedForStatement, false)) {
            enhancedForStatement.getExpression().accept((ASTVisitor)this);
            enhancedForStatement.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        if (this.visit((ASTNode)enumConstantDeclaration, false)) {
            List list = enumConstantDeclaration.arguments();
            AnonymousClassDeclaration anonymousClassDeclaration = list.iterator();
            while (anonymousClassDeclaration.hasNext()) {
                ((Expression)anonymousClassDeclaration.next()).accept((ASTVisitor)this);
            }
            anonymousClassDeclaration = enumConstantDeclaration.getAnonymousClassDeclaration();
            if (anonymousClassDeclaration != null) {
                anonymousClassDeclaration.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        if (this.visit((ASTNode)enumDeclaration, false)) {
            List list = enumDeclaration.enumConstants();
            Object object = list.iterator();
            while (object.hasNext()) {
                ((EnumConstantDeclaration)object.next()).accept((ASTVisitor)this);
            }
            object = enumDeclaration.bodyDeclarations();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ((BodyDeclaration)iterator.next()).accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        return this.visit((ASTNode)expressionStatement, false);
    }

    public boolean visit(FieldAccess fieldAccess) {
        return this.visit((ASTNode)fieldAccess, false);
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        if (this.visit((ASTNode)fieldDeclaration, false)) {
            int n;
            List list;
            if (this.fBestMatch && (list = fieldDeclaration.fragments()).size() == 1 && this.lineNumber(n = ((VariableDeclarationFragment)list.get(0)).getName().getStartPosition()) == this.fLineNumber) {
                this.fMemberOffset = n;
                this.fLocationType = 3;
                this.fLocationFound = true;
                return false;
            }
            list = fieldDeclaration.fragments();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((VariableDeclarationFragment)iterator.next()).accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(ForStatement forStatement) {
        return this.visit((ASTNode)forStatement, forStatement.initializers().isEmpty() && forStatement.getExpression() == null && forStatement.updaters().isEmpty());
    }

    public boolean visit(IfStatement ifStatement) {
        return this.visit((ASTNode)ifStatement, false);
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        return false;
    }

    public boolean visit(InfixExpression infixExpression) {
        if (this.visit((ASTNode)infixExpression, false)) {
            Expression expression;
            Expression expression2 = infixExpression.getLeftOperand();
            Expression expression3 = null;
            if (this.visit((ASTNode)expression2, false)) {
                expression2.accept((ASTVisitor)this);
                return false;
            }
            if (this.isReplacedByConstantValue(expression2)) {
                expression3 = expression2;
            }
            if (this.visit((ASTNode)(expression = infixExpression.getRightOperand()), false)) {
                if (expression3 == null || !this.isReplacedByConstantValue(expression)) {
                    expression.accept((ASTVisitor)this);
                    return false;
                }
            } else {
                if (this.isReplacedByConstantValue(expression)) {
                    if (expression3 == null) {
                        expression3 = expression;
                    }
                } else {
                    expression3 = null;
                }
                List list = infixExpression.extendedOperands();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Expression expression4 = (Expression)iterator.next();
                    if (this.visit((ASTNode)expression4, false)) {
                        if (expression3 != null && this.isReplacedByConstantValue(expression4)) break;
                        expression4.accept((ASTVisitor)this);
                        return false;
                    }
                    if (this.isReplacedByConstantValue(expression4)) {
                        if (expression3 != null) continue;
                        expression3 = expression4;
                        continue;
                    }
                    expression3 = null;
                }
            }
            this.fLineLocation = this.lineNumber(expression3.getStartPosition());
            this.fLocationFound = true;
            this.fLocationType = 1;
            this.fTypeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)expression3);
        }
        return false;
    }

    public boolean visit(Initializer initializer) {
        return this.visit((ASTNode)initializer, false);
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        return this.visit((ASTNode)instanceofExpression, true);
    }

    public boolean visit(Javadoc javadoc) {
        return false;
    }

    public boolean visit(LabeledStatement labeledStatement) {
        this.nestLabel(labeledStatement.getLabel().getFullyQualifiedName());
        return this.visit((ASTNode)labeledStatement, false);
    }

    public void endVisit(LabeledStatement labeledStatement) {
        this.popLabel();
        super.endVisit(labeledStatement);
    }

    private String getLabel() {
        if (this.fLabels == null || this.fLabels.isEmpty()) {
            return null;
        }
        return (String)this.fLabels.get(this.fLabels.size() - 1);
    }

    private void nestLabel(String string) {
        if (this.fLabels == null) {
            this.fLabels = new ArrayList();
        }
        this.fLabels.add(string);
    }

    private void popLabel() {
        if (this.fLabels == null || this.fLabels.isEmpty()) {
            return;
        }
        this.fLabels.remove(this.fLabels.size() - 1);
    }

    public boolean visit(LineComment lineComment) {
        return false;
    }

    public boolean visit(MarkerAnnotation markerAnnotation) {
        return false;
    }

    public boolean visit(MemberRef memberRef) {
        return false;
    }

    public boolean visit(MemberValuePair memberValuePair) {
        return false;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        if (this.visit((ASTNode)methodDeclaration, false)) {
            SimpleName simpleName;
            int n;
            if (this.fBestMatch && this.lineNumber(n = (simpleName = methodDeclaration.getName()) == null ? methodDeclaration.getStartPosition() : simpleName.getStartPosition()) == this.fLineNumber) {
                this.fMemberOffset = n;
                this.fLocationType = 2;
                this.fLocationFound = true;
                return false;
            }
            simpleName = methodDeclaration.getBody();
            if (simpleName != null) {
                simpleName.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        return this.visit((ASTNode)methodInvocation, true);
    }

    public boolean visit(MethodRef methodRef) {
        return false;
    }

    public boolean visit(MethodRefParameter methodRefParameter) {
        return false;
    }

    public boolean visit(Modifier modifier) {
        return false;
    }

    public boolean visit(NormalAnnotation normalAnnotation) {
        return false;
    }

    public boolean visit(NullLiteral nullLiteral) {
        return this.visit((ASTNode)nullLiteral, true);
    }

    public boolean visit(NumberLiteral numberLiteral) {
        return this.visit((ASTNode)numberLiteral, true);
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        return false;
    }

    public boolean visit(ParameterizedType parameterizedType) {
        return false;
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        return this.visit((ASTNode)parenthesizedExpression, false);
    }

    public boolean visit(PostfixExpression postfixExpression) {
        return this.visit((ASTNode)postfixExpression, true);
    }

    public boolean visit(PrefixExpression prefixExpression) {
        if (this.visit((ASTNode)prefixExpression, false)) {
            if (this.isReplacedByConstantValue(prefixExpression)) {
                this.fLineLocation = this.lineNumber(prefixExpression.getStartPosition());
                this.fLocationFound = true;
                this.fLocationType = 1;
                this.fTypeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)prefixExpression);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean visit(PrimitiveType primitiveType) {
        return false;
    }

    public boolean visit(QualifiedName qualifiedName) {
        this.visit((ASTNode)qualifiedName, true);
        return false;
    }

    public boolean visit(QualifiedType qualifiedType) {
        return false;
    }

    public boolean visit(ReturnStatement returnStatement) {
        return this.visit((ASTNode)returnStatement, true);
    }

    public boolean visit(SimpleName simpleName) {
        return this.visit((ASTNode)simpleName, !simpleName.getFullyQualifiedName().equals(this.getLabel()));
    }

    public boolean visit(SimpleType simpleType) {
        return false;
    }

    public boolean visit(SingleMemberAnnotation singleMemberAnnotation) {
        return false;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        return this.visit((ASTNode)singleVariableDeclaration, false);
    }

    public boolean visit(StringLiteral stringLiteral) {
        return this.visit((ASTNode)stringLiteral, true);
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        return this.visit((ASTNode)superConstructorInvocation, true);
    }

    public boolean visit(SuperFieldAccess superFieldAccess) {
        return this.visit((ASTNode)superFieldAccess, true);
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        return this.visit((ASTNode)superMethodInvocation, true);
    }

    public boolean visit(SwitchCase switchCase) {
        return false;
    }

    public boolean visit(SwitchStatement switchStatement) {
        return this.visit((ASTNode)switchStatement, false);
    }

    public boolean visit(SynchronizedStatement synchronizedStatement) {
        return this.visit((ASTNode)synchronizedStatement, false);
    }

    public boolean visit(TagElement tagElement) {
        return false;
    }

    public boolean visit(TextElement textElement) {
        return false;
    }

    public boolean visit(ThisExpression thisExpression) {
        return this.visit((ASTNode)thisExpression, true);
    }

    public boolean visit(ThrowStatement throwStatement) {
        return this.visit((ASTNode)throwStatement, true);
    }

    public boolean visit(TryStatement tryStatement) {
        return this.visit((ASTNode)tryStatement, false);
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        if (this.visit((ASTNode)typeDeclaration, false)) {
            List list = typeDeclaration.bodyDeclarations();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((BodyDeclaration)iterator.next()).accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        return this.visit((ASTNode)typeDeclarationStatement, false);
    }

    public boolean visit(TypeParameter typeParameter) {
        return false;
    }

    public boolean visit(TypeLiteral typeLiteral) {
        return false;
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        return this.visit((ASTNode)variableDeclarationExpression, false);
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        Expression expression = variableDeclarationFragment.getInitializer();
        if (this.visit((ASTNode)variableDeclarationFragment, false) && expression != null) {
            int n = this.lineNumber(variableDeclarationFragment.getName().getStartPosition());
            if (this.fLineNumber == n) {
                this.fLineLocation = n;
                this.fLocationFound = true;
                this.fLocationType = 1;
                this.fTypeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)variableDeclarationFragment);
                return false;
            }
            expression.accept((ASTVisitor)this);
        }
        return false;
    }

    private int lineNumber(int n) {
        int n2 = this.fCompilationUnit.getLineNumber(n);
        return n2 < 1 ? 1 : n2;
    }

    public boolean visit(WildcardType wildcardType) {
        return false;
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        return this.visit((ASTNode)variableDeclarationStatement, false);
    }

    public boolean visit(WhileStatement whileStatement) {
        return this.visit((ASTNode)whileStatement, false);
    }
}

