/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.jsdoc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.wst.jsdt.jsdoc.MappingException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XSLTMap {
    private File stylesheet;

    private XSLTMap() {
    }

    public XSLTMap(File file) {
        this.stylesheet = file;
    }

    public String applyMap(String string) throws MappingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        this.applyMap(string, byteArrayOutputStream);
        String string2 = byteArrayOutputStream.toString();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {}
        return string2;
    }

    public void applyMap(String string, OutputStream outputStream) throws MappingException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setFeature("validating", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            byte[] byArray = string.getBytes();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(this.stylesheet);
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(dOMSource, streamResult);
            transformer.clearParameters();
        }
        catch (SAXException sAXException) {
            throw new MappingException("Transformer c error:\n" + sAXException.getMessage());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new MappingException("Transformer c error:\n" + transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new MappingException("Transformer error:\n" + transformerException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MappingException("Transformer factory error:\n" + parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            throw new MappingException("I/O Exception error (probably bad/missing XSL map) :\n" + iOException.getMessage());
        }
        catch (Exception exception) {
            throw new MappingException("General exceptioned occured while mapping: " + exception.getMessage());
        }
    }
}

