/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodCall;

class CallSearchResultCollector {
    private Map fCalledMembers = this.createCalledMethodsData();

    public Map getCallers() {
        return this.fCalledMembers;
    }

    protected void addMember(IMember iMember, IMember iMember2, int n, int n2) {
        this.addMember(iMember, iMember2, n, n2, -1);
    }

    protected void addMember(IMember iMember, IMember iMember2, int n, int n2, int n3) {
        if (iMember != null && iMember2 != null && !this.isIgnored(iMember2)) {
            MethodCall methodCall = (MethodCall)this.fCalledMembers.get(iMember2.getHandleIdentifier());
            if (methodCall == null) {
                methodCall = new MethodCall(iMember2);
                this.fCalledMembers.put(iMember2.getHandleIdentifier(), methodCall);
            }
            methodCall.addCallLocation(new CallLocation(iMember, iMember2, n, n2, n3));
        }
    }

    protected Map createCalledMethodsData() {
        return new HashMap();
    }

    private boolean isIgnored(IMember iMember) {
        IType iType = this.getTypeOfElement(iMember);
        String string = iType != null ? iType.getFullyQualifiedName() : iMember.getCompilationUnit().getElementName();
        return CallHierarchy.getDefault().isIgnored(string);
    }

    private IType getTypeOfElement(IMember iMember) {
        if (iMember.getElementType() == 7) {
            return (IType)iMember;
        }
        return iMember.getDeclaringType();
    }
}

