/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CalleeAnalyzerVisitor;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;

class CalleeMethodWrapper
extends MethodWrapper {
    private Comparator fMethodWrapperComparator = new MethodWrapperComparator();

    public CalleeMethodWrapper(MethodWrapper methodWrapper, MethodCall methodCall) {
        super(methodWrapper, methodCall);
    }

    public MethodWrapper[] getCalls(IProgressMonitor iProgressMonitor) {
        MethodWrapper[] methodWrapperArray = super.getCalls(iProgressMonitor);
        Arrays.sort(methodWrapperArray, this.fMethodWrapperComparator);
        return methodWrapperArray;
    }

    protected String getTaskName() {
        return CallHierarchyMessages.CalleeMethodWrapper_taskname;
    }

    protected MethodWrapper createMethodWrapper(MethodCall methodCall) {
        return new CalleeMethodWrapper(this, methodCall);
    }

    protected Map findChildren(IProgressMonitor iProgressMonitor) {
        if (this.getMember().exists() && this.getMember().getElementType() == 9) {
            CompilationUnit compilationUnit = CallHierarchy.getCompilationUnitNode(this.getMember(), true);
            if (iProgressMonitor != null) {
                iProgressMonitor.worked(5);
            }
            if (compilationUnit != null) {
                CalleeAnalyzerVisitor calleeAnalyzerVisitor = new CalleeAnalyzerVisitor((IMethod)this.getMember(), compilationUnit, iProgressMonitor);
                compilationUnit.accept((ASTVisitor)calleeAnalyzerVisitor);
                return calleeAnalyzerVisitor.getCallees();
            }
        }
        return new HashMap(0);
    }

    private static class MethodWrapperComparator
    implements Comparator {
        private MethodWrapperComparator() {
        }

        public int compare(Object object, Object object2) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)object);
            MethodWrapper methodWrapper2 = (MethodWrapper)((Object)object2);
            CallLocation callLocation = methodWrapper.getMethodCall().getFirstCallLocation();
            CallLocation callLocation2 = methodWrapper2.getMethodCall().getFirstCallLocation();
            if (callLocation != null && callLocation2 != null) {
                if (callLocation.getStart() == callLocation2.getStart()) {
                    return callLocation.getEnd() - callLocation2.getEnd();
                }
                return callLocation.getStart() - callLocation2.getStart();
            }
            return 0;
        }
    }
}

