/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodReferencesSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

class CallerMethodWrapper
extends MethodWrapper {
    public CallerMethodWrapper(MethodWrapper methodWrapper, MethodCall methodCall) {
        super(methodWrapper, methodCall);
    }

    protected IJavaSearchScope getSearchScope() {
        return CallHierarchy.getDefault().getSearchScope();
    }

    protected String getTaskName() {
        return CallHierarchyMessages.CallerMethodWrapper_taskname;
    }

    protected MethodWrapper createMethodWrapper(MethodCall methodCall) {
        return new CallerMethodWrapper(this, methodCall);
    }

    protected Map findChildren(IProgressMonitor iProgressMonitor) {
        try {
            MethodReferencesSearchRequestor methodReferencesSearchRequestor = new MethodReferencesSearchRequestor();
            SearchEngine searchEngine = new SearchEngine();
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 95, 2);
            IJavaSearchScope iJavaSearchScope = this.getSearchScope();
            boolean bl = SearchEngine.createWorkspaceScope().equals(iJavaSearchScope);
            Iterator iterator = this.getMembers().iterator();
            while (iterator.hasNext()) {
                this.checkCanceled(iProgressMonitor);
                IMember iMember = (IMember)iterator.next();
                SearchPattern searchPattern = SearchPattern.createPattern((IJavaElement)iMember, (int)2, (int)24);
                IJavaSearchScope iJavaSearchScope2 = bl ? this.getAccurateSearchScope(iJavaSearchScope, iMember) : iJavaSearchScope;
                searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, iJavaSearchScope2, (SearchRequestor)methodReferencesSearchRequestor, (IProgressMonitor)subProgressMonitor);
            }
            return methodReferencesSearchRequestor.getCallers();
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
            return new HashMap(0);
        }
    }

    private IJavaSearchScope getAccurateSearchScope(IJavaSearchScope iJavaSearchScope, IMember iMember) throws JavaModelException {
        if (!JdtFlags.isPrivate(iMember)) {
            return iJavaSearchScope;
        }
        if (iMember.getCompilationUnit() != null) {
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iMember.getCompilationUnit()});
        }
        if (iMember.getClassFile() != null) {
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iMember.getAncestor(4)});
        }
        return iJavaSearchScope;
    }

    private Collection getMembers() {
        ArrayList<IMember> arrayList = new ArrayList<IMember>();
        arrayList.add(this.getMember());
        return arrayList;
    }
}

