/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.IImplementorFinder;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.JavaImplementorFinder;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class Implementors {
    private static IImplementorFinder[] IMPLEMENTOR_FINDERS = new IImplementorFinder[]{new JavaImplementorFinder()};
    private static Implementors fgInstance;

    public static Implementors getInstance() {
        if (fgInstance == null) {
            fgInstance = new Implementors();
        }
        return fgInstance;
    }

    public IJavaElement[] searchForImplementors(IJavaElement[] iJavaElementArray, IProgressMonitor iProgressMonitor) {
        if (iJavaElementArray != null && iJavaElementArray.length > 0) {
            IJavaElement iJavaElement = iJavaElementArray[0];
            try {
                IMember iMember;
                IType iType;
                if (iJavaElement instanceof IMember && (iType = (iMember = (IMember)iJavaElement).getDeclaringType()) != null && iType.isInterface()) {
                    IType[] iTypeArray = this.findImplementingTypes(iType, iProgressMonitor);
                    if (iMember.getElementType() == 9) {
                        return this.findMethods((IMethod)iMember, iTypeArray, iProgressMonitor);
                    }
                    return iTypeArray;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        return null;
    }

    public IJavaElement[] searchForInterfaces(IJavaElement[] iJavaElementArray, IProgressMonitor iProgressMonitor) {
        IJavaElement iJavaElement;
        if (iJavaElementArray != null && iJavaElementArray.length > 0 && (iJavaElement = iJavaElementArray[0]) instanceof IMember) {
            IMember iMember = (IMember)iJavaElement;
            IType iType = iMember.getDeclaringType();
            IType[] iTypeArray = this.findInterfaces(iType, iProgressMonitor);
            if (!iProgressMonitor.isCanceled()) {
                if (iMember.getElementType() == 9) {
                    return this.findMethods((IMethod)iMember, iTypeArray, iProgressMonitor);
                }
                return iTypeArray;
            }
        }
        return null;
    }

    private IImplementorFinder[] getImplementorFinders() {
        return IMPLEMENTOR_FINDERS;
    }

    private IType[] findImplementingTypes(IType iType, IProgressMonitor iProgressMonitor) {
        ArrayList arrayList = new ArrayList();
        IImplementorFinder[] iImplementorFinderArray = this.getImplementorFinders();
        int n = 0;
        while (n < iImplementorFinderArray.length && !iProgressMonitor.isCanceled()) {
            Collection collection = iImplementorFinderArray[n].findImplementingTypes(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10, 2));
            if (collection != null) {
                arrayList.addAll(collection);
            }
            ++n;
        }
        return arrayList.toArray(new IType[arrayList.size()]);
    }

    private IType[] findInterfaces(IType iType, IProgressMonitor iProgressMonitor) {
        ArrayList arrayList = new ArrayList();
        IImplementorFinder[] iImplementorFinderArray = this.getImplementorFinders();
        int n = 0;
        while (n < iImplementorFinderArray.length && !iProgressMonitor.isCanceled()) {
            Collection collection = iImplementorFinderArray[n].findInterfaces(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10, 2));
            if (collection != null) {
                arrayList.addAll(collection);
            }
            ++n;
        }
        return arrayList.toArray(new IType[arrayList.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IJavaElement[] findMethods(IMethod iMethod, IType[] iTypeArray, IProgressMonitor iProgressMonitor) {
        ArrayList<IMethod> arrayList = new ArrayList<IMethod>();
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10, 2);
        subProgressMonitor.beginTask("", iTypeArray.length);
        try {
            int n = 0;
            while (n < iTypeArray.length) {
                IType iType = iTypeArray[n];
                IMethod[] iMethodArray = iType.findMethods(iMethod);
                if (iMethodArray != null) {
                    int n2 = 0;
                    while (n2 < iMethodArray.length) {
                        arrayList.add(iMethodArray[n2]);
                        ++n2;
                    }
                }
                subProgressMonitor.worked(1);
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            subProgressMonitor.done();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        subProgressMonitor.done();
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }
}

