/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Annotation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public class AddImportsOperation
implements IWorkspaceRunnable {
    private ICompilationUnit fCompilationUnit;
    private final int fSelectionOffset;
    private final int fSelectionLength;
    private final IChooseImportQuery fQuery;
    private IStatus fStatus;
    private boolean fDoSave;

    public AddImportsOperation(ICompilationUnit iCompilationUnit, int n, int n2, IChooseImportQuery iChooseImportQuery, boolean bl) {
        Assert.isNotNull((Object)iCompilationUnit);
        this.fCompilationUnit = iCompilationUnit;
        this.fSelectionOffset = n;
        this.fSelectionLength = n2;
        this.fQuery = iChooseImportQuery;
        this.fStatus = Status.OK_STATUS;
        this.fDoSave = bl;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        block8: {
            block7: {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                try {
                    try {
                        iProgressMonitor.beginTask(CodeGenerationMessages.AddImportsOperation_description, 4);
                        CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCompilationUnit, ASTProvider.WAIT_YES, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        ImportRewrite importRewrite = StubUtility.createImportRewrite(compilationUnit, true);
                        MultiTextEdit multiTextEdit = new MultiTextEdit();
                        TextEdit textEdit = this.evaluateEdits(compilationUnit, importRewrite, this.fSelectionOffset, this.fSelectionLength, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        if (textEdit == null) {
                            Object var7_7 = null;
                            break block7;
                        }
                        multiTextEdit.addChild(textEdit);
                        TextEdit textEdit2 = importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        multiTextEdit.addChild(textEdit2);
                        JavaModelUtil.applyEdit(this.fCompilationUnit, (TextEdit)multiTextEdit, this.fDoSave, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        break block8;
                    }
                    catch (BadLocationException badLocationException) {
                        throw new CoreException(JavaUIStatus.createError(4, badLocationException));
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return;
        }
        Object var7_9 = null;
        iProgressMonitor.done();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TextEdit evaluateEdits(CompilationUnit compilationUnit, ImportRewrite importRewrite, int n, int n2, IProgressMonitor iProgressMonitor) throws BadLocationException, JavaModelException {
        TypeNameMatch typeNameMatch;
        TypeNameMatch[] typeNameMatchArray;
        int n3;
        String string;
        IBuffer iBuffer;
        int n4;
        String string2;
        SimpleName simpleName = null;
        if (compilationUnit != null) {
            void var7_9;
            ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, n, n2);
            if (aSTNode instanceof MarkerAnnotation) {
                Name name = ((Annotation)aSTNode).getTypeName();
            }
            if (var7_9 instanceof QualifiedName) {
                simpleName = ((QualifiedName)var7_9).getName();
            } else if (var7_9 instanceof SimpleName) {
                simpleName = (SimpleName)var7_9;
            }
        }
        if (simpleName != null) {
            string2 = simpleName.getIdentifier();
            n4 = simpleName.getStartPosition();
            if (simpleName.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
                iBuffer = ((QualifiedName)simpleName.getParent()).getQualifier();
                string = iBuffer.getFullyQualifiedName();
                String string3 = JavaModelUtil.concatenateName(string, string2);
                n3 = iBuffer.getStartPosition();
            } else if (simpleName.getParent().getLocationInParent() == QualifiedType.NAME_PROPERTY) {
                iBuffer = ((QualifiedType)simpleName.getParent().getParent()).getQualifier();
                string = ASTNodes.asString((ASTNode)iBuffer);
                String string4 = JavaModelUtil.concatenateName(string, string2);
                n3 = iBuffer.getStartPosition();
            } else if (simpleName.getLocationInParent() == MethodInvocation.NAME_PROPERTY) {
                iBuffer = ((MethodInvocation)simpleName.getParent()).getExpression();
                if (!(iBuffer instanceof Name)) return null;
                string = ASTNodes.asString((ASTNode)iBuffer);
                String string5 = JavaModelUtil.concatenateName(string, string2);
                n3 = iBuffer.getStartPosition();
            } else {
                string = "";
                String string6 = string2;
                n3 = n4;
            }
            iBuffer = simpleName.resolveBinding();
            if (iBuffer != null && !iBuffer.isRecovered()) {
                ITypeBinding iTypeBinding;
                if (iBuffer instanceof ITypeBinding) {
                    void var7_14;
                    ITypeBinding iTypeBinding2 = (ITypeBinding)iBuffer;
                    String string7 = iTypeBinding2.getQualifiedName();
                    if (string.length() > 0 && !string7.equals(var7_14)) {
                        return null;
                    }
                    String string8 = importRewrite.addImport(iTypeBinding2);
                    if (string.length() <= 0 || string8.equals(string2)) return new ReplaceEdit(n3, n4 - n3, new String());
                    return null;
                }
                if (!(iBuffer instanceof IVariableBinding) && !(iBuffer instanceof IMethodBinding)) return null;
                boolean bl = iBuffer instanceof IVariableBinding;
                ITypeBinding iTypeBinding3 = iTypeBinding = bl ? ((IVariableBinding)iBuffer).getDeclaringClass() : ((IMethodBinding)iBuffer).getDeclaringClass();
                if (iTypeBinding == null) {
                    return null;
                }
                if (!Modifier.isStatic((int)iBuffer.getModifiers())) return null;
                if (Modifier.isPrivate((int)iTypeBinding.getModifiers())) {
                    this.fStatus = JavaUIStatus.createError(4, Messages.format(CodeGenerationMessages.AddImportsOperation_error_not_visible_class, iTypeBinding.getName()), null);
                    return null;
                }
                if (string.length() <= 0 || !string.equals(iTypeBinding.getName()) && !string.equals(iTypeBinding.getQualifiedName())) return null;
                String string9 = importRewrite.addStaticImport(iTypeBinding.getQualifiedName(), iBuffer.getName(), bl);
                if (string9.equals(string2)) return new ReplaceEdit(n3, n4 - n3, "");
                return null;
            }
            if (iBuffer != null && iBuffer.getKind() != 2) {
                return null;
            }
        } else {
            int n5;
            int n6;
            iBuffer = this.fCompilationUnit.getBuffer();
            String string10 = iBuffer.getText(n3 = this.getNameStart(iBuffer, n), n6 = (n5 = this.getNameEnd(iBuffer, n + n2)) - n3).trim();
            if (string10.length() == 0) {
                return null;
            }
            string2 = Signature.getSimpleName((String)string10);
            string = Signature.getQualifier((String)string10);
            n4 = this.getSimpleNameStart(iBuffer, n3, string);
            int n7 = importRewrite.getDefaultImportRewriteContext().findInContext(string, string2, 1);
            if (n7 == 3) {
                this.fStatus = JavaUIStatus.createError(4, CodeGenerationMessages.AddImportsOperation_error_importclash, null);
                return null;
            }
            if (n7 == 1) {
                return new ReplaceEdit(n3, n4 - n3, "");
            }
        }
        if ((typeNameMatchArray = this.findAllTypes(string2, (IJavaSearchScope)(iBuffer = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.fCompilationUnit.getJavaProject()})), simpleName, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1))).length == 0) {
            this.fStatus = JavaUIStatus.createError(4, Messages.format(CodeGenerationMessages.AddImportsOperation_error_notresolved_message, string2), null);
            return null;
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (typeNameMatchArray.length > 1 && this.fQuery != null) {
            typeNameMatch = this.fQuery.chooseImport(typeNameMatchArray, string);
            if (typeNameMatch == null) {
                throw new OperationCanceledException();
            }
        } else {
            typeNameMatch = typeNameMatchArray[0];
        }
        importRewrite.addImport(typeNameMatch.getFullyQualifiedName());
        return new ReplaceEdit(n3, n4 - n3, "");
    }

    private int getNameStart(IBuffer iBuffer, int n) throws BadLocationException {
        while (n > 0) {
            char c = iBuffer.getChar(n - 1);
            if (!Character.isJavaIdentifierPart(c) && c != '.') {
                return n;
            }
            --n;
        }
        return n;
    }

    private int getNameEnd(IBuffer iBuffer, int n) throws BadLocationException {
        if (n > 0 && Character.isWhitespace(iBuffer.getChar(n - 1))) {
            return n;
        }
        int n2 = iBuffer.getLength();
        while (n < n2) {
            char c = iBuffer.getChar(n);
            if (!Character.isJavaIdentifierPart(c)) {
                return n;
            }
            ++n;
        }
        return n;
    }

    private int getSimpleNameStart(IBuffer iBuffer, int n, String string) throws BadLocationException {
        int n2 = string.length();
        int n3 = iBuffer.getLength();
        if (n2 > 0 && n + n2 + 1 < n3) {
            int n4 = 0;
            while (n4 < n2) {
                if (iBuffer.getChar(n + n4) != string.charAt(n4)) {
                    return n;
                }
                ++n4;
            }
            if (iBuffer.getChar(n + n2) == '.') {
                return n + n2 + 1;
            }
        }
        return n;
    }

    private int getSearchForConstant(int n) {
        switch (n & 0x1E) {
            case 2: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 16: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 18: {
                return 9;
            }
        }
        return 0;
    }

    private TypeNameMatch[] findAllTypes(String string, IJavaSearchScope iJavaSearchScope, SimpleName simpleName, IProgressMonitor iProgressMonitor) throws JavaModelException {
        boolean bl = JavaModelUtil.is50OrHigher(this.fCompilationUnit.getJavaProject());
        int n = 126;
        if (simpleName != null) {
            n = ASTResolving.getPossibleTypeKinds((ASTNode)simpleName, bl);
        }
        ArrayList arrayList = new ArrayList();
        TypeNameMatchCollector typeNameMatchCollector = new TypeNameMatchCollector(arrayList);
        int n2 = 8;
        new SearchEngine().searchAllTypeNames(null, n2, string.toCharArray(), n2, this.getSearchForConstant(n), iJavaSearchScope, (TypeNameMatchRequestor)typeNameMatchCollector, 3, iProgressMonitor);
        ArrayList<TypeNameMatch> arrayList2 = new ArrayList<TypeNameMatch>(arrayList.size());
        int n3 = 0;
        int n4 = arrayList.size();
        while (n3 < n4) {
            TypeNameMatch typeNameMatch = (TypeNameMatch)arrayList.get(n3);
            if (typeNameMatch.getPackageName().length() > 0 && this.isOfKind(typeNameMatch, n, bl) && this.isVisible(typeNameMatch)) {
                arrayList2.add(typeNameMatch);
            }
            ++n3;
        }
        return arrayList2.toArray(new TypeNameMatch[arrayList2.size()]);
    }

    private boolean isOfKind(TypeNameMatch typeNameMatch, int n, boolean bl) {
        int n2 = typeNameMatch.getModifiers();
        if (Flags.isAnnotation((int)n2)) {
            return bl && (n & 8) != 0;
        }
        if (Flags.isEnum((int)n2)) {
            return bl && (n & 0x10) != 0;
        }
        if (Flags.isInterface((int)n2)) {
            return (n & 4) != 0;
        }
        return (n & 2) != 0;
    }

    private boolean isVisible(TypeNameMatch typeNameMatch) {
        int n = typeNameMatch.getModifiers();
        if (Flags.isPrivate((int)n)) {
            return false;
        }
        if (Flags.isPublic((int)n) || Flags.isProtected((int)n)) {
            return true;
        }
        return typeNameMatch.getPackageName().equals(this.fCompilationUnit.getParent().getElementName());
    }

    public ISchedulingRule getScheduleRule() {
        return this.fCompilationUnit.getJavaProject().getResource();
    }

    public static interface IChooseImportQuery {
        public TypeNameMatch chooseImport(TypeNameMatch[] var1, String var2);
    }
}

