/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;

public final class AddUnimplementedConstructorsOperation
implements IWorkspaceRunnable {
    private final boolean fApply;
    private String[] fCreatedImports;
    private final List fCreatedMethods = new ArrayList();
    private final boolean fImports;
    private final int fInsertPos;
    private final IMethodBinding[] fConstructorsToImplement;
    private boolean fOmitSuper;
    private final boolean fSave;
    private boolean fCreateComments;
    private final ITypeBinding fType;
    private final CompilationUnit fASTRoot;
    private int fVisibility;

    public AddUnimplementedConstructorsOperation(CompilationUnit compilationUnit, ITypeBinding iTypeBinding, IMethodBinding[] iMethodBindingArray, int n, boolean bl, boolean bl2, boolean bl3) {
        if (compilationUnit == null || !(compilationUnit.getJavaElement() instanceof ICompilationUnit)) {
            throw new IllegalArgumentException("AST must not be null and has to be created from a ICompilationUnit");
        }
        if (iTypeBinding == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)iTypeBinding);
        if (!(aSTNode instanceof AnonymousClassDeclaration) && !(aSTNode instanceof AbstractTypeDeclaration)) {
            throw new IllegalArgumentException("type has to map to a type declaration in the AST");
        }
        this.fType = iTypeBinding;
        this.fInsertPos = n;
        this.fASTRoot = compilationUnit;
        this.fConstructorsToImplement = iMethodBindingArray;
        this.fSave = bl3;
        this.fApply = bl2;
        this.fImports = bl;
        this.fCreateComments = StubUtility.doAddComments(compilationUnit.getJavaElement().getJavaProject());
        this.fVisibility = 1;
        this.fOmitSuper = false;
    }

    public String[] getCreatedConstructors() {
        String[] stringArray = new String[this.fCreatedMethods.size()];
        this.fCreatedMethods.toArray(stringArray);
        return stringArray;
    }

    public String[] getCreatedImports() {
        return this.fCreatedImports;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public boolean isOmitSuper() {
        return this.fOmitSuper;
    }

    public void setCreateComments(boolean bl) {
        this.fCreateComments = bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            Object object;
            iProgressMonitor.beginTask("", 2);
            iProgressMonitor.setTaskName(CodeGenerationMessages.AddUnimplementedMethodsOperation_description);
            this.fCreatedMethods.clear();
            ICompilationUnit iCompilationUnit = (ICompilationUnit)this.fASTRoot.getJavaElement();
            AST aST = this.fASTRoot.getAST();
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            ImportRewrite importRewrite = StubUtility.createImportRewrite(this.fASTRoot, true);
            ITypeBinding iTypeBinding = this.fType;
            ListRewrite listRewrite = null;
            ASTNode aSTNode = this.fASTRoot.findDeclaringNode((IBinding)iTypeBinding);
            if (aSTNode instanceof AnonymousClassDeclaration) {
                listRewrite = aSTRewrite.getListRewrite(aSTNode, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            } else {
                if (!(aSTNode instanceof AbstractTypeDeclaration)) throw new IllegalArgumentException();
                object = ((AbstractTypeDeclaration)aSTNode).getBodyDeclarationsProperty();
                listRewrite = aSTRewrite.getListRewrite(aSTNode, object);
            }
            object = JavaPreferencesSettings.getCodeGenerationSettings(iCompilationUnit.getJavaProject());
            object.createComments = this.fCreateComments;
            ASTNode aSTNode2 = this.getNodeToInsertBefore(listRewrite);
            IMethodBinding[] iMethodBindingArray = this.fConstructorsToImplement;
            if (iMethodBindingArray == null) {
                iMethodBindingArray = StubUtility2.getVisibleConstructors(iTypeBinding, true, true);
            }
            int n = 0;
            int n2 = 0;
            while (true) {
                block15: {
                    if (n2 < iMethodBindingArray.length) break block15;
                }
                if (iMethodBindingArray[n2].isDeprecated()) {
                    ++n;
                }
                ++n2;
            }
            n2 = n == iMethodBindingArray.length ? 1 : 0;
            int n3 = 0;
            while (true) {
                MethodDeclaration methodDeclaration;
                IMethodBinding iMethodBinding;
                block16: {
                    if (n3 < iMethodBindingArray.length) break block16;
                    MultiTextEdit multiTextEdit = new MultiTextEdit();
                    iMethodBinding = importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    this.fCreatedImports = importRewrite.getCreatedImports();
                    if (this.fImports) {
                        multiTextEdit.addChild((TextEdit)iMethodBinding);
                    }
                    multiTextEdit.addChild(aSTRewrite.rewriteAST());
                    if (this.fApply) {
                        JavaModelUtil.applyEdit(iCompilationUnit, (TextEdit)multiTextEdit, this.fSave, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    break;
                }
                iMethodBinding = iMethodBindingArray[n3];
                if (!(iMethodBinding.isDeprecated() && n2 == 0 || (methodDeclaration = StubUtility2.createConstructorStub(iCompilationUnit, aSTRewrite, importRewrite, iMethodBinding, iTypeBinding.getName(), this.fVisibility, this.fOmitSuper, true, (CodeGenerationSettings)object)) == null)) {
                    this.fCreatedMethods.add(iMethodBinding.getKey());
                    if (aSTNode2 != null) {
                        listRewrite.insertBefore((ASTNode)methodDeclaration, aSTNode2, null);
                    } else {
                        listRewrite.insertLast((ASTNode)methodDeclaration, null);
                    }
                }
                ++n3;
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var17_20 = null;
        }
        iProgressMonitor.done();
    }

    public void setOmitSuper(boolean bl) {
        this.fOmitSuper = bl;
    }

    public void setVisibility(int n) {
        this.fVisibility = n;
    }

    private ASTNode getNodeToInsertBefore(ListRewrite listRewrite) {
        if (this.fInsertPos != -1) {
            List list = listRewrite.getOriginalList();
            int n = 0;
            while (n < list.size()) {
                ASTNode aSTNode = (ASTNode)list.get(n);
                if (aSTNode.getStartPosition() >= this.fInsertPos) {
                    return aSTNode;
                }
                ++n;
            }
        }
        return null;
    }
}

