/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public final class GenerateHashCodeEqualsOperation
implements IWorkspaceRunnable {
    private static final String JAVA_UTIL_ARRAYS = "java.util.Arrays";
    private static final String BOOLEAN_TRUE_CONSTANT = "1231";
    private static final String BOOLEAN_FALSE_CONSTANT = "1237";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String METHODNAME_GETCLASS = "getClass";
    private static final String METHODNAME_EQUALS = "equals";
    private static final String METHODNAME_HASH_CODE = "hashCode";
    private static final String PRIME_NUMBER = "31";
    private static final String INITIAL_HASHCODE_VALUE = "1";
    private static final String VARIABLE_NAME_DOUBLE_TEMPORARY = "temp";
    private static final String VARIABLE_NAME_PRIME = "prime";
    private static final String VARIABLE_NAME_RESULT = "result";
    private static final String VARIABLE_NAME_EQUALS_PARAM = "obj";
    private static final String VARIABLE_NAME_HASHCODE_PARAM = "array";
    private static final String VARIABLE_NAME_EQUALS_CASTED = "other";
    private static final String VARIABLE_NAME_INDEX = "index";
    private final boolean fApply;
    private TextEdit fEdit = null;
    private final IJavaElement fInsert;
    private final IVariableBinding[] fFields;
    private final boolean fForce;
    private final boolean fSave;
    private final CodeGenerationSettings fSettings;
    private final ITypeBinding fType;
    private final CompilationUnit fUnit;
    private final CompilationUnitRewrite fRewrite;
    private final AST fAst;
    private int fDoubleCount;
    private Set fCustomHashCodeTypes = new HashSet();
    private final boolean fUseInstanceOf;
    static /* synthetic */ Class class$0;

    public GenerateHashCodeEqualsOperation(ITypeBinding iTypeBinding, IVariableBinding[] iVariableBindingArray, CompilationUnit compilationUnit, IJavaElement iJavaElement, CodeGenerationSettings codeGenerationSettings, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Assert.isNotNull((Object)iTypeBinding);
        Assert.isNotNull((Object)iVariableBindingArray);
        Assert.isNotNull((Object)compilationUnit);
        Assert.isNotNull((Object)codeGenerationSettings);
        this.fType = iTypeBinding;
        this.fInsert = iJavaElement;
        this.fUnit = compilationUnit;
        this.fFields = iVariableBindingArray;
        this.fSettings = codeGenerationSettings;
        this.fUseInstanceOf = bl;
        this.fSave = bl4;
        this.fApply = bl3;
        this.fDoubleCount = 0;
        this.fRewrite = new CompilationUnitRewrite((ICompilationUnit)this.fUnit.getJavaElement(), this.fUnit);
        this.fForce = bl2;
        this.fAst = this.fRewrite.getAST();
    }

    public final TextEdit getResultingEdit() {
        return this.fEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            block30: {
                iProgressMonitor.beginTask("", 1);
                iProgressMonitor.setTaskName(CodeGenerationMessages.GenerateHashCodeEqualsOperation_description);
                this.fCustomHashCodeTypes.clear();
                AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.findDeclaration((IBinding)this.fType, (ASTNode)this.fRewrite.getRoot());
                ListRewrite listRewrite = this.fRewrite.getASTRewrite().getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty());
                if (this.fType != null && listRewrite != null) {
                    ICompilationUnit iCompilationUnit = (ICompilationUnit)this.fUnit.getJavaElement();
                    ITextFileBuffer iTextFileBuffer = null;
                    IDocument iDocument = null;
                    try {
                        block29: {
                            CompilationUnitChange compilationUnitChange;
                            ITypeBinding[] iTypeBindingArray;
                            ITypeBinding iTypeBinding;
                            Object object;
                            IMethodBinding iMethodBinding;
                            Object object2;
                            Object object3;
                            Object object4;
                            if (!JavaModelUtil.isPrimary(iCompilationUnit)) {
                                iDocument = new Document(iCompilationUnit.getBuffer().getContents());
                            } else {
                                iTextFileBuffer = RefactoringFileBuffers.acquire(iCompilationUnit);
                                iDocument = iTextFileBuffer.getDocument();
                            }
                            ASTNode aSTNode = null;
                            if (this.fInsert instanceof IMethod) {
                                ASTNode aSTNode2 = NodeFinder.perform((ASTNode)this.fRewrite.getRoot(), ((IMethod)this.fInsert).getNameRange());
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                aSTNode = ASTNodes.getParent(aSTNode2, clazz);
                            }
                            Object object5 = null;
                            if (this.fForce) {
                                object4 = (List)abstractTypeDeclaration.getStructuralProperty((StructuralPropertyDescriptor)abstractTypeDeclaration.getBodyDeclarationsProperty());
                                object3 = object4.iterator();
                                while (object3.hasNext()) {
                                    object2 = (BodyDeclaration)object3.next();
                                    if (!(object2 instanceof MethodDeclaration) || (iMethodBinding = (object = (MethodDeclaration)object2).resolveBinding()) == null || !iMethodBinding.getName().equals(METHODNAME_EQUALS) || ((ITypeBinding[])(iTypeBinding = iMethodBinding.getParameterTypes())).length != 1 || !iTypeBinding[0].getQualifiedName().equals(JAVA_LANG_OBJECT)) continue;
                                    object5 = object2;
                                    break;
                                }
                            }
                            object4 = this.createEqualsMethod();
                            this.addMethod(listRewrite, aSTNode, (MethodDeclaration)object4, (BodyDeclaration)object5);
                            if (iProgressMonitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            object5 = null;
                            if (this.fForce) {
                                object3 = (List)abstractTypeDeclaration.getStructuralProperty((StructuralPropertyDescriptor)abstractTypeDeclaration.getBodyDeclarationsProperty());
                                object2 = object3.iterator();
                                while (object2.hasNext()) {
                                    object = (BodyDeclaration)object2.next();
                                    if (!(object instanceof MethodDeclaration) || (iTypeBinding = (iMethodBinding = (MethodDeclaration)object).resolveBinding()) == null || !iTypeBinding.getName().equals(METHODNAME_HASH_CODE) || (iTypeBindingArray = iTypeBinding.getParameterTypes()).length != 0) continue;
                                    object5 = object;
                                    break;
                                }
                            }
                            object3 = this.createHashCodeMethod();
                            this.addMethod(listRewrite, (ASTNode)object4, (MethodDeclaration)object3, (BodyDeclaration)object5);
                            object2 = null;
                            object = this.fCustomHashCodeTypes.iterator();
                            while (object.hasNext()) {
                                MethodDeclaration methodDeclaration;
                                boolean bl = false;
                                iTypeBinding = (ITypeBinding)object.next();
                                iTypeBindingArray = abstractTypeDeclaration.resolveBinding();
                                if (iTypeBindingArray != null) {
                                    methodDeclaration = iTypeBindingArray.getDeclaredMethods();
                                    int n = 0;
                                    while (n < ((MethodDeclaration)methodDeclaration).length) {
                                        ITypeBinding iTypeBinding2;
                                        MethodDeclaration methodDeclaration2 = methodDeclaration[n];
                                        ITypeBinding[] iTypeBindingArray2 = methodDeclaration2.getParameterTypes();
                                        if (methodDeclaration2.getName().equals(METHODNAME_HASH_CODE) && iTypeBindingArray2.length == 1 && (bl = !(iTypeBinding2 = iTypeBindingArray2[0]).isPrimitive() ? iTypeBinding2.getQualifiedName().equals(JAVA_LANG_OBJECT) : iTypeBinding2.isEqualTo((IBinding)iTypeBinding))) break;
                                        ++n;
                                    }
                                }
                                if (bl) continue;
                                methodDeclaration = this.createHashCodeHelper(iTypeBinding);
                                this.addHelper(listRewrite, (ASTNode)object2, methodDeclaration);
                            }
                            object = this.fRewrite.createChange();
                            if (object instanceof CompilationUnitChange && (iTypeBinding = (compilationUnitChange = (CompilationUnitChange)((Object)object)).getEdit()) != null) {
                                try {
                                    this.fEdit = iTypeBinding;
                                    if (this.fApply) {
                                        iTypeBinding.apply(iDocument, 2);
                                    }
                                    if (!this.fSave) break block29;
                                    if (iTextFileBuffer != null) {
                                        iTextFileBuffer.commit((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), true);
                                    } else {
                                        iCompilationUnit.getBuffer().setContents(iDocument.get());
                                    }
                                }
                                catch (Exception exception) {
                                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, exception.getLocalizedMessage(), (Throwable)exception));
                                }
                            }
                        }
                        Object var21_26 = null;
                        if (iTextFileBuffer == null) break block30;
                    }
                    catch (Throwable throwable) {
                        Object var21_25 = null;
                        if (iTextFileBuffer == null) throw throwable;
                        RefactoringFileBuffers.release(iCompilationUnit);
                        throw throwable;
                    }
                    RefactoringFileBuffers.release(iCompilationUnit);
                }
            }
            Object var23_29 = null;
        }
        catch (Throwable throwable) {
            Object var23_28 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
    }

    private void addHelper(ListRewrite listRewrite, ASTNode aSTNode, MethodDeclaration methodDeclaration) {
        if (aSTNode != null) {
            listRewrite.insertBefore((ASTNode)methodDeclaration, aSTNode, null);
        } else {
            listRewrite.insertFirst((ASTNode)methodDeclaration, null);
        }
    }

    private void addMethod(ListRewrite listRewrite, ASTNode aSTNode, MethodDeclaration methodDeclaration, BodyDeclaration bodyDeclaration) {
        if (bodyDeclaration != null) {
            listRewrite.replace((ASTNode)bodyDeclaration, (ASTNode)methodDeclaration, null);
        } else if (aSTNode != null) {
            listRewrite.insertBefore((ASTNode)methodDeclaration, aSTNode, null);
        } else {
            listRewrite.insertLast((ASTNode)methodDeclaration, null);
        }
    }

    private MethodDeclaration createHashCodeMethod() throws CoreException {
        Statement[] statementArray;
        MethodDeclaration methodDeclaration = this.fAst.newMethodDeclaration();
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 1));
        methodDeclaration.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
        methodDeclaration.setConstructor(false);
        methodDeclaration.setReturnType2((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        Block block = this.fAst.newBlock();
        methodDeclaration.setBody(block);
        VariableDeclarationFragment variableDeclarationFragment = this.fAst.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.fAst.newSimpleName(VARIABLE_NAME_PRIME));
        variableDeclarationFragment.setInitializer((Expression)this.fAst.newNumberLiteral(PRIME_NUMBER));
        VariableDeclarationStatement variableDeclarationStatement = this.fAst.newVariableDeclarationStatement(variableDeclarationFragment);
        variableDeclarationStatement.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        variableDeclarationStatement.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        block.statements().add(variableDeclarationStatement);
        VariableDeclarationFragment variableDeclarationFragment2 = this.fAst.newVariableDeclarationFragment();
        variableDeclarationFragment2.setName(this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        VariableDeclarationStatement variableDeclarationStatement2 = this.fAst.newVariableDeclarationStatement(variableDeclarationFragment2);
        variableDeclarationStatement2.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        block.statements().add(variableDeclarationStatement2);
        if (this.needsNoSuperCall(this.fType, METHODNAME_HASH_CODE, new ITypeBinding[0])) {
            variableDeclarationFragment2.setInitializer((Expression)this.fAst.newNumberLiteral(INITIAL_HASHCODE_VALUE));
        } else {
            SuperMethodInvocation superMethodInvocation = this.fAst.newSuperMethodInvocation();
            superMethodInvocation.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            variableDeclarationFragment2.setInitializer((Expression)superMethodInvocation);
        }
        int n = 0;
        while (n < this.fFields.length) {
            if (this.fFields[n].getType().isPrimitive()) {
                statementArray = this.createAddSimpleHashCode(this.fFields[n].getType(), new IHashCodeAccessProvider(){

                    public Expression getThisAccess(String string) {
                        return GenerateHashCodeEqualsOperation.this.getThisAccessForHashCode(string);
                    }
                }, this.fFields[n].getName(), false);
                int n2 = 0;
                while (n2 < statementArray.length) {
                    block.statements().add(statementArray[n2]);
                    ++n2;
                }
            } else if (this.fFields[n].getType().isArray()) {
                block.statements().add(this.createAddArrayHashCode(this.fFields[n]));
            } else {
                block.statements().add(this.createAddQualifiedHashCode(this.fFields[n]));
            }
            ++n;
        }
        ReturnStatement returnStatement = this.fAst.newReturnStatement();
        returnStatement.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        block.statements().add(returnStatement);
        if (this.fSettings != null) {
            statementArray = this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT);
            IMethodBinding[] iMethodBindingArray = statementArray.getDeclaredMethods();
            IMethodBinding iMethodBinding = null;
            int n3 = 0;
            while (n3 < iMethodBindingArray.length) {
                if (iMethodBindingArray[n3].getName().equals(METHODNAME_HASH_CODE) && iMethodBindingArray[n3].getParameterTypes().length == 0) {
                    iMethodBinding = iMethodBindingArray[n3];
                }
                ++n3;
            }
            this.createMethodComment(methodDeclaration, iMethodBinding);
        }
        return methodDeclaration;
    }

    private Statement[] createAddSimpleHashCode(ITypeBinding iTypeBinding, IHashCodeAccessProvider iHashCodeAccessProvider, String string, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!iTypeBinding.isPrimitive()) {
            ConditionalExpression conditionalExpression = this.fAst.newConditionalExpression();
            InfixExpression infixExpression = this.fAst.newInfixExpression();
            ArrayAccess arrayAccess = this.fAst.newArrayAccess();
            arrayAccess.setArray((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
            arrayAccess.setIndex((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
            infixExpression.setLeftOperand((Expression)arrayAccess);
            infixExpression.setOperator(InfixExpression.Operator.EQUALS);
            infixExpression.setRightOperand((Expression)this.fAst.newNullLiteral());
            conditionalExpression.setExpression((Expression)infixExpression);
            conditionalExpression.setThenExpression((Expression)this.fAst.newNumberLiteral("0"));
            MethodInvocation methodInvocation = this.fAst.newMethodInvocation();
            arrayAccess = this.fAst.newArrayAccess();
            arrayAccess.setArray((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
            arrayAccess.setIndex((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
            methodInvocation.setExpression((Expression)arrayAccess);
            methodInvocation.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            conditionalExpression.setElseExpression((Expression)methodInvocation);
            arrayList.add(this.prepareAssignment(this.parenthesize((Expression)conditionalExpression)));
        } else if (this.isPrimitiveType(iTypeBinding, PrimitiveType.BOOLEAN)) {
            ConditionalExpression conditionalExpression = this.fAst.newConditionalExpression();
            conditionalExpression.setExpression(iHashCodeAccessProvider.getThisAccess(string));
            conditionalExpression.setThenExpression((Expression)this.fAst.newNumberLiteral(BOOLEAN_TRUE_CONSTANT));
            conditionalExpression.setElseExpression((Expression)this.fAst.newNumberLiteral(BOOLEAN_FALSE_CONSTANT));
            arrayList.add(this.prepareAssignment(this.parenthesize((Expression)conditionalExpression)));
        } else if (this.isPrimitiveType(iTypeBinding, new PrimitiveType.Code[]{PrimitiveType.CHAR, PrimitiveType.INT, PrimitiveType.SHORT})) {
            arrayList.add(this.prepareAssignment(iHashCodeAccessProvider.getThisAccess(string)));
        } else if (this.isPrimitiveType(iTypeBinding, PrimitiveType.FLOAT)) {
            arrayList.add(this.prepareAssignment(this.createFloatInvocation(iHashCodeAccessProvider.getThisAccess(string))));
        } else if (this.isPrimitiveType(iTypeBinding, PrimitiveType.LONG)) {
            arrayList.add(this.prepareAssignment(this.createShiftAssignment(iHashCodeAccessProvider.getThisAccess(string), iHashCodeAccessProvider.getThisAccess(string))));
        } else if (this.isPrimitiveType(iTypeBinding, PrimitiveType.DOUBLE)) {
            Expression expression;
            VariableDeclarationFragment variableDeclarationFragment = null;
            if (bl || this.fDoubleCount == 0) {
                variableDeclarationFragment = this.fAst.newVariableDeclarationFragment();
                variableDeclarationFragment.setName(this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY));
                expression = this.fAst.newVariableDeclarationStatement(variableDeclarationFragment);
                expression.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.LONG));
                arrayList.add(expression);
            }
            ++this.fDoubleCount;
            expression = this.createDoubleInvocation(iHashCodeAccessProvider.getThisAccess(string));
            if (bl) {
                variableDeclarationFragment.setInitializer(expression);
            } else {
                Assignment assignment = this.fAst.newAssignment();
                assignment.setLeftHandSide((Expression)this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY));
                assignment.setRightHandSide(expression);
                arrayList.add(this.fAst.newExpressionStatement((Expression)assignment));
            }
            arrayList.add(this.prepareAssignment(this.createShiftAssignment((Expression)this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY), (Expression)this.fAst.newSimpleName(VARIABLE_NAME_DOUBLE_TEMPORARY))));
        }
        return arrayList.toArray(new Statement[arrayList.size()]);
    }

    private Statement createAddArrayHashCode(IVariableBinding iVariableBinding) {
        MethodInvocation methodInvocation = this.fAst.newMethodInvocation();
        if (JavaModelUtil.is50OrHigher(this.fRewrite.getCu().getJavaProject())) {
            methodInvocation.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            methodInvocation.setExpression((Expression)this.getQualifiedName(JAVA_UTIL_ARRAYS));
            methodInvocation.arguments().add(this.getThisAccessForHashCode(iVariableBinding.getName()));
        } else {
            methodInvocation.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
            IJavaElement iJavaElement = this.fType.getJavaElement();
            if (iJavaElement != null && !"".equals(iJavaElement.getElementName())) {
                methodInvocation.setExpression((Expression)this.fAst.newSimpleName(iJavaElement.getElementName()));
            }
            methodInvocation.arguments().add(this.getThisAccessForHashCode(iVariableBinding.getName()));
            ITypeBinding iTypeBinding = iVariableBinding.getType().getElementType();
            if (!Bindings.isVoidType(iTypeBinding)) {
                if (iTypeBinding.isPrimitive() && iVariableBinding.getType().getDimensions() < 2) {
                    this.fCustomHashCodeTypes.add(iTypeBinding);
                } else {
                    this.fCustomHashCodeTypes.add(this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT));
                }
            }
        }
        return this.prepareAssignment((Expression)methodInvocation);
    }

    private MethodDeclaration createHashCodeHelper(ITypeBinding iTypeBinding) {
        Assert.isTrue((!iTypeBinding.isArray() ? 1 : 0) != 0);
        MethodDeclaration methodDeclaration = this.fAst.newMethodDeclaration();
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 10));
        methodDeclaration.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
        methodDeclaration.setConstructor(false);
        methodDeclaration.setReturnType2((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        List list = methodDeclaration.parameters();
        SingleVariableDeclaration singleVariableDeclaration = this.fAst.newSingleVariableDeclaration();
        if (!iTypeBinding.isPrimitive()) {
            singleVariableDeclaration.setType((Type)this.fAst.newArrayType((Type)this.fAst.newSimpleType(this.getQualifiedName(JAVA_LANG_OBJECT)), 1));
        } else {
            singleVariableDeclaration.setType((Type)this.fAst.newArrayType((Type)this.fAst.newPrimitiveType(PrimitiveType.toCode((String)iTypeBinding.getName())), 1));
        }
        singleVariableDeclaration.setName(this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
        list.add(singleVariableDeclaration);
        Block block = this.fAst.newBlock();
        methodDeclaration.setBody(block);
        VariableDeclarationFragment variableDeclarationFragment = this.fAst.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.fAst.newSimpleName(VARIABLE_NAME_PRIME));
        variableDeclarationFragment.setInitializer((Expression)this.fAst.newNumberLiteral(PRIME_NUMBER));
        VariableDeclarationStatement variableDeclarationStatement = this.fAst.newVariableDeclarationStatement(variableDeclarationFragment);
        variableDeclarationStatement.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        variableDeclarationStatement.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        block.statements().add(variableDeclarationStatement);
        IfStatement ifStatement = this.fAst.newIfStatement();
        InfixExpression infixExpression = this.fAst.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
        infixExpression.setRightOperand((Expression)this.fAst.newNullLiteral());
        infixExpression.setOperator(InfixExpression.Operator.EQUALS);
        ifStatement.setExpression((Expression)infixExpression);
        ReturnStatement returnStatement = this.fAst.newReturnStatement();
        returnStatement.setExpression((Expression)this.fAst.newNumberLiteral("0"));
        ifStatement.setThenStatement((Statement)returnStatement);
        block.statements().add(ifStatement);
        VariableDeclarationFragment variableDeclarationFragment2 = this.fAst.newVariableDeclarationFragment();
        variableDeclarationFragment2.setName(this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        variableDeclarationFragment2.setInitializer((Expression)this.fAst.newNumberLiteral(INITIAL_HASHCODE_VALUE));
        VariableDeclarationStatement variableDeclarationStatement2 = this.fAst.newVariableDeclarationStatement(variableDeclarationFragment2);
        variableDeclarationStatement2.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        block.statements().add(variableDeclarationStatement2);
        ForStatement forStatement = this.fAst.newForStatement();
        VariableDeclarationFragment variableDeclarationFragment3 = this.fAst.newVariableDeclarationFragment();
        variableDeclarationFragment3.setName(this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
        variableDeclarationFragment3.setInitializer((Expression)this.fAst.newNumberLiteral("0"));
        VariableDeclarationExpression variableDeclarationExpression = this.fAst.newVariableDeclarationExpression(variableDeclarationFragment3);
        variableDeclarationExpression.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        forStatement.initializers().add(variableDeclarationExpression);
        InfixExpression infixExpression2 = this.fAst.newInfixExpression();
        infixExpression2.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
        FieldAccess fieldAccess = this.fAst.newFieldAccess();
        fieldAccess.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
        fieldAccess.setName(this.fAst.newSimpleName("length"));
        infixExpression2.setRightOperand((Expression)fieldAccess);
        infixExpression2.setOperator(InfixExpression.Operator.LESS);
        forStatement.setExpression((Expression)infixExpression2);
        PostfixExpression postfixExpression = this.fAst.newPostfixExpression();
        postfixExpression.setOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_INDEX));
        postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
        forStatement.updaters().add(postfixExpression);
        block.statements().add(forStatement);
        Block block2 = this.fAst.newBlock();
        Statement[] statementArray = this.createAddSimpleHashCode(iTypeBinding, new IHashCodeAccessProvider(){

            public Expression getThisAccess(String string) {
                ArrayAccess arrayAccess = GenerateHashCodeEqualsOperation.this.fAst.newArrayAccess();
                arrayAccess.setArray((Expression)GenerateHashCodeEqualsOperation.this.fAst.newSimpleName(GenerateHashCodeEqualsOperation.VARIABLE_NAME_HASHCODE_PARAM));
                arrayAccess.setIndex((Expression)GenerateHashCodeEqualsOperation.this.fAst.newSimpleName(string));
                return arrayAccess;
            }
        }, VARIABLE_NAME_INDEX, true);
        int n = 0;
        while (n < statementArray.length) {
            block2.statements().add(statementArray[n]);
            ++n;
        }
        forStatement.setBody((Statement)block2);
        ReturnStatement returnStatement2 = this.fAst.newReturnStatement();
        returnStatement2.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        block.statements().add(returnStatement2);
        if (this.fSettings != null && this.fSettings.createComments) {
            Javadoc javadoc = this.fAst.newJavadoc();
            TagElement tagElement = this.fAst.newTagElement();
            TextElement textElement = this.fAst.newTextElement();
            textElement.setText(CodeGenerationMessages.GenerateHashCodeEqualsOperation_hash_code_comment);
            tagElement.fragments().add(textElement);
            javadoc.tags().add(tagElement);
            TagElement tagElement2 = this.fAst.newTagElement();
            tagElement2.setTagName(CodeGenerationMessages.GenerateHashCodeEqualsOperation_tag_param);
            tagElement2.fragments().add(this.fAst.newSimpleName(VARIABLE_NAME_HASHCODE_PARAM));
            textElement = this.fAst.newTextElement();
            textElement.setText(CodeGenerationMessages.GenerateHashCodeEqualsOperation_hash_code_argument);
            tagElement2.fragments().add(textElement);
            javadoc.tags().add(tagElement2);
            TagElement tagElement3 = this.fAst.newTagElement();
            tagElement3.setTagName(CodeGenerationMessages.GenerateHashCodeEqualsOperation_tag_return);
            textElement = this.fAst.newTextElement();
            textElement.setText(CodeGenerationMessages.GenerateHashCodeEqualsOperation_return_comment);
            tagElement3.fragments().add(textElement);
            javadoc.tags().add(tagElement3);
            methodDeclaration.setJavadoc(javadoc);
        }
        return methodDeclaration;
    }

    private Statement createAddQualifiedHashCode(IVariableBinding iVariableBinding) {
        MethodInvocation methodInvocation = this.fAst.newMethodInvocation();
        methodInvocation.setExpression(this.getThisAccessForHashCode(iVariableBinding.getName()));
        methodInvocation.setName(this.fAst.newSimpleName(METHODNAME_HASH_CODE));
        InfixExpression infixExpression = this.fAst.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.EQUALS);
        infixExpression.setLeftOperand(this.getThisAccessForHashCode(iVariableBinding.getName()));
        infixExpression.setRightOperand((Expression)this.fAst.newNullLiteral());
        ConditionalExpression conditionalExpression = this.fAst.newConditionalExpression();
        conditionalExpression.setThenExpression((Expression)this.fAst.newNumberLiteral("0"));
        conditionalExpression.setElseExpression((Expression)methodInvocation);
        conditionalExpression.setExpression(this.parenthesize((Expression)infixExpression));
        return this.prepareAssignment(this.parenthesize((Expression)conditionalExpression));
    }

    private Expression createShiftAssignment(Expression expression, Expression expression2) {
        CastExpression castExpression = this.fAst.newCastExpression();
        castExpression.setType((Type)this.fAst.newPrimitiveType(PrimitiveType.INT));
        InfixExpression infixExpression = this.fAst.newInfixExpression();
        infixExpression.setLeftOperand(expression);
        infixExpression.setRightOperand((Expression)this.fAst.newNumberLiteral("32"));
        infixExpression.setOperator(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED);
        InfixExpression infixExpression2 = this.fAst.newInfixExpression();
        infixExpression2.setLeftOperand(expression2);
        infixExpression2.setRightOperand(this.parenthesize((Expression)infixExpression));
        infixExpression2.setOperator(InfixExpression.Operator.XOR);
        castExpression.setExpression(this.parenthesize((Expression)infixExpression2));
        return castExpression;
    }

    private Statement prepareAssignment(Expression expression) {
        InfixExpression infixExpression = this.fAst.newInfixExpression();
        infixExpression.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_PRIME));
        infixExpression.setRightOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        infixExpression.setOperator(InfixExpression.Operator.TIMES);
        Assignment assignment = this.fAst.newAssignment();
        assignment.setLeftHandSide((Expression)this.fAst.newSimpleName(VARIABLE_NAME_RESULT));
        InfixExpression infixExpression2 = this.fAst.newInfixExpression();
        infixExpression2.setLeftOperand((Expression)infixExpression);
        infixExpression2.setOperator(InfixExpression.Operator.PLUS);
        infixExpression2.setRightOperand(expression);
        assignment.setRightHandSide((Expression)infixExpression2);
        return this.fAst.newExpressionStatement((Expression)assignment);
    }

    private MethodDeclaration createEqualsMethod() throws CoreException {
        IfStatement ifStatement;
        PrefixExpression prefixExpression;
        SuperMethodInvocation superMethodInvocation;
        MethodDeclaration methodDeclaration = this.fAst.newMethodDeclaration();
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAst, 1));
        methodDeclaration.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
        methodDeclaration.setConstructor(false);
        methodDeclaration.setReturnType2((Type)this.fAst.newPrimitiveType(PrimitiveType.BOOLEAN));
        List list = methodDeclaration.parameters();
        SingleVariableDeclaration singleVariableDeclaration = this.fAst.newSingleVariableDeclaration();
        singleVariableDeclaration.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName("Object")));
        singleVariableDeclaration.setName(this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
        list.add(singleVariableDeclaration);
        Block block = this.fAst.newBlock();
        methodDeclaration.setBody(block);
        block.statements().add(this.createReturningIfStatement((Expression)this.fAst.newThisExpression(), (Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM), InfixExpression.Operator.EQUALS, true));
        if (this.needsNoSuperCall(this.fType, METHODNAME_EQUALS, new ITypeBinding[]{this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT)})) {
            block.statements().add(this.createReturningIfStatement((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM), (Expression)this.fAst.newNullLiteral(), InfixExpression.Operator.EQUALS, false));
        } else {
            superMethodInvocation = this.fAst.newSuperMethodInvocation();
            superMethodInvocation.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
            superMethodInvocation.arguments().add(this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
            prefixExpression = this.fAst.newPrefixExpression();
            prefixExpression.setOperator(PrefixExpression.Operator.NOT);
            prefixExpression.setOperand((Expression)superMethodInvocation);
            ifStatement = this.fAst.newIfStatement();
            ifStatement.setExpression((Expression)prefixExpression);
            ifStatement.setThenStatement((Statement)this.getReturnFalse());
            block.statements().add(ifStatement);
        }
        if (this.fUseInstanceOf) {
            superMethodInvocation = this.fAst.newInstanceofExpression();
            superMethodInvocation.setLeftOperand((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
            superMethodInvocation.setRightOperand(this.fRewrite.getImportRewrite().addImport(this.fType, this.fAst));
            prefixExpression = this.fAst.newPrefixExpression();
            prefixExpression.setOperator(PrefixExpression.Operator.NOT);
            ifStatement = this.fAst.newParenthesizedExpression();
            ifStatement.setExpression((Expression)superMethodInvocation);
            prefixExpression.setOperand((Expression)ifStatement);
            block.statements().add(this.createReturningIfStatement(false, (Expression)prefixExpression));
        } else {
            superMethodInvocation = this.fAst.newMethodInvocation();
            superMethodInvocation.setName(this.fAst.newSimpleName(METHODNAME_GETCLASS));
            prefixExpression = this.fAst.newMethodInvocation();
            prefixExpression.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
            prefixExpression.setName(this.fAst.newSimpleName(METHODNAME_GETCLASS));
            block.statements().add(this.createReturningIfStatement((Expression)superMethodInvocation, (Expression)prefixExpression, InfixExpression.Operator.NOT_EQUALS, false));
        }
        superMethodInvocation = this.fAst.newVariableDeclarationFragment();
        superMethodInvocation.setName(this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_CASTED));
        prefixExpression = this.fAst.newCastExpression();
        prefixExpression.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName(this.fType.getName())));
        prefixExpression.setExpression((Expression)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_PARAM));
        superMethodInvocation.setInitializer((Expression)prefixExpression);
        ifStatement = this.fAst.newVariableDeclarationStatement((VariableDeclarationFragment)superMethodInvocation);
        ifStatement.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName(this.fType.getName())));
        ifStatement.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        block.statements().add(ifStatement);
        int n = 0;
        while (n < this.fFields.length) {
            if (this.fFields[n].getType().isPrimitive()) {
                block.statements().add(this.createSimpleComparison(this.fFields[n]));
            } else if (this.fFields[n].getType().isArray()) {
                block.statements().add(this.createArrayComparison(this.fFields[n].getName()));
            } else {
                block.statements().add(this.createQualifiedComparison(this.fFields[n].getName()));
            }
            ++n;
        }
        ReturnStatement returnStatement = this.fAst.newReturnStatement();
        returnStatement.setExpression((Expression)this.fAst.newBooleanLiteral(true));
        block.statements().add(returnStatement);
        if (this.fSettings != null) {
            ITypeBinding iTypeBinding = this.fAst.resolveWellKnownType(JAVA_LANG_OBJECT);
            IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
            IMethodBinding iMethodBinding = null;
            int n2 = 0;
            while (n2 < iMethodBindingArray.length) {
                if (iMethodBindingArray[n2].getName().equals(METHODNAME_EQUALS) && iMethodBindingArray[n2].getParameterTypes().length == 1 && iMethodBindingArray[n2].getParameterTypes()[0].getQualifiedName().equals(JAVA_LANG_OBJECT)) {
                    iMethodBinding = iMethodBindingArray[n2];
                }
                ++n2;
            }
            this.createMethodComment(methodDeclaration, iMethodBinding);
        }
        return methodDeclaration;
    }

    private Statement createSimpleComparison(IVariableBinding iVariableBinding) {
        if (this.isPrimitiveType(iVariableBinding.getType(), PrimitiveType.FLOAT)) {
            return this.createReturningIfStatement(this.createFloatInvocation(this.getThisAccessForEquals(iVariableBinding.getName())), this.createFloatInvocation(this.getOtherAccess(iVariableBinding.getName())), InfixExpression.Operator.NOT_EQUALS, false);
        }
        if (this.isPrimitiveType(iVariableBinding.getType(), PrimitiveType.DOUBLE)) {
            return this.createReturningIfStatement(this.createDoubleInvocation(this.getThisAccessForEquals(iVariableBinding.getName())), this.createDoubleInvocation(this.getOtherAccess(iVariableBinding.getName())), InfixExpression.Operator.NOT_EQUALS, false);
        }
        return this.createReturningIfStatement(this.getThisAccessForEquals(iVariableBinding.getName()), this.getOtherAccess(iVariableBinding.getName()), InfixExpression.Operator.NOT_EQUALS, false);
    }

    private Statement createArrayComparison(String string) {
        MethodInvocation methodInvocation = this.fAst.newMethodInvocation();
        methodInvocation.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
        methodInvocation.setExpression((Expression)this.getQualifiedName(JAVA_UTIL_ARRAYS));
        methodInvocation.arguments().add(this.getThisAccessForEquals(string));
        methodInvocation.arguments().add(this.getOtherAccess(string));
        PrefixExpression prefixExpression = this.fAst.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        prefixExpression.setOperand((Expression)methodInvocation);
        IfStatement ifStatement = this.fAst.newIfStatement();
        ifStatement.setExpression((Expression)prefixExpression);
        ifStatement.setThenStatement((Statement)this.getReturnFalse());
        return ifStatement;
    }

    private Statement createQualifiedComparison(String string) {
        InfixExpression infixExpression = this.fAst.newInfixExpression();
        infixExpression.setOperator(InfixExpression.Operator.EQUALS);
        infixExpression.setLeftOperand(this.getThisAccessForEquals(string));
        infixExpression.setRightOperand((Expression)this.fAst.newNullLiteral());
        InfixExpression infixExpression2 = this.fAst.newInfixExpression();
        infixExpression2.setOperator(InfixExpression.Operator.NOT_EQUALS);
        infixExpression2.setLeftOperand(this.getOtherAccess(string));
        infixExpression2.setRightOperand((Expression)this.fAst.newNullLiteral());
        IfStatement ifStatement = this.fAst.newIfStatement();
        ifStatement.setExpression((Expression)infixExpression2);
        ifStatement.setThenStatement((Statement)this.getReturnFalse());
        Block block = this.fAst.newBlock();
        block.statements().add(ifStatement);
        MethodInvocation methodInvocation = this.fAst.newMethodInvocation();
        methodInvocation.setName(this.fAst.newSimpleName(METHODNAME_EQUALS));
        methodInvocation.setExpression(this.getThisAccessForEquals(string));
        methodInvocation.arguments().add(this.getOtherAccess(string));
        PrefixExpression prefixExpression = this.fAst.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        prefixExpression.setOperand((Expression)methodInvocation);
        IfStatement ifStatement2 = this.fAst.newIfStatement();
        ifStatement2.setExpression((Expression)prefixExpression);
        ifStatement2.setThenStatement((Statement)this.getReturnFalse());
        IfStatement ifStatement3 = this.fAst.newIfStatement();
        ifStatement3.setExpression((Expression)infixExpression);
        ifStatement3.setThenStatement((Statement)block);
        ifStatement3.setElseStatement((Statement)ifStatement2);
        return ifStatement3;
    }

    private Statement createReturningIfStatement(Expression expression, Expression expression2, InfixExpression.Operator operator, boolean bl) {
        InfixExpression infixExpression = this.fAst.newInfixExpression();
        infixExpression.setOperator(operator);
        infixExpression.setLeftOperand(expression);
        infixExpression.setRightOperand(expression2);
        return this.createReturningIfStatement(bl, (Expression)infixExpression);
    }

    private Statement createReturningIfStatement(boolean bl, Expression expression) {
        IfStatement ifStatement = this.fAst.newIfStatement();
        ifStatement.setExpression(expression);
        ReturnStatement returnStatement = this.fAst.newReturnStatement();
        returnStatement.setExpression((Expression)this.fAst.newBooleanLiteral(bl));
        ifStatement.setThenStatement((Statement)returnStatement);
        return ifStatement;
    }

    private void createMethodComment(MethodDeclaration methodDeclaration, IMethodBinding iMethodBinding) throws CoreException {
        String string;
        if (this.fSettings.createComments && (string = CodeGeneration.getMethodComment(this.fRewrite.getCu(), this.fType.getQualifiedName(), methodDeclaration, iMethodBinding, StubUtility.getLineDelimiterUsed((IJavaElement)this.fRewrite.getCu()))) != null) {
            Javadoc javadoc = (Javadoc)this.fRewrite.getASTRewrite().createStringPlaceholder(string, 29);
            methodDeclaration.setJavadoc(javadoc);
        }
        if (this.fSettings.overrideAnnotation && JavaModelUtil.is50OrHigher(this.fUnit.getJavaElement().getJavaProject())) {
            StubUtility2.addOverrideAnnotation(this.fRewrite.getASTRewrite(), methodDeclaration, iMethodBinding);
        }
    }

    private boolean needsNoSuperCall(ITypeBinding iTypeBinding, String string, ITypeBinding[] iTypeBindingArray) {
        Assert.isNotNull((Object)iTypeBinding);
        IMethodBinding iMethodBinding = GenerateHashCodeEqualsOperation.findMethodInHierarchy(iTypeBinding, string, iTypeBindingArray);
        if (iMethodBinding != null) {
            ITypeBinding iTypeBinding2 = iMethodBinding.getDeclaringClass();
            if (Bindings.equals((IBinding)iTypeBinding, (IBinding)iTypeBinding2)) {
                return true;
            }
            return iTypeBinding2.getQualifiedName().equals(JAVA_LANG_OBJECT);
        }
        return true;
    }

    public static IMethodBinding findMethodInType(ITypeBinding iTypeBinding, String string, ITypeBinding[] iTypeBindingArray) {
        if (iTypeBinding.isPrimitive()) {
            return null;
        }
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray.length) {
            if (iTypeBindingArray == null ? string.equals(iMethodBindingArray[n].getName()) && !Modifier.isAbstract((int)iMethodBindingArray[n].getModifiers()) : Bindings.isEqualMethod(iMethodBindingArray[n], string, iTypeBindingArray) && !Modifier.isAbstract((int)iMethodBindingArray[n].getModifiers())) {
                return iMethodBindingArray[n];
            }
            ++n;
        }
        return null;
    }

    public static IMethodBinding findMethodInHierarchy(ITypeBinding iTypeBinding, String string, ITypeBinding[] iTypeBindingArray) {
        IMethodBinding iMethodBinding = GenerateHashCodeEqualsOperation.findMethodInType(iTypeBinding, string, iTypeBindingArray);
        if (iMethodBinding != null) {
            return iMethodBinding;
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 != null && (iMethodBinding = GenerateHashCodeEqualsOperation.findMethodInHierarchy(iTypeBinding2, string, iTypeBindingArray)) != null) {
            return iMethodBinding;
        }
        ITypeBinding[] iTypeBindingArray2 = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < iTypeBindingArray2.length) {
            iMethodBinding = GenerateHashCodeEqualsOperation.findMethodInHierarchy(iTypeBindingArray2[n], string, iTypeBindingArray);
            if (iMethodBinding != null) {
                return iMethodBinding;
            }
            ++n;
        }
        return null;
    }

    private Expression getThisAccessForEquals(String string) {
        return this.getThisAccess(string, false);
    }

    private Expression getThisAccessForHashCode(String string) {
        return this.getThisAccess(string, true);
    }

    private Expression getThisAccess(String string, boolean bl) {
        if (this.fSettings.useKeywordThis || this.needsThisQualification(string, bl)) {
            FieldAccess fieldAccess = this.fAst.newFieldAccess();
            fieldAccess.setExpression((Expression)this.fAst.newThisExpression());
            fieldAccess.setName(this.fAst.newSimpleName(string));
            return fieldAccess;
        }
        return this.fAst.newSimpleName(string);
    }

    private Expression getOtherAccess(String string) {
        return this.fAst.newQualifiedName((Name)this.fAst.newSimpleName(VARIABLE_NAME_EQUALS_CASTED), this.fAst.newSimpleName(string));
    }

    private boolean isPrimitiveType(ITypeBinding iTypeBinding, PrimitiveType.Code code) {
        return iTypeBinding.getName().equals(code.toString());
    }

    private boolean isPrimitiveType(ITypeBinding iTypeBinding, PrimitiveType.Code[] codeArray) {
        int n = 0;
        while (n < codeArray.length) {
            PrimitiveType.Code code = codeArray[n];
            if (this.isPrimitiveType(iTypeBinding, code)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Name getQualifiedName(String string) {
        String string2 = this.fRewrite.getImportRewrite().addImport(string);
        return ASTNodeFactory.newName(this.fAst, string2);
    }

    private ReturnStatement getReturnFalse() {
        ReturnStatement returnStatement = this.fAst.newReturnStatement();
        returnStatement.setExpression((Expression)this.fAst.newBooleanLiteral(false));
        return returnStatement;
    }

    private Expression parenthesize(Expression expression) {
        ParenthesizedExpression parenthesizedExpression = this.fAst.newParenthesizedExpression();
        parenthesizedExpression.setExpression(expression);
        return parenthesizedExpression;
    }

    private Expression createFloatInvocation(Expression expression) {
        return this.createMethodInvocation(expression, "java.lang.Float", "floatToIntBits");
    }

    private Expression createDoubleInvocation(Expression expression) {
        return this.createMethodInvocation(expression, "java.lang.Double", "doubleToLongBits");
    }

    private Expression createMethodInvocation(Expression expression, String string, String string2) {
        MethodInvocation methodInvocation = this.fAst.newMethodInvocation();
        methodInvocation.setExpression((Expression)this.getQualifiedName(string));
        methodInvocation.setName(this.fAst.newSimpleName(string2));
        methodInvocation.arguments().add(expression);
        return methodInvocation;
    }

    private boolean needsThisQualification(String string, boolean bl) {
        if (bl) {
            return this.fDoubleCount > 0 && string.equals(VARIABLE_NAME_DOUBLE_TEMPORARY) || string.equals(VARIABLE_NAME_PRIME) || string.equals(VARIABLE_NAME_RESULT);
        }
        return string.equals(VARIABLE_NAME_EQUALS_CASTED) || string.equals(VARIABLE_NAME_EQUALS_PARAM);
    }

    private static interface IHashCodeAccessProvider {
        public Expression getThisAccess(String var1);
    }
}

