/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom.fragments;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IASTFragment;

class ASTMatchingFragmentFinder
extends GenericVisitor {
    private ASTFragment fFragmentToMatch;
    private Set fMatches = new HashSet();

    public static IASTFragment[] findMatchingFragments(ASTNode aSTNode, ASTFragment aSTFragment) {
        return new ASTMatchingFragmentFinder(aSTFragment).findMatches(aSTNode);
    }

    private ASTMatchingFragmentFinder(ASTFragment aSTFragment) {
        super(true);
        this.fFragmentToMatch = aSTFragment;
    }

    private IASTFragment[] findMatches(ASTNode aSTNode) {
        this.fMatches.clear();
        aSTNode.accept((ASTVisitor)this);
        return this.getMatches();
    }

    private IASTFragment[] getMatches() {
        return this.fMatches.toArray(new IASTFragment[this.fMatches.size()]);
    }

    public boolean visit(Javadoc javadoc) {
        return false;
    }

    protected boolean visitNode(ASTNode aSTNode) {
        IASTFragment[] iASTFragmentArray = this.fFragmentToMatch.getMatchingFragmentsWithNode(aSTNode);
        int n = 0;
        while (n < iASTFragmentArray.length) {
            this.fMatches.add(iASTFragmentArray[n]);
            ++n;
        }
        return true;
    }
}

