/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MultiStateCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.fix.CodeFormatCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.CommentFormatCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.ControlStatementsCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.ConvertLoopCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.ExpressionsCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.SortMembersCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.StringCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IScheduledRefactoring;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class CleanUpRefactoring
extends Refactoring
implements IScheduledRefactoring {
    private static final RefactoringTickProvider CLEAN_UP_REFACTORING_TICK_PROVIDER = new RefactoringTickProvider(0, 1, 0, 0);
    private final List fCleanUps;
    private final Hashtable fProjects;
    private Change fChange;
    private boolean fLeaveFilesDirty;
    private final String fName;

    public CleanUpRefactoring() {
        this(FixMessages.CleanUpRefactoring_Refactoring_name);
    }

    public CleanUpRefactoring(String string) {
        this.fName = string;
        this.fCleanUps = new ArrayList();
        this.fProjects = new Hashtable();
    }

    public void addCompilationUnit(ICompilationUnit iCompilationUnit) {
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        if (!this.fProjects.containsKey(iJavaProject)) {
            this.fProjects.put(iJavaProject, new ArrayList());
        }
        List list = (List)this.fProjects.get(iJavaProject);
        list.add(iCompilationUnit);
    }

    public void clearCompilationUnits() {
        this.fProjects.clear();
    }

    public boolean hasCompilationUnits() {
        return !this.fProjects.isEmpty();
    }

    public ICompilationUnit[] getCompilationUnits() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.fProjects.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            arrayList.addAll(list);
        }
        return arrayList.toArray(new ICompilationUnit[arrayList.size()]);
    }

    public void addCleanUp(ICleanUp iCleanUp) {
        this.fCleanUps.add(iCleanUp);
    }

    public void clearCleanUps() {
        this.fCleanUps.clear();
    }

    public boolean hasCleanUps() {
        return !this.fCleanUps.isEmpty();
    }

    public ICleanUp[] getCleanUps() {
        return this.fCleanUps.toArray(new ICleanUp[this.fCleanUps.size()]);
    }

    public IJavaProject[] getProjects() {
        return this.fProjects.keySet().toArray(new IJavaProject[this.fProjects.keySet().size()]);
    }

    public void setLeaveFilesDirty(boolean bl) {
        this.fLeaveFilesDirty = bl;
    }

    public String getName() {
        return this.fName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("", 1);
            iProgressMonitor.worked(1);
            iProgressMonitor.done();
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("", 1);
            iProgressMonitor.worked(1);
            iProgressMonitor.done();
        }
        return this.fChange;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        block11: {
            RefactoringStatus refactoringStatus2;
            Object object;
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            if (this.fProjects.size() == 0 || this.fCleanUps.size() == 0) {
                iProgressMonitor.beginTask("", 1);
                iProgressMonitor.worked(1);
                iProgressMonitor.done();
                this.fChange = new NullChange();
                return new RefactoringStatus();
            }
            int n = 0;
            refactoringStatus = this.fProjects.keySet().iterator();
            while (refactoringStatus.hasNext()) {
                object = (IJavaProject)refactoringStatus.next();
                n += ((List)this.fProjects.get(object)).size();
            }
            refactoringStatus = new RefactoringStatus();
            iProgressMonitor.beginTask("", n * 2 * this.fCleanUps.size() + 4 * this.fCleanUps.size());
            try {
                object = new DynamicValidationStateChange(this.getName());
                ((DynamicValidationStateChange)object).setSchedulingRule(this.getSchedulingRule());
                Object object2 = this.fProjects.keySet().iterator();
                while (object2.hasNext()) {
                    IJavaProject iJavaProject = (IJavaProject)object2.next();
                    List list = (List)this.fProjects.get(iJavaProject);
                    ICompilationUnit[] iCompilationUnitArray = list.toArray(new ICompilationUnit[list.size()]);
                    ICleanUp[] iCleanUpArray = this.fCleanUps.toArray(new ICleanUp[this.fCleanUps.size()]);
                    refactoringStatus.merge(this.initialize(iJavaProject));
                    if (refactoringStatus.hasFatalError()) {
                        RefactoringStatus refactoringStatus3 = refactoringStatus;
                        Object var12_16 = null;
                        iProgressMonitor.done();
                        return refactoringStatus3;
                    }
                    refactoringStatus.merge(this.checkPreConditions(iJavaProject, iCompilationUnitArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3 * iCleanUpArray.length)));
                    if (refactoringStatus.hasFatalError()) {
                        RefactoringStatus refactoringStatus4 = refactoringStatus;
                        Object var12_17 = null;
                        iProgressMonitor.done();
                        return refactoringStatus4;
                    }
                    Change[] changeArray = this.cleanUpProject(iJavaProject, iCompilationUnitArray, iCleanUpArray, iProgressMonitor);
                    refactoringStatus.merge(this.checkPostConditions(new SubProgressMonitor(iProgressMonitor, iCleanUpArray.length)));
                    if (refactoringStatus.hasFatalError()) {
                        RefactoringStatus refactoringStatus5 = refactoringStatus;
                        Object var12_18 = null;
                        iProgressMonitor.done();
                        return refactoringStatus5;
                    }
                    int n2 = 0;
                    while (n2 < changeArray.length) {
                        object.add(changeArray[n2]);
                        ++n2;
                    }
                }
                this.fChange = object;
                object2 = new ArrayList();
                this.findFilesToBeModified((CompositeChange)object, (List)object2);
                refactoringStatus.merge(Checks.validateModifiesFiles(object2.toArray(new IFile[object2.size()]), this.getValidationContext()));
                if (!refactoringStatus.hasFatalError()) break block11;
                refactoringStatus2 = refactoringStatus;
                Object var12_19 = null;
            }
            catch (Throwable throwable) {
                Object var12_20 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return refactoringStatus2;
        }
        Object var12_21 = null;
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private void findFilesToBeModified(CompositeChange compositeChange, List list) throws JavaModelException {
        Change[] changeArray = compositeChange.getChildren();
        int n = 0;
        while (n < changeArray.length) {
            Change change = changeArray[n];
            if (change instanceof CompositeChange) {
                this.findFilesToBeModified((CompositeChange)change, list);
            } else if (change instanceof MultiStateCompilationUnitChange) {
                list.add(((MultiStateCompilationUnitChange)change).getCompilationUnit().getCorrespondingResource());
            } else if (change instanceof CompilationUnitChange) {
                list.add(((CompilationUnitChange)change).getCompilationUnit().getCorrespondingResource());
            }
            ++n;
        }
    }

    private Change[] cleanUpProject(IJavaProject iJavaProject, ICompilationUnit[] iCompilationUnitArray, ICleanUp[] iCleanUpArray, IProgressMonitor iProgressMonitor) throws CoreException {
        Change[] changeArray;
        CleanUpFixpointIterator cleanUpFixpointIterator = new CleanUpFixpointIterator(iJavaProject, iCompilationUnitArray, iCleanUpArray);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 2 * iCompilationUnitArray.length * iCleanUpArray.length);
        subProgressMonitor.beginTask("", iCompilationUnitArray.length);
        subProgressMonitor.subTask(Messages.format(FixMessages.CleanUpRefactoring_Parser_Startup_message, iJavaProject.getElementName()));
        try {
            while (cleanUpFixpointIterator.hasNext()) {
                cleanUpFixpointIterator.next((IProgressMonitor)subProgressMonitor);
            }
            changeArray = cleanUpFixpointIterator.getResult();
            Object var7_8 = null;
            cleanUpFixpointIterator.dispose();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            cleanUpFixpointIterator.dispose();
            subProgressMonitor.done();
            throw throwable;
        }
        subProgressMonitor.done();
        return changeArray;
    }

    private RefactoringStatus initialize(IJavaProject iJavaProject) throws CoreException {
        Map map = CleanUpPreferenceUtil.loadOptions((IScopeContext)new ProjectScope(iJavaProject.getProject()));
        if (map == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(FixMessages.CleanUpRefactoring_could_not_retrive_profile, iJavaProject.getElementName()));
        }
        ICleanUp[] iCleanUpArray = this.getCleanUps();
        int n = 0;
        while (n < iCleanUpArray.length) {
            iCleanUpArray[n].initialize(map);
            ++n;
        }
        return new RefactoringStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus checkPreConditions(IJavaProject iJavaProject, ICompilationUnit[] iCompilationUnitArray, IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block6: {
            RefactoringStatus refactoringStatus2;
            block5: {
                refactoringStatus = new RefactoringStatus();
                ICleanUp[] iCleanUpArray = this.getCleanUps();
                iProgressMonitor.beginTask("", iCompilationUnitArray.length * iCleanUpArray.length);
                iProgressMonitor.subTask(Messages.format(FixMessages.CleanUpRefactoring_Initialize_message, iJavaProject.getElementName()));
                try {
                    int n = 0;
                    while (n < iCleanUpArray.length) {
                        refactoringStatus.merge(iCleanUpArray[n].checkPreConditions(iJavaProject, iCompilationUnitArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, iCompilationUnitArray.length)));
                        if (refactoringStatus.hasFatalError()) {
                            refactoringStatus2 = refactoringStatus;
                            Object var7_8 = null;
                            break block5;
                        }
                        ++n;
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return refactoringStatus2;
        }
        Object var7_10 = null;
        iProgressMonitor.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus checkPostConditions(SubProgressMonitor subProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block6: {
            RefactoringStatus refactoringStatus2;
            block5: {
                refactoringStatus = new RefactoringStatus();
                ICleanUp[] iCleanUpArray = this.getCleanUps();
                subProgressMonitor.beginTask("", iCleanUpArray.length);
                subProgressMonitor.subTask(FixMessages.CleanUpRefactoring_checkingPostConditions_message);
                try {
                    int n = 0;
                    while (n < iCleanUpArray.length) {
                        refactoringStatus.merge(iCleanUpArray[n].checkPostConditions((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1)));
                        if (refactoringStatus.hasFatalError()) {
                            refactoringStatus2 = refactoringStatus;
                            Object var5_6 = null;
                            break block5;
                        }
                        ++n;
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    subProgressMonitor.done();
                    throw throwable;
                }
            }
            subProgressMonitor.done();
            return refactoringStatus2;
        }
        Object var5_8 = null;
        subProgressMonitor.done();
        return refactoringStatus;
    }

    private static String getChangeName(ICompilationUnit iCompilationUnit) {
        StringBuffer stringBuffer = new StringBuffer();
        JavaElementLabels.getCompilationUnitLabel(iCompilationUnit, JavaElementLabels.ALL_DEFAULT, stringBuffer);
        stringBuffer.append(JavaElementLabels.CONCAT_STRING);
        StringBuffer stringBuffer2 = new StringBuffer();
        JavaElementLabels.getPackageFragmentLabel((IPackageFragment)iCompilationUnit.getParent(), 0x800000000L, stringBuffer2);
        stringBuffer.append(stringBuffer2.toString().replace('.', '/'));
        return stringBuffer.toString();
    }

    public static CleanUpChange calculateChange(CompilationUnit compilationUnit, ICompilationUnit iCompilationUnit, ICleanUp[] iCleanUpArray, List list) throws CoreException {
        if (iCleanUpArray.length == 0) {
            return null;
        }
        CleanUpChange cleanUpChange = null;
        int n = 0;
        do {
            ICleanUp iCleanUp = iCleanUpArray[n];
            IFix iFix = compilationUnit == null || !iCleanUp.requireAST(iCompilationUnit) ? iCleanUp.createFix(iCompilationUnit) : iCleanUp.createFix(compilationUnit);
            if (iFix == null) continue;
            TextChange textChange = iFix.createChange();
            TextEdit textEdit = CleanUpRefactoring.pack(textChange.getEdit());
            if (cleanUpChange != null) {
                if (CleanUpRefactoring.intersects(textEdit, cleanUpChange.getEdit())) {
                    list.add(iCleanUp);
                    continue;
                }
                CleanUpChange cleanUpChange2 = new CleanUpChange(FixMessages.CleanUpRefactoring_clean_up_multi_chang_name, iCompilationUnit);
                cleanUpChange2.setEdit(CleanUpRefactoring.merge(textEdit, cleanUpChange.getEdit()));
                CleanUpRefactoring.copyChangeGroups(cleanUpChange2, (TextChange)cleanUpChange);
                CleanUpRefactoring.copyChangeGroups(cleanUpChange2, textChange);
                cleanUpChange = cleanUpChange2;
                continue;
            }
            cleanUpChange = new CleanUpChange(textChange.getName(), iCompilationUnit);
            cleanUpChange.setEdit(textEdit);
            CleanUpRefactoring.copyChangeGroups(cleanUpChange, textChange);
        } while (++n < iCleanUpArray.length && (cleanUpChange == null || compilationUnit != null && !iCleanUpArray[n].needsFreshAST(compilationUnit)));
        while (n < iCleanUpArray.length) {
            list.add(iCleanUpArray[n]);
            ++n;
        }
        return cleanUpChange;
    }

    private static void copyChangeGroups(CompilationUnitChange compilationUnitChange, TextChange textChange) {
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = textChange.getChangeGroups();
        int n = 0;
        while (n < textEditBasedChangeGroupArray.length) {
            TextEditGroup textEditGroup;
            TextEdit[] textEditArray;
            TextEditGroup textEditGroup2 = textEditBasedChangeGroupArray[n].getTextEditGroup();
            if (textEditGroup2 instanceof CategorizedTextEditGroup) {
                textEditArray = textEditGroup2.getName();
                textEditGroup = new CategorizedTextEditGroup((String)textEditArray, new GroupCategorySet(new GroupCategory((String)textEditArray, (String)textEditArray, (String)textEditArray)));
            } else {
                textEditGroup = new TextEditGroup(textEditGroup2.getName());
            }
            textEditArray = textEditGroup2.getTextEdits();
            int n2 = 0;
            while (n2 < textEditArray.length) {
                textEditGroup.addTextEdit(textEditArray[n2]);
                ++n2;
            }
            compilationUnitChange.addTextEditGroup(textEditGroup);
            ++n;
        }
    }

    private static TextEdit pack(TextEdit textEdit) {
        final ArrayList arrayList = new ArrayList();
        textEdit.accept(new TextEditVisitor(){

            public boolean visitNode(TextEdit textEdit) {
                if (textEdit instanceof MultiTextEdit) {
                    return true;
                }
                arrayList.add(textEdit);
                return false;
            }
        });
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TextEdit textEdit2 = (TextEdit)iterator.next();
            textEdit2.getParent().removeChild(textEdit2);
            TextChangeCompatibility.insert((TextEdit)multiTextEdit, textEdit2);
        }
        return multiTextEdit;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean intersects(TextEdit var0, TextEdit var1_1) {
        block13: {
            if (!(var0 instanceof MultiTextEdit) || !(var1_1 instanceof MultiTextEdit)) break block13;
            var2_2 = (MultiTextEdit)var0;
            var3_6 = var2_2.getChildren();
            var4_10 = (MultiTextEdit)var1_1;
            var5_14 = var4_10.getChildren();
            var6_18 = 0;
            var7_19 = 0;
            ** GOTO lbl22
            {
                if (++var6_18 >= var3_6.length) {
                    return false;
                }
                do {
                    if (var3_6[var6_18].getExclusiveEnd() < var5_14[var7_19].getOffset()) continue block0;
                    while (var5_14[var7_19].getExclusiveEnd() < var3_6[var6_18].getOffset()) {
                        if (++var7_19 < var5_14.length) continue;
                        return false;
                    }
                    if (CleanUpRefactoring.intersects(var3_6[var6_18], var5_14[var7_19])) {
                        return true;
                    }
                    if (var3_6[var6_18].getExclusiveEnd() < var5_14[var7_19].getExclusiveEnd()) {
                        ++var6_18;
                        continue;
                    }
                    ++var7_19;
lbl22:
                    // 3 sources

                } while (var6_18 < var3_6.length && var7_19 < var5_14.length);
            }
            return false;
        }
        if (var0 instanceof MultiTextEdit) {
            var2_3 = (MultiTextEdit)var0;
            var3_7 = var2_3.getChildren();
            var4_11 = 0;
            while (var4_11 < var3_7.length) {
                var5_15 = var3_7[var4_11];
                if (CleanUpRefactoring.intersects(var5_15, var1_1)) {
                    return true;
                }
                ++var4_11;
            }
            return false;
        }
        if (var1_1 instanceof MultiTextEdit) {
            var2_4 = (MultiTextEdit)var1_1;
            var3_8 = var2_4.getChildren();
            var4_12 = 0;
            while (var4_12 < var3_8.length) {
                var5_16 = var3_8[var4_12];
                if (CleanUpRefactoring.intersects(var5_16, var0)) {
                    return true;
                }
                ++var4_12;
            }
            return false;
        }
        var2_5 = var0.getOffset();
        var3_9 = var2_5 + var0.getLength();
        var4_13 = var1_1.getOffset();
        var5_17 = var4_13 + var1_1.getLength();
        if (var2_5 > var5_17) {
            return false;
        }
        return var4_13 <= var3_9;
    }

    /*
     * Unable to fully structure code
     */
    private static TextEdit merge(TextEdit var0, TextEdit var1_1) {
        block16: {
            var2_2 = new MultiTextEdit();
            if (!(var0 instanceof MultiTextEdit) || !(var1_1 instanceof MultiTextEdit)) break block16;
            var3_3 = (MultiTextEdit)var0;
            var4_6 = var3_3.getChildren();
            if (var4_6.length == 0) {
                return var1_1;
            }
            var5_9 = (MultiTextEdit)var1_1;
            var6_10 = var5_9.getChildren();
            if (var6_10.length == 0) {
                return var0;
            }
            var7_11 = 0;
            var8_12 = 0;
            ** GOTO lbl51
            {
                var0.removeChild(0);
                var2_2.addChild(var4_6[var7_11]);
                ++var7_11;
                do {
                    if (var7_11 < var4_6.length && var4_6[var7_11].getExclusiveEnd() < var6_10[var8_12].getOffset()) continue block0;
                    if (var7_11 < var4_6.length) ** GOTO lbl33
                    var9_13 = var8_12;
                    while (var9_13 < var6_10.length) {
                        var1_1.removeChild(0);
                        var2_2.addChild(var6_10[var9_13]);
                        ++var9_13;
                    }
                    return var2_2;
lbl-1000:
                    // 1 sources

                    {
                        var1_1.removeChild(0);
                        var2_2.addChild(var6_10[var8_12]);
                        ++var8_12;
lbl33:
                        // 2 sources

                        ** while (var8_12 < var6_10.length && var6_10[var8_12].getExclusiveEnd() < var4_6[var7_11].getOffset())
                    }
lbl34:
                    // 1 sources

                    if (var8_12 >= var6_10.length) {
                        var9_14 = var7_11;
                        while (var9_14 < var4_6.length) {
                            var0.removeChild(0);
                            var2_2.addChild(var4_6[var9_14]);
                            ++var9_14;
                        }
                        return var2_2;
                    }
                    if (var4_6[var7_11].getExclusiveEnd() < var6_10[var8_12].getOffset()) continue;
                    var0.removeChild(0);
                    var1_1.removeChild(0);
                    var2_2.addChild(CleanUpRefactoring.merge(var4_6[var7_11], var6_10[var8_12]));
                    ++var7_11;
                    ++var8_12;
lbl51:
                    // 3 sources

                } while (var7_11 < var4_6.length && var8_12 < var6_10.length);
            }
            return var2_2;
        }
        if (var0 instanceof MultiTextEdit) {
            var3_4 = var0.getChildren();
            var4_7 = 0;
            while (var3_4[var4_7].getExclusiveEnd() < var1_1.getOffset()) {
                var0.removeChild(0);
                var2_2.addChild(var3_4[var4_7]);
                if (++var4_7 < var3_4.length) continue;
                var2_2.addChild(var1_1);
                return var2_2;
            }
            var0.removeChild(0);
            var2_2.addChild(CleanUpRefactoring.merge(var3_4[var4_7], var1_1));
            ++var4_7;
            while (var4_7 < var3_4.length) {
                var0.removeChild(0);
                var2_2.addChild(var3_4[var4_7]);
                ++var4_7;
            }
            return var2_2;
        }
        if (var1_1 instanceof MultiTextEdit) {
            var3_5 = var1_1.getChildren();
            var4_8 = 0;
            while (var3_5[var4_8].getExclusiveEnd() < var0.getOffset()) {
                var1_1.removeChild(0);
                var2_2.addChild(var3_5[var4_8]);
                if (++var4_8 < var3_5.length) continue;
                var2_2.addChild(var0);
                return var2_2;
            }
            var1_1.removeChild(0);
            var2_2.addChild(CleanUpRefactoring.merge(var0, var3_5[var4_8]));
            ++var4_8;
            while (var4_8 < var3_5.length) {
                var1_1.removeChild(0);
                var2_2.addChild(var3_5[var4_8]);
                ++var4_8;
            }
            return var2_2;
        }
        if (var0.getExclusiveEnd() < var1_1.getOffset()) {
            var2_2.addChild(var0);
            var2_2.addChild(var1_1);
        } else {
            var2_2.addChild(var1_1);
            var2_2.addChild(var0);
        }
        return var2_2;
    }

    protected RefactoringTickProvider doGetRefactoringTickProvider() {
        return CLEAN_UP_REFACTORING_TICK_PROVIDER;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static ICleanUp[] createCleanUps() {
        return new ICleanUp[]{new ControlStatementsCleanUp(), new ConvertLoopCleanUp(), new ExpressionsCleanUp(), new UnusedCodeCleanUp(), new StringCleanUp(), new SortMembersCleanUp(), new CodeFormatCleanUp(), new CommentFormatCleanUp()};
    }

    public static ICleanUp[] createCleanUps(Map map) {
        return new ICleanUp[]{new ControlStatementsCleanUp(map), new ConvertLoopCleanUp(map), new ExpressionsCleanUp(map), new UnusedCodeCleanUp(map), new StringCleanUp(map), new SortMembersCleanUp(map), new CodeFormatCleanUp(map), new CommentFormatCleanUp(map)};
    }

    private static class CleanUpASTRequestor
    extends ASTRequestor {
        private final List fUndoneElements;
        private final Hashtable fSolutions;
        private final Hashtable fCompilationUnitCleanUpMap;
        private final CleanUpRefactoringProgressMonitor fMonitor;

        public CleanUpASTRequestor(List list, Hashtable hashtable, CleanUpRefactoringProgressMonitor cleanUpRefactoringProgressMonitor) {
            this.fSolutions = hashtable;
            this.fMonitor = cleanUpRefactoringProgressMonitor;
            this.fUndoneElements = new ArrayList();
            this.fCompilationUnitCleanUpMap = new Hashtable(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ParseListElement parseListElement = (ParseListElement)iterator.next();
                this.fCompilationUnitCleanUpMap.put(parseListElement.getCompilationUnit(), parseListElement.getCleanUps());
            }
        }

        public void acceptAST(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit) {
            this.fMonitor.subTask(this.fMonitor.getSubTaskMessage(iCompilationUnit));
            ICompilationUnit iCompilationUnit2 = (ICompilationUnit)iCompilationUnit.getPrimaryElement();
            ICleanUp[] iCleanUpArray = (ICleanUp[])this.fCompilationUnitCleanUpMap.get(iCompilationUnit2);
            ICleanUp[] iCleanUpArray2 = this.calculateSolutions(iCompilationUnit, compilationUnit, iCleanUpArray);
            if (iCleanUpArray2.length > 0) {
                this.fUndoneElements.add(new ParseListElement(iCompilationUnit2, iCleanUpArray2));
                this.fMonitor.reset();
            } else {
                this.fMonitor.flush();
            }
        }

        public void acceptSource(ICompilationUnit iCompilationUnit) {
            this.acceptAST(iCompilationUnit, null);
        }

        public List getUndoneElements() {
            return this.fUndoneElements;
        }

        private ICleanUp[] calculateSolutions(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, ICleanUp[] iCleanUpArray) {
            CleanUpChange cleanUpChange;
            ArrayList arrayList = new ArrayList();
            try {
                cleanUpChange = CleanUpRefactoring.calculateChange(compilationUnit, iCompilationUnit, iCleanUpArray, arrayList);
            }
            catch (CoreException coreException) {
                throw new FixCalculationException(coreException);
            }
            if (cleanUpChange != null) {
                try {
                    this.integrateSolution(cleanUpChange, iCompilationUnit);
                }
                catch (JavaModelException javaModelException) {
                    throw new FixCalculationException((CoreException)((Object)javaModelException));
                }
            }
            return arrayList.toArray(new ICleanUp[arrayList.size()]);
        }

        private void integrateSolution(CleanUpChange cleanUpChange, ICompilationUnit iCompilationUnit) throws JavaModelException {
            ICompilationUnit iCompilationUnit2 = iCompilationUnit.getPrimary();
            ArrayList<CleanUpChange> arrayList = (ArrayList<CleanUpChange>)this.fSolutions.get(iCompilationUnit2);
            if (arrayList == null) {
                arrayList = new ArrayList<CleanUpChange>();
                this.fSolutions.put(iCompilationUnit2, arrayList);
            }
            arrayList.add(cleanUpChange);
        }
    }

    public static class CleanUpChange
    extends CompilationUnitChange {
        private UndoEdit fUndoEdit;

        public CleanUpChange(String string, ICompilationUnit iCompilationUnit) {
            super(string, iCompilationUnit);
        }

        protected Change createUndoChange(UndoEdit undoEdit, ContentStamp contentStamp) {
            this.fUndoEdit = undoEdit;
            return super.createUndoChange(undoEdit, contentStamp);
        }

        public UndoEdit getUndoEdit() {
            return this.fUndoEdit;
        }
    }

    private class CleanUpFixpointIterator {
        private List fParseList;
        private final Hashtable fSolutions;
        private final Hashtable fWorkingCopies;
        private final IJavaProject fProject;
        private final Map fCleanUpOptions;
        private final int fSize;
        private int fIndex;

        public CleanUpFixpointIterator(IJavaProject iJavaProject, ICompilationUnit[] iCompilationUnitArray, ICleanUp[] iCleanUpArray) {
            this.fProject = iJavaProject;
            this.fSolutions = new Hashtable(iCompilationUnitArray.length);
            this.fWorkingCopies = new Hashtable();
            this.fParseList = new ArrayList(iCompilationUnitArray.length);
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                this.fParseList.add(new ParseListElement(iCompilationUnitArray[n], iCleanUpArray));
                ++n;
            }
            this.fCleanUpOptions = new Hashtable();
            n = 0;
            while (n < iCleanUpArray.length) {
                ICleanUp iCleanUp = iCleanUpArray[n];
                Map map = iCleanUp.getRequiredOptions();
                if (map != null) {
                    this.fCleanUpOptions.putAll(map);
                }
                ++n;
            }
            this.fSize = iCompilationUnitArray.length;
            this.fIndex = 1;
        }

        public boolean hasNext() {
            return !this.fParseList.isEmpty();
        }

        public void next(IProgressMonitor iProgressMonitor) throws CoreException {
            Object object;
            Object object2;
            Object object3;
            ArrayList<ICompilationUnit> arrayList = new ArrayList<ICompilationUnit>();
            ArrayList<ICompilationUnit> arrayList2 = new ArrayList<ICompilationUnit>();
            Object object4 = this.fParseList.iterator();
            while (object4.hasNext()) {
                object3 = (ParseListElement)object4.next();
                object2 = ((ParseListElement)object3).getCompilationUnit();
                if (this.fSolutions.containsKey(object2)) {
                    if (this.fWorkingCopies.containsKey(object2)) {
                        object2 = (ICompilationUnit)this.fWorkingCopies.get(object2);
                    } else {
                        object2 = object2.getWorkingCopy(new WorkingCopyOwner(this){
                            final /* synthetic */ CleanUpFixpointIterator this$1;
                            {
                                this.this$1 = cleanUpFixpointIterator;
                            }
                        }, null);
                        this.fWorkingCopies.put(object2.getPrimary(), object2);
                    }
                    this.applyChange((ICompilationUnit)object2, (List)this.fSolutions.get(object2.getPrimary()));
                }
                if (this.requiresAST((ICompilationUnit)object2, ((ParseListElement)object3).getCleanUps())) {
                    arrayList.add((ICompilationUnit)object2);
                    continue;
                }
                arrayList2.add((ICompilationUnit)object2);
            }
            object4 = new CleanUpRefactoringProgressMonitor(iProgressMonitor, arrayList.size() + arrayList2.size(), this.fSize, this.fIndex);
            object3 = new CleanUpASTRequestor(this.fParseList, this.fSolutions, (CleanUpRefactoringProgressMonitor)((Object)object4));
            object2 = new CleanUpParser(this){
                final /* synthetic */ CleanUpFixpointIterator this$1;
                {
                    this.this$1 = cleanUpFixpointIterator;
                }

                protected ASTParser createParser() {
                    ASTParser aSTParser = ASTParser.newParser((int)3);
                    aSTParser.setResolveBindings(true);
                    aSTParser.setProject(CleanUpFixpointIterator.access$0(this.this$1));
                    Map map = RefactoringASTParser.getCompilerOptions((IJavaElement)CleanUpFixpointIterator.access$0(this.this$1));
                    map.putAll(CleanUpFixpointIterator.access$1(this.this$1));
                    aSTParser.setCompilerOptions(map);
                    return aSTParser;
                }
            };
            try {
                object = arrayList.toArray(new ICompilationUnit[arrayList.size()]);
                ((CleanUpParser)object2).createASTs((ICompilationUnit[])object, new String[0], (CleanUpASTRequestor)((Object)object3), (IProgressMonitor)object4);
            }
            catch (FixCalculationException fixCalculationException) {
                throw fixCalculationException.getException();
            }
            object = arrayList2.iterator();
            while (object.hasNext()) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)object.next();
                ((CleanUpASTRequestor)((Object)object3)).acceptSource(iCompilationUnit);
            }
            this.fParseList = ((CleanUpASTRequestor)((Object)object3)).getUndoneElements();
            this.fIndex = ((CleanUpRefactoringProgressMonitor)((Object)object4)).getIndex();
        }

        public void dispose() {
            Iterator iterator = this.fWorkingCopies.values().iterator();
            while (iterator.hasNext()) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iterator.next();
                try {
                    iCompilationUnit.discardWorkingCopy();
                }
                catch (JavaModelException javaModelException) {
                    JavaPlugin.log(javaModelException);
                }
            }
        }

        private boolean requiresAST(ICompilationUnit iCompilationUnit, ICleanUp[] iCleanUpArray) throws CoreException {
            int n = 0;
            while (n < iCleanUpArray.length) {
                if (iCleanUpArray[n].requireAST(iCompilationUnit)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public Change[] getResult() {
            Change[] changeArray = new Change[this.fSolutions.size()];
            int n = 0;
            Iterator iterator = this.fSolutions.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                int n2;
                Map.Entry entry = iterator.next();
                List list = (List)entry.getValue();
                ICompilationUnit iCompilationUnit = (ICompilationUnit)entry.getKey();
                try {
                    n2 = CleanUpRefactoring.this.fLeaveFilesDirty || iCompilationUnit.getBuffer().hasUnsavedChanges() ? 4 : 2;
                }
                catch (JavaModelException javaModelException) {
                    n2 = 4;
                    JavaPlugin.log(javaModelException);
                }
                if (list.size() == 1) {
                    object = (CleanUpChange)((Object)list.get(0));
                    object.setSaveMode(n2);
                    changeArray[n] = object;
                } else {
                    object = new MultiStateCompilationUnitChange(CleanUpRefactoring.getChangeName(iCompilationUnit), iCompilationUnit);
                    int n3 = 0;
                    while (n3 < list.size()) {
                        object.addChange(this.createGroupFreeChange((CleanUpChange)((Object)list.get(n3))));
                        ++n3;
                    }
                    object.setSaveMode(n2);
                    changeArray[n] = object;
                }
                ++n;
            }
            return changeArray;
        }

        private TextChange createGroupFreeChange(CleanUpChange cleanUpChange) {
            CleanUpChange cleanUpChange2 = new CleanUpChange(cleanUpChange.getName(), cleanUpChange.getCompilationUnit());
            cleanUpChange2.setEdit(cleanUpChange.getEdit());
            cleanUpChange2.setSaveMode(cleanUpChange.getSaveMode());
            return cleanUpChange2;
        }

        private void applyChange(ICompilationUnit iCompilationUnit, List list) throws JavaModelException, CoreException {
            if (list.size() == 1) {
                CleanUpChange cleanUpChange = (CleanUpChange)((Object)list.get(list.size() - 1));
                iCompilationUnit.getBuffer().setContents(cleanUpChange.getPreviewContent(null));
            } else {
                MultiStateCompilationUnitChange multiStateCompilationUnitChange = new MultiStateCompilationUnitChange("", iCompilationUnit.getPrimary());
                int n = 0;
                while (n < list.size()) {
                    multiStateCompilationUnitChange.addChange((TextChange)((CleanUpChange)((Object)list.get(n))));
                    ++n;
                }
                iCompilationUnit.getBuffer().setContents(multiStateCompilationUnitChange.getPreviewContent(null));
            }
        }

        static /* synthetic */ IJavaProject access$0(CleanUpFixpointIterator cleanUpFixpointIterator) {
            return cleanUpFixpointIterator.fProject;
        }

        static /* synthetic */ Map access$1(CleanUpFixpointIterator cleanUpFixpointIterator) {
            return cleanUpFixpointIterator.fCleanUpOptions;
        }
    }

    private static abstract class CleanUpParser {
        private static final int MAX_AT_ONCE;

        static {
            long l = Runtime.getRuntime().maxMemory();
            int n = (int)Math.round((double)l / 6.7108864E7);
            switch (n) {
                case 0: {
                    MAX_AT_ONCE = 25;
                    break;
                }
                case 1: {
                    MAX_AT_ONCE = 100;
                    break;
                }
                case 2: {
                    MAX_AT_ONCE = 200;
                    break;
                }
                case 3: {
                    MAX_AT_ONCE = 300;
                    break;
                }
                case 4: {
                    MAX_AT_ONCE = 400;
                    break;
                }
                default: {
                    MAX_AT_ONCE = 500;
                }
            }
        }

        private CleanUpParser() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void createASTs(ICompilationUnit[] iCompilationUnitArray, String[] stringArray, CleanUpASTRequestor cleanUpASTRequestor, IProgressMonitor iProgressMonitor) {
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            try {
                iProgressMonitor.beginTask("", iCompilationUnitArray.length);
                List<ICompilationUnit> list = Arrays.asList(iCompilationUnitArray);
                int n = 0;
                int n2 = 0;
                while (n2 < iCompilationUnitArray.length) {
                    n = Math.min(n + MAX_AT_ONCE, iCompilationUnitArray.length);
                    List<ICompilationUnit> list2 = list.subList(n2, n);
                    this.createParser().createASTs(list2.toArray(new ICompilationUnit[list2.size()]), stringArray, (ASTRequestor)cleanUpASTRequestor, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, list2.size()));
                    n2 = n;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                Object var9_11 = null;
            }
            iProgressMonitor.done();
        }

        protected abstract ASTParser createParser();
    }

    private final class CleanUpRefactoringProgressMonitor
    extends SubProgressMonitor {
        private double fRealWork;
        private int fFlushCount = 0;
        private final int fSize;
        private final int fIndex;

        private CleanUpRefactoringProgressMonitor(IProgressMonitor iProgressMonitor, int n, int n2, int n3) {
            super(iProgressMonitor, n);
            this.fSize = n2;
            this.fIndex = n3;
        }

        public void internalWorked(double d) {
            this.fRealWork += d;
        }

        public void flush() {
            super.internalWorked(this.fRealWork);
            this.reset();
            ++this.fFlushCount;
        }

        public void reset() {
            this.fRealWork = 0.0;
        }

        public void done() {
        }

        public int getIndex() {
            return this.fIndex + this.fFlushCount;
        }

        public String getSubTaskMessage(ICompilationUnit iCompilationUnit) {
            String string = iCompilationUnit.getElementName();
            return Messages.format(FixMessages.CleanUpRefactoring_ProcessingCompilationUnit_message, new Object[]{new Integer(this.getIndex()), new Integer(this.fSize), string});
        }
    }

    private static class FixCalculationException
    extends RuntimeException {
        private static final long serialVersionUID = 3807273310144726165L;
        private final CoreException fException;

        public FixCalculationException(CoreException coreException) {
            this.fException = coreException;
        }

        public CoreException getException() {
            return this.fException;
        }
    }

    private static class ParseListElement {
        private final ICompilationUnit fUnit;
        private final ICleanUp[] fCleanUpsArray;

        public ParseListElement(ICompilationUnit iCompilationUnit) {
            this.fUnit = iCompilationUnit;
            this.fCleanUpsArray = new ICleanUp[0];
        }

        public ParseListElement(ICompilationUnit iCompilationUnit, ICleanUp[] iCleanUpArray) {
            this.fUnit = iCompilationUnit;
            this.fCleanUpsArray = iCleanUpArray;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fUnit;
        }

        public ICleanUp[] getCleanUps() {
            return this.fCleanUpsArray;
        }
    }
}

