/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedFix;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsConstraintCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsConstraintsSolver;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsTCModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsUpdate;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class Java50Fix
extends LinkedFix {
    private static final String OVERRIDE = "Override";
    private static final String DEPRECATED = "Deprecated";

    public static Java50Fix createAddOverrideAnnotationFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) {
        if (iProblemLocation.getProblemId() != 67109491) {
            return null;
        }
        return Java50Fix.createFix(compilationUnit, iProblemLocation, OVERRIDE, FixMessages.Java50Fix_AddOverride_description);
    }

    public static Java50Fix createAddDeprectatedAnnotation(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) {
        int n = iProblemLocation.getProblemId();
        if (n != 536871540 && n != 536871541 && n != 536871542) {
            return null;
        }
        return Java50Fix.createFix(compilationUnit, iProblemLocation, DEPRECATED, FixMessages.Java50Fix_AddDeprecated_description);
    }

    private static Java50Fix createFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation, String string, String string2) {
        ICompilationUnit iCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher(iCompilationUnit.getJavaProject())) {
            return null;
        }
        ASTNode aSTNode = iProblemLocation.getCoveringNode(compilationUnit);
        if (aSTNode == null) {
            return null;
        }
        ASTNode aSTNode2 = Java50Fix.getDeclaringNode(aSTNode);
        if (!(aSTNode2 instanceof BodyDeclaration)) {
            return null;
        }
        BodyDeclaration bodyDeclaration = (BodyDeclaration)aSTNode2;
        AnnotationRewriteOperation annotationRewriteOperation = new AnnotationRewriteOperation(bodyDeclaration, string);
        return new Java50Fix(string2, compilationUnit, new IFixRewriteOperation[]{annotationRewriteOperation});
    }

    public static Java50Fix createRawTypeReferenceFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) {
        ArrayList arrayList = new ArrayList();
        SimpleType simpleType = Java50Fix.createRawTypeReferenceOperations(compilationUnit, new IProblemLocation[]{iProblemLocation}, arrayList);
        if (arrayList.size() == 0) {
            return null;
        }
        return new Java50Fix(Messages.format(FixMessages.Java50Fix_AddTypeParameters_description, simpleType.getName()), compilationUnit, arrayList.toArray(new IFixRewriteOperation[arrayList.size()]));
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean bl, boolean bl2, boolean bl3) {
        ICompilationUnit iCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher(iCompilationUnit.getJavaProject())) {
            return null;
        }
        if (!(bl || bl2 || bl3)) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        IProblem[] iProblemArray = compilationUnit.getProblems();
        IProblemLocation[] iProblemLocationArray = new IProblemLocation[iProblemArray.length];
        int n = 0;
        while (n < iProblemArray.length) {
            iProblemLocationArray[n] = new ProblemLocation(iProblemArray[n]);
            ++n;
        }
        if (bl) {
            Java50Fix.createAddOverrideAnnotationOperations(compilationUnit, iProblemLocationArray, arrayList);
        }
        if (bl2) {
            Java50Fix.createAddDeprecatedAnnotationOperations(compilationUnit, iProblemLocationArray, arrayList);
        }
        if (bl3) {
            Java50Fix.createRawTypeReferenceOperations(compilationUnit, iProblemLocationArray, arrayList);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        IFixRewriteOperation[] iFixRewriteOperationArray = arrayList.toArray(new IFixRewriteOperation[arrayList.size()]);
        return new Java50Fix(FixMessages.Java50Fix_add_annotations_change_name, compilationUnit, iFixRewriteOperationArray);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray, boolean bl, boolean bl2, boolean bl3) {
        ICompilationUnit iCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher(iCompilationUnit.getJavaProject())) {
            return null;
        }
        if (!(bl || bl2 || bl3)) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        if (bl) {
            Java50Fix.createAddOverrideAnnotationOperations(compilationUnit, iProblemLocationArray, arrayList);
        }
        if (bl2) {
            Java50Fix.createAddDeprecatedAnnotationOperations(compilationUnit, iProblemLocationArray, arrayList);
        }
        if (bl3) {
            Java50Fix.createRawTypeReferenceOperations(compilationUnit, iProblemLocationArray, arrayList);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        IFixRewriteOperation[] iFixRewriteOperationArray = arrayList.toArray(new IFixRewriteOperation[arrayList.size()]);
        return new Java50Fix(FixMessages.Java50Fix_add_annotations_change_name, compilationUnit, iFixRewriteOperationArray);
    }

    private static void createAddDeprecatedAnnotationOperations(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray, List list) {
        int n = 0;
        while (n < iProblemLocationArray.length) {
            ASTNode aSTNode;
            IProblemLocation iProblemLocation;
            ASTNode aSTNode2;
            int n2 = iProblemLocationArray[n].getProblemId();
            if ((n2 == 536871540 || n2 == 536871541 || n2 == 536871542) && (aSTNode2 = (iProblemLocation = iProblemLocationArray[n]).getCoveringNode(compilationUnit)) != null && (aSTNode = Java50Fix.getDeclaringNode(aSTNode2)) instanceof BodyDeclaration) {
                BodyDeclaration bodyDeclaration = (BodyDeclaration)aSTNode;
                AnnotationRewriteOperation annotationRewriteOperation = new AnnotationRewriteOperation(bodyDeclaration, DEPRECATED);
                list.add(annotationRewriteOperation);
            }
            ++n;
        }
    }

    private static void createAddOverrideAnnotationOperations(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray, List list) {
        int n = 0;
        while (n < iProblemLocationArray.length) {
            ASTNode aSTNode;
            IProblemLocation iProblemLocation;
            ASTNode aSTNode2;
            if (iProblemLocationArray[n].getProblemId() == 67109491 && (aSTNode2 = (iProblemLocation = iProblemLocationArray[n]).getCoveringNode(compilationUnit)) != null && (aSTNode = Java50Fix.getDeclaringNode(aSTNode2)) instanceof BodyDeclaration) {
                BodyDeclaration bodyDeclaration = (BodyDeclaration)aSTNode;
                AnnotationRewriteOperation annotationRewriteOperation = new AnnotationRewriteOperation(bodyDeclaration, OVERRIDE);
                list.add(annotationRewriteOperation);
            }
            ++n;
        }
    }

    private static SimpleType createRawTypeReferenceOperations(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray, List list) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        int n = 0;
        while (n < iProblemLocationArray.length) {
            IProblemLocation iProblemLocation = iProblemLocationArray[n];
            int n2 = iProblemLocation.getProblemId();
            if (n2 == 16777748 || n2 == 16777788 || n2 == 16777747) {
                ASTNode aSTNode;
                ASTNode aSTNode2;
                ASTNode aSTNode3 = iProblemLocation.getCoveredNode(compilationUnit);
                if (aSTNode3 instanceof ClassInstanceCreation) {
                    aSTNode2 = (ASTNode)aSTNode3.getStructuralProperty((StructuralPropertyDescriptor)ClassInstanceCreation.TYPE_PROPERTY);
                    if (Java50Fix.isRawTypeReference(aSTNode2)) {
                        arrayList.add(aSTNode2);
                    }
                } else if (aSTNode3 instanceof SimpleName) {
                    aSTNode2 = aSTNode3.getParent();
                    if (Java50Fix.isRawTypeReference(aSTNode2)) {
                        arrayList.add(aSTNode2);
                    }
                } else if (aSTNode3 instanceof MethodInvocation && (aSTNode = Java50Fix.getRawReference((MethodInvocation)(aSTNode2 = (MethodInvocation)aSTNode3), compilationUnit)) != null) {
                    arrayList.add(aSTNode);
                }
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        SimpleType[] simpleTypeArray = arrayList.toArray(new SimpleType[arrayList.size()]);
        list.add(new AddTypeParametersOperation(simpleTypeArray));
        return simpleTypeArray[0];
    }

    private static ASTNode getRawReference(MethodInvocation methodInvocation, CompilationUnit compilationUnit) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        Name name = (Name)methodInvocation.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.NAME_PROPERTY);
        if (name instanceof SimpleName && (aSTNode2 = Java50Fix.getRawReference((SimpleName)name, compilationUnit)) != null) {
            return aSTNode2;
        }
        aSTNode2 = (Expression)methodInvocation.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY);
        if (aSTNode2 instanceof SimpleName) {
            ASTNode aSTNode3 = Java50Fix.getRawReference((SimpleName)aSTNode2, compilationUnit);
            if (aSTNode3 != null) {
                return aSTNode3;
            }
        } else if (aSTNode2 instanceof QualifiedName) {
            SimpleName simpleName;
            Name name2 = (Name)aSTNode2;
            while (name2 instanceof QualifiedName) {
                simpleName = (SimpleName)name2.getStructuralProperty((StructuralPropertyDescriptor)QualifiedName.NAME_PROPERTY);
                ASTNode aSTNode4 = Java50Fix.getRawReference(simpleName, compilationUnit);
                if (aSTNode4 != null) {
                    return aSTNode4;
                }
                name2 = (Name)name2.getStructuralProperty((StructuralPropertyDescriptor)QualifiedName.QUALIFIER_PROPERTY);
            }
            if (name2 instanceof SimpleName && (simpleName = Java50Fix.getRawReference((SimpleName)name2, compilationUnit)) != null) {
                return simpleName;
            }
        } else if (aSTNode2 instanceof MethodInvocation && (aSTNode = Java50Fix.getRawReference((MethodInvocation)aSTNode2, compilationUnit)) != null) {
            return aSTNode;
        }
        return null;
    }

    private static ASTNode getRawReference(SimpleName simpleName, CompilationUnit compilationUnit) {
        SimpleName[] simpleNameArray = LinkedNodeFinder.findByNode((ASTNode)compilationUnit, simpleName);
        int n = 0;
        while (n < simpleNameArray.length) {
            VariableDeclarationStatement variableDeclarationStatement;
            VariableDeclarationFragment variableDeclarationFragment;
            if (simpleNameArray[n].getParent() instanceof VariableDeclarationFragment) {
                ASTNode aSTNode;
                variableDeclarationFragment = (VariableDeclarationFragment)simpleNameArray[n].getParent();
                if (variableDeclarationFragment.getParent() instanceof VariableDeclarationStatement ? Java50Fix.isRawTypeReference(aSTNode = (ASTNode)(variableDeclarationStatement = (VariableDeclarationStatement)variableDeclarationFragment.getParent()).getStructuralProperty((StructuralPropertyDescriptor)VariableDeclarationStatement.TYPE_PROPERTY)) : variableDeclarationFragment.getParent() instanceof FieldDeclaration && Java50Fix.isRawTypeReference(aSTNode = (ASTNode)(variableDeclarationStatement = (FieldDeclaration)variableDeclarationFragment.getParent()).getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY))) {
                    return aSTNode;
                }
            } else if (simpleNameArray[n].getParent() instanceof SingleVariableDeclaration ? Java50Fix.isRawTypeReference((ASTNode)(variableDeclarationStatement = (ASTNode)(variableDeclarationFragment = (SingleVariableDeclaration)simpleNameArray[n].getParent()).getStructuralProperty((StructuralPropertyDescriptor)SingleVariableDeclaration.TYPE_PROPERTY))) : simpleNameArray[n].getParent() instanceof MethodDeclaration && Java50Fix.isRawTypeReference((ASTNode)(variableDeclarationStatement = (ASTNode)(variableDeclarationFragment = (MethodDeclaration)simpleNameArray[n].getParent()).getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY)))) {
                return variableDeclarationStatement;
            }
            ++n;
        }
        return null;
    }

    private static boolean isRawTypeReference(ASTNode aSTNode) {
        if (!(aSTNode instanceof SimpleType)) {
            return false;
        }
        ITypeBinding iTypeBinding = ((SimpleType)aSTNode).resolveBinding().getTypeDeclaration();
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeParameters();
        return iTypeBindingArray.length != 0;
    }

    private static ASTNode getDeclaringNode(ASTNode aSTNode) {
        ASTNode aSTNode2 = null;
        if (aSTNode instanceof MethodDeclaration) {
            aSTNode2 = aSTNode;
        } else if (aSTNode instanceof SimpleName) {
            StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
            if (structuralPropertyDescriptor == MethodDeclaration.NAME_PROPERTY || structuralPropertyDescriptor == TypeDeclaration.NAME_PROPERTY) {
                aSTNode2 = aSTNode.getParent();
            } else if (structuralPropertyDescriptor == VariableDeclarationFragment.NAME_PROPERTY) {
                aSTNode2 = aSTNode.getParent().getParent();
            }
        }
        return aSTNode2;
    }

    private Java50Fix(String string, CompilationUnit compilationUnit, IFixRewriteOperation[] iFixRewriteOperationArray) {
        super(string, compilationUnit, iFixRewriteOperationArray);
    }

    private static class AddTypeParametersOperation
    extends LinkedFix.AbstractLinkedFixRewriteOperation {
        private final SimpleType[] fTypes;

        public AddTypeParametersOperation(SimpleType[] simpleTypeArray) {
            this.fTypes = simpleTypeArray;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list, LinkedProposalModel linkedProposalModel) throws CoreException {
            InferTypeArgumentsTCModel inferTypeArgumentsTCModel = new InferTypeArgumentsTCModel();
            InferTypeArgumentsConstraintCreator inferTypeArgumentsConstraintCreator = new InferTypeArgumentsConstraintCreator(inferTypeArgumentsTCModel, true);
            CompilationUnit compilationUnit = compilationUnitRewrite.getRoot();
            compilationUnit.accept((ASTVisitor)inferTypeArgumentsConstraintCreator);
            InferTypeArgumentsConstraintsSolver inferTypeArgumentsConstraintsSolver = new InferTypeArgumentsConstraintsSolver(inferTypeArgumentsTCModel);
            InferTypeArgumentsUpdate inferTypeArgumentsUpdate = inferTypeArgumentsConstraintsSolver.solveConstraints((IProgressMonitor)new NullProgressMonitor());
            inferTypeArgumentsConstraintsSolver = null;
            ParameterizedType[] parameterizedTypeArray = InferTypeArgumentsRefactoring.inferArguments(this.fTypes, inferTypeArgumentsUpdate, inferTypeArgumentsTCModel, compilationUnitRewrite);
            if (parameterizedTypeArray.length == 0) {
                return;
            }
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            int n = 0;
            while (n < parameterizedTypeArray.length) {
                if (parameterizedTypeArray[n] instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = parameterizedTypeArray[0];
                    List list2 = (List)parameterizedType.getStructuralProperty((StructuralPropertyDescriptor)ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
                    int n2 = 0;
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        LinkedProposalPositionGroup linkedProposalPositionGroup = new LinkedProposalPositionGroup("G" + n + "_" + n2);
                        Type type = (Type)iterator.next();
                        if (!linkedProposalModel.hasLinkedPositions()) {
                            linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)type), true);
                        } else {
                            linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)type), false);
                        }
                        if (type.isWildcardType()) {
                            linkedProposalPositionGroup.addProposal("?", null, 10);
                            linkedProposalPositionGroup.addProposal("Object", null, 10);
                        }
                        linkedProposalModel.addPositionGroup(linkedProposalPositionGroup);
                        ++n2;
                    }
                }
                ++n;
            }
            linkedProposalModel.setEndPosition(aSTRewrite.track((ASTNode)parameterizedTypeArray[0]));
        }
    }

    private static class AnnotationRewriteOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final BodyDeclaration fBodyDeclaration;
        private final String fAnnotation;

        public AnnotationRewriteOperation(BodyDeclaration bodyDeclaration, String string) {
            this.fBodyDeclaration = bodyDeclaration;
            this.fAnnotation = string;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            AST aST = compilationUnitRewrite.getRoot().getAST();
            ListRewrite listRewrite = compilationUnitRewrite.getASTRewrite().getListRewrite((ASTNode)this.fBodyDeclaration, this.fBodyDeclaration.getModifiersProperty());
            MarkerAnnotation markerAnnotation = aST.newMarkerAnnotation();
            markerAnnotation.setTypeName((Name)aST.newSimpleName(this.fAnnotation));
            TextEditGroup textEditGroup = this.createTextEditGroup(Messages.format(FixMessages.Java50Fix_AddMissingAnnotation_description, this.fAnnotation));
            list.add(textEditGroup);
            listRewrite.insertFirst((ASTNode)markerAnnotation, textEditGroup);
        }
    }
}

