/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public class VariableDeclarationFix
extends AbstractFix {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static IFix createChangeModifierToFinalFix(CompilationUnit compilationUnit, ASTNode[] aSTNodeArray) {
        Object object;
        HashMap hashMap = new HashMap();
        WrittenNamesFinder writtenNamesFinder = new WrittenNamesFinder(hashMap);
        compilationUnit.accept((ASTVisitor)writtenNamesFinder);
        ArrayList arrayList = new ArrayList();
        VariableDeclarationFinder variableDeclarationFinder = new VariableDeclarationFinder(true, true, true, compilationUnit, arrayList, hashMap);
        if (aSTNodeArray.length == 1) {
            if (aSTNodeArray[0] instanceof SimpleName) {
                aSTNodeArray[0] = aSTNodeArray[0].getParent();
            }
            aSTNodeArray[0].accept((ASTVisitor)variableDeclarationFinder);
        } else {
            int n = 0;
            while (n < aSTNodeArray.length) {
                object = aSTNodeArray[n];
                object.accept((ASTVisitor)variableDeclarationFinder);
                ++n;
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        IFixRewriteOperation[] iFixRewriteOperationArray = arrayList.toArray(new IFixRewriteOperation[arrayList.size()]);
        object = iFixRewriteOperationArray.length == 1 ? FixMessages.VariableDeclarationFix_changeModifierOfUnknownToFinal_description : FixMessages.VariableDeclarationFix_ChangeMidifiersToFinalWherPossible_description;
        return new VariableDeclarationFix((String)object, compilationUnit, iFixRewriteOperationArray);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean bl, boolean bl2, boolean bl3) {
        if (!(bl || bl2 || bl3)) {
            return null;
        }
        HashMap hashMap = new HashMap();
        WrittenNamesFinder writtenNamesFinder = new WrittenNamesFinder(hashMap);
        compilationUnit.accept((ASTVisitor)writtenNamesFinder);
        ArrayList arrayList = new ArrayList();
        VariableDeclarationFinder variableDeclarationFinder = new VariableDeclarationFinder(bl, bl2, bl3, compilationUnit, arrayList, hashMap);
        compilationUnit.accept((ASTVisitor)variableDeclarationFinder);
        if (arrayList.isEmpty()) {
            return null;
        }
        return new VariableDeclarationFix(FixMessages.VariableDeclarationFix_add_final_change_name, compilationUnit, arrayList.toArray(new IFixRewriteOperation[arrayList.size()]));
    }

    private static ModifierChangeOperation createAddFinalOperation(SimpleName simpleName, CompilationUnit compilationUnit, ASTNode aSTNode) {
        if (aSTNode == null) {
            return null;
        }
        IBinding iBinding = simpleName.resolveBinding();
        if (!VariableDeclarationFix.canAddFinal(iBinding, simpleName, aSTNode)) {
            return null;
        }
        if (aSTNode instanceof SingleVariableDeclaration) {
            return new ModifierChangeOperation(aSTNode, new ArrayList(), 16, 64);
        }
        if (aSTNode instanceof VariableDeclarationExpression) {
            return new ModifierChangeOperation(aSTNode, new ArrayList(), 16, 64);
        }
        if (aSTNode instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)aSTNode;
            if ((aSTNode = aSTNode.getParent()) instanceof FieldDeclaration || aSTNode instanceof VariableDeclarationStatement) {
                ArrayList<VariableDeclarationFragment> arrayList = new ArrayList<VariableDeclarationFragment>();
                arrayList.add(variableDeclarationFragment);
                return new ModifierChangeOperation(aSTNode, arrayList, 16, 64);
            }
            if (aSTNode instanceof VariableDeclarationExpression) {
                return new ModifierChangeOperation(aSTNode, new ArrayList(), 16, 64);
            }
        }
        return null;
    }

    private static boolean canAddFinal(IBinding iBinding, SimpleName simpleName, ASTNode aSTNode) {
        MethodDeclaration methodDeclaration;
        ASTNode aSTNode2;
        ASTNode aSTNode3;
        if (!(iBinding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
        if (Modifier.isFinal((int)iVariableBinding.getModifiers())) {
            return false;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((aSTNode3 = ASTNodes.getParent(aSTNode, clazz)) != null && ((VariableDeclarationExpression)aSTNode3).fragments().size() > 1) {
            return false;
        }
        if (iVariableBinding.isField() && !Modifier.isPrivate((int)iVariableBinding.getModifiers())) {
            return false;
        }
        return !iVariableBinding.isParameter() || !((aSTNode2 = aSTNode.getParent()) instanceof MethodDeclaration) || (methodDeclaration = (MethodDeclaration)aSTNode2).getBody() != null;
    }

    protected VariableDeclarationFix(String string, CompilationUnit compilationUnit, IFixRewriteOperation[] iFixRewriteOperationArray) {
        super(string, compilationUnit, iFixRewriteOperationArray);
    }

    private static class ModifierChangeOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final ASTNode fDeclaration;
        private final List fToChange;
        private final int fIncludedModifiers;
        private final int fExcludedModifiers;

        public ModifierChangeOperation(ASTNode aSTNode, List list, int n, int n2) {
            this.fDeclaration = aSTNode;
            this.fToChange = list;
            this.fIncludedModifiers = n;
            this.fExcludedModifiers = n2;
        }

        public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list) throws CoreException {
            ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
            TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.VariableDeclarationFix_changeModifierOfUnknownToFinal_description);
            list.add(textEditGroup);
            if (this.fDeclaration instanceof VariableDeclarationStatement) {
                VariableDeclarationFragment[] variableDeclarationFragmentArray = this.fToChange.toArray(new VariableDeclarationFragment[this.fToChange.size()]);
                VariableDeclarationRewrite.rewriteModifiers((VariableDeclarationStatement)this.fDeclaration, variableDeclarationFragmentArray, this.fIncludedModifiers, this.fExcludedModifiers, aSTRewrite, textEditGroup);
            } else if (this.fDeclaration instanceof FieldDeclaration) {
                VariableDeclarationFragment[] variableDeclarationFragmentArray = this.fToChange.toArray(new VariableDeclarationFragment[this.fToChange.size()]);
                VariableDeclarationRewrite.rewriteModifiers((FieldDeclaration)this.fDeclaration, variableDeclarationFragmentArray, this.fIncludedModifiers, this.fExcludedModifiers, aSTRewrite, textEditGroup);
            } else if (this.fDeclaration instanceof SingleVariableDeclaration) {
                VariableDeclarationRewrite.rewriteModifiers((SingleVariableDeclaration)this.fDeclaration, this.fIncludedModifiers, this.fExcludedModifiers, aSTRewrite, textEditGroup);
            } else if (this.fDeclaration instanceof VariableDeclarationExpression) {
                VariableDeclarationRewrite.rewriteModifiers((VariableDeclarationExpression)this.fDeclaration, this.fIncludedModifiers, this.fExcludedModifiers, aSTRewrite, textEditGroup);
            }
        }
    }

    private static class VariableDeclarationFinder
    extends GenericVisitor {
        private final CompilationUnit fCompilationUnit;
        private final List fResult;
        private final HashMap fWrittenVariables;
        private final boolean fAddFinalFields;
        private final boolean fAddFinalParameters;
        private final boolean fAddFinalLocals;

        public VariableDeclarationFinder(boolean bl, boolean bl2, boolean bl3, CompilationUnit compilationUnit, List list, HashMap hashMap) {
            this.fAddFinalFields = bl;
            this.fAddFinalParameters = bl2;
            this.fAddFinalLocals = bl3;
            this.fCompilationUnit = compilationUnit;
            this.fResult = list;
            this.fWrittenVariables = hashMap;
        }

        public boolean visit(FieldDeclaration fieldDeclaration) {
            if (this.fAddFinalFields) {
                return this.handleFragments(fieldDeclaration.fragments(), (ASTNode)fieldDeclaration);
            }
            return false;
        }

        public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
            if (this.fAddFinalLocals) {
                return this.handleFragments(variableDeclarationStatement.fragments(), (ASTNode)variableDeclarationStatement);
            }
            return false;
        }

        public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
            if (this.fAddFinalLocals && variableDeclarationExpression.fragments().size() == 1) {
                SimpleName simpleName = ((VariableDeclarationFragment)variableDeclarationExpression.fragments().get(0)).getName();
                IBinding iBinding = simpleName.resolveBinding();
                if (iBinding == null) {
                    return false;
                }
                if (this.fWrittenVariables.containsKey(iBinding)) {
                    return false;
                }
                ModifierChangeOperation modifierChangeOperation = VariableDeclarationFix.createAddFinalOperation(simpleName, this.fCompilationUnit, (ASTNode)variableDeclarationExpression);
                if (modifierChangeOperation == null) {
                    return false;
                }
                this.fResult.add(modifierChangeOperation);
                return false;
            }
            return false;
        }

        private boolean handleFragments(List list, ASTNode aSTNode) {
            ArrayList<VariableDeclarationFragment> arrayList = new ArrayList<VariableDeclarationFragment>();
            Object object = list.iterator();
            while (object.hasNext()) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)object.next();
                SimpleName simpleName = variableDeclarationFragment.getName();
                IBinding iBinding = simpleName.resolveBinding();
                if (!VariableDeclarationFix.canAddFinal(iBinding, simpleName, aSTNode)) continue;
                IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
                if (iVariableBinding.isField()) {
                    if (!this.fieldCanBeFinal(variableDeclarationFragment, iVariableBinding)) continue;
                    arrayList.add(variableDeclarationFragment);
                    continue;
                }
                if (this.fWrittenVariables.containsKey(iBinding)) continue;
                arrayList.add(variableDeclarationFragment);
            }
            if (arrayList.size() == 0) {
                return false;
            }
            object = new ModifierChangeOperation(aSTNode, arrayList, 16, 64);
            this.fResult.add(object);
            return false;
        }

        private boolean fieldCanBeFinal(VariableDeclarationFragment variableDeclarationFragment, IVariableBinding iVariableBinding) {
            MethodDeclaration[] methodDeclarationArray;
            SimpleName simpleName;
            if (Modifier.isStatic((int)((FieldDeclaration)variableDeclarationFragment.getParent()).getModifiers())) {
                return false;
            }
            if (!this.fWrittenVariables.containsKey(iVariableBinding)) {
                return variableDeclarationFragment.getInitializer() != null;
            }
            if (variableDeclarationFragment.getInitializer() != null) {
                return false;
            }
            ITypeBinding iTypeBinding = iVariableBinding.getDeclaringClass();
            if (iTypeBinding == null) {
                return false;
            }
            ArrayList arrayList = (ArrayList)this.fWrittenVariables.get(iVariableBinding);
            if (!this.isWrittenInTypeConstructors(iVariableBinding, arrayList, iTypeBinding)) {
                return false;
            }
            HashSet<IMethodBinding> hashSet = new HashSet<IMethodBinding>();
            ArrayList<MethodDeclaration[]> arrayList2 = new ArrayList<MethodDeclaration[]>();
            int n = 0;
            while (n < arrayList.size()) {
                simpleName = (SimpleName)arrayList.get(n);
                methodDeclarationArray = this.getWritingConstructor(simpleName);
                if (arrayList2.contains(methodDeclarationArray)) {
                    return false;
                }
                arrayList2.add(methodDeclarationArray);
                IMethodBinding iMethodBinding = methodDeclarationArray.resolveBinding();
                if (iMethodBinding == null) {
                    return false;
                }
                hashSet.add(iMethodBinding);
                ++n;
            }
            n = 0;
            while (n < arrayList2.size()) {
                simpleName = (MethodDeclaration)arrayList2.get(n);
                if (this.callsWrittingConstructor((MethodDeclaration)simpleName, hashSet)) {
                    return false;
                }
                ++n;
            }
            MethodDeclaration methodDeclaration = (MethodDeclaration)arrayList2.get(0);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.TypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((simpleName = (TypeDeclaration)ASTNodes.getParent((ASTNode)methodDeclaration, clazz)) == null) {
                return false;
            }
            methodDeclarationArray = simpleName.getMethods();
            int n2 = 0;
            while (n2 < methodDeclarationArray.length) {
                if (methodDeclarationArray[n2].isConstructor()) {
                    IMethodBinding iMethodBinding = methodDeclarationArray[n2].resolveBinding();
                    if (iMethodBinding == null) {
                        return false;
                    }
                    if (!hashSet.contains(iMethodBinding) && !this.callsWrittingConstructor(methodDeclarationArray[n2], hashSet)) {
                        return false;
                    }
                }
                ++n2;
            }
            return true;
        }

        private boolean callsWrittingConstructor(MethodDeclaration methodDeclaration, HashSet hashSet) {
            Block block = methodDeclaration.getBody();
            if (block == null) {
                return false;
            }
            List list = block.statements();
            if (list.size() == 0) {
                return false;
            }
            Statement statement = (Statement)list.get(0);
            if (!(statement instanceof ConstructorInvocation)) {
                return false;
            }
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)statement;
            IMethodBinding iMethodBinding = constructorInvocation.resolveConstructorBinding();
            if (iMethodBinding == null) {
                return false;
            }
            if (hashSet.contains(iMethodBinding)) {
                return true;
            }
            ASTNode aSTNode = ASTNodes.findDeclaration((IBinding)iMethodBinding, methodDeclaration.getParent());
            if (!(aSTNode instanceof MethodDeclaration)) {
                return false;
            }
            return this.callsWrittingConstructor((MethodDeclaration)aSTNode, hashSet);
        }

        private boolean isWrittenInTypeConstructors(IVariableBinding iVariableBinding, ArrayList arrayList, ITypeBinding iTypeBinding) {
            int n = 0;
            while (n < arrayList.size()) {
                SimpleName simpleName = (SimpleName)arrayList.get(n);
                MethodDeclaration methodDeclaration = this.getWritingConstructor(simpleName);
                if (methodDeclaration == null) {
                    return false;
                }
                if (!methodDeclaration.isConstructor()) {
                    return false;
                }
                IMethodBinding iMethodBinding = methodDeclaration.resolveBinding();
                if (iMethodBinding == null) {
                    return false;
                }
                ITypeBinding iTypeBinding2 = iMethodBinding.getDeclaringClass();
                if (!iTypeBinding.equals((Object)iTypeBinding2)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private MethodDeclaration getWritingConstructor(SimpleName simpleName) {
            Assignment assignment;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.Assignment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((assignment = (Assignment)ASTNodes.getParent((ASTNode)simpleName, clazz)) == null) {
                return null;
            }
            ASTNode aSTNode = assignment.getParent();
            if (!(aSTNode instanceof ExpressionStatement)) {
                return null;
            }
            ASTNode aSTNode2 = aSTNode.getParent();
            if (!(aSTNode2 instanceof Block)) {
                return null;
            }
            ASTNode aSTNode3 = aSTNode2.getParent();
            if (!(aSTNode3 instanceof MethodDeclaration)) {
                return null;
            }
            return (MethodDeclaration)aSTNode3;
        }

        public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
            SimpleName simpleName = variableDeclarationFragment.getName();
            IBinding iBinding = simpleName.resolveBinding();
            if (iBinding == null) {
                return false;
            }
            if (this.fWrittenVariables.containsKey(iBinding)) {
                return false;
            }
            ModifierChangeOperation modifierChangeOperation = VariableDeclarationFix.createAddFinalOperation(simpleName, this.fCompilationUnit, (ASTNode)variableDeclarationFragment);
            if (modifierChangeOperation == null) {
                return false;
            }
            this.fResult.add(modifierChangeOperation);
            return false;
        }

        public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
            SimpleName simpleName = singleVariableDeclaration.getName();
            IBinding iBinding = simpleName.resolveBinding();
            if (!(iBinding instanceof IVariableBinding)) {
                return false;
            }
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            if (this.fWrittenVariables.containsKey(iVariableBinding)) {
                return false;
            }
            if (this.fAddFinalParameters && this.fAddFinalLocals) {
                ModifierChangeOperation modifierChangeOperation = VariableDeclarationFix.createAddFinalOperation(simpleName, this.fCompilationUnit, (ASTNode)singleVariableDeclaration);
                if (modifierChangeOperation == null) {
                    return false;
                }
                this.fResult.add(modifierChangeOperation);
                return false;
            }
            if (this.fAddFinalParameters) {
                if (!iVariableBinding.isParameter()) {
                    return false;
                }
                ModifierChangeOperation modifierChangeOperation = VariableDeclarationFix.createAddFinalOperation(simpleName, this.fCompilationUnit, (ASTNode)singleVariableDeclaration);
                if (modifierChangeOperation == null) {
                    return false;
                }
                this.fResult.add(modifierChangeOperation);
                return false;
            }
            if (this.fAddFinalLocals) {
                if (iVariableBinding.isParameter()) {
                    return false;
                }
                ModifierChangeOperation modifierChangeOperation = VariableDeclarationFix.createAddFinalOperation(simpleName, this.fCompilationUnit, (ASTNode)singleVariableDeclaration);
                if (modifierChangeOperation == null) {
                    return false;
                }
                this.fResult.add(modifierChangeOperation);
                return false;
            }
            return false;
        }
    }

    private static class WrittenNamesFinder
    extends GenericVisitor {
        private final HashMap fResult;

        public WrittenNamesFinder(HashMap hashMap) {
            this.fResult = hashMap;
        }

        public boolean visit(SimpleName simpleName) {
            if (simpleName.getParent() instanceof VariableDeclarationFragment) {
                return super.visit(simpleName);
            }
            if (simpleName.getParent() instanceof SingleVariableDeclaration) {
                return super.visit(simpleName);
            }
            IBinding iBinding = simpleName.resolveBinding();
            if (!(iBinding instanceof IVariableBinding)) {
                return super.visit(simpleName);
            }
            iBinding = ((IVariableBinding)iBinding).getVariableDeclaration();
            if (ASTResolving.isWriteAccess((Name)simpleName)) {
                List<Object> list = this.fResult.containsKey(iBinding) ? (List)this.fResult.get(iBinding) : new ArrayList<SimpleName>();
                list.add(simpleName);
                this.fResult.put(iBinding, list);
            }
            return super.visit(simpleName);
        }
    }
}

