/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringActions;

public final class RefactoringAvailabilityTester {
    public static IType getDeclaringType(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        if (!(iJavaElement instanceof IType)) {
            iJavaElement = iJavaElement.getAncestor(7);
        }
        return (IType)iJavaElement;
    }

    public static IJavaElement[] getJavaElements(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IJavaElement) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    public static IMember[] getPullUpMembers(IType iType) throws JavaModelException {
        ArrayList<IField> arrayList = new ArrayList<IField>(3);
        if (iType.exists()) {
            IField[] iFieldArray = iType.getFields();
            int n = 0;
            while (n < iFieldArray.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)iFieldArray[n])) {
                    arrayList.add(iFieldArray[n]);
                }
                ++n;
            }
            iFieldArray = iType.getMethods();
            n = 0;
            while (n < iFieldArray.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)iFieldArray[n])) {
                    arrayList.add(iFieldArray[n]);
                }
                ++n;
            }
            iFieldArray = iType.getTypes();
            n = 0;
            while (n < iFieldArray.length) {
                if (RefactoringAvailabilityTester.isPullUpAvailable((IMember)iFieldArray[n])) {
                    arrayList.add(iFieldArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new IMember[arrayList.size()]);
    }

    public static IMember[] getPushDownMembers(IType iType) throws JavaModelException {
        ArrayList<IField> arrayList = new ArrayList<IField>(3);
        if (iType.exists()) {
            IField[] iFieldArray = iType.getFields();
            int n = 0;
            while (n < iFieldArray.length) {
                if (RefactoringAvailabilityTester.isPushDownAvailable((IMember)iFieldArray[n])) {
                    arrayList.add(iFieldArray[n]);
                }
                ++n;
            }
            iFieldArray = iType.getMethods();
            n = 0;
            while (n < iFieldArray.length) {
                if (RefactoringAvailabilityTester.isPushDownAvailable((IMember)iFieldArray[n])) {
                    arrayList.add(iFieldArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new IMember[arrayList.size()]);
    }

    public static IResource[] getResources(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IResource) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    public static IType getSingleSelectedType(IStructuredSelection iStructuredSelection) throws JavaModelException {
        ICompilationUnit iCompilationUnit;
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IType) {
            return (IType)object;
        }
        if (object instanceof ICompilationUnit && (iCompilationUnit = (ICompilationUnit)object).exists()) {
            return JavaElementUtil.getMainType(iCompilationUnit);
        }
        return null;
    }

    public static IType getTopLevelType(IMember[] iMemberArray) {
        if (iMemberArray != null && iMemberArray.length == 1 && Checks.isTopLevelType(iMemberArray[0])) {
            return (IType)iMemberArray[0];
        }
        return null;
    }

    public static boolean isChangeSignatureAvailable(IMethod iMethod) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iMethod) && (iMethod.getDeclaringType() == null || !Flags.isAnnotation((int)iMethod.getDeclaringType().getFlags()));
    }

    public static boolean isChangeSignatureAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof IMethod) {
            IMethod iMethod = (IMethod)iStructuredSelection.getFirstElement();
            return RefactoringAvailabilityTester.isChangeSignatureAvailable(iMethod);
        }
        return false;
    }

    public static boolean isChangeSignatureAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaTextSelection.resolveElementAtOffset();
        if (iJavaElementArray.length == 1 && iJavaElementArray[0] instanceof IMethod) {
            return RefactoringAvailabilityTester.isChangeSignatureAvailable((IMethod)iJavaElementArray[0]);
        }
        IJavaElement iJavaElement = javaTextSelection.resolveEnclosingElement();
        return iJavaElement instanceof IMethod && RefactoringAvailabilityTester.isChangeSignatureAvailable((IMethod)iJavaElement);
    }

    public static boolean isCommonDeclaringType(IMember[] iMemberArray) {
        if (iMemberArray.length == 0) {
            return false;
        }
        IType iType = iMemberArray[0].getDeclaringType();
        if (iType == null) {
            return false;
        }
        int n = 0;
        while (n < iMemberArray.length) {
            if (!iType.equals(iMemberArray[n].getDeclaringType())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isConvertAnonymousAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof IType) {
            return RefactoringAvailabilityTester.isConvertAnonymousAvailable((IType)iStructuredSelection.getFirstElement());
        }
        return false;
    }

    public static boolean isConvertAnonymousAvailable(IType iType) throws JavaModelException {
        if (Checks.isAvailable((IJavaElement)iType)) {
            IJavaElement iJavaElement = iType.getParent();
            if (iJavaElement instanceof IField && JdtFlags.isEnum((IMember)iJavaElement)) {
                return false;
            }
            return iType.isAnonymous();
        }
        return false;
    }

    public static boolean isConvertAnonymousAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IType iType = RefactoringActions.getEnclosingType(javaTextSelection);
        if (iType != null) {
            return RefactoringAvailabilityTester.isConvertAnonymousAvailable(iType);
        }
        return false;
    }

    public static boolean isCopyAvailable(IResource[] iResourceArray, IJavaElement[] iJavaElementArray) throws JavaModelException {
        return ReorgPolicyFactory.createCopyPolicy(iResourceArray, iJavaElementArray).canEnable();
    }

    public static boolean isDelegateCreationAvailable(IField iField) throws JavaModelException {
        return iField.exists() && Flags.isStatic((int)iField.getFlags()) && Flags.isFinal((int)iField.getFlags());
    }

    public static boolean isDeleteAvailable(IJavaElement iJavaElement) throws JavaModelException {
        IPackageFragmentRoot iPackageFragmentRoot;
        if (!iJavaElement.exists()) {
            return false;
        }
        if (iJavaElement instanceof IJavaModel || iJavaElement instanceof IJavaProject) {
            return false;
        }
        if (iJavaElement.getParent() != null && iJavaElement.getParent().isReadOnly()) {
            return false;
        }
        if (iJavaElement instanceof IPackageFragmentRoot && ((iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement).isExternal() || Checks.isClasspathDelete(iPackageFragmentRoot))) {
            return false;
        }
        if (iJavaElement.getResource() == null && !RefactoringAvailabilityTester.isWorkingCopyElement(iJavaElement)) {
            return false;
        }
        return !(iJavaElement instanceof IMember) || !((IMember)iJavaElement).isBinary();
    }

    public static boolean isDeleteAvailable(IResource iResource) {
        if (!iResource.exists() || iResource.isPhantom()) {
            return false;
        }
        return iResource.getType() != 8 && iResource.getType() != 4;
    }

    public static boolean isDeleteAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (!iStructuredSelection.isEmpty()) {
            return RefactoringAvailabilityTester.isDeleteAvailable(iStructuredSelection.toArray());
        }
        return false;
    }

    public static boolean isDeleteAvailable(Object[] objectArray) throws JavaModelException {
        if (objectArray.length != 0) {
            IJavaElement[] iJavaElementArray;
            IResource[] iResourceArray = RefactoringAvailabilityTester.getResources(objectArray);
            if (objectArray.length != iResourceArray.length + (iJavaElementArray = RefactoringAvailabilityTester.getJavaElements(objectArray)).length) {
                return false;
            }
            int n = 0;
            while (n < iResourceArray.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(iResourceArray[n])) {
                    return false;
                }
                ++n;
            }
            n = 0;
            while (n < iJavaElementArray.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(iJavaElementArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static boolean isExternalizeStringsAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            ICompilationUnit iCompilationUnit;
            IPackageFragmentRoot iPackageFragmentRoot;
            IJavaElement iJavaElement;
            Object e = iterator.next();
            if (!(e instanceof IJavaElement) || !(iJavaElement = (IJavaElement)e).exists() || iJavaElement.isReadOnly()) continue;
            int n = iJavaElement.getElementType();
            if (n == 4) {
                return true;
            }
            if (n == 3) {
                iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                if (iPackageFragmentRoot.isExternal() || ReorgUtils.isClassFolder((IJavaElement)iPackageFragmentRoot)) continue;
                return true;
            }
            if (n == 2) {
                return true;
            }
            if (!(n == 5 ? (iPackageFragmentRoot = (ICompilationUnit)iJavaElement).exists() : n == 7 && (iCompilationUnit = (iPackageFragmentRoot = (IType)e).getCompilationUnit()) != null && iCompilationUnit.exists())) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtractConstantAvailable(JavaTextSelection javaTextSelection) {
        return (javaTextSelection.resolveInClassInitializer() || javaTextSelection.resolveInMethodBody() || javaTextSelection.resolveInVariableInitializer()) && Checks.isExtractableExpression(javaTextSelection.resolveSelectedNodes(), javaTextSelection.resolveCoveringNode());
    }

    public static boolean isExtractInterfaceAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IType) {
                return RefactoringAvailabilityTester.isExtractInterfaceAvailable((IType)object);
            }
            if (object instanceof ICompilationUnit) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)object;
                return iCompilationUnit.exists() && !iCompilationUnit.isReadOnly();
            }
        }
        return false;
    }

    public static boolean isExtractInterfaceAvailable(IType iType) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iType) && !iType.isBinary() && !iType.isReadOnly() && !iType.isAnnotation() && !iType.isAnonymous();
    }

    public static boolean isExtractInterfaceAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        return RefactoringAvailabilityTester.isExtractInterfaceAvailable(RefactoringActions.getEnclosingOrPrimaryType(javaTextSelection));
    }

    public static boolean isExtractMethodAvailable(ASTNode[] aSTNodeArray) {
        if (aSTNodeArray != null && aSTNodeArray.length != 0) {
            if (aSTNodeArray.length == 1) {
                return aSTNodeArray[0] instanceof Statement || Checks.isExtractableExpression(aSTNodeArray[0]);
            }
            int n = 0;
            while (n < aSTNodeArray.length) {
                if (!(aSTNodeArray[n] instanceof Statement)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static boolean isExtractMethodAvailable(JavaTextSelection javaTextSelection) {
        return (javaTextSelection.resolveInMethodBody() || javaTextSelection.resolveInClassInitializer()) && RefactoringAvailabilityTester.isExtractMethodAvailable(javaTextSelection.resolveSelectedNodes());
    }

    public static boolean isExtractSupertypeAvailable(IMember iMember) throws JavaModelException {
        if (!iMember.exists()) {
            return false;
        }
        int n = iMember.getElementType();
        if (n != 9 && n != 8 && n != 7) {
            return false;
        }
        if (JdtFlags.isEnum(iMember) && n != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)iMember)) {
            return false;
        }
        if (iMember instanceof IType && !JdtFlags.isStatic(iMember) && !JdtFlags.isEnum(iMember) && !JdtFlags.isAnnotation(iMember)) {
            return false;
        }
        if (iMember instanceof IMethod) {
            IMethod iMethod = (IMethod)iMember;
            if (iMethod.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)iMethod)) {
                return false;
            }
            IType iType = iMethod.getDeclaringType();
            if (iType != null && iType.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isExtractSupertypeAvailable(IMember[] iMemberArray) throws JavaModelException {
        if (iMemberArray != null && iMemberArray.length != 0) {
            IType iType = RefactoringAvailabilityTester.getTopLevelType(iMemberArray);
            if (iType != null && !iType.isInterface()) {
                return true;
            }
            int n = 0;
            while (n < iMemberArray.length) {
                if (!RefactoringAvailabilityTester.isExtractSupertypeAvailable(iMemberArray[n])) {
                    return false;
                }
                ++n;
            }
            return RefactoringAvailabilityTester.isCommonDeclaringType(iMemberArray);
        }
        return false;
    }

    public static boolean isExtractSupertypeAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (!iStructuredSelection.isEmpty()) {
            Object object;
            if (iStructuredSelection.size() == 1) {
                if (iStructuredSelection.getFirstElement() instanceof ICompilationUnit) {
                    return true;
                }
                object = RefactoringAvailabilityTester.getSingleSelectedType(iStructuredSelection);
                if (object != null) {
                    return Checks.isAvailable((IJavaElement)object) && RefactoringAvailabilityTester.isExtractSupertypeAvailable((IMember[])new IType[]{object});
                }
            }
            object = iStructuredSelection.iterator();
            while (object.hasNext()) {
                if (object.next() instanceof IMember) continue;
                return false;
            }
            object = new HashSet();
            object.addAll(Arrays.asList(iStructuredSelection.toArray()));
            return RefactoringAvailabilityTester.isExtractSupertypeAvailable(object.toArray(new IMember[object.size()]));
        }
        return false;
    }

    public static boolean isExtractSupertypeAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = javaTextSelection.resolveEnclosingElement();
        if (!(iJavaElement instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isExtractSupertypeAvailable(new IMember[]{(IMember)iJavaElement});
    }

    public static boolean isExtractTempAvailable(JavaTextSelection javaTextSelection) {
        ASTNode[] aSTNodeArray = javaTextSelection.resolveSelectedNodes();
        return (javaTextSelection.resolveInMethodBody() || javaTextSelection.resolveInClassInitializer()) && (Checks.isExtractableExpression(aSTNodeArray, javaTextSelection.resolveCoveringNode()) || aSTNodeArray != null && aSTNodeArray.length == 1 && aSTNodeArray[0] instanceof ExpressionStatement);
    }

    public static boolean isGeneralizeTypeAvailable(IJavaElement iJavaElement) throws JavaModelException {
        if (iJavaElement != null && iJavaElement.exists()) {
            String string = null;
            if (iJavaElement instanceof IMethod) {
                string = ((IMethod)iJavaElement).getReturnType();
            } else if (iJavaElement instanceof IField) {
                IField iField = (IField)iJavaElement;
                if (JdtFlags.isEnum((IMember)iField)) {
                    return false;
                }
                string = iField.getTypeSignature();
            } else {
                if (iJavaElement instanceof ILocalVariable) {
                    return true;
                }
                if (iJavaElement instanceof IType) {
                    IType iType = (IType)iJavaElement;
                    return !JdtFlags.isEnum((IMember)iType);
                }
            }
            return string != null && PrimitiveType.toCode((String)Signature.toString((String)string)) == null;
        }
        return false;
    }

    public static boolean isGeneralizeTypeAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IMethod) {
                IMethod iMethod = (IMethod)object;
                if (!iMethod.exists()) {
                    return false;
                }
                String string = iMethod.getReturnType();
                if (PrimitiveType.toCode((String)Signature.toString((String)string)) == null) {
                    return Checks.isAvailable((IJavaElement)iMethod);
                }
            } else if (object instanceof IField) {
                IField iField = (IField)object;
                if (!iField.exists()) {
                    return false;
                }
                if (!JdtFlags.isEnum((IMember)iField)) {
                    return Checks.isAvailable((IJavaElement)iField);
                }
            }
        }
        return false;
    }

    public static boolean isGeneralizeTypeAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaTextSelection.resolveElementAtOffset();
        if (iJavaElementArray.length != 1) {
            return false;
        }
        return RefactoringAvailabilityTester.isGeneralizeTypeAvailable(iJavaElementArray[0]);
    }

    public static boolean isInferTypeArgumentsAvailable(IJavaElement iJavaElement) throws JavaModelException {
        if (!Checks.isAvailable(iJavaElement)) {
            return false;
        }
        if (iJavaElement instanceof IJavaProject) {
            IJavaProject iJavaProject = (IJavaProject)iJavaElement;
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            int n = 0;
            while (n < iClasspathEntryArray.length) {
                if (iClasspathEntryArray[n].getEntryKind() == 3) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (iJavaElement instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)iJavaElement).getKind() == 1;
        }
        if (iJavaElement instanceof IPackageFragment) {
            return ((IPackageFragment)iJavaElement).getKind() == 1;
        }
        if (iJavaElement instanceof ICompilationUnit) {
            return true;
        }
        return iJavaElement.getAncestor(5) != null;
    }

    public static boolean isInferTypeArgumentsAvailable(IJavaElement[] iJavaElementArray) throws JavaModelException {
        if (iJavaElementArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (!RefactoringAvailabilityTester.isInferTypeArgumentsAvailable(iJavaElementArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isInferTypeArgumentsAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.isEmpty()) {
            return false;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof IJavaElement)) {
                return false;
            }
            if (e instanceof ICompilationUnit) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)e;
                return iCompilationUnit.exists() && !iCompilationUnit.isReadOnly();
            }
            if (RefactoringAvailabilityTester.isInferTypeArgumentsAvailable((IJavaElement)e)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInlineConstantAvailable(IField iField) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iField) && JdtFlags.isStatic((IMember)iField) && JdtFlags.isFinal((IMember)iField) && !JdtFlags.isEnum((IMember)iField);
    }

    public static boolean isInlineConstantAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() != 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        return object instanceof IField && RefactoringAvailabilityTester.isInlineConstantAvailable((IField)object);
    }

    public static boolean isInlineConstantAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaTextSelection.resolveElementAtOffset();
        if (iJavaElementArray.length != 1) {
            return false;
        }
        return iJavaElementArray[0] instanceof IField && RefactoringAvailabilityTester.isInlineConstantAvailable((IField)iJavaElementArray[0]);
    }

    public static boolean isInlineMethodAvailable(IMethod iMethod) throws JavaModelException {
        if (iMethod == null) {
            return false;
        }
        if (!iMethod.exists()) {
            return false;
        }
        if (!iMethod.isStructureKnown()) {
            return false;
        }
        if (!iMethod.isBinary()) {
            return true;
        }
        if (iMethod.isConstructor()) {
            return false;
        }
        return SourceRange.isAvailable(iMethod.getNameRange());
    }

    public static boolean isInlineMethodAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() != 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        return object instanceof IMethod && RefactoringAvailabilityTester.isInlineMethodAvailable((IMethod)object);
    }

    public static boolean isInlineMethodAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaTextSelection.resolveElementAtOffset();
        if (iJavaElementArray.length != 1) {
            return false;
        }
        IJavaElement iJavaElement = iJavaElementArray[0];
        if (!(iJavaElement instanceof IMethod)) {
            return false;
        }
        IMethod iMethod = (IMethod)iJavaElement;
        if (!RefactoringAvailabilityTester.isInlineMethodAvailable(iMethod)) {
            return false;
        }
        IJavaElement iJavaElement2 = javaTextSelection.resolveEnclosingElement();
        if (iJavaElement2 == null || iJavaElement2.getAncestor(6) == null) {
            return true;
        }
        if (!(iJavaElement2 instanceof IMethod)) {
            return false;
        }
        IMethod iMethod2 = (IMethod)iJavaElement2;
        if (iMethod2.isConstructor()) {
            return false;
        }
        int n = iMethod2.getNameRange().getOffset();
        int n2 = iMethod2.getNameRange().getLength();
        return n <= javaTextSelection.getOffset() && javaTextSelection.getOffset() + javaTextSelection.getLength() <= n + n2;
    }

    public static boolean isInlineTempAvailable(ILocalVariable iLocalVariable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iLocalVariable);
    }

    public static boolean isInlineTempAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaTextSelection.resolveElementAtOffset();
        if (iJavaElementArray.length != 1) {
            return false;
        }
        return iJavaElementArray[0] instanceof ILocalVariable && RefactoringAvailabilityTester.isInlineTempAvailable((ILocalVariable)iJavaElementArray[0]);
    }

    public static boolean isIntroduceFactoryAvailable(IMethod iMethod) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iMethod) && iMethod.isConstructor();
    }

    public static boolean isIntroduceFactoryAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof IMethod) {
            return RefactoringAvailabilityTester.isIntroduceFactoryAvailable((IMethod)iStructuredSelection.getFirstElement());
        }
        return false;
    }

    public static boolean isIntroduceFactoryAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaTextSelection.resolveElementAtOffset();
        if (iJavaElementArray.length == 1 && iJavaElementArray[0] instanceof IMethod) {
            return RefactoringAvailabilityTester.isIntroduceFactoryAvailable((IMethod)iJavaElementArray[0]);
        }
        if (!Checks.isAvailable(javaTextSelection.resolveEnclosingElement())) {
            return false;
        }
        ASTNode aSTNode = javaTextSelection.resolveCoveringNode();
        if (aSTNode == null) {
            ASTNode[] aSTNodeArray = javaTextSelection.resolveSelectedNodes();
            if (aSTNodeArray != null && aSTNodeArray.length == 1) {
                aSTNode = aSTNodeArray[0];
                if (aSTNode == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (aSTNode.getNodeType() == 14) {
            return true;
        }
        return (aSTNode = ASTNodes.getNormalizedNode(aSTNode)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY;
    }

    public static boolean isIntroduceIndirectionAvailable(IMethod iMethod) throws JavaModelException {
        if (iMethod == null) {
            return false;
        }
        if (!iMethod.exists()) {
            return false;
        }
        if (!iMethod.isStructureKnown()) {
            return false;
        }
        if (iMethod.isConstructor()) {
            return false;
        }
        return iMethod.getDeclaringType() == null || !iMethod.getDeclaringType().isAnnotation();
    }

    public static boolean isIntroduceIndirectionAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() != 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        return object instanceof IMethod && RefactoringAvailabilityTester.isIntroduceIndirectionAvailable((IMethod)object);
    }

    public static boolean isIntroduceIndirectionAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaTextSelection.resolveElementAtOffset();
        if (iJavaElementArray.length == 1) {
            return iJavaElementArray[0] instanceof IMethod && RefactoringAvailabilityTester.isIntroduceIndirectionAvailable((IMethod)iJavaElementArray[0]);
        }
        ASTNode[] aSTNodeArray = javaTextSelection.resolveSelectedNodes();
        if (aSTNodeArray == null || aSTNodeArray.length != 1) {
            return false;
        }
        switch (aSTNodeArray[0].getNodeType()) {
            case 31: 
            case 32: 
            case 48: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntroduceParameterAvailable(ASTNode[] aSTNodeArray, ASTNode aSTNode) {
        return Checks.isExtractableExpression(aSTNodeArray, aSTNode);
    }

    public static boolean isIntroduceParameterAvailable(JavaTextSelection javaTextSelection) {
        return javaTextSelection.resolveInMethodBody() && RefactoringAvailabilityTester.isIntroduceParameterAvailable(javaTextSelection.resolveSelectedNodes(), javaTextSelection.resolveCoveringNode());
    }

    public static boolean isMoveAvailable(IResource[] iResourceArray, IJavaElement[] iJavaElementArray) throws JavaModelException {
        if (iJavaElementArray != null) {
            int n = 0;
            while (n < iJavaElementArray.length) {
                IJavaElement iJavaElement = iJavaElementArray[n];
                if (iJavaElement == null || !iJavaElement.exists()) {
                    return false;
                }
                if (iJavaElement instanceof IType && ((IType)iJavaElement).isLocal()) {
                    return false;
                }
                if (iJavaElement instanceof IPackageDeclaration) {
                    return false;
                }
                if (iJavaElement instanceof IField && JdtFlags.isEnum((IMember)iJavaElement)) {
                    return false;
                }
                ++n;
            }
        }
        return ReorgPolicyFactory.createMovePolicy(iResourceArray, iJavaElementArray).canEnable();
    }

    public static boolean isMoveAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = javaTextSelection.resolveEnclosingElement();
        if (iJavaElement == null) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveAvailable(new IResource[0], new IJavaElement[]{iJavaElement});
    }

    public static boolean isMoveInnerAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        Object object;
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IType) {
            return RefactoringAvailabilityTester.isMoveInnerAvailable((IType)object);
        }
        return false;
    }

    public static boolean isMoveInnerAvailable(IType iType) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iType) && !Checks.isAnonymous(iType) && !Checks.isTopLevel(iType) && !Checks.isInsideLocalType(iType);
    }

    public static boolean isMoveInnerAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IType iType = RefactoringAvailabilityTester.getDeclaringType(javaTextSelection.resolveEnclosingElement());
        if (iType == null) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveInnerAvailable(iType);
    }

    public static boolean isMoveMethodAvailable(IMethod iMethod) throws JavaModelException {
        return iMethod.exists() && !iMethod.isConstructor() && !iMethod.isBinary() && (iMethod.getDeclaringType() == null || !iMethod.getDeclaringType().isAnnotation()) && !iMethod.isReadOnly() && !JdtFlags.isStatic((IMember)iMethod);
    }

    public static boolean isMoveMethodAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            return object instanceof IMethod && RefactoringAvailabilityTester.isMoveMethodAvailable((IMethod)object);
        }
        return false;
    }

    public static boolean isMoveMethodAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = javaTextSelection.resolveEnclosingElement();
        if (!(iJavaElement instanceof IMethod)) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveMethodAvailable((IMethod)iJavaElement);
    }

    public static boolean isMoveStaticAvailable(IMember iMember) throws JavaModelException {
        if (!iMember.exists()) {
            return false;
        }
        int n = iMember.getElementType();
        if (n != 9 && n != 8 && n != 7) {
            return false;
        }
        if (JdtFlags.isEnum(iMember) && n != 7) {
            return false;
        }
        IType iType = iMember.getDeclaringType();
        if (iType == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)iMember)) {
            return false;
        }
        if (n == 9 && iType.isInterface()) {
            return false;
        }
        if (n == 9 && !JdtFlags.isStatic(iMember)) {
            return false;
        }
        if (n == 9 && ((IMethod)iMember).isConstructor()) {
            return false;
        }
        if (n == 7 && !JdtFlags.isStatic(iMember)) {
            return false;
        }
        return iType.isInterface() || JdtFlags.isStatic(iMember);
    }

    public static boolean isMoveStaticAvailable(IMember[] iMemberArray) throws JavaModelException {
        int n = 0;
        while (n < iMemberArray.length) {
            if (!RefactoringAvailabilityTester.isMoveStaticAvailable(iMemberArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isMoveStaticAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = javaTextSelection.resolveEnclosingElement();
        if (!(iJavaElement instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveStaticMembersAvailable(new IMember[]{(IMember)iJavaElement});
    }

    public static boolean isMoveStaticMembersAvailable(IMember[] iMemberArray) throws JavaModelException {
        if (iMemberArray == null) {
            return false;
        }
        if (iMemberArray.length == 0) {
            return false;
        }
        if (!RefactoringAvailabilityTester.isMoveStaticAvailable(iMemberArray)) {
            return false;
        }
        return RefactoringAvailabilityTester.isCommonDeclaringType(iMemberArray);
    }

    public static boolean isPromoteTempAvailable(ILocalVariable iLocalVariable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iLocalVariable);
    }

    public static boolean isPromoteTempAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaTextSelection.resolveElementAtOffset();
        if (iJavaElementArray.length != 1) {
            return false;
        }
        return iJavaElementArray[0] instanceof ILocalVariable && RefactoringAvailabilityTester.isPromoteTempAvailable((ILocalVariable)iJavaElementArray[0]);
    }

    public static boolean isPullUpAvailable(IMember iMember) throws JavaModelException {
        if (!iMember.exists()) {
            return false;
        }
        int n = iMember.getElementType();
        if (n != 9 && n != 8 && n != 7) {
            return false;
        }
        if (JdtFlags.isEnum(iMember) && n != 7) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)iMember)) {
            return false;
        }
        if (iMember instanceof IType && !JdtFlags.isStatic(iMember) && !JdtFlags.isEnum(iMember) && !JdtFlags.isAnnotation(iMember)) {
            return false;
        }
        if (iMember instanceof IMethod) {
            IMethod iMethod = (IMethod)iMember;
            if (iMethod.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)iMethod)) {
                return false;
            }
            IType iType = iMethod.getDeclaringType();
            if (iType != null && iType.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPullUpAvailable(IMember[] iMemberArray) throws JavaModelException {
        if (iMemberArray != null && iMemberArray.length != 0) {
            IType iType = RefactoringAvailabilityTester.getTopLevelType(iMemberArray);
            if (iType != null && RefactoringAvailabilityTester.getPullUpMembers(iType).length != 0) {
                return true;
            }
            int n = 0;
            while (n < iMemberArray.length) {
                if (!RefactoringAvailabilityTester.isPullUpAvailable(iMemberArray[n])) {
                    return false;
                }
                ++n;
            }
            return RefactoringAvailabilityTester.isCommonDeclaringType(iMemberArray);
        }
        return false;
    }

    public static boolean isPullUpAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (!iStructuredSelection.isEmpty()) {
            Object object;
            if (iStructuredSelection.size() == 1) {
                if (iStructuredSelection.getFirstElement() instanceof ICompilationUnit) {
                    return true;
                }
                object = RefactoringAvailabilityTester.getSingleSelectedType(iStructuredSelection);
                if (object != null) {
                    return Checks.isAvailable((IJavaElement)object) && RefactoringAvailabilityTester.isPullUpAvailable((IMember[])new IType[]{object});
                }
            }
            object = iStructuredSelection.iterator();
            while (object.hasNext()) {
                if (object.next() instanceof IMember) continue;
                return false;
            }
            object = new HashSet();
            object.addAll(Arrays.asList(iStructuredSelection.toArray()));
            return RefactoringAvailabilityTester.isPullUpAvailable(object.toArray(new IMember[object.size()]));
        }
        return false;
    }

    public static boolean isPullUpAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = javaTextSelection.resolveEnclosingElement();
        if (!(iJavaElement instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isPullUpAvailable(new IMember[]{(IMember)iJavaElement});
    }

    public static boolean isPushDownAvailable(IMember iMember) throws JavaModelException {
        if (!iMember.exists()) {
            return false;
        }
        int n = iMember.getElementType();
        if (n != 9 && n != 8) {
            return false;
        }
        if (JdtFlags.isEnum(iMember)) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)iMember)) {
            return false;
        }
        if (JdtFlags.isStatic(iMember)) {
            return false;
        }
        if (n == 9) {
            IMethod iMethod = (IMethod)iMember;
            if (iMethod.isConstructor()) {
                return false;
            }
            if (JdtFlags.isNative((IMember)iMethod)) {
                return false;
            }
            IType iType = iMethod.getDeclaringType();
            if (iType != null && iType.isAnnotation()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPushDownAvailable(IMember[] iMemberArray) throws JavaModelException {
        if (iMemberArray != null && iMemberArray.length != 0) {
            IType iType = RefactoringAvailabilityTester.getTopLevelType(iMemberArray);
            if (iType != null && RefactoringAvailabilityTester.getPushDownMembers(iType).length != 0) {
                return true;
            }
            if (iType != null && JdtFlags.isEnum((IMember)iType)) {
                return false;
            }
            int n = 0;
            while (n < iMemberArray.length) {
                if (!RefactoringAvailabilityTester.isPushDownAvailable(iMemberArray[n])) {
                    return false;
                }
                ++n;
            }
            return RefactoringAvailabilityTester.isCommonDeclaringType(iMemberArray);
        }
        return false;
    }

    public static boolean isPushDownAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (!iStructuredSelection.isEmpty()) {
            Object object;
            if (iStructuredSelection.size() == 1) {
                if (iStructuredSelection.getFirstElement() instanceof ICompilationUnit) {
                    return true;
                }
                object = RefactoringAvailabilityTester.getSingleSelectedType(iStructuredSelection);
                if (object != null) {
                    return RefactoringAvailabilityTester.isPushDownAvailable((IMember[])new IType[]{object});
                }
            }
            object = iStructuredSelection.iterator();
            while (object.hasNext()) {
                if (object.next() instanceof IMember) continue;
                return false;
            }
            object = new HashSet();
            object.addAll(Arrays.asList(iStructuredSelection.toArray()));
            return RefactoringAvailabilityTester.isPushDownAvailable(object.toArray(new IMember[object.size()]));
        }
        return false;
    }

    public static boolean isPushDownAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = javaTextSelection.resolveEnclosingElement();
        if (!(iJavaElement instanceof IMember)) {
            return false;
        }
        return RefactoringAvailabilityTester.isPullUpAvailable(new IMember[]{(IMember)iJavaElement});
    }

    public static boolean isRenameAvailable(ICompilationUnit iCompilationUnit) {
        if (iCompilationUnit == null) {
            return false;
        }
        if (!iCompilationUnit.exists()) {
            return false;
        }
        if (!JavaModelUtil.isPrimary(iCompilationUnit)) {
            return false;
        }
        return !iCompilationUnit.isReadOnly();
    }

    public static boolean isRenameAvailable(IJavaProject iJavaProject) throws JavaModelException {
        if (iJavaProject == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)iJavaProject)) {
            return false;
        }
        return iJavaProject.isConsistent();
    }

    public static boolean isRenameAvailable(ILocalVariable iLocalVariable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iLocalVariable);
    }

    public static boolean isRenameAvailable(IMethod iMethod) throws CoreException {
        if (iMethod == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)iMethod)) {
            return false;
        }
        if (iMethod.isConstructor()) {
            return false;
        }
        return !RefactoringAvailabilityTester.isRenameProhibited(iMethod);
    }

    public static boolean isRenameAvailable(IPackageFragment iPackageFragment) throws JavaModelException {
        if (iPackageFragment == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)iPackageFragment)) {
            return false;
        }
        return !iPackageFragment.isDefaultPackage();
    }

    public static boolean isRenameAvailable(IPackageFragmentRoot iPackageFragmentRoot) throws JavaModelException {
        if (iPackageFragmentRoot == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)iPackageFragmentRoot)) {
            return false;
        }
        if (iPackageFragmentRoot.isArchive()) {
            return false;
        }
        if (iPackageFragmentRoot.isExternal()) {
            return false;
        }
        if (!iPackageFragmentRoot.isConsistent()) {
            return false;
        }
        return !(iPackageFragmentRoot.getResource() instanceof IProject);
    }

    public static boolean isRenameAvailable(IResource iResource) {
        if (iResource == null) {
            return false;
        }
        if (!iResource.exists()) {
            return false;
        }
        return iResource.isAccessible();
    }

    public static boolean isRenameAvailable(IType iType) throws JavaModelException {
        if (iType == null) {
            return false;
        }
        if (iType.isAnonymous()) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)iType)) {
            return false;
        }
        return !RefactoringAvailabilityTester.isRenameProhibited(iType);
    }

    public static boolean isRenameAvailable(ITypeParameter iTypeParameter) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iTypeParameter);
    }

    public static boolean isRenameEnumConstAvailable(IField iField) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iField) && iField.getDeclaringType().isEnum();
    }

    public static boolean isRenameFieldAvailable(IField iField) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iField) && !JdtFlags.isEnum((IMember)iField);
    }

    public static boolean isRenameNonVirtualMethodAvailable(IMethod iMethod) throws JavaModelException, CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(iMethod) && !MethodChecks.isVirtual(iMethod);
    }

    public static boolean isRenameProhibited(IMethod iMethod) throws CoreException {
        return iMethod.getElementName().equals("toString") && iMethod.getNumberOfParameters() == 0 && (iMethod.getReturnType().equals("Ljava.lang.String;") || iMethod.getReturnType().equals("QString;") || iMethod.getReturnType().equals("Qjava.lang.String;"));
    }

    public static boolean isRenameProhibited(IType iType) {
        return iType.getPackageFragment().getElementName().equals("java.lang");
    }

    public static boolean isRenameVirtualMethodAvailable(IMethod iMethod) throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(iMethod) && MethodChecks.isVirtual(iMethod);
    }

    public static boolean isReplaceInvocationsAvailable(IMethod iMethod) throws JavaModelException {
        if (iMethod == null) {
            return false;
        }
        if (!iMethod.exists()) {
            return false;
        }
        return !iMethod.isConstructor();
    }

    public static boolean isReplaceInvocationsAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() != 1) {
            return false;
        }
        Object object = iStructuredSelection.getFirstElement();
        return object instanceof IMethod && RefactoringAvailabilityTester.isReplaceInvocationsAvailable((IMethod)object);
    }

    public static boolean isReplaceInvocationsAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaTextSelection.resolveElementAtOffset();
        if (iJavaElementArray.length != 1) {
            return false;
        }
        IJavaElement iJavaElement = iJavaElementArray[0];
        return iJavaElement instanceof IMethod && RefactoringAvailabilityTester.isReplaceInvocationsAvailable((IMethod)iJavaElement);
    }

    public static boolean isSelfEncapsulateAvailable(IField iField) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)iField) && !JdtFlags.isEnum((IMember)iField) && !iField.getDeclaringType().isAnnotation();
    }

    public static boolean isSelfEncapsulateAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof IField) {
            IField iField = (IField)iStructuredSelection.getFirstElement();
            return Checks.isAvailable((IJavaElement)iField) && !JdtFlags.isEnum((IMember)iField);
        }
        return false;
    }

    public static boolean isSelfEncapsulateAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        IJavaElement[] iJavaElementArray = javaTextSelection.resolveElementAtOffset();
        if (iJavaElementArray.length != 1) {
            return false;
        }
        return iJavaElementArray[0] instanceof IField && RefactoringAvailabilityTester.isSelfEncapsulateAvailable((IField)iJavaElementArray[0]);
    }

    public static boolean isUseSuperTypeAvailable(IStructuredSelection iStructuredSelection) throws JavaModelException {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IType) {
                return RefactoringAvailabilityTester.isUseSuperTypeAvailable((IType)object);
            }
            if (object instanceof ICompilationUnit) {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)object;
                return iCompilationUnit.exists() && !iCompilationUnit.isReadOnly();
            }
        }
        return false;
    }

    public static boolean isUseSuperTypeAvailable(IType iType) throws JavaModelException {
        return iType != null && iType.exists() && !iType.isAnnotation() && !iType.isAnonymous();
    }

    public static boolean isUseSuperTypeAvailable(JavaTextSelection javaTextSelection) throws JavaModelException {
        return RefactoringAvailabilityTester.isUseSuperTypeAvailable(RefactoringActions.getEnclosingOrPrimaryType(javaTextSelection));
    }

    public static boolean isWorkingCopyElement(IJavaElement iJavaElement) {
        if (iJavaElement instanceof ICompilationUnit) {
            return ((ICompilationUnit)iJavaElement).isWorkingCopy();
        }
        if (ReorgUtils.isInsideCompilationUnit(iJavaElement)) {
            return ReorgUtils.getCompilationUnit(iJavaElement).isWorkingCopy();
        }
        return false;
    }

    private RefactoringAvailabilityTester() {
    }
}

