/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.base;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public abstract class JDTChange
extends Change {
    private long fModificationStamp = -1L;
    private boolean fReadOnly = false;
    protected static final int NONE = 0;
    protected static final int READ_ONLY = 1;
    protected static final int DIRTY = 2;
    private static final int SAVE = 4;
    protected static final int SAVE_IF_DIRTY = 6;
    static /* synthetic */ Class class$0;

    protected JDTChange() {
    }

    public void initializeValidationData(IProgressMonitor iProgressMonitor) {
        IResource iResource = JDTChange.getResource(this.getModifiedElement());
        if (iResource != null) {
            this.fModificationStamp = this.getModificationStamp(iResource);
            this.fReadOnly = Resources.isReadOnly(iResource);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final RefactoringStatus isValid(IProgressMonitor iProgressMonitor, int n) throws CoreException {
        RefactoringStatus refactoringStatus;
        block17: {
            RefactoringStatus refactoringStatus2;
            block16: {
                RefactoringStatus refactoringStatus3;
                block15: {
                    RefactoringStatus refactoringStatus4;
                    block14: {
                        RefactoringStatus refactoringStatus5;
                        block13: {
                            RefactoringStatus refactoringStatus6;
                            block12: {
                                iProgressMonitor.beginTask("", 2);
                                try {
                                    RefactoringStatus refactoringStatus7 = new RefactoringStatus();
                                    Object object = this.getModifiedElement();
                                    JDTChange.checkExistence(refactoringStatus7, object);
                                    if (refactoringStatus7.hasFatalError()) {
                                        refactoringStatus6 = refactoringStatus7;
                                        Object var7_11 = null;
                                        break block12;
                                    }
                                    if (n == 0) {
                                        refactoringStatus5 = refactoringStatus7;
                                        break block13;
                                    }
                                    IResource iResource = JDTChange.getResource(object);
                                    if (iResource != null) {
                                        ValidationState validationState = new ValidationState(iResource);
                                        validationState.checkModificationStamp(refactoringStatus7, this.fModificationStamp);
                                        if (refactoringStatus7.hasFatalError()) {
                                            refactoringStatus4 = refactoringStatus7;
                                            break block14;
                                        }
                                        validationState.checkSameReadOnly(refactoringStatus7, this.fReadOnly);
                                        if (refactoringStatus7.hasFatalError()) {
                                            refactoringStatus3 = refactoringStatus7;
                                            break block15;
                                        }
                                        if ((n & 1) != 0) {
                                            validationState.checkReadOnly(refactoringStatus7);
                                            if (refactoringStatus7.hasFatalError()) {
                                                refactoringStatus2 = refactoringStatus7;
                                                break block16;
                                            }
                                        }
                                        if ((n & 2) != 0) {
                                            if ((n & 4) != 0) {
                                                validationState.checkDirty(refactoringStatus7, this.fModificationStamp, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                            } else {
                                                validationState.checkDirty(refactoringStatus7);
                                            }
                                        }
                                    }
                                    refactoringStatus = refactoringStatus7;
                                    break block17;
                                }
                                catch (Throwable throwable) {
                                    Object var7_17 = null;
                                    iProgressMonitor.done();
                                    throw throwable;
                                }
                            }
                            iProgressMonitor.done();
                            return refactoringStatus6;
                        }
                        Object var7_12 = null;
                        iProgressMonitor.done();
                        return refactoringStatus5;
                    }
                    Object var7_13 = null;
                    iProgressMonitor.done();
                    return refactoringStatus4;
                }
                Object var7_14 = null;
                iProgressMonitor.done();
                return refactoringStatus3;
            }
            Object var7_15 = null;
            iProgressMonitor.done();
            return refactoringStatus2;
        }
        Object var7_16 = null;
        iProgressMonitor.done();
        return refactoringStatus;
    }

    protected static void checkIfModifiable(RefactoringStatus refactoringStatus, Object object, int n) {
        JDTChange.checkIfModifiable(refactoringStatus, JDTChange.getResource(object), n);
    }

    protected static void checkIfModifiable(RefactoringStatus refactoringStatus, IResource iResource, int n) {
        JDTChange.checkExistence(refactoringStatus, iResource);
        if (refactoringStatus.hasFatalError()) {
            return;
        }
        if (n == 0) {
            return;
        }
        ValidationState validationState = new ValidationState(iResource);
        if ((n & 1) != 0) {
            validationState.checkReadOnly(refactoringStatus);
            if (refactoringStatus.hasFatalError()) {
                return;
            }
        }
        if ((n & 2) != 0) {
            validationState.checkDirty(refactoringStatus);
        }
    }

    protected static void checkExistence(RefactoringStatus refactoringStatus, Object object) {
        if (object == null) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.DynamicValidationStateChange_workspace_changed);
        } else if (object instanceof IResource && !((IResource)object).exists()) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Change_does_not_exist, ((IResource)object).getFullPath().toString()));
        } else if (object instanceof IJavaElement && !((IJavaElement)object).exists()) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Change_does_not_exist, ((IJavaElement)object).getElementName()));
        }
    }

    private static IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof ICompilationUnit) {
            return ((ICompilationUnit)object).getPrimary().getResource();
        }
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getResource();
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public long getModificationStamp(IResource iResource) {
        if (!(iResource instanceof IFile)) {
            return iResource.getModificationStamp();
        }
        IFile iFile = (IFile)iResource;
        ITextFileBuffer iTextFileBuffer = JDTChange.getBuffer(iFile);
        if (iTextFileBuffer == null) {
            return iFile.getModificationStamp();
        }
        IDocument iDocument = iTextFileBuffer.getDocument();
        if (iDocument instanceof IDocumentExtension4) {
            return ((IDocumentExtension4)iDocument).getModificationStamp();
        }
        return iFile.getModificationStamp();
    }

    private static ITextFileBuffer getBuffer(IFile iFile) {
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        return iTextFileBufferManager.getTextFileBuffer(iFile.getFullPath(), LocationKind.IFILE);
    }

    private static class ValidationState {
        private IResource fResource;
        private int fKind;
        private boolean fDirty;
        private boolean fReadOnly;
        private long fModificationStamp;
        private ITextFileBuffer fTextFileBuffer;
        public static final int RESOURCE = 1;
        public static final int DOCUMENT = 2;

        public ValidationState(IResource iResource) {
            this.fResource = iResource;
            if (iResource instanceof IFile) {
                this.initializeFile((IFile)iResource);
            } else {
                this.initializeResource(iResource);
            }
        }

        public void checkDirty(RefactoringStatus refactoringStatus, long l, IProgressMonitor iProgressMonitor) throws CoreException {
            if (this.fDirty) {
                if (this.fKind == 2 && this.fTextFileBuffer != null && l == this.fModificationStamp) {
                    this.fTextFileBuffer.commit(iProgressMonitor, false);
                } else {
                    refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Change_is_unsaved, this.fResource.getFullPath().toString()));
                }
            }
        }

        public void checkDirty(RefactoringStatus refactoringStatus) {
            if (this.fDirty) {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Change_is_unsaved, this.fResource.getFullPath().toString()));
            }
        }

        public void checkReadOnly(RefactoringStatus refactoringStatus) {
            if (this.fReadOnly) {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Change_is_read_only, this.fResource.getFullPath().toString()));
            }
        }

        public void checkSameReadOnly(RefactoringStatus refactoringStatus, boolean bl) {
            if (this.fReadOnly != bl) {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Change_same_read_only, this.fResource.getFullPath().toString()));
            }
        }

        public void checkModificationStamp(RefactoringStatus refactoringStatus, long l) {
            if (this.fKind == 2) {
                if (l != -1L && this.fModificationStamp != l) {
                    refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Change_has_modifications, this.fResource.getFullPath().toString()));
                }
            } else if (l != -1L && this.fModificationStamp != l) {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.Change_has_modifications, this.fResource.getFullPath().toString()));
            }
        }

        private void initializeFile(IFile iFile) {
            this.fTextFileBuffer = JDTChange.getBuffer(iFile);
            if (this.fTextFileBuffer == null) {
                this.initializeResource((IResource)iFile);
            } else {
                IDocument iDocument = this.fTextFileBuffer.getDocument();
                this.fDirty = this.fTextFileBuffer.isDirty();
                this.fReadOnly = Resources.isReadOnly((IResource)iFile);
                if (iDocument instanceof IDocumentExtension4) {
                    this.fKind = 2;
                    this.fModificationStamp = ((IDocumentExtension4)iDocument).getModificationStamp();
                } else {
                    this.fKind = 1;
                    this.fModificationStamp = iFile.getModificationStamp();
                }
            }
        }

        private void initializeResource(IResource iResource) {
            this.fKind = 1;
            this.fDirty = false;
            this.fReadOnly = Resources.isReadOnly(iResource);
            this.fModificationStamp = iResource.getModificationStamp();
        }
    }
}

