/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.AbstractExceptionAnalyzer;

class ExceptionAnalyzer
extends AbstractExceptionAnalyzer {
    ExceptionAnalyzer() {
    }

    public static ITypeBinding[] perform(ASTNode[] aSTNodeArray) {
        ExceptionAnalyzer exceptionAnalyzer = new ExceptionAnalyzer();
        int n = 0;
        while (n < aSTNodeArray.length) {
            aSTNodeArray[n].accept((ASTVisitor)exceptionAnalyzer);
            ++n;
        }
        List list = exceptionAnalyzer.getCurrentExceptions();
        return list.toArray(new ITypeBinding[list.size()]);
    }

    public boolean visit(ThrowStatement throwStatement) {
        ITypeBinding iTypeBinding = throwStatement.getExpression().resolveTypeBinding();
        if (iTypeBinding == null) {
            return true;
        }
        this.addException(iTypeBinding);
        return true;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        SimpleName simpleName = methodInvocation.getName();
        if (simpleName != null) {
            return this.handleExceptions((IMethodBinding)simpleName.resolveBinding());
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        return this.handleExceptions((IMethodBinding)superMethodInvocation.getName().resolveBinding());
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        return this.handleExceptions(classInstanceCreation.resolveConstructorBinding());
    }

    private boolean handleExceptions(IMethodBinding iMethodBinding) {
        if (iMethodBinding == null) {
            return true;
        }
        this.addExceptions(iMethodBinding.getExceptionTypes());
        return true;
    }
}

