/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.NoCommentSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class ExtractTempRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_FINAL = "final";
    private CompilationUnit fCompilationUnitNode;
    private CompilationUnitRewrite fCURewrite;
    private ICompilationUnit fCu;
    private boolean fDeclareFinal;
    private String[] fExcludedVariableNames;
    private boolean fReplaceAllOccurrences;
    private IExpressionFragment fSelectedExpression;
    private int fSelectionLength;
    private int fSelectionStart;
    private String fTempName;
    private String[] fGuessedTempNames;
    private TextChange fChange;
    private LinkedProposalModel fLinkedProposalModel;
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private static boolean allArraysEqual(Object[][] objectArray, int n) {
        Object object = objectArray[0][n];
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object[] objectArray2 = objectArray[n2];
            if (!object.equals(objectArray2[n])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean canReplace(IASTFragment iASTFragment) {
        VariableDeclarationFragment variableDeclarationFragment;
        ASTNode aSTNode = iASTFragment.getAssociatedNode();
        ASTNode aSTNode2 = aSTNode.getParent();
        if (aSTNode2 instanceof VariableDeclarationFragment && aSTNode.equals((Object)(variableDeclarationFragment = (VariableDeclarationFragment)aSTNode2).getName())) {
            return false;
        }
        if (ExtractTempRefactoring.isMethodParameter(aSTNode)) {
            return false;
        }
        if (ExtractTempRefactoring.isThrowableInCatchBlock(aSTNode)) {
            return false;
        }
        if (aSTNode2 instanceof ExpressionStatement) {
            return false;
        }
        if (ExtractTempRefactoring.isLeftValue(aSTNode)) {
            return false;
        }
        if (ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)aSTNode)) {
            return false;
        }
        if (ExtractTempRefactoring.isUsedInForInitializerOrUpdater((Expression)aSTNode)) {
            return false;
        }
        return !(aSTNode2 instanceof SwitchCase);
    }

    private static Object[] getArrayPrefix(Object[] objectArray, int n) {
        Assert.isTrue((n <= objectArray.length ? 1 : 0) != 0);
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        while (n2 < objectArray2.length) {
            objectArray2[n2] = objectArray[n2];
            ++n2;
        }
        return objectArray2;
    }

    private static List getForInitializedVariables(VariableDeclarationExpression variableDeclarationExpression) {
        ArrayList<IVariableBinding> arrayList = new ArrayList<IVariableBinding>(1);
        Iterator iterator = variableDeclarationExpression.fragments().iterator();
        while (iterator.hasNext()) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
            IVariableBinding iVariableBinding = variableDeclarationFragment.resolveBinding();
            if (iVariableBinding == null) continue;
            arrayList.add(iVariableBinding);
        }
        return arrayList;
    }

    private static Object[] getLongestArrayPrefix(Object[][] objectArray) {
        int n = -1;
        if (objectArray.length == 0) {
            return new Object[0];
        }
        int n2 = objectArray[0].length;
        int n3 = 1;
        while (n3 < objectArray.length) {
            n2 = Math.min(n2, objectArray[n3].length);
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (!ExtractTempRefactoring.allArraysEqual(objectArray, n3)) break;
            ++n;
            ++n3;
        }
        if (n == -1) {
            return new Object[0];
        }
        return ExtractTempRefactoring.getArrayPrefix(objectArray[0], n + 1);
    }

    private static ASTNode[] getParents(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode;
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        do {
            arrayList.add(aSTNode2.getParent());
        } while ((aSTNode2 = aSTNode2.getParent()).getParent() != null);
        Collections.reverse(arrayList);
        return arrayList.toArray(new ASTNode[arrayList.size()]);
    }

    private static boolean isLeftValue(ASTNode aSTNode) {
        Assignment assignment;
        ASTNode aSTNode2 = aSTNode.getParent();
        if (aSTNode2 instanceof Assignment && (assignment = (Assignment)aSTNode2).getLeftHandSide() == aSTNode) {
            return true;
        }
        if (aSTNode2 instanceof PostfixExpression) {
            return true;
        }
        if (aSTNode2 instanceof PrefixExpression) {
            assignment = ((PrefixExpression)aSTNode2).getOperator();
            if (assignment.equals(PrefixExpression.Operator.DECREMENT)) {
                return true;
            }
            return assignment.equals(PrefixExpression.Operator.INCREMENT);
        }
        return false;
    }

    private static boolean isMethodParameter(ASTNode aSTNode) {
        return aSTNode instanceof SimpleName && aSTNode.getParent() instanceof SingleVariableDeclaration && aSTNode.getParent().getParent() instanceof MethodDeclaration;
    }

    private static boolean isReferringToLocalVariableFromFor(Expression expression) {
        Expression expression2 = expression;
        ASTNode aSTNode = expression2.getParent();
        while (aSTNode != null && !(aSTNode instanceof BodyDeclaration)) {
            Object object;
            ArrayList<IVariableBinding> arrayList;
            ForStatement forStatement;
            if (aSTNode instanceof ForStatement) {
                forStatement = (ForStatement)aSTNode;
                if ((forStatement.initializers().contains(expression2) || forStatement.updaters().contains(expression2) || forStatement.getExpression() == expression2) && (arrayList = forStatement.initializers()).size() == 1 && arrayList.get(0) instanceof VariableDeclarationExpression) {
                    object = ExtractTempRefactoring.getForInitializedVariables((VariableDeclarationExpression)arrayList.get(0));
                    ForStatementChecker forStatementChecker = new ForStatementChecker((Collection)object);
                    expression.accept((ASTVisitor)forStatementChecker);
                    if (forStatementChecker.isReferringToForVariable()) {
                        return true;
                    }
                }
            } else if (aSTNode instanceof ForInStatement && ((forStatement = (ForInStatement)aSTNode).getIterationVariable().equals((Object)expression2) || forStatement.getCollection() == expression2) && forStatement.getIterationVariable() instanceof VariableDeclarationStatement) {
                arrayList = new ArrayList<IVariableBinding>(1);
                arrayList.add(((VariableDeclarationStatement)forStatement.getIterationVariable()).resolveBinding());
                object = new ForStatementChecker(arrayList);
                expression.accept((ASTVisitor)object);
                if (((ForStatementChecker)((Object)object)).isReferringToForVariable()) {
                    return true;
                }
            }
            expression2 = aSTNode;
            aSTNode = expression2.getParent();
        }
        return false;
    }

    private static boolean isThrowableInCatchBlock(ASTNode aSTNode) {
        return aSTNode instanceof SimpleName && aSTNode.getParent() instanceof SingleVariableDeclaration && aSTNode.getParent().getParent() instanceof CatchClause;
    }

    private static boolean isUsedInForInitializerOrUpdater(Expression expression) {
        ASTNode aSTNode = expression.getParent();
        if (aSTNode instanceof ForStatement) {
            ForStatement forStatement = (ForStatement)aSTNode;
            return forStatement.initializers().contains(expression) || forStatement.updaters().contains(expression);
        }
        return false;
    }

    private static IASTFragment[] retainOnlyReplacableMatches(IASTFragment[] iASTFragmentArray) {
        ArrayList<IASTFragment> arrayList = new ArrayList<IASTFragment>(iASTFragmentArray.length);
        int n = 0;
        while (n < iASTFragmentArray.length) {
            if (ExtractTempRefactoring.canReplace(iASTFragmentArray[n])) {
                arrayList.add(iASTFragmentArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IASTFragment[arrayList.size()]);
    }

    public ExtractTempRefactoring(ICompilationUnit iCompilationUnit, int n, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fCu = iCompilationUnit;
        this.fCompilationUnitNode = null;
        this.fReplaceAllOccurrences = true;
        this.fDeclareFinal = false;
        this.fTempName = "";
        this.fLinkedProposalModel = null;
    }

    public ExtractTempRefactoring(CompilationUnit compilationUnit, int n, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        Assert.isTrue((boolean)(compilationUnit.getTypeRoot() instanceof ICompilationUnit));
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fCu = (ICompilationUnit)compilationUnit.getTypeRoot();
        this.fCompilationUnitNode = compilationUnit;
        this.fReplaceAllOccurrences = true;
        this.fDeclareFinal = false;
        this.fTempName = "";
        this.fLinkedProposalModel = null;
    }

    public void setLinkedProposalModel(LinkedProposalModel linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    private void addReplaceExpressionWithTemp() throws JavaModelException {
        IASTFragment[] iASTFragmentArray = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        ASTRewrite aSTRewrite = this.fCURewrite.getASTRewrite();
        HashSet<IASTFragment> hashSet = new HashSet<IASTFragment>();
        int n = 0;
        while (n < iASTFragmentArray.length) {
            IASTFragment iASTFragment = iASTFragmentArray[n];
            if (hashSet.add(iASTFragment)) {
                SimpleName simpleName = this.fCURewrite.getAST().newSimpleName(this.fTempName);
                TextEditGroup textEditGroup = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_replace);
                iASTFragment.replace(aSTRewrite, (ASTNode)simpleName, textEditGroup);
                if (this.fLinkedProposalModel != null) {
                    this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true).addPosition(aSTRewrite.track((ASTNode)simpleName), false);
                }
            }
            ++n;
        }
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        Expression expression = this.getSelectedExpression().getAssociatedExpression();
        if (expression != null) {
            ASTNode aSTNode = expression.getParent();
            if (expression instanceof NullLiteral) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
            }
            if (expression instanceof ArrayInitializer) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
            }
            if (expression instanceof Assignment) {
                if (aSTNode instanceof Expression && !(aSTNode instanceof ParenthesizedExpression)) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
                }
                return null;
            }
            if (expression instanceof SimpleName) {
                if (((SimpleName)expression).isDeclaration()) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
                }
                if (aSTNode instanceof QualifiedName && expression.getLocationInParent() == QualifiedName.NAME_PROPERTY || aSTNode instanceof FieldAccess && expression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
                }
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.getSelectedExpression().getAssociatedExpression())) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.ExtractTempRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public TextChange createTextChange(IProgressMonitor iProgressMonitor) throws CoreException {
        CompilationUnitChange compilationUnitChange;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 3);
            this.fCURewrite = new CompilationUnitRewrite(this.fCu, this.fCompilationUnitNode);
            this.fCURewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)new NoCommentSourceRangeComputer());
            this.doCreateChange((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
            compilationUnitChange = this.fCURewrite.createChange(RefactoringCoreMessages.ExtractTempRefactoring_change_name, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return compilationUnitChange;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        this.fChange = this.createTextChange(iProgressMonitor);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (Arrays.asList(this.getExcludedVariableNames()).contains(this.fTempName)) {
            refactoringStatus.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, this.fTempName));
        }
        refactoringStatus.merge(this.checkMatchingFragments());
        this.fChange.setKeepPreviewEdits(true);
        this.checkNewSource(refactoringStatus);
        return refactoringStatus;
    }

    private final JDTRefactoringDescriptor createRefactoringDescriptor() {
        Object object;
        BodyDeclaration bodyDeclaration;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        IJavaProject iJavaProject = this.fCu.getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        String string2 = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description_short, this.fTempName);
        String string3 = ASTNodes.asString((ASTNode)this.fSelectedExpression.getAssociatedExpression());
        String string4 = Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_descriptor_description, new String[]{this.fTempName, string3});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string4);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_name_pattern, this.fTempName));
        Expression expression = this.fSelectedExpression.getAssociatedExpression();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.BodyDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bodyDeclaration = (BodyDeclaration)ASTNodes.getParent((ASTNode)expression, clazz)) instanceof MethodDeclaration) {
            object = ((MethodDeclaration)bodyDeclaration).resolveBinding();
            String string5 = object != null ? BindingLabelProvider.getBindingLabel((IBinding)object, JavaElementLabels.ALL_FULLY_QUALIFIED) : "{...}";
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_destination_pattern, string5));
        }
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_expression_pattern, string3));
        if (this.fReplaceAllOccurrences) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_replace_occurrences);
        }
        if (this.fDeclareFinal) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.ExtractTempRefactoring_declare_final);
        }
        object = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.extract.temp", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, 0);
        hashMap.put("input", ((JDTRefactoringDescriptor)((Object)object)).elementToHandle((IJavaElement)this.fCu));
        hashMap.put(KEY_NAME, this.fTempName);
        hashMap.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        hashMap.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceAllOccurrences).toString());
        hashMap.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fDeclareFinal).toString());
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCreateChange(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 1);
            try {
                this.createTempDeclaration();
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
            this.addReplaceExpressionWithTemp();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        iProgressMonitor.done();
    }

    private void checkNewSource(RefactoringStatus refactoringStatus) throws CoreException {
        String string = this.fChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        CompilationUnit compilationUnit = new RefactoringASTParser(3).parse(string, this.fCu, true, true, null);
        IProblem[] iProblemArray = RefactoringAnalyzeUtil.getIntroducedCompileProblems(compilationUnit, this.fCompilationUnitNode);
        int n = 0;
        while (n < iProblemArray.length) {
            IProblem iProblem = iProblemArray[n];
            if (iProblem.isError()) {
                refactoringStatus.addEntry(new RefactoringStatusEntry(iProblem.isError() ? 3 : 2, iProblem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(string, new SourceRange(iProblem))));
            }
            ++n;
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block6: {
            RefactoringStatus refactoringStatus2;
            try {
                iProgressMonitor.beginTask("", 6);
                refactoringStatus = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
                if (!refactoringStatus.hasFatalError()) break block6;
                refactoringStatus2 = refactoringStatus;
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return refactoringStatus2;
        }
        if (this.fCompilationUnitNode == null) {
            this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
        } else {
            iProgressMonitor.worked(3);
        }
        refactoringStatus.merge(this.checkSelection((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3)));
        if (!refactoringStatus.hasFatalError() && this.isLiteralNodeSelected()) {
            this.fReplaceAllOccurrences = false;
        }
        RefactoringStatus refactoringStatus3 = refactoringStatus;
        Object var3_6 = null;
        iProgressMonitor.done();
        return refactoringStatus3;
    }

    private RefactoringStatus checkMatchingFragments() throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IASTFragment[] iASTFragmentArray = this.getMatchingFragments();
        int n = 0;
        while (n < iASTFragmentArray.length) {
            ASTNode aSTNode = iASTFragmentArray[n].getAssociatedNode();
            if (ExtractTempRefactoring.isLeftValue(aSTNode) && !ExtractTempRefactoring.isReferringToLocalVariableFromFor((Expression)aSTNode)) {
                String string = RefactoringCoreMessages.ExtractTempRefactoring_assigned_to;
                refactoringStatus.addWarning(string, JavaStatusContext.create((ITypeRoot)this.fCu, aSTNode));
            }
            ++n;
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkSelection(IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            IExpressionFragment iExpressionFragment;
                            block12: {
                                block11: {
                                    block10: {
                                        RefactoringStatus refactoringStatus2;
                                        try {
                                            iProgressMonitor.beginTask("", 8);
                                            iExpressionFragment = this.getSelectedExpression();
                                            if (iExpressionFragment != null) break block10;
                                            String string = RefactoringCoreMessages.ExtractTempRefactoring_select_expression;
                                            refactoringStatus2 = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, string);
                                            Object var5_14 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var5_23 = null;
                                            iProgressMonitor.done();
                                            throw throwable;
                                        }
                                        iProgressMonitor.done();
                                        return refactoringStatus2;
                                    }
                                    iProgressMonitor.worked(1);
                                    if (!this.isUsedInExplicitConstructorCall()) break block11;
                                    RefactoringStatus refactoringStatus3 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_explicit_constructor);
                                    Object var5_15 = null;
                                    iProgressMonitor.done();
                                    return refactoringStatus3;
                                }
                                iProgressMonitor.worked(1);
                                if (this.getEnclosingBodyNode() != null) break block12;
                                RefactoringStatus refactoringStatus4 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_expr_in_method_or_initializer);
                                Object var5_16 = null;
                                iProgressMonitor.done();
                                return refactoringStatus4;
                            }
                            iProgressMonitor.worked(1);
                            ASTNode aSTNode = iExpressionFragment.getAssociatedNode();
                            if (!(aSTNode instanceof Name) || !(aSTNode.getParent() instanceof ClassInstanceCreation) || aSTNode.getLocationInParent() != ClassInstanceCreation.TYPE_PROPERTY) break block13;
                            RefactoringStatus refactoringStatus5 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
                            Object var5_17 = null;
                            iProgressMonitor.done();
                            return refactoringStatus5;
                        }
                        iProgressMonitor.worked(1);
                        refactoringStatus = new RefactoringStatus();
                        refactoringStatus.merge(this.checkExpression());
                        if (!refactoringStatus.hasFatalError()) break block14;
                        RefactoringStatus refactoringStatus6 = refactoringStatus;
                        Object var5_18 = null;
                        iProgressMonitor.done();
                        return refactoringStatus6;
                    }
                    iProgressMonitor.worked(1);
                    refactoringStatus.merge(this.checkExpressionFragmentIsRValue());
                    if (!refactoringStatus.hasFatalError()) break block15;
                    RefactoringStatus refactoringStatus7 = refactoringStatus;
                    Object var5_19 = null;
                    iProgressMonitor.done();
                    return refactoringStatus7;
                }
                iProgressMonitor.worked(1);
                if (!ExtractTempRefactoring.isUsedInForInitializerOrUpdater(this.getSelectedExpression().getAssociatedExpression())) break block16;
                RefactoringStatus refactoringStatus8 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_for_initializer_updater);
                Object var5_20 = null;
                iProgressMonitor.done();
                return refactoringStatus8;
            }
            iProgressMonitor.worked(1);
            if (!ExtractTempRefactoring.isReferringToLocalVariableFromFor(this.getSelectedExpression().getAssociatedExpression())) break block17;
            RefactoringStatus refactoringStatus9 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_refers_to_for_variable);
            Object var5_21 = null;
            iProgressMonitor.done();
            return refactoringStatus9;
        }
        iProgressMonitor.worked(1);
        RefactoringStatus refactoringStatus10 = refactoringStatus;
        Object var5_22 = null;
        iProgressMonitor.done();
        return refactoringStatus10;
    }

    public RefactoringStatus checkTempName(String string) {
        RefactoringStatus refactoringStatus = Checks.checkTempName(string);
        if (Arrays.asList(this.getExcludedVariableNames()).contains(string)) {
            refactoringStatus.addWarning(Messages.format(RefactoringCoreMessages.ExtractTempRefactoring_another_variable, string));
        }
        return refactoringStatus;
    }

    private void createAndInsertTempDeclaration() throws CoreException {
        Expression expression = this.getSelectedExpression().createCopyTarget(this.fCURewrite.getASTRewrite());
        VariableDeclarationStatement variableDeclarationStatement = this.createTempDeclaration(expression);
        if (!this.fReplaceAllOccurrences || ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments()).length <= 1) {
            this.insertAt(this.getSelectedExpression().getAssociatedNode(), (Statement)variableDeclarationStatement);
            return;
        }
        ASTNode[] aSTNodeArray = ExtractTempRefactoring.getParents(this.getFirstReplacedExpression().getAssociatedNode());
        ASTNode[] aSTNodeArray2 = this.findDeepestCommonSuperNodePathForReplacedNodes();
        Assert.isTrue((aSTNodeArray2.length <= aSTNodeArray.length ? 1 : 0) != 0);
        ASTNode aSTNode = aSTNodeArray[aSTNodeArray2.length - 1];
        if (aSTNode instanceof Block) {
            this.insertAt(aSTNodeArray[aSTNodeArray2.length], (Statement)variableDeclarationStatement);
        } else {
            this.insertAt(aSTNode, (Statement)variableDeclarationStatement);
        }
    }

    private VariableDeclarationStatement createTempDeclaration(Expression expression) throws CoreException {
        AST aST = this.fCURewrite.getAST();
        VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(aST.newSimpleName(this.fTempName));
        variableDeclarationFragment.setInitializer(expression);
        VariableDeclarationStatement variableDeclarationStatement = aST.newVariableDeclarationStatement(variableDeclarationFragment);
        if (this.fLinkedProposalModel != null) {
            ASTRewrite aSTRewrite = this.fCURewrite.getASTRewrite();
            LinkedProposalPositionGroup linkedProposalPositionGroup = this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true);
            linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)variableDeclarationFragment.getName()), true);
            String[] stringArray = this.guessTempNames();
            if (stringArray.length > 0 && !stringArray[0].equals(this.fTempName)) {
                linkedProposalPositionGroup.addProposal(this.fTempName, null, stringArray.length + 1);
            }
            int n = 0;
            while (n < stringArray.length) {
                linkedProposalPositionGroup.addProposal(stringArray[n], null, stringArray.length - n);
                ++n;
            }
        }
        return variableDeclarationStatement;
    }

    private void insertAt(ASTNode aSTNode, Statement statement) throws JavaModelException {
        StructuralPropertyDescriptor structuralPropertyDescriptor;
        ASTRewrite aSTRewrite = this.fCURewrite.getASTRewrite();
        TextEditGroup textEditGroup = this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable);
        ASTNode aSTNode2 = aSTNode.getParent();
        while (!(aSTNode2 instanceof Block)) {
            structuralPropertyDescriptor = aSTNode.getLocationInParent();
            if (structuralPropertyDescriptor == IfStatement.THEN_STATEMENT_PROPERTY || structuralPropertyDescriptor == IfStatement.ELSE_STATEMENT_PROPERTY || structuralPropertyDescriptor == ForStatement.BODY_PROPERTY || structuralPropertyDescriptor == ForInStatement.BODY_PROPERTY || structuralPropertyDescriptor == EnhancedForStatement.BODY_PROPERTY || structuralPropertyDescriptor == DoStatement.BODY_PROPERTY || structuralPropertyDescriptor == WhileStatement.BODY_PROPERTY || structuralPropertyDescriptor == WithStatement.BODY_PROPERTY) {
                Block block = aSTRewrite.getAST().newBlock();
                ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                listRewrite.insertFirst((ASTNode)statement, null);
                listRewrite.insertLast(aSTRewrite.createMoveTarget(aSTNode), null);
                aSTRewrite.replace(aSTNode, (ASTNode)block, textEditGroup);
                return;
            }
            aSTNode = aSTNode2;
            aSTNode2 = aSTNode2.getParent();
        }
        structuralPropertyDescriptor = aSTRewrite.getListRewrite(aSTNode2, Block.STATEMENTS_PROPERTY);
        structuralPropertyDescriptor.insertBefore((ASTNode)statement, aSTNode, textEditGroup);
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringDescriptorChange refactoringDescriptorChange;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.ExtractTempRefactoring_checking_preconditions, 1);
            JDTRefactoringDescriptor jDTRefactoringDescriptor = this.createRefactoringDescriptor();
            refactoringDescriptorChange = new RefactoringDescriptorChange((RefactoringDescriptor)jDTRefactoringDescriptor, RefactoringCoreMessages.ExtractTempRefactoring_extract_temp, new Change[]{this.fChange});
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringDescriptorChange;
    }

    private void createTempDeclaration() throws CoreException {
        if (this.shouldReplaceSelectedExpressionWithTempDeclaration()) {
            this.replaceSelectedExpressionWithTempDeclaration();
        } else {
            this.createAndInsertTempDeclaration();
        }
    }

    public boolean declareFinal() {
        return this.fDeclareFinal;
    }

    private ASTNode[] findDeepestCommonSuperNodePathForReplacedNodes() throws JavaModelException {
        ASTNode[] aSTNodeArray = this.getMatchNodes();
        Object[][] objectArray = new ASTNode[aSTNodeArray.length][];
        int n = 0;
        while (n < aSTNodeArray.length) {
            objectArray[n] = ExtractTempRefactoring.getParents(aSTNodeArray[n]);
            ++n;
        }
        List<Object> list = Arrays.asList(ExtractTempRefactoring.getLongestArrayPrefix(objectArray));
        return list.toArray(new ASTNode[list.size()]);
    }

    private Block getEnclosingBodyNode() throws JavaModelException {
        ASTNode aSTNode = this.getSelectedExpression().getAssociatedNode();
        do {
            switch (aSTNode.getNodeType()) {
                case 31: {
                    return ((MethodDeclaration)aSTNode).getBody();
                }
                case 28: {
                    return ((Initializer)aSTNode).getBody();
                }
            }
        } while ((aSTNode = aSTNode.getParent()) != null);
        return null;
    }

    private String[] getExcludedVariableNames() {
        if (this.fExcludedVariableNames == null) {
            try {
                IBinding[] iBindingArray = new ScopeAnalyzer(this.fCompilationUnitNode).getDeclarationsInScope(this.getSelectedExpression().getStartPosition(), 2);
                this.fExcludedVariableNames = new String[iBindingArray.length];
                int n = 0;
                while (n < iBindingArray.length) {
                    this.fExcludedVariableNames[n] = iBindingArray[n].getName();
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {
                this.fExcludedVariableNames = new String[0];
            }
        }
        return this.fExcludedVariableNames;
    }

    private IExpressionFragment getFirstReplacedExpression() throws JavaModelException {
        if (!this.fReplaceAllOccurrences) {
            return this.getSelectedExpression();
        }
        IASTFragment[] iASTFragmentArray = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        if (iASTFragmentArray.length == 0) {
            return this.getSelectedExpression();
        }
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((IASTFragment)object).getStartPosition() - ((IASTFragment)object2).getStartPosition();
            }
        };
        Arrays.sort(iASTFragmentArray, comparator);
        return (IExpressionFragment)iASTFragmentArray[0];
    }

    private IASTFragment[] getMatchingFragments() throws JavaModelException {
        if (this.fReplaceAllOccurrences) {
            IASTFragment[] iASTFragmentArray = ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)this.getEnclosingBodyNode()).getSubFragmentsMatching(this.getSelectedExpression());
            return iASTFragmentArray;
        }
        return new IASTFragment[]{this.getSelectedExpression()};
    }

    private ASTNode[] getMatchNodes() throws JavaModelException {
        IASTFragment[] iASTFragmentArray = ExtractTempRefactoring.retainOnlyReplacableMatches(this.getMatchingFragments());
        ASTNode[] aSTNodeArray = new ASTNode[iASTFragmentArray.length];
        int n = 0;
        while (n < iASTFragmentArray.length) {
            aSTNodeArray[n] = iASTFragmentArray[n].getAssociatedNode();
            ++n;
        }
        return aSTNodeArray;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractTempRefactoring_name;
    }

    private IExpressionFragment getSelectedExpression() throws JavaModelException {
        if (this.fSelectedExpression != null) {
            return this.fSelectedExpression;
        }
        IASTFragment iASTFragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fCompilationUnitNode, this.fCu);
        if (iASTFragment instanceof IExpressionFragment && !Checks.isInsideJavadoc(iASTFragment.getAssociatedNode())) {
            this.fSelectedExpression = (IExpressionFragment)iASTFragment;
        } else if (iASTFragment != null) {
            if (iASTFragment.getAssociatedNode() instanceof ExpressionStatement) {
                ExpressionStatement expressionStatement = (ExpressionStatement)iASTFragment.getAssociatedNode();
                Expression expression = expressionStatement.getExpression();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)expression);
            } else if (iASTFragment.getAssociatedNode() instanceof Assignment) {
                Assignment assignment = (Assignment)iASTFragment.getAssociatedNode();
                this.fSelectedExpression = (IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)assignment);
            }
        }
        if (this.fSelectedExpression != null && Checks.isEnumCase(this.fSelectedExpression.getAssociatedExpression().getParent())) {
            this.fSelectedExpression = null;
        }
        return this.fSelectedExpression;
    }

    private Type createTempType() throws CoreException {
        Expression expression = this.getSelectedExpression().getAssociatedExpression();
        Type type = null;
        ITypeBinding iTypeBinding = expression.resolveTypeBinding();
        ASTRewrite aSTRewrite = this.fCURewrite.getASTRewrite();
        AST aST = aSTRewrite.getAST();
        if (expression instanceof ClassInstanceCreation) {
            type = (Type)aSTRewrite.createCopyTarget((ASTNode)((ClassInstanceCreation)expression).getType());
        } else if (expression instanceof CastExpression) {
            type = (Type)aSTRewrite.createCopyTarget((ASTNode)((CastExpression)expression).getType());
        } else {
            if (iTypeBinding == null) {
                iTypeBinding = ASTResolving.guessBindingForReference((ASTNode)expression);
            }
            if (iTypeBinding != null) {
                iTypeBinding = Bindings.normalizeForDeclarationUse(iTypeBinding, aST);
                type = this.fCURewrite.getImportRewrite().addImport(iTypeBinding, aST);
            } else {
                type = aST.newSimpleType((Name)aST.newSimpleName("Object"));
            }
        }
        if (this.fLinkedProposalModel != null) {
            LinkedProposalPositionGroup linkedProposalPositionGroup = this.fLinkedProposalModel.getPositionGroup(KEY_TYPE, true);
            linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)type), false);
            if (iTypeBinding != null) {
                ITypeBinding[] iTypeBindingArray = ASTResolving.getNarrowingTypes(aST, iTypeBinding);
                int n = 0;
                while (n < iTypeBindingArray.length) {
                    linkedProposalPositionGroup.addProposal(iTypeBindingArray[n], this.fCURewrite.getCu(), iTypeBindingArray.length - n);
                    ++n;
                }
            }
        }
        return type;
    }

    public String guessTempName() {
        String[] stringArray = this.guessTempNames();
        if (stringArray.length == 0) {
            return this.fTempName;
        }
        return stringArray[0];
    }

    public String[] guessTempNames() {
        if (this.fGuessedTempNames == null) {
            try {
                Expression expression = this.getSelectedExpression().getAssociatedExpression();
                if (expression != null) {
                    ITypeBinding iTypeBinding = expression.resolveTypeBinding();
                    this.fGuessedTempNames = StubUtility.getVariableNameSuggestions(5, this.fCu.getJavaProject(), iTypeBinding, expression, Arrays.asList(this.getExcludedVariableNames()));
                }
            }
            catch (JavaModelException javaModelException) {}
            if (this.fGuessedTempNames == null) {
                this.fGuessedTempNames = new String[0];
            }
        }
        return this.fGuessedTempNames;
    }

    private boolean isLiteralNodeSelected() throws JavaModelException {
        IExpressionFragment iExpressionFragment = this.getSelectedExpression();
        if (iExpressionFragment == null) {
            return false;
        }
        Expression expression = iExpressionFragment.getAssociatedExpression();
        if (expression == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 9: 
            case 13: 
            case 33: 
            case 34: 
            case 87: 
            case 88: {
                return true;
            }
        }
        return false;
    }

    private boolean isUsedInExplicitConstructorCall() throws JavaModelException {
        Expression expression = this.getSelectedExpression().getAssociatedExpression();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.ConstructorInvocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ASTNodes.getParent((ASTNode)expression, clazz) != null) {
            return true;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTNodes.getParent((ASTNode)expression, clazz2) != null;
    }

    public boolean replaceAllOccurrences() {
        return this.fReplaceAllOccurrences;
    }

    private void replaceSelectedExpressionWithTempDeclaration() throws CoreException {
        ASTRewrite aSTRewrite = this.fCURewrite.getASTRewrite();
        Expression expression = this.getSelectedExpression().getAssociatedExpression();
        Expression expression2 = (Expression)aSTRewrite.createMoveTarget((ASTNode)expression);
        VariableDeclarationStatement variableDeclarationStatement = this.createTempDeclaration(expression2);
        ExpressionStatement expressionStatement = (ExpressionStatement)expression.getParent();
        if (ASTNodes.isControlStatementBody(expressionStatement.getLocationInParent())) {
            Block block = aSTRewrite.getAST().newBlock();
            block.statements().add(variableDeclarationStatement);
            variableDeclarationStatement = block;
        }
        aSTRewrite.replace((ASTNode)expressionStatement, (ASTNode)variableDeclarationStatement, this.fCURewrite.createGroupDescription(RefactoringCoreMessages.ExtractTempRefactoring_declare_local_variable));
    }

    public void setDeclareFinal(boolean bl) {
        this.fDeclareFinal = bl;
    }

    public void setReplaceAllOccurrences(boolean bl) {
        this.fReplaceAllOccurrences = bl;
    }

    public void setTempName(String string) {
        this.fTempName = string;
    }

    private boolean shouldReplaceSelectedExpressionWithTempDeclaration() throws JavaModelException {
        IExpressionFragment iExpressionFragment = this.getSelectedExpression();
        return iExpressionFragment.getAssociatedNode().getParent() instanceof ExpressionStatement && iExpressionFragment.matches(ASTFragmentFactory.createFragmentForFullSubtree(iExpressionFragment.getAssociatedNode()));
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            Object object;
            Object object2;
            int n;
            int n2;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string2 = javaRefactoringArguments.getAttribute("selection");
            if (string2 != null) {
                n2 = -1;
                n = -1;
                object2 = new StringTokenizer(string2);
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    n2 = Integer.valueOf(((StringTokenizer)object2).nextToken());
                }
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    n = Integer.valueOf(((StringTokenizer)object2).nextToken());
                }
                if (n2 < 0 || n < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string2, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = n2;
            this.fSelectionLength = n;
            String string3 = javaRefactoringArguments.getAttribute("input");
            if (string3 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string3, false);
                if (object == null || !object.exists() || object.getElementType() != 5) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.extract.temp");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (ICompilationUnit)object;
            object = javaRefactoringArguments.getAttribute(KEY_NAME);
            if (object == null || "".equals(object)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, KEY_NAME));
            }
            this.fTempName = object;
            object2 = javaRefactoringArguments.getAttribute(ATTRIBUTE_REPLACE);
            if (object2 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
            }
            this.fReplaceAllOccurrences = Boolean.valueOf((String)object2);
            string = javaRefactoringArguments.getAttribute(ATTRIBUTE_FINAL);
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fDeclareFinal = Boolean.valueOf(string);
        return new RefactoringStatus();
    }

    private static final class ForStatementChecker
    extends ASTVisitor {
        private final Collection fForInitializerVariables;
        private boolean fReferringToForVariable = false;

        public ForStatementChecker(Collection collection) {
            Assert.isNotNull((Object)collection);
            this.fForInitializerVariables = collection;
        }

        public boolean isReferringToForVariable() {
            return this.fReferringToForVariable;
        }

        public boolean visit(SimpleName simpleName) {
            IBinding iBinding = simpleName.resolveBinding();
            if (iBinding != null && this.fForInitializerVariables.contains(iBinding)) {
                this.fReferringToForVariable = true;
            }
            return false;
        }
    }
}

