/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;

public class InOutFlowAnalyzer
extends FlowAnalyzer {
    public InOutFlowAnalyzer(FlowContext flowContext) {
        super(flowContext);
    }

    public FlowInfo perform(ASTNode[] aSTNodeArray) {
        FlowContext flowContext = this.getFlowContext();
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential();
        int n = 0;
        while (n < aSTNodeArray.length) {
            ASTNode aSTNode = aSTNodeArray[n];
            aSTNode.accept((ASTVisitor)this);
            genericSequentialFlowInfo.merge(this.getFlowInfo(aSTNode), flowContext);
            ++n;
        }
        return genericSequentialFlowInfo;
    }

    protected boolean traverseNode(ASTNode aSTNode) {
        return true;
    }

    protected boolean createReturnFlowInfo(ReturnStatement returnStatement) {
        return true;
    }

    public void endVisit(Block block) {
        super.endVisit(block);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)block), block.statements());
    }

    public void endVisit(CatchClause catchClause) {
        super.endVisit(catchClause);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)catchClause), catchClause.getException());
    }

    public void endVisit(EnhancedForStatement enhancedForStatement) {
        super.endVisit(enhancedForStatement);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)enhancedForStatement), enhancedForStatement.getParameter());
    }

    public void endVisit(ForStatement forStatement) {
        super.endVisit(forStatement);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)forStatement), forStatement.initializers());
    }

    public void endVisit(ForInStatement forInStatement) {
        super.endVisit(forInStatement);
        if (forInStatement.getIterationVariable() instanceof VariableDeclarationStatement) {
            this.clearAccessMode(this.accessFlowInfo((ASTNode)forInStatement), (VariableDeclarationStatement)forInStatement.getIterationVariable());
        }
    }

    public void endVisit(MethodDeclaration methodDeclaration) {
        super.endVisit(methodDeclaration);
        FlowInfo flowInfo = this.accessFlowInfo((ASTNode)methodDeclaration);
        Iterator iterator = methodDeclaration.parameters().iterator();
        while (iterator.hasNext()) {
            this.clearAccessMode(flowInfo, (SingleVariableDeclaration)iterator.next());
        }
    }

    private void clearAccessMode(FlowInfo flowInfo, SingleVariableDeclaration singleVariableDeclaration) {
        IVariableBinding iVariableBinding = singleVariableDeclaration.resolveBinding();
        if (iVariableBinding != null && !iVariableBinding.isField()) {
            flowInfo.clearAccessMode(iVariableBinding, this.fFlowContext);
        }
    }

    private void clearAccessMode(FlowInfo flowInfo, VariableDeclarationStatement variableDeclarationStatement) {
        IVariableBinding iVariableBinding = variableDeclarationStatement.resolveBinding();
        if (iVariableBinding != null && !iVariableBinding.isField()) {
            flowInfo.clearAccessMode(iVariableBinding, this.fFlowContext);
        }
    }

    private void clearAccessMode(FlowInfo flowInfo, List list) {
        if (list == null || list.isEmpty() || flowInfo == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Iterator iterator2 = null;
            if (e instanceof VariableDeclarationStatement) {
                iterator2 = ((VariableDeclarationStatement)e).fragments().iterator();
            } else if (e instanceof VariableDeclarationExpression) {
                iterator2 = ((VariableDeclarationExpression)e).fragments().iterator();
            }
            if (iterator2 == null) continue;
            while (iterator2.hasNext()) {
                this.clearAccessMode(flowInfo, (VariableDeclarationFragment)iterator2.next());
            }
        }
    }

    private void clearAccessMode(FlowInfo flowInfo, VariableDeclarationFragment variableDeclarationFragment) {
        IVariableBinding iVariableBinding = variableDeclarationFragment.resolveBinding();
        if (iVariableBinding != null && !iVariableBinding.isField()) {
            flowInfo.clearAccessMode(iVariableBinding, this.fFlowContext);
        }
    }
}

