/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.EnhancedForFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.GenericConditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;

public class InputFlowAnalyzer
extends FlowAnalyzer {
    private Selection fSelection;
    private boolean fDoLoopReentrance;
    private LoopReentranceVisitor fLoopReentranceVisitor;

    public InputFlowAnalyzer(FlowContext flowContext, Selection selection, boolean bl) {
        super(flowContext);
        this.fSelection = selection;
        Assert.isNotNull((Object)this.fSelection);
        this.fDoLoopReentrance = bl;
    }

    public FlowInfo perform(BodyDeclaration bodyDeclaration) {
        Assert.isTrue((!(bodyDeclaration instanceof AbstractTypeDeclaration) ? 1 : 0) != 0);
        bodyDeclaration.accept((ASTVisitor)this);
        return this.getFlowInfo((ASTNode)bodyDeclaration);
    }

    protected boolean traverseNode(ASTNode aSTNode) {
        return aSTNode.getStartPosition() + aSTNode.getLength() > this.fSelection.getInclusiveEnd();
    }

    protected boolean createReturnFlowInfo(ReturnStatement returnStatement) {
        return returnStatement.getStartPosition() >= this.fSelection.getInclusiveEnd();
    }

    public boolean visit(DoStatement doStatement) {
        this.createLoopReentranceVisitor((ASTNode)doStatement);
        return super.visit(doStatement);
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        this.createLoopReentranceVisitor((ASTNode)enhancedForStatement);
        return super.visit(enhancedForStatement);
    }

    public boolean visit(ForStatement forStatement) {
        this.createLoopReentranceVisitor((ASTNode)forStatement);
        return super.visit(forStatement);
    }

    public boolean visit(ForInStatement forInStatement) {
        this.createLoopReentranceVisitor((ASTNode)forInStatement);
        return super.visit(forInStatement);
    }

    public boolean visit(WhileStatement whileStatement) {
        this.createLoopReentranceVisitor((ASTNode)whileStatement);
        return super.visit(whileStatement);
    }

    private void createLoopReentranceVisitor(ASTNode aSTNode) {
        if (this.fLoopReentranceVisitor == null && this.fDoLoopReentrance) {
            this.fLoopReentranceVisitor = new LoopReentranceVisitor(this.fFlowContext, this.fSelection, aSTNode);
        }
    }

    public void endVisit(ConditionalExpression conditionalExpression) {
        if (this.skipNode((ASTNode)conditionalExpression)) {
            return;
        }
        Expression expression = conditionalExpression.getThenExpression();
        Expression expression2 = conditionalExpression.getElseExpression();
        if (expression != null && this.fSelection.coveredBy((ASTNode)expression) || expression2 != null && this.fSelection.coveredBy((ASTNode)expression2)) {
            GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential();
            this.setFlowInfo((ASTNode)conditionalExpression, genericSequentialFlowInfo);
            this.endVisitConditional(genericSequentialFlowInfo, (ASTNode)conditionalExpression.getExpression(), new ASTNode[]{expression, expression2});
        } else {
            super.endVisit(conditionalExpression);
        }
    }

    public void endVisit(DoStatement doStatement) {
        super.endVisit(doStatement);
        this.handleLoopReentrance((ASTNode)doStatement);
    }

    public void endVisit(IfStatement ifStatement) {
        if (this.skipNode((ASTNode)ifStatement)) {
            return;
        }
        Statement statement = ifStatement.getThenStatement();
        Statement statement2 = ifStatement.getElseStatement();
        if (statement != null && this.fSelection.coveredBy((ASTNode)statement) || statement2 != null && this.fSelection.coveredBy((ASTNode)statement2)) {
            GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential();
            this.setFlowInfo((ASTNode)ifStatement, genericSequentialFlowInfo);
            this.endVisitConditional(genericSequentialFlowInfo, (ASTNode)ifStatement.getExpression(), new ASTNode[]{statement, statement2});
        } else {
            super.endVisit(ifStatement);
        }
    }

    public void endVisit(EnhancedForStatement enhancedForStatement) {
        super.endVisit(enhancedForStatement);
        this.handleLoopReentrance((ASTNode)enhancedForStatement);
    }

    public void endVisit(ForStatement forStatement) {
        super.endVisit(forStatement);
        this.handleLoopReentrance((ASTNode)forStatement);
    }

    public void endVisit(ForInStatement forInStatement) {
        super.endVisit(forInStatement);
        this.handleLoopReentrance((ASTNode)forInStatement);
    }

    public void endVisit(SwitchStatement switchStatement) {
        if (this.skipNode((ASTNode)switchStatement)) {
            return;
        }
        FlowAnalyzer.SwitchData switchData = this.createSwitchData(switchStatement);
        IRegion[] iRegionArray = switchData.getRanges();
        int n = 0;
        while (n < iRegionArray.length) {
            IRegion iRegion = iRegionArray[n];
            if (this.fSelection.coveredBy(iRegion)) {
                GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential();
                this.setFlowInfo((ASTNode)switchStatement, genericSequentialFlowInfo);
                genericSequentialFlowInfo.merge(this.getFlowInfo((ASTNode)switchStatement.getExpression()), this.fFlowContext);
                genericSequentialFlowInfo.merge(switchData.getInfo(n), this.fFlowContext);
                genericSequentialFlowInfo.removeLabel(null);
                return;
            }
            ++n;
        }
        super.endVisit(switchStatement, switchData);
    }

    public void endVisit(WhileStatement whileStatement) {
        super.endVisit(whileStatement);
        this.handleLoopReentrance((ASTNode)whileStatement);
    }

    private void endVisitConditional(GenericSequentialFlowInfo genericSequentialFlowInfo, ASTNode aSTNode, ASTNode[] aSTNodeArray) {
        genericSequentialFlowInfo.merge(this.getFlowInfo(aSTNode), this.fFlowContext);
        int n = 0;
        while (n < aSTNodeArray.length) {
            ASTNode aSTNode2 = aSTNodeArray[n];
            if (aSTNode2 != null && this.fSelection.coveredBy(aSTNode2)) {
                genericSequentialFlowInfo.merge(this.getFlowInfo(aSTNode2), this.fFlowContext);
                break;
            }
            ++n;
        }
    }

    private void handleLoopReentrance(ASTNode aSTNode) {
        if (!this.fSelection.coveredBy(aSTNode) || this.fLoopReentranceVisitor == null || this.fLoopReentranceVisitor.getLoopNode() != aSTNode) {
            return;
        }
        this.fLoopReentranceVisitor.process(aSTNode);
        GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential();
        genericSequentialFlowInfo.merge(this.getFlowInfo(aSTNode), this.fFlowContext);
        genericSequentialFlowInfo.merge(this.fLoopReentranceVisitor.getFlowInfo(aSTNode), this.fFlowContext);
        this.setFlowInfo(aSTNode, genericSequentialFlowInfo);
    }

    private static class LoopReentranceVisitor
    extends FlowAnalyzer {
        private Selection fSelection;
        private ASTNode fLoopNode;

        public LoopReentranceVisitor(FlowContext flowContext, Selection selection, ASTNode aSTNode) {
            super(flowContext);
            this.fSelection = selection;
            this.fLoopNode = aSTNode;
        }

        protected boolean traverseNode(ASTNode aSTNode) {
            return true;
        }

        protected boolean createReturnFlowInfo(ReturnStatement returnStatement) {
            return returnStatement.getStartPosition() + returnStatement.getLength() <= this.fSelection.getExclusiveEnd();
        }

        protected ASTNode getLoopNode() {
            return this.fLoopNode;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void process(ASTNode aSTNode) {
            try {
                this.fFlowContext.setLoopReentranceMode(true);
                aSTNode.accept((ASTVisitor)this);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fFlowContext.setLoopReentranceMode(false);
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.fFlowContext.setLoopReentranceMode(false);
                return;
            }
        }

        public void endVisit(DoStatement doStatement) {
            if (this.skipNode((ASTNode)doStatement)) {
                return;
            }
            DoWhileFlowInfo doWhileFlowInfo = this.createDoWhile();
            this.setFlowInfo((ASTNode)doStatement, doWhileFlowInfo);
            doWhileFlowInfo.mergeAction(this.getFlowInfo((ASTNode)doStatement.getBody()), this.fFlowContext);
            doWhileFlowInfo.removeLabel(null);
        }

        public void endVisit(ForInStatement forInStatement) {
            if (this.skipNode((ASTNode)forInStatement)) {
                return;
            }
            FlowInfo flowInfo = this.getFlowInfo((ASTNode)forInStatement.getIterationVariable());
            FlowInfo flowInfo2 = this.getFlowInfo((ASTNode)forInStatement.getCollection());
            FlowInfo flowInfo3 = this.getFlowInfo((ASTNode)forInStatement.getBody());
            EnhancedForFlowInfo enhancedForFlowInfo = this.createEnhancedFor();
            this.setFlowInfo((ASTNode)forInStatement, enhancedForFlowInfo);
            if (forInStatement == this.fLoopNode) {
                enhancedForFlowInfo.mergeAction(flowInfo3, this.fFlowContext);
            } else {
                enhancedForFlowInfo.mergeExpression(flowInfo2, this.fFlowContext);
                enhancedForFlowInfo.mergeParameter(flowInfo, this.fFlowContext);
                enhancedForFlowInfo.mergeAction(flowInfo3, this.fFlowContext);
            }
            enhancedForFlowInfo.removeLabel(null);
        }

        public void endVisit(EnhancedForStatement enhancedForStatement) {
            if (this.skipNode((ASTNode)enhancedForStatement)) {
                return;
            }
            FlowInfo flowInfo = this.getFlowInfo((ASTNode)enhancedForStatement.getParameter());
            FlowInfo flowInfo2 = this.getFlowInfo((ASTNode)enhancedForStatement.getExpression());
            FlowInfo flowInfo3 = this.getFlowInfo((ASTNode)enhancedForStatement.getBody());
            EnhancedForFlowInfo enhancedForFlowInfo = this.createEnhancedFor();
            this.setFlowInfo((ASTNode)enhancedForStatement, enhancedForFlowInfo);
            if (enhancedForStatement == this.fLoopNode) {
                enhancedForFlowInfo.mergeAction(flowInfo3, this.fFlowContext);
            } else {
                enhancedForFlowInfo.mergeExpression(flowInfo2, this.fFlowContext);
                enhancedForFlowInfo.mergeParameter(flowInfo, this.fFlowContext);
                enhancedForFlowInfo.mergeAction(flowInfo3, this.fFlowContext);
            }
            enhancedForFlowInfo.removeLabel(null);
        }

        public void endVisit(ForStatement forStatement) {
            if (this.skipNode((ASTNode)forStatement)) {
                return;
            }
            GenericSequentialFlowInfo genericSequentialFlowInfo = this.createSequential(forStatement.initializers());
            FlowInfo flowInfo = this.getFlowInfo((ASTNode)forStatement.getExpression());
            GenericSequentialFlowInfo genericSequentialFlowInfo2 = this.createSequential(forStatement.updaters());
            FlowInfo flowInfo2 = this.getFlowInfo((ASTNode)forStatement.getBody());
            ForFlowInfo forFlowInfo = this.createFor();
            this.setFlowInfo((ASTNode)forStatement, forFlowInfo);
            if (forStatement == this.fLoopNode) {
                forFlowInfo.mergeIncrement(genericSequentialFlowInfo2, this.fFlowContext);
                forFlowInfo.mergeCondition(flowInfo, this.fFlowContext);
                forFlowInfo.mergeAction(flowInfo2, this.fFlowContext);
            } else {
                GenericConditionalFlowInfo genericConditionalFlowInfo = new GenericConditionalFlowInfo();
                genericConditionalFlowInfo.merge(genericSequentialFlowInfo, this.fFlowContext);
                genericConditionalFlowInfo.merge(genericSequentialFlowInfo2, this.fFlowContext);
                forFlowInfo.mergeAccessModeSequential(genericConditionalFlowInfo, this.fFlowContext);
                forFlowInfo.mergeCondition(flowInfo, this.fFlowContext);
                forFlowInfo.mergeAction(flowInfo2, this.fFlowContext);
            }
            forFlowInfo.removeLabel(null);
        }
    }
}

