/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.delegates;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;

public abstract class DelegateCreator {
    public static final GroupCategorySet CATEGORY_DELEGATE = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.delegate", RefactoringCoreMessages.DelegateCreator_change_category_title, RefactoringCoreMessages.DelegateCreator_change_category_description));
    private CompilationUnitRewrite fOriginalRewrite;
    private CompilationUnitRewrite fDelegateRewrite;
    private boolean fIsMoveToAnotherFile;
    private boolean fCopy = true;
    private boolean fDeclareDeprecated = true;
    private boolean fInsertBefore = false;
    private BodyDeclaration fDeclaration;
    private String fNewElementName;
    private ITypeBinding fDestinationTypeBinding;
    private Type fDestinationType;
    private ITrackedNodePosition fTrackedPosition;
    private CodeGenerationSettings fPreferences;

    public void setSourceRewrite(CompilationUnitRewrite compilationUnitRewrite) {
        this.fOriginalRewrite = compilationUnitRewrite;
        this.fPreferences = JavaPreferencesSettings.getCodeGenerationSettings(compilationUnitRewrite.getCu().getJavaProject());
        this.fDelegateRewrite = new CompilationUnitRewrite(compilationUnitRewrite.getCu(), compilationUnitRewrite.getRoot());
        this.fDelegateRewrite.getASTRewrite().setTargetSourceRangeComputer(compilationUnitRewrite.getASTRewrite().getExtendedSourceRangeComputer());
    }

    public void setDeclaration(BodyDeclaration bodyDeclaration) {
        this.fDeclaration = bodyDeclaration;
    }

    public void setNewElementName(String string) {
        this.fNewElementName = string;
    }

    public void setNewLocation(ITypeBinding iTypeBinding) {
        this.fDestinationTypeBinding = iTypeBinding;
    }

    public void setCopy(boolean bl) {
        this.fCopy = bl;
    }

    public void setDeclareDeprecated(boolean bl) {
        this.fDeclareDeprecated = bl;
    }

    public void setInsertBefore(boolean bl) {
        this.fInsertBefore = bl;
    }

    protected abstract void initialize();

    protected abstract ASTNode createBody(BodyDeclaration var1) throws JavaModelException;

    protected abstract ASTNode createDocReference(BodyDeclaration var1) throws JavaModelException;

    protected abstract ASTNode getBodyHead(BodyDeclaration var1);

    protected abstract ChildPropertyDescriptor getJavaDocProperty();

    protected abstract ChildPropertyDescriptor getBodyProperty();

    protected boolean isMoveToAnotherFile() {
        return this.fIsMoveToAnotherFile;
    }

    protected AST getAst() {
        return this.fDelegateRewrite.getAST();
    }

    protected BodyDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    protected String getNewElementName() {
        return this.fNewElementName;
    }

    public void prepareDelegate() throws JavaModelException {
        Assert.isNotNull((Object)this.fDelegateRewrite);
        Assert.isNotNull((Object)this.fDeclaration);
        this.initialize();
        if (this.fDestinationTypeBinding != null) {
            this.fDestinationType = this.fOriginalRewrite.getImportRewrite().addImport(this.fDestinationTypeBinding, this.getAst());
            this.fIsMoveToAnotherFile = true;
        } else {
            this.fIsMoveToAnotherFile = false;
        }
        this.fTrackedPosition = this.fDelegateRewrite.getASTRewrite().track((ASTNode)this.fDeclaration);
        ASTNode aSTNode = this.createBody(this.fDeclaration);
        if (aSTNode != null) {
            this.fDelegateRewrite.getASTRewrite().set(this.getBodyHead(this.fDeclaration), (StructuralPropertyDescriptor)this.getBodyProperty(), (Object)aSTNode, null);
        }
        if (this.fDeclareDeprecated) {
            this.createJavadoc();
        }
    }

    private void createJavadoc() throws JavaModelException {
        TagElement tagElement = this.getDelegateJavadocTag(this.fDeclaration);
        Javadoc javadoc = this.fDeclaration.getJavadoc();
        if (javadoc == null) {
            javadoc = this.getAst().newJavadoc();
            javadoc.tags().add(tagElement);
            this.fDelegateRewrite.getASTRewrite().set((ASTNode)this.fDeclaration, (StructuralPropertyDescriptor)this.getJavaDocProperty(), (Object)javadoc, null);
        } else {
            this.fDelegateRewrite.getASTRewrite().getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY).insertLast((ASTNode)tagElement, null);
        }
    }

    public void createEdit() throws JavaModelException {
        try {
            Document document = new Document(this.fDelegateRewrite.getCu().getBuffer().getContents());
            TextEdit textEdit = this.fDelegateRewrite.getASTRewrite().rewriteAST((IDocument)document, this.fDelegateRewrite.getCu().getJavaProject().getOptions(true));
            textEdit.apply((IDocument)document, 2);
            String string = Strings.trimIndentation(document.get(this.fTrackedPosition.getStartPosition(), this.fTrackedPosition.getLength()), this.fPreferences.tabWidth, this.fPreferences.indentWidth, false);
            ASTNode aSTNode = this.fOriginalRewrite.getASTRewrite().createStringPlaceholder(string, this.fDeclaration.getNodeType());
            CategorizedTextEditGroup categorizedTextEditGroup = this.fOriginalRewrite.createCategorizedGroupDescription(this.getTextEditGroupLabel(), CATEGORY_DELEGATE);
            ListRewrite listRewrite = this.fOriginalRewrite.getASTRewrite().getListRewrite(this.fDeclaration.getParent(), this.getTypeBodyDeclarationsProperty());
            if (this.fCopy) {
                if (this.fInsertBefore) {
                    listRewrite.insertBefore(aSTNode, (ASTNode)this.fDeclaration, (TextEditGroup)categorizedTextEditGroup);
                } else {
                    listRewrite.insertAfter(aSTNode, (ASTNode)this.fDeclaration, (TextEditGroup)categorizedTextEditGroup);
                }
            } else {
                listRewrite.replace((ASTNode)this.fDeclaration, aSTNode, (TextEditGroup)categorizedTextEditGroup);
            }
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    protected abstract String getTextEditGroupLabel();

    protected abstract IBinding getDeclarationBinding();

    public CompilationUnitRewrite getDelegateRewrite() {
        return this.fDelegateRewrite;
    }

    private TagElement getDelegateJavadocTag(BodyDeclaration bodyDeclaration) throws JavaModelException {
        Assert.isNotNull((Object)bodyDeclaration);
        String string = RefactoringCoreMessages.DelegateCreator_use_member_instead;
        int n = string.indexOf("{0}");
        Assert.isTrue((n != -1 ? 1 : 0) != 0);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TextElement textElement = this.getAst().newTextElement();
        textElement.setText(string.substring(0, n).trim());
        arrayList.add(textElement);
        arrayList.add(this.createJavadocMemberReferenceTag(bodyDeclaration, this.getAst()));
        textElement = this.getAst().newTextElement();
        textElement.setText(string.substring(n + 3).trim());
        arrayList.add(textElement);
        TagElement tagElement = this.getAst().newTagElement();
        tagElement.setTagName("@deprecated");
        tagElement.fragments().addAll(arrayList);
        return tagElement;
    }

    private TagElement createJavadocMemberReferenceTag(BodyDeclaration bodyDeclaration, AST aST) throws JavaModelException {
        Assert.isNotNull((Object)aST);
        Assert.isNotNull((Object)bodyDeclaration);
        ASTNode aSTNode = this.createDocReference(bodyDeclaration);
        TagElement tagElement = aST.newTagElement();
        tagElement.setTagName("@link");
        tagElement.fragments().add(aSTNode);
        return tagElement;
    }

    protected Expression getAccess() {
        return this.isMoveToAnotherFile() ? this.createDestinationTypeName() : null;
    }

    protected Name createDestinationTypeName() {
        return ASTNodeFactory.newName(this.getAst(), ASTNodes.asString((ASTNode)this.fDestinationType));
    }

    private ChildListPropertyDescriptor getTypeBodyDeclarationsProperty() {
        ASTNode aSTNode = this.fDeclaration.getParent();
        if (aSTNode instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)aSTNode).getBodyDeclarationsProperty();
        }
        if (aSTNode instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }
}

