/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.generics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsTCModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsUpdate;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.ParametricStructureComputer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ArrayElementVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ArrayTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CollectionElementVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraint2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.IndependentTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;

public class InferTypeArgumentsConstraintsSolver {
    private static final String CHOSEN_TYPE = "chosenType";
    private final InferTypeArgumentsTCModel fTCModel;
    private TypeSetEnvironment fTypeSetEnvironment;
    private LinkedList fWorkList;
    private InferTypeArgumentsUpdate fUpdate;
    private static final int MAX_CACHE = 1024;
    private Map fInterfaceTaggingCache = new LinkedHashMap(1024, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 1024;
        }
    };

    public InferTypeArgumentsConstraintsSolver(InferTypeArgumentsTCModel inferTypeArgumentsTCModel) {
        this.fTCModel = inferTypeArgumentsTCModel;
        this.fWorkList = new LinkedList();
    }

    public InferTypeArgumentsUpdate solveConstraints(IProgressMonitor iProgressMonitor) {
        Object object;
        TypeEquivalenceSet typeEquivalenceSet;
        iProgressMonitor.beginTask("", 2);
        this.fUpdate = new InferTypeArgumentsUpdate();
        ConstraintVariable2[] constraintVariable2Array = this.fTCModel.getAllConstraintVariables();
        if (constraintVariable2Array.length == 0) {
            return this.fUpdate;
        }
        this.fTypeSetEnvironment = new TypeSetEnvironment(this.fTCModel.getTypeEnvironment());
        ParametricStructureComputer parametricStructureComputer = new ParametricStructureComputer(constraintVariable2Array, this.fTCModel);
        Collection collection = parametricStructureComputer.createElemConstraintVariables();
        ArrayList<ConstraintVariable2> arrayList = new ArrayList<ConstraintVariable2>();
        arrayList.addAll(Arrays.asList(constraintVariable2Array));
        arrayList.addAll(collection);
        constraintVariable2Array = arrayList.toArray(new ConstraintVariable2[arrayList.size()]);
        HashSet<TypeEquivalenceSet> hashSet = new HashSet<TypeEquivalenceSet>();
        int n = 0;
        while (n < constraintVariable2Array.length) {
            typeEquivalenceSet = constraintVariable2Array[n].getTypeEquivalenceSet();
            if (typeEquivalenceSet != null) {
                hashSet.add(typeEquivalenceSet);
            }
            ++n;
        }
        ITypeConstraint2[] iTypeConstraint2Array = hashSet.iterator();
        while (iTypeConstraint2Array.hasNext()) {
            typeEquivalenceSet = (TypeEquivalenceSet)iTypeConstraint2Array.next();
            object = typeEquivalenceSet.getContributingVariables();
            int n2 = 0;
            while (n2 < ((ConstraintVariable2[])object).length) {
                int n3 = n2 + 1;
                while (n3 < ((Object)object).length) {
                    Object object2 = object[n2];
                    Object object3 = object[n3];
                    this.fTCModel.createElementEqualsConstraints((ConstraintVariable2)object2, (ConstraintVariable2)object3);
                    ++n3;
                }
                ++n2;
            }
        }
        iTypeConstraint2Array = this.fTCModel.getAllTypeConstraints();
        int n4 = 0;
        while (n4 < iTypeConstraint2Array.length) {
            object = iTypeConstraint2Array[n4];
            this.fTCModel.createElementEqualsConstraints(object.getLeft(), object.getRight());
            ++n4;
        }
        this.initializeTypeEstimates(constraintVariable2Array);
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fWorkList.addAll(Arrays.asList(constraintVariable2Array));
        this.runSolver(new SubProgressMonitor(iProgressMonitor, 1));
        this.chooseTypes(constraintVariable2Array, new SubProgressMonitor(iProgressMonitor, 1));
        this.findCastsToRemove(this.fTCModel.getCastVariables());
        return this.fUpdate;
    }

    private void initializeTypeEstimates(ConstraintVariable2[] constraintVariable2Array) {
        int n = 0;
        while (n < constraintVariable2Array.length) {
            ConstraintVariable2 constraintVariable2 = constraintVariable2Array[n];
            TypeEquivalenceSet typeEquivalenceSet = constraintVariable2.getTypeEquivalenceSet();
            if (typeEquivalenceSet == null) {
                typeEquivalenceSet = new TypeEquivalenceSet(constraintVariable2);
                typeEquivalenceSet.setTypeEstimate(this.createInitialEstimate(constraintVariable2));
                constraintVariable2.setTypeEquivalenceSet(typeEquivalenceSet);
            } else {
                TypeSet typeSet = (TypeSet)constraintVariable2.getTypeEstimate();
                if (typeSet == null) {
                    ConstraintVariable2[] constraintVariable2Array2 = typeEquivalenceSet.getContributingVariables();
                    typeSet = this.fTypeSetEnvironment.getUniverseTypeSet();
                    int n2 = 0;
                    while (n2 < constraintVariable2Array2.length) {
                        typeSet = typeSet.intersectedWith(this.createInitialEstimate(constraintVariable2Array2[n2]));
                        ++n2;
                    }
                    typeEquivalenceSet.setTypeEstimate(typeSet);
                }
            }
            ++n;
        }
    }

    private TypeSet createInitialEstimate(ConstraintVariable2 constraintVariable2) {
        TType tType = constraintVariable2.getType();
        if (tType == null) {
            return this.fTypeSetEnvironment.getUniverseTypeSet();
        }
        if (constraintVariable2 instanceof IndependentTypeVariable2) {
            return this.fTypeSetEnvironment.getUniverseTypeSet();
        }
        if (constraintVariable2 instanceof ArrayTypeVariable2) {
            return this.fTypeSetEnvironment.getUniverseTypeSet();
        }
        if (constraintVariable2 instanceof ArrayElementVariable2) {
            if (constraintVariable2.getType() != null && constraintVariable2.getType().isTypeVariable()) {
                return this.fTypeSetEnvironment.getUniverseTypeSet();
            }
            return new SingletonTypeSet(tType, this.fTypeSetEnvironment);
        }
        if (tType.isVoidType()) {
            return this.fTypeSetEnvironment.getEmptyTypeSet();
        }
        return new SingletonTypeSet(tType, this.fTypeSetEnvironment);
    }

    private void runSolver(SubProgressMonitor subProgressMonitor) {
        subProgressMonitor.beginTask("", this.fWorkList.size() * 3);
        while (!this.fWorkList.isEmpty()) {
            ConstraintVariable2 constraintVariable2 = (ConstraintVariable2)this.fWorkList.removeFirst();
            List list = this.fTCModel.getUsedIn(constraintVariable2);
            this.processConstraints(list, constraintVariable2);
            subProgressMonitor.worked(1);
            if (!subProgressMonitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        subProgressMonitor.done();
    }

    private void processConstraints(List list, ConstraintVariable2 constraintVariable2) {
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ITypeConstraint2 iTypeConstraint2 = (ITypeConstraint2)iterator.next();
            this.maintainSimpleConstraint(constraintVariable2, iTypeConstraint2);
            ++n;
        }
    }

    private void maintainSimpleConstraint(ConstraintVariable2 constraintVariable2, ITypeConstraint2 iTypeConstraint2) {
        TypeSet typeSet;
        ConstraintVariable2 constraintVariable22 = iTypeConstraint2.getLeft();
        ConstraintVariable2 constraintVariable23 = iTypeConstraint2.getRight();
        TypeEquivalenceSet typeEquivalenceSet = constraintVariable22.getTypeEquivalenceSet();
        TypeEquivalenceSet typeEquivalenceSet2 = constraintVariable23.getTypeEquivalenceSet();
        TypeSet typeSet2 = (TypeSet)typeEquivalenceSet.getTypeEstimate();
        TypeSet typeSet3 = (TypeSet)typeEquivalenceSet2.getTypeEstimate();
        if (typeSet2.isUniverse() && typeSet3.isUniverse()) {
            return;
        }
        if (typeSet2.equals(typeSet3)) {
            return;
        }
        TypeSet typeSet4 = typeSet2.superTypes();
        TypeSet typeSet5 = typeSet3.subTypes();
        if (!typeSet5.containsAll(typeSet2)) {
            typeSet = typeSet2.intersectedWith(typeSet5);
            typeEquivalenceSet.setTypeEstimate(typeSet);
            this.fWorkList.addAll(Arrays.asList(typeEquivalenceSet.getContributingVariables()));
        }
        if (!typeSet4.containsAll(typeSet3)) {
            typeSet = typeSet3.intersectedWith(typeSet4);
            typeEquivalenceSet2.setTypeEstimate(typeSet);
            this.fWorkList.addAll(Arrays.asList(typeEquivalenceSet2.getContributingVariables()));
        }
    }

    private void chooseTypes(ConstraintVariable2[] constraintVariable2Array, SubProgressMonitor subProgressMonitor) {
        subProgressMonitor.beginTask("", constraintVariable2Array.length);
        int n = 0;
        while (n < constraintVariable2Array.length) {
            ConstraintVariable2 constraintVariable2 = constraintVariable2Array[n];
            TypeEquivalenceSet typeEquivalenceSet = constraintVariable2.getTypeEquivalenceSet();
            if (typeEquivalenceSet != null) {
                TType tType = this.chooseSingleType((TypeSet)constraintVariable2.getTypeEstimate());
                InferTypeArgumentsConstraintsSolver.setChosenType(constraintVariable2, tType);
                if (constraintVariable2 instanceof CollectionElementVariable2) {
                    CollectionElementVariable2 collectionElementVariable2 = (CollectionElementVariable2)constraintVariable2;
                    this.fUpdate.addDeclaration(collectionElementVariable2);
                }
                subProgressMonitor.worked(1);
                if (subProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++n;
        }
        subProgressMonitor.done();
    }

    private TType chooseSingleType(TypeSet typeSet) {
        if (typeSet.isUniverse() || typeSet.isEmpty()) {
            return null;
        }
        if (typeSet.hasUniqueLowerBound()) {
            return typeSet.uniqueLowerBound();
        }
        EnumeratedTypeSet enumeratedTypeSet = typeSet.lowerBound().enumerate();
        ArrayList<TType> arrayList = null;
        Object object = enumeratedTypeSet.iterator();
        while (object.hasNext()) {
            TType tType = (TType)object.next();
            if (!tType.isInterface()) {
                return tType;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<TType>(2);
            }
            arrayList.add(tType);
        }
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (TType)arrayList.get(0);
        }
        object = this.getNonTaggingInterfaces(arrayList);
        if (((ArrayList)object).size() != 0) {
            return (TType)Collections.min(object, TTypeComparator.INSTANCE);
        }
        return (TType)Collections.min(arrayList, TTypeComparator.INSTANCE);
    }

    private ArrayList getNonTaggingInterfaces(ArrayList arrayList) {
        Object object;
        TType tType;
        ArrayList<TType> arrayList2 = new ArrayList<TType>();
        ArrayList<TType> arrayList3 = new ArrayList<TType>();
        int n = 0;
        while (n < arrayList.size()) {
            tType = (TType)arrayList.get(n);
            object = this.fInterfaceTaggingCache.get(tType);
            if (object == null) {
                arrayList2.add(tType);
            } else if (object == Boolean.FALSE) {
                arrayList3.add(tType);
            }
            ++n;
        }
        if (arrayList2.size() != 0) {
            TType[] tTypeArray = arrayList2.toArray(new TType[arrayList2.size()]);
            tType = (HierarchyType)tTypeArray[0];
            object = ((HierarchyType)tType).getJavaElementType().getJavaProject();
            ITypeBinding[] iTypeBindingArray = TypeEnvironment.createTypeBindings(tTypeArray, object);
            int n2 = 0;
            while (n2 < iTypeBindingArray.length) {
                if (iTypeBindingArray[n2].getDeclaredMethods().length == 0) {
                    this.fInterfaceTaggingCache.put(tTypeArray[n2], Boolean.TRUE);
                } else {
                    this.fInterfaceTaggingCache.put(tTypeArray[n2], Boolean.FALSE);
                    arrayList3.add(tTypeArray[n2]);
                }
                ++n2;
            }
        }
        return arrayList3;
    }

    private void findCastsToRemove(CastVariable2[] castVariable2Array) {
        int n = 0;
        while (n < castVariable2Array.length) {
            TType tType;
            ArrayElementVariable2 arrayElementVariable2;
            CastVariable2 castVariable2 = castVariable2Array[n];
            ConstraintVariable2 constraintVariable2 = castVariable2.getExpressionVariable();
            TType tType2 = InferTypeArgumentsConstraintsSolver.getChosenType(constraintVariable2);
            TType tType3 = castVariable2.getType();
            TType tType4 = constraintVariable2.getType();
            if (tType2 != null && TTypes.canAssignTo(tType2, tType3)) {
                if (!tType2.equals(tType4)) {
                    this.fUpdate.addCastToRemove(castVariable2);
                }
            } else if (constraintVariable2 instanceof ArrayTypeVariable2 && tType3.isArrayType() && (arrayElementVariable2 = this.fTCModel.getArrayElementVariable(constraintVariable2)) != null && (tType = InferTypeArgumentsConstraintsSolver.getChosenType(arrayElementVariable2)) != null && TTypes.canAssignTo(tType, ((ArrayType)tType3).getComponentType()) && (!(tType4 instanceof ArrayType) || !tType.equals(((ArrayType)tType4).getComponentType()))) {
                this.fUpdate.addCastToRemove(castVariable2);
            }
            ++n;
        }
    }

    public static TType getChosenType(ConstraintVariable2 constraintVariable2) {
        TType tType = (TType)constraintVariable2.getData(CHOSEN_TYPE);
        if (tType != null) {
            return tType;
        }
        TypeEquivalenceSet typeEquivalenceSet = constraintVariable2.getTypeEquivalenceSet();
        if (typeEquivalenceSet == null) {
            return null;
        }
        return constraintVariable2.getTypeEstimate().chooseSingleType();
    }

    private static void setChosenType(ConstraintVariable2 constraintVariable2, TType tType) {
        constraintVariable2.setData(CHOSEN_TYPE, tType);
    }

    private static class TTypeComparator
    implements Comparator {
        public static TTypeComparator INSTANCE = new TTypeComparator();

        private TTypeComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((TType)object).getPrettySignature().compareTo(((TType)object2).getPrettySignature());
        }
    }
}

