/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.generics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.GenericType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ParameterizedType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ArrayElementVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ArrayTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CollectionElementVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraint2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ImmutableTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.IndependentTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ParameterTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ParameterizedTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ReturnTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.SubTypeConstraint2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.VariableVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;

public class InferTypeArgumentsTCModel {
    protected static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.ui/debug/TypeConstraints"));
    private static final String INDEXED_COLLECTION_ELEMENTS = "IndexedCollectionElements";
    private static final String ARRAY_ELEMENT = "ArrayElement";
    private static final String USED_IN = "UsedIn";
    private static final String METHOD_RECEIVER = "MethodReceiver";
    private static final Map EMPTY_COLLECTION_ELEMENT_VARIABLES_MAP = Collections.EMPTY_MAP;
    protected static boolean fStoreToString = DEBUG;
    private HashMap fConstraintVariables;
    private HashMap fTypeConstraints;
    private Collection fCastVariables;
    private HashSet fCuScopedConstraintVariables;
    private TypeEnvironment fTypeEnvironment;
    private static final int MAX_TTYPE_CACHE = 1024;
    private Map fTTypeCache = new LinkedHashMap(1024, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 1024;
        }
    };

    public InferTypeArgumentsTCModel() {
        this.fTypeConstraints = new HashMap();
        this.fConstraintVariables = new LinkedHashMap();
        this.fCastVariables = new ArrayList();
        this.fCuScopedConstraintVariables = new HashSet();
        this.fTypeEnvironment = new TypeEnvironment(true);
    }

    protected boolean keep(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22) {
        if (constraintVariable2 == null || constraintVariable22 == null) {
            return false;
        }
        if (constraintVariable2.equals(constraintVariable22)) {
            if (constraintVariable2 == constraintVariable22) {
                return false;
            }
            Assert.isTrue((boolean)false);
        }
        if (constraintVariable2 instanceof CollectionElementVariable2 || constraintVariable22 instanceof CollectionElementVariable2) {
            return true;
        }
        if (constraintVariable2 instanceof IndependentTypeVariable2 || constraintVariable22 instanceof IndependentTypeVariable2) {
            return true;
        }
        if (InferTypeArgumentsTCModel.isAGenericType(constraintVariable2.getType())) {
            return true;
        }
        return InferTypeArgumentsTCModel.isAGenericType(constraintVariable22.getType());
    }

    public List getUsedIn(ConstraintVariable2 constraintVariable2) {
        Object object = constraintVariable2.getData(USED_IN);
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        if (object instanceof ArrayList) {
            return Collections.unmodifiableList((ArrayList)object);
        }
        return Collections.singletonList(object);
    }

    public void newCu() {
        this.pruneUnusedCuScopedCvs();
        this.fCuScopedConstraintVariables.clear();
        this.fTTypeCache.clear();
    }

    private void pruneUnusedCuScopedCvs() {
        Iterator iterator = this.fCuScopedConstraintVariables.iterator();
        while (iterator.hasNext()) {
            ConstraintVariable2 constraintVariable2 = (ConstraintVariable2)iterator.next();
            this.pruneCvIfUnused(constraintVariable2);
        }
    }

    private boolean pruneCvIfUnused(ConstraintVariable2 constraintVariable2) {
        if (this.getUsedIn(constraintVariable2).size() != 0) {
            return false;
        }
        if (constraintVariable2.getTypeEquivalenceSet() != null && constraintVariable2.getTypeEquivalenceSet().getContributingVariables().length > 0) {
            return false;
        }
        ArrayElementVariable2 arrayElementVariable2 = this.getArrayElementVariable(constraintVariable2);
        if (arrayElementVariable2 != null && !this.pruneCvIfUnused(arrayElementVariable2)) {
            return false;
        }
        Map map = this.getElementVariables(constraintVariable2);
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            CollectionElementVariable2 collectionElementVariable2 = (CollectionElementVariable2)iterator.next();
            if (this.pruneCvIfUnused(collectionElementVariable2)) continue;
            return false;
        }
        this.fConstraintVariables.remove(constraintVariable2);
        return true;
    }

    public ConstraintVariable2[] getAllConstraintVariables() {
        ConstraintVariable2[] constraintVariable2Array = new ConstraintVariable2[this.fConstraintVariables.size()];
        int n = 0;
        Iterator iterator = this.fConstraintVariables.keySet().iterator();
        while (iterator.hasNext()) {
            constraintVariable2Array[n] = (ConstraintVariable2)iterator.next();
            ++n;
        }
        return constraintVariable2Array;
    }

    public ITypeConstraint2[] getAllTypeConstraints() {
        Set set = this.fTypeConstraints.keySet();
        return set.toArray(new ITypeConstraint2[set.size()]);
    }

    public CastVariable2[] getCastVariables() {
        return this.fCastVariables.toArray(new CastVariable2[this.fCastVariables.size()]);
    }

    public static void setStoreToString(boolean bl) {
        fStoreToString = bl;
    }

    public void createSubtypeConstraint(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22) {
        ConstraintVariable2 constraintVariable23;
        if (!this.keep(constraintVariable2, constraintVariable22)) {
            return;
        }
        ConstraintVariable2 constraintVariable24 = this.storedCv(constraintVariable2);
        ITypeConstraint2 iTypeConstraint2 = new SubTypeConstraint2(constraintVariable24, constraintVariable23 = this.storedCv(constraintVariable22));
        Object v = this.fTypeConstraints.get(iTypeConstraint2);
        if (v == null) {
            this.fTypeConstraints.put(iTypeConstraint2, iTypeConstraint2);
        } else {
            iTypeConstraint2 = (ITypeConstraint2)v;
        }
        this.registerCvWithTc(constraintVariable24, iTypeConstraint2);
        this.registerCvWithTc(constraintVariable23, iTypeConstraint2);
    }

    private ConstraintVariable2 storedCv(ConstraintVariable2 constraintVariable2) {
        Object v = this.fConstraintVariables.get(constraintVariable2);
        if (v == null) {
            this.fConstraintVariables.put(constraintVariable2, constraintVariable2);
            return constraintVariable2;
        }
        return (ConstraintVariable2)v;
    }

    private void registerCvWithTc(ConstraintVariable2 constraintVariable2, ITypeConstraint2 iTypeConstraint2) {
        Object object = constraintVariable2.getData(USED_IN);
        if (object == null) {
            constraintVariable2.setData(USED_IN, iTypeConstraint2);
        } else if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            arrayList.add(iTypeConstraint2);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(object);
            arrayList.add(iTypeConstraint2);
            constraintVariable2.setData(USED_IN, arrayList);
        }
    }

    public void createEqualsConstraint(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22) {
        if (constraintVariable2 == null || constraintVariable22 == null) {
            return;
        }
        TypeEquivalenceSet typeEquivalenceSet = constraintVariable2.getTypeEquivalenceSet();
        TypeEquivalenceSet typeEquivalenceSet2 = constraintVariable22.getTypeEquivalenceSet();
        if (typeEquivalenceSet == null) {
            if (typeEquivalenceSet2 == null) {
                TypeEquivalenceSet typeEquivalenceSet3 = new TypeEquivalenceSet(constraintVariable2, constraintVariable22);
                constraintVariable2.setTypeEquivalenceSet(typeEquivalenceSet3);
                constraintVariable22.setTypeEquivalenceSet(typeEquivalenceSet3);
            } else {
                typeEquivalenceSet2.add(constraintVariable2);
                constraintVariable2.setTypeEquivalenceSet(typeEquivalenceSet2);
            }
        } else if (typeEquivalenceSet2 == null) {
            typeEquivalenceSet.add(constraintVariable22);
            constraintVariable22.setTypeEquivalenceSet(typeEquivalenceSet);
        } else {
            if (typeEquivalenceSet == typeEquivalenceSet2) {
                return;
            }
            ConstraintVariable2[] constraintVariable2Array = typeEquivalenceSet2.getContributingVariables();
            typeEquivalenceSet.addAll(constraintVariable2Array);
            int n = 0;
            while (n < constraintVariable2Array.length) {
                constraintVariable2Array[n].setTypeEquivalenceSet(typeEquivalenceSet);
                ++n;
            }
        }
    }

    public TType createTType(ITypeBinding iTypeBinding) {
        String string = iTypeBinding.getKey();
        TType tType = (TType)this.fTTypeCache.get(string);
        if (tType != null) {
            return tType;
        }
        TType tType2 = this.fTypeEnvironment.create(iTypeBinding);
        this.fTTypeCache.put(string, tType2);
        return tType2;
    }

    private TType getBoxedType(ITypeBinding iTypeBinding, Expression expression) {
        if (iTypeBinding == null) {
            return null;
        }
        if (!iTypeBinding.isPrimitive()) {
            return this.createTType(iTypeBinding);
        }
        if (expression == null || !expression.resolveBoxing()) {
            return null;
        }
        String string = iTypeBinding.getName();
        ITypeBinding iTypeBinding2 = expression.getAST().resolveWellKnownType(this.getBoxedTypeName(string));
        return this.createTType(iTypeBinding2);
    }

    private String getBoxedTypeName(String string) {
        if ("long".equals(string)) {
            return "java.lang.Long";
        }
        if ("int".equals(string)) {
            return "java.lang.Integer";
        }
        if ("short".equals(string)) {
            return "java.lang.Short";
        }
        if ("char".equals(string)) {
            return "java.lang.Character";
        }
        if ("byte".equals(string)) {
            return "java.lang.Byte";
        }
        if ("boolean".equals(string)) {
            return "java.lang.Boolean";
        }
        if ("float".equals(string)) {
            return "java.lang.Float";
        }
        if ("double".equals(string)) {
            return "java.lang.Double";
        }
        return null;
    }

    public VariableVariable2 makeVariableVariable(IVariableBinding iVariableBinding) {
        if (iVariableBinding == null) {
            return null;
        }
        TType tType = this.getBoxedType(iVariableBinding.getType(), null);
        if (tType == null) {
            return null;
        }
        VariableVariable2 variableVariable2 = new VariableVariable2(tType, iVariableBinding);
        VariableVariable2 variableVariable22 = (VariableVariable2)this.storedCv(variableVariable2);
        if (variableVariable22 == variableVariable2) {
            if (!iVariableBinding.isField() || Modifier.isPrivate((int)iVariableBinding.getModifiers())) {
                this.fCuScopedConstraintVariables.add(variableVariable22);
            }
            this.makeElementVariables(variableVariable22, tType);
            this.makeArrayElementVariable(variableVariable22);
            if (fStoreToString) {
                variableVariable22.setData("toString", String.valueOf('[') + iVariableBinding.getName() + ']');
            }
        }
        return variableVariable22;
    }

    public VariableVariable2 makeDeclaredVariableVariable(IVariableBinding iVariableBinding, ICompilationUnit iCompilationUnit) {
        VariableVariable2 variableVariable2 = this.makeVariableVariable(iVariableBinding);
        if (variableVariable2 == null) {
            return null;
        }
        variableVariable2.setCompilationUnit(iCompilationUnit);
        return variableVariable2;
    }

    public TypeVariable2 makeTypeVariable(Type type) {
        ICompilationUnit iCompilationUnit = RefactoringASTParser.getCompilationUnit((ASTNode)type);
        TType tType = this.getBoxedType(type.resolveBinding(), null);
        if (tType == null) {
            return null;
        }
        CompilationUnitRange compilationUnitRange = new CompilationUnitRange(iCompilationUnit, (ASTNode)type);
        TypeVariable2 typeVariable2 = new TypeVariable2(tType, compilationUnitRange);
        TypeVariable2 typeVariable22 = (TypeVariable2)this.storedCv(typeVariable2);
        if (typeVariable22 == typeVariable2) {
            this.fCuScopedConstraintVariables.add(typeVariable22);
            if (InferTypeArgumentsTCModel.isAGenericType(tType)) {
                this.makeElementVariables(typeVariable22, tType);
            }
            this.makeArrayElementVariable(typeVariable22);
            if (fStoreToString) {
                typeVariable22.setData("toString", type.toString());
            }
        }
        return typeVariable22;
    }

    public IndependentTypeVariable2 makeIndependentTypeVariable(TypeVariable typeVariable) {
        IndependentTypeVariable2 independentTypeVariable2 = new IndependentTypeVariable2(typeVariable);
        IndependentTypeVariable2 independentTypeVariable22 = (IndependentTypeVariable2)this.storedCv(independentTypeVariable2);
        if (independentTypeVariable2 == independentTypeVariable22) {
            this.fCuScopedConstraintVariables.add(independentTypeVariable22);
            if (fStoreToString) {
                independentTypeVariable22.setData("toString", "IndependentType(" + typeVariable.getPrettySignature() + ")");
            }
        }
        return independentTypeVariable22;
    }

    public ParameterizedTypeVariable2 makeParameterizedTypeVariable(ITypeBinding iTypeBinding) {
        if (iTypeBinding == null) {
            return null;
        }
        TType tType = this.createTType(iTypeBinding);
        return this.makeParameterizedTypeVariable(tType);
    }

    private ParameterizedTypeVariable2 makeParameterizedTypeVariable(TType tType) {
        Assert.isTrue((boolean)InferTypeArgumentsTCModel.isAGenericType(tType));
        ParameterizedTypeVariable2 parameterizedTypeVariable2 = new ParameterizedTypeVariable2(tType);
        ParameterizedTypeVariable2 parameterizedTypeVariable22 = (ParameterizedTypeVariable2)this.storedCv(parameterizedTypeVariable2);
        if (parameterizedTypeVariable2 == parameterizedTypeVariable22) {
            this.fCuScopedConstraintVariables.add(parameterizedTypeVariable22);
            this.makeElementVariables(parameterizedTypeVariable22, tType);
            if (fStoreToString) {
                parameterizedTypeVariable22.setData("toString", "ParameterizedType(" + tType.getPrettySignature() + ")");
            }
        }
        return parameterizedTypeVariable22;
    }

    public ArrayTypeVariable2 makeArrayTypeVariable(ITypeBinding iTypeBinding) {
        if (iTypeBinding == null) {
            return null;
        }
        TType tType = this.createTType(iTypeBinding);
        return this.makeArrayTypeVariable((ArrayType)tType);
    }

    private ArrayTypeVariable2 makeArrayTypeVariable(ArrayType arrayType) {
        ArrayTypeVariable2 arrayTypeVariable2 = new ArrayTypeVariable2(arrayType);
        ArrayTypeVariable2 arrayTypeVariable22 = (ArrayTypeVariable2)this.storedCv(arrayTypeVariable2);
        if (arrayTypeVariable2 == arrayTypeVariable22) {
            this.fCuScopedConstraintVariables.add(arrayTypeVariable22);
            this.makeArrayElementVariable(arrayTypeVariable22);
            if (fStoreToString) {
                arrayTypeVariable22.setData("toString", "ArrayType(" + arrayType.getPrettySignature() + ")");
            }
        }
        return arrayTypeVariable22;
    }

    public ParameterTypeVariable2 makeParameterTypeVariable(IMethodBinding iMethodBinding, int n) {
        if (iMethodBinding == null) {
            return null;
        }
        TType tType = this.getBoxedType(iMethodBinding.getParameterTypes()[n], null);
        if (tType == null) {
            return null;
        }
        ParameterTypeVariable2 parameterTypeVariable2 = new ParameterTypeVariable2(tType, n, iMethodBinding);
        ParameterTypeVariable2 parameterTypeVariable22 = (ParameterTypeVariable2)this.storedCv(parameterTypeVariable2);
        if (parameterTypeVariable22 == parameterTypeVariable2) {
            if (iMethodBinding.getDeclaringClass().isLocal() || Modifier.isPrivate((int)iMethodBinding.getModifiers())) {
                this.fCuScopedConstraintVariables.add(parameterTypeVariable2);
            }
            this.makeElementVariables(parameterTypeVariable22, tType);
            this.makeArrayElementVariable(parameterTypeVariable22);
            if (fStoreToString) {
                parameterTypeVariable22.setData("toString", "[Parameter(" + n + "," + Bindings.asString((IBinding)iMethodBinding) + ")]");
            }
        }
        return parameterTypeVariable22;
    }

    public ParameterTypeVariable2 makeDeclaredParameterTypeVariable(IMethodBinding iMethodBinding, int n, ICompilationUnit iCompilationUnit) {
        if (iMethodBinding == null) {
            return null;
        }
        ParameterTypeVariable2 parameterTypeVariable2 = this.makeParameterTypeVariable(iMethodBinding, n);
        if (parameterTypeVariable2 == null) {
            return null;
        }
        parameterTypeVariable2.setCompilationUnit(iCompilationUnit);
        return parameterTypeVariable2;
    }

    public ReturnTypeVariable2 makeReturnTypeVariable(IMethodBinding iMethodBinding) {
        if (iMethodBinding == null) {
            return null;
        }
        TType tType = this.getBoxedType(iMethodBinding.getReturnType(), null);
        if (tType == null) {
            return null;
        }
        ReturnTypeVariable2 returnTypeVariable2 = new ReturnTypeVariable2(tType, iMethodBinding);
        ReturnTypeVariable2 returnTypeVariable22 = (ReturnTypeVariable2)this.storedCv(returnTypeVariable2);
        if (returnTypeVariable2 == returnTypeVariable22) {
            this.makeElementVariables(returnTypeVariable22, tType);
            this.makeArrayElementVariable(returnTypeVariable22);
            if (fStoreToString) {
                returnTypeVariable22.setData("toString", "[ReturnType(" + Bindings.asString((IBinding)iMethodBinding) + ")]");
            }
        }
        return returnTypeVariable22;
    }

    public ReturnTypeVariable2 makeDeclaredReturnTypeVariable(IMethodBinding iMethodBinding, ICompilationUnit iCompilationUnit) {
        if (iMethodBinding == null) {
            return null;
        }
        ReturnTypeVariable2 returnTypeVariable2 = this.makeReturnTypeVariable(iMethodBinding);
        if (returnTypeVariable2 == null) {
            return null;
        }
        returnTypeVariable2.setCompilationUnit(iCompilationUnit);
        if (iMethodBinding.getDeclaringClass().isLocal()) {
            this.fCuScopedConstraintVariables.add(returnTypeVariable2);
        }
        return returnTypeVariable2;
    }

    public ImmutableTypeVariable2 makeImmutableTypeVariable(ITypeBinding iTypeBinding, Expression expression) {
        TType tType = this.getBoxedType(iTypeBinding, expression);
        if (tType == null) {
            return null;
        }
        return this.makeImmutableTypeVariable(tType);
    }

    public ImmutableTypeVariable2 makeImmutableTypeVariable(TType tType) {
        ImmutableTypeVariable2 immutableTypeVariable2 = new ImmutableTypeVariable2(tType);
        ImmutableTypeVariable2 immutableTypeVariable22 = (ImmutableTypeVariable2)this.storedCv(immutableTypeVariable2);
        if (immutableTypeVariable2 == immutableTypeVariable22) {
            this.makeFixedElementVariables(immutableTypeVariable22, tType);
            this.makeArrayElementVariable(immutableTypeVariable22);
        }
        return immutableTypeVariable22;
    }

    public static boolean isAGenericType(TType tType) {
        return tType.isGenericType() || tType.isParameterizedType() || tType.isRawType() && tType.getTypeDeclaration().isGenericType();
    }

    public static boolean isAGenericType(ITypeBinding iTypeBinding) {
        return iTypeBinding.isGenericType() || iTypeBinding.isParameterizedType() || iTypeBinding.isRawType() && iTypeBinding.getTypeDeclaration().isGenericType();
    }

    public CastVariable2 makeCastVariable(CastExpression castExpression, ConstraintVariable2 constraintVariable2) {
        ITypeBinding iTypeBinding = castExpression.resolveTypeBinding();
        ICompilationUnit iCompilationUnit = RefactoringASTParser.getCompilationUnit((ASTNode)castExpression);
        CompilationUnitRange compilationUnitRange = new CompilationUnitRange(iCompilationUnit, (ASTNode)castExpression);
        CastVariable2 castVariable2 = new CastVariable2(this.createTType(iTypeBinding), compilationUnitRange, constraintVariable2);
        this.fCastVariables.add(castVariable2);
        return castVariable2;
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.fTypeEnvironment;
    }

    public CollectionElementVariable2 getElementVariable(ConstraintVariable2 constraintVariable2, ITypeBinding iTypeBinding) {
        Assert.isTrue((boolean)iTypeBinding.isTypeVariable());
        HashMap hashMap = (HashMap)constraintVariable2.getData(INDEXED_COLLECTION_ELEMENTS);
        if (hashMap == null) {
            return null;
        }
        return (CollectionElementVariable2)hashMap.get(iTypeBinding.getKey());
    }

    public Map getElementVariables(ConstraintVariable2 constraintVariable2) {
        Map map = (Map)constraintVariable2.getData(INDEXED_COLLECTION_ELEMENTS);
        if (map == null) {
            return EMPTY_COLLECTION_ELEMENT_VARIABLES_MAP;
        }
        return map;
    }

    public ArrayElementVariable2 getArrayElementVariable(ConstraintVariable2 constraintVariable2) {
        return (ArrayElementVariable2)constraintVariable2.getData(ARRAY_ELEMENT);
    }

    private void setArrayElementVariable(ConstraintVariable2 constraintVariable2, ArrayElementVariable2 arrayElementVariable2) {
        constraintVariable2.setData(ARRAY_ELEMENT, arrayElementVariable2);
    }

    public void makeArrayElementVariable(ConstraintVariable2 constraintVariable2) {
        if (constraintVariable2.getType() == null || !constraintVariable2.getType().isArrayType()) {
            return;
        }
        ArrayElementVariable2 arrayElementVariable2 = this.getArrayElementVariable(constraintVariable2);
        if (arrayElementVariable2 != null) {
            return;
        }
        ArrayElementVariable2 arrayElementVariable22 = new ArrayElementVariable2(constraintVariable2);
        arrayElementVariable22 = (ArrayElementVariable2)this.storedCv(arrayElementVariable22);
        this.setArrayElementVariable(constraintVariable2, arrayElementVariable22);
        this.makeArrayElementVariable(arrayElementVariable22);
    }

    public void makeElementVariables(ConstraintVariable2 constraintVariable2, TType tType) {
        if (InferTypeArgumentsTCModel.isAGenericType(tType)) {
            GenericType genericType = (GenericType)tType.getTypeDeclaration();
            TypeVariable[] typeVariableArray = genericType.getTypeParameters();
            int n = 0;
            while (n < typeVariableArray.length) {
                TypeVariable typeVariable = typeVariableArray[n];
                this.makeElementVariable(constraintVariable2, typeVariable, n);
                int cfr_ignored_0 = typeVariable.getBounds().length;
                ++n;
            }
        }
        this.makeElementVariablesFromSupertypes(constraintVariable2, tType.getTypeDeclaration());
    }

    private void makeElementVariablesFromSupertypes(ConstraintVariable2 constraintVariable2, TType tType) {
        TType tType2 = tType.getSuperclass();
        if (tType2 != null) {
            this.makeSupertypeElementVariables(constraintVariable2, tType2);
        }
        TType[] tTypeArray = tType.getInterfaces();
        int n = 0;
        while (n < tTypeArray.length) {
            this.makeSupertypeElementVariables(constraintVariable2, tTypeArray[n]);
            ++n;
        }
    }

    private void makeSupertypeElementVariables(ConstraintVariable2 constraintVariable2, TType tType) {
        if (tType.isParameterizedType() || tType.isRawType()) {
            TType[] tTypeArray = null;
            if (tType.isParameterizedType()) {
                tTypeArray = ((ParameterizedType)tType).getTypeArguments();
            }
            TypeVariable[] typeVariableArray = ((GenericType)tType.getTypeDeclaration()).getTypeParameters();
            int n = 0;
            while (n < typeVariableArray.length) {
                TypeVariable typeVariable = typeVariableArray[n];
                TType tType2 = tTypeArray == null ? typeVariable.getErasure() : tTypeArray[n];
                if (tType2.isTypeVariable()) {
                    CollectionElementVariable2 collectionElementVariable2 = this.getElementVariable(constraintVariable2, (TypeVariable)tType2);
                    this.setElementVariable(constraintVariable2, collectionElementVariable2, typeVariable);
                } else {
                    this.makeElementVariable(constraintVariable2, typeVariable, -1);
                }
                ++n;
            }
        }
        this.makeElementVariablesFromSupertypes(constraintVariable2, tType);
    }

    public void makeFixedElementVariables(ConstraintVariable2 constraintVariable2, TType tType) {
        if (InferTypeArgumentsTCModel.isAGenericType(tType)) {
            GenericType genericType = (GenericType)tType.getTypeDeclaration();
            TypeVariable[] typeVariableArray = genericType.getTypeParameters();
            TType[] tTypeArray = null;
            if (tType.isParameterizedType()) {
                tTypeArray = ((ParameterizedType)tType).getTypeArguments();
            }
            int n = 0;
            while (n < typeVariableArray.length) {
                TypeVariable typeVariable = typeVariableArray[n];
                CollectionElementVariable2 collectionElementVariable2 = this.makeElementVariable(constraintVariable2, typeVariable, n);
                if (tTypeArray != null) {
                    TType tType2 = tTypeArray[n];
                    this.createEqualsConstraint(collectionElementVariable2, this.makeImmutableTypeVariable(tType2));
                }
                ++n;
            }
        }
        this.makeFixedElementVariablesFromSupertypes(constraintVariable2, tType.getTypeDeclaration());
    }

    private void makeFixedElementVariablesFromSupertypes(ConstraintVariable2 constraintVariable2, TType tType) {
        TType tType2 = tType.getSuperclass();
        if (tType2 != null) {
            this.makeFixedSupertypeElementVariables(constraintVariable2, tType2);
        }
        TType[] tTypeArray = tType.getInterfaces();
        int n = 0;
        while (n < tTypeArray.length) {
            this.makeFixedSupertypeElementVariables(constraintVariable2, tTypeArray[n]);
            ++n;
        }
    }

    private void makeFixedSupertypeElementVariables(ConstraintVariable2 constraintVariable2, TType tType) {
        if (tType.isParameterizedType() || tType.isRawType()) {
            TType[] tTypeArray = null;
            if (tType.isParameterizedType()) {
                tTypeArray = ((ParameterizedType)tType).getTypeArguments();
            }
            TypeVariable[] typeVariableArray = ((GenericType)tType.getTypeDeclaration()).getTypeParameters();
            int n = 0;
            while (n < typeVariableArray.length) {
                TypeVariable typeVariable = typeVariableArray[n];
                if (tTypeArray != null) {
                    CollectionElementVariable2 collectionElementVariable2;
                    TType tType2 = tTypeArray[n];
                    if (tType2.isTypeVariable()) {
                        collectionElementVariable2 = this.getElementVariable(constraintVariable2, (TypeVariable)tType2);
                        this.setElementVariable(constraintVariable2, collectionElementVariable2, typeVariable);
                    } else {
                        collectionElementVariable2 = this.makeElementVariable(constraintVariable2, typeVariable, -1);
                        this.createEqualsConstraint(collectionElementVariable2, this.makeImmutableTypeVariable(tType2));
                    }
                }
                ++n;
            }
        }
        this.makeFixedElementVariablesFromSupertypes(constraintVariable2, tType);
    }

    public void createTypeVariablesEqualityConstraints(ConstraintVariable2 constraintVariable2, Map map, ConstraintVariable2 constraintVariable22, TType tType) {
        if (tType.isParameterizedType() || tType.isRawType()) {
            TType[] tTypeArray = null;
            if (tType.isParameterizedType()) {
                tTypeArray = ((ParameterizedType)tType).getTypeArguments();
            }
            TypeVariable[] typeVariableArray = ((GenericType)tType.getTypeDeclaration()).getTypeParameters();
            int n = 0;
            while (n < typeVariableArray.length) {
                CollectionElementVariable2 collectionElementVariable2;
                ConstraintVariable2 constraintVariable23;
                TypeVariable typeVariable = typeVariableArray[n];
                TType tType2 = tTypeArray == null ? typeVariable.getErasure() : tTypeArray[n];
                if (tType2.isTypeVariable()) {
                    constraintVariable23 = this.getElementTypeCv(tType2, constraintVariable2, map);
                    collectionElementVariable2 = this.getElementVariable(constraintVariable22, typeVariable);
                    this.createEqualsConstraint(constraintVariable23, collectionElementVariable2);
                } else if (tType2.isWildcardType()) {
                    constraintVariable23 = this.makeImmutableTypeVariable(this.fTypeEnvironment.VOID);
                    collectionElementVariable2 = this.getElementVariable(constraintVariable22, typeVariable);
                    this.createEqualsConstraint(constraintVariable23, collectionElementVariable2);
                }
                ++n;
            }
        } else if (tType.isArrayType()) {
            TType tType3 = ((ArrayType)tType).getElementType();
            if (tType3.isRawType()) {
                tType3 = tType3.getErasure();
            }
            ConstraintVariable2 constraintVariable24 = this.getElementTypeCv(tType3, constraintVariable2, map);
            ArrayElementVariable2 arrayElementVariable2 = this.getArrayElementVariable(constraintVariable22);
            this.createEqualsConstraint(constraintVariable24, arrayElementVariable2);
        }
    }

    private ConstraintVariable2 getElementTypeCv(TType tType, ConstraintVariable2 constraintVariable2, Map map) {
        if (tType.isTypeVariable()) {
            ConstraintVariable2 constraintVariable22 = (ConstraintVariable2)map.get(tType.getBindingKey());
            if (constraintVariable22 != null) {
                return constraintVariable22;
            }
            if (constraintVariable2 != null) {
                return this.getElementVariable(constraintVariable2, (TypeVariable)tType);
            }
        }
        return null;
    }

    private CollectionElementVariable2 makeElementVariable(ConstraintVariable2 constraintVariable2, TypeVariable typeVariable, int n) {
        if (constraintVariable2 == null) {
            return null;
        }
        CollectionElementVariable2 collectionElementVariable2 = this.getElementVariable(constraintVariable2, typeVariable);
        if (collectionElementVariable2 != null) {
            return collectionElementVariable2;
        }
        CollectionElementVariable2 collectionElementVariable22 = new CollectionElementVariable2(constraintVariable2, typeVariable, n);
        collectionElementVariable22 = (CollectionElementVariable2)this.storedCv(collectionElementVariable22);
        this.setElementVariable(constraintVariable2, collectionElementVariable22, typeVariable);
        return collectionElementVariable22;
    }

    private void setElementVariable(ConstraintVariable2 constraintVariable2, CollectionElementVariable2 collectionElementVariable2, TypeVariable typeVariable) {
        HashMap<String, CollectionElementVariable2> hashMap = (HashMap<String, CollectionElementVariable2>)constraintVariable2.getData(INDEXED_COLLECTION_ELEMENTS);
        String string = typeVariable.getBindingKey();
        if (hashMap == null) {
            hashMap = new HashMap<String, CollectionElementVariable2>();
            constraintVariable2.setData(INDEXED_COLLECTION_ELEMENTS, hashMap);
        } else {
            Object v = hashMap.get(string);
            if (v != null) {
                Assert.isTrue((v == collectionElementVariable2 ? 1 : 0) != 0);
            }
        }
        hashMap.put(string, collectionElementVariable2);
    }

    public CollectionElementVariable2 getElementVariable(ConstraintVariable2 constraintVariable2, TypeVariable typeVariable) {
        Assert.isTrue((boolean)typeVariable.isTypeVariable());
        HashMap hashMap = (HashMap)constraintVariable2.getData(INDEXED_COLLECTION_ELEMENTS);
        if (hashMap == null) {
            return null;
        }
        return (CollectionElementVariable2)hashMap.get(typeVariable.getBindingKey());
    }

    public void createElementEqualsConstraints(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22) {
        this.internalCreateElementEqualsConstraints(constraintVariable2, constraintVariable22, false);
    }

    public void createAssignmentElementConstraints(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22) {
        this.internalCreateElementEqualsConstraints(constraintVariable2, constraintVariable22, true);
    }

    private void internalCreateElementEqualsConstraints(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22, boolean bl) {
        Map.Entry entry;
        if (constraintVariable2 == null || constraintVariable22 == null) {
            return;
        }
        Map map = this.getElementVariables(constraintVariable2);
        Map map2 = this.getElementVariables(constraintVariable22);
        Object object = map.entrySet().iterator();
        while (object.hasNext()) {
            entry = object.next();
            String string = (String)entry.getKey();
            CollectionElementVariable2 collectionElementVariable2 = (CollectionElementVariable2)map2.get(string);
            if (collectionElementVariable2 == null) continue;
            CollectionElementVariable2 collectionElementVariable22 = (CollectionElementVariable2)entry.getValue();
            this.createEqualsConstraint(collectionElementVariable22, collectionElementVariable2);
            this.internalCreateElementEqualsConstraints(collectionElementVariable22, collectionElementVariable2, false);
        }
        object = this.getArrayElementVariable(constraintVariable2);
        entry = this.getArrayElementVariable(constraintVariable22);
        if (object != null && entry != null) {
            if (bl) {
                this.createSubtypeConstraint((ConstraintVariable2)((Object)entry), (ConstraintVariable2)object);
            } else {
                this.createEqualsConstraint((ConstraintVariable2)object, (ConstraintVariable2)((Object)entry));
            }
            this.internalCreateElementEqualsConstraints((ConstraintVariable2)object, (ConstraintVariable2)((Object)entry), false);
        }
    }

    public ConstraintVariable2 getMethodReceiverCv(ConstraintVariable2 constraintVariable2) {
        return (ConstraintVariable2)constraintVariable2.getData(METHOD_RECEIVER);
    }

    public void setMethodReceiverCV(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22) {
        constraintVariable2.setData(METHOD_RECEIVER, constraintVariable22);
    }
}

