/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSLine;

public class NLSScanner {
    private NLSScanner() {
    }

    public static NLSLine[] scan(ICompilationUnit iCompilationUnit) throws JavaModelException, InvalidInputException {
        return NLSScanner.scan(iCompilationUnit.getBuffer().getCharacters());
    }

    public static NLSLine[] scan(String string) throws InvalidInputException {
        return NLSScanner.scan(string.toCharArray());
    }

    private static NLSLine[] scan(char[] cArray) throws InvalidInputException {
        NLSLine[] nLSLineArray;
        ArrayList<NLSLine> arrayList = new ArrayList<NLSLine>();
        IScanner iScanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        iScanner.setSource(cArray);
        int n = iScanner.getNextToken();
        int n2 = -1;
        int n3 = -1;
        NLSLine nLSLine = null;
        int n4 = 0;
        while (n != 158) {
            switch (n) {
                case 45: {
                    n2 = iScanner.getLineNumber(iScanner.getCurrentTokenStartPosition());
                    if (n2 != n3) {
                        nLSLine = new NLSLine(n2 - 1);
                        arrayList.add(nLSLine);
                        n3 = n2;
                        n4 = 0;
                    }
                    nLSLineArray = new String(iScanner.getCurrentTokenSource());
                    nLSLine.add(new NLSElement((String)nLSLineArray, iScanner.getCurrentTokenStartPosition(), iScanner.getCurrentTokenEndPosition() + 1 - iScanner.getCurrentTokenStartPosition(), n4++, false));
                    break;
                }
                case 1001: {
                    if (n2 != iScanner.getLineNumber(iScanner.getCurrentTokenStartPosition())) break;
                    NLSScanner.parseTags(nLSLine, iScanner);
                }
            }
            n = iScanner.getNextToken();
        }
        try {
            nLSLineArray = arrayList.toArray(new NLSLine[arrayList.size()]);
            Document document = new Document(String.valueOf(iScanner.getSource()));
            int n5 = 0;
            while (n5 < nLSLineArray.length) {
                NLSScanner.setTagPositions((IDocument)document, nLSLineArray[n5]);
                ++n5;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new InvalidInputException();
        }
        return nLSLineArray;
    }

    private static void parseTags(NLSLine nLSLine, IScanner iScanner) {
        String string = new String(iScanner.getCurrentTokenSource());
        int n = string.indexOf("//$NON-NLS-");
        while (n != -1) {
            int n2 = n + NLSElement.TAG_PREFIX_LENGTH;
            int n3 = string.indexOf("$", n2);
            if (n3 < 0) {
                return;
            }
            String string2 = string.substring(n2, n3);
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string2) - 1;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (!nLSLine.exists(n4)) {
                return;
            }
            NLSElement nLSElement = nLSLine.get(n4);
            nLSElement.setTagPosition(iScanner.getCurrentTokenStartPosition() + n, n3 - n + 1);
            n = string.indexOf("//$NON-NLS-", n2);
        }
    }

    private static void setTagPositions(IDocument iDocument, NLSLine nLSLine) throws BadLocationException {
        IRegion iRegion = iDocument.getLineInformation(nLSLine.getLineNumber());
        int n = iRegion.getOffset() + iRegion.getLength();
        NLSElement[] nLSElementArray = nLSLine.getElements();
        int n2 = 0;
        while (n2 < nLSElementArray.length) {
            NLSElement nLSElement = nLSElementArray[n2];
            if (!nLSElement.hasTag()) {
                nLSElement.setTagPosition(NLSScanner.computeInsertOffset(nLSElementArray, n2, n), 0);
            }
            ++n2;
        }
    }

    private static int computeInsertOffset(NLSElement[] nLSElementArray, int n, int n2) {
        NLSElement nLSElement = NLSScanner.findPreviousTagged(n, nLSElementArray);
        if (nLSElement != null) {
            return nLSElement.getTagPosition().getOffset() + nLSElement.getTagPosition().getLength();
        }
        NLSElement nLSElement2 = NLSScanner.findNextTagged(n, nLSElementArray);
        if (nLSElement2 != null) {
            return nLSElement2.getTagPosition().getOffset();
        }
        return n2;
    }

    private static NLSElement findPreviousTagged(int n, NLSElement[] nLSElementArray) {
        int n2 = n - 1;
        while (n2 >= 0) {
            if (nLSElementArray[n2].hasTag()) {
                return nLSElementArray[n2];
            }
            --n2;
        }
        return null;
    }

    private static NLSElement findNextTagged(int n, NLSElement[] nLSElementArray) {
        int n2 = n + 1;
        while (n2 < nLSElementArray.length) {
            if (nLSElementArray[n2].hasTag()) {
                return nLSElementArray[n2];
            }
            ++n2;
        }
        return null;
    }
}

