/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class NLSSourceModifier {
    private final String fSubstitutionPattern;
    private final boolean fIsEclipseNLS;

    private NLSSourceModifier(String string, boolean bl) {
        this.fSubstitutionPattern = string;
        this.fIsEclipseNLS = bl;
    }

    public static Change create(ICompilationUnit iCompilationUnit, NLSSubstitution[] nLSSubstitutionArray, String string, IPackageFragment iPackageFragment, String string2, boolean bl) throws CoreException {
        NLSSourceModifier nLSSourceModifier = new NLSSourceModifier(string, bl);
        String string3 = Messages.format(NLSMessages.NLSSourceModifier_change_description, iCompilationUnit.getElementName());
        CompilationUnitChange compilationUnitChange = new CompilationUnitChange(string3, iCompilationUnit);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        compilationUnitChange.setEdit((TextEdit)multiTextEdit);
        string2 = nLSSourceModifier.createImportForAccessor(multiTextEdit, string2, iPackageFragment, iCompilationUnit);
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            NLSSubstitution nLSSubstitution = nLSSubstitutionArray[n];
            int n2 = nLSSubstitution.getState();
            if (nLSSubstitution.hasStateChanged()) {
                if (n2 == 0) {
                    if (nLSSubstitution.getInitialState() == 2) {
                        nLSSourceModifier.addNLS(nLSSubstitution, (TextChange)compilationUnitChange, string2);
                    } else if (nLSSubstitution.getInitialState() == 1) {
                        nLSSourceModifier.addAccessor(nLSSubstitution, (TextChange)compilationUnitChange, string2);
                    }
                } else if (n2 == 2) {
                    if (nLSSubstitution.getInitialState() == 1) {
                        nLSSourceModifier.deleteTag(nLSSubstitution, (TextChange)compilationUnitChange);
                        if (nLSSubstitution.isValueRename()) {
                            nLSSourceModifier.replaceValue(nLSSubstitution, (TextChange)compilationUnitChange);
                        }
                    } else if (nLSSubstitution.getInitialState() == 0) {
                        nLSSourceModifier.deleteAccessor(nLSSubstitution, (TextChange)compilationUnitChange, iCompilationUnit);
                        if (!bl) {
                            nLSSourceModifier.deleteTag(nLSSubstitution, (TextChange)compilationUnitChange);
                        }
                    }
                } else if (n2 == 1) {
                    if (nLSSubstitution.getInitialState() == 2) {
                        nLSSourceModifier.addNLS(nLSSubstitution, (TextChange)compilationUnitChange, string2);
                        if (nLSSubstitution.isValueRename()) {
                            nLSSourceModifier.replaceValue(nLSSubstitution, (TextChange)compilationUnitChange);
                        }
                    } else if (nLSSubstitution.getInitialState() == 0) {
                        nLSSourceModifier.deleteAccessor(nLSSubstitution, (TextChange)compilationUnitChange, iCompilationUnit);
                    }
                }
            } else if (n2 == 0) {
                if (nLSSubstitution.isKeyRename()) {
                    nLSSourceModifier.replaceKey(nLSSubstitution, (TextChange)compilationUnitChange);
                }
                if (nLSSubstitution.isAccessorRename()) {
                    nLSSourceModifier.replaceAccessor(nLSSubstitution, (TextChange)compilationUnitChange);
                }
            } else if (nLSSubstitution.isValueRename()) {
                nLSSourceModifier.replaceValue(nLSSubstitution, (TextChange)compilationUnitChange);
            }
            ++n;
        }
        return compilationUnitChange;
    }

    private void replaceAccessor(NLSSubstitution nLSSubstitution, TextChange textChange) {
        AccessorClassReference accessorClassReference = nLSSubstitution.getAccessorClassReference();
        if (accessorClassReference != null) {
            Region region = accessorClassReference.getRegion();
            int n = accessorClassReference.getName().length();
            Object[] objectArray = new String[]{accessorClassReference.getName(), nLSSubstitution.getUpdatedAccessor()};
            TextChangeCompatibility.addTextEdit(textChange, Messages.format(NLSMessages.NLSSourceModifier_replace_accessor, objectArray), (TextEdit)new ReplaceEdit(region.getOffset(), n, nLSSubstitution.getUpdatedAccessor()));
        }
    }

    private void replaceKey(NLSSubstitution nLSSubstitution, TextChange textChange) {
        Region region = nLSSubstitution.getNLSElement().getPosition();
        Object[] objectArray = new String[]{nLSSubstitution.getInitialKey(), nLSSubstitution.getKey()};
        ReplaceEdit replaceEdit = this.fIsEclipseNLS ? new ReplaceEdit(region.getOffset(), region.getLength(), nLSSubstitution.getKey()) : new ReplaceEdit(region.getOffset(), region.getLength(), String.valueOf('\"') + this.unwindEscapeChars(nLSSubstitution.getKey()) + '\"');
        TextChangeCompatibility.addTextEdit(textChange, Messages.format(NLSMessages.NLSSourceModifier_replace_key, objectArray), (TextEdit)replaceEdit);
    }

    private void replaceValue(NLSSubstitution nLSSubstitution, TextChange textChange) {
        Region region = nLSSubstitution.getNLSElement().getPosition();
        Object[] objectArray = new String[]{nLSSubstitution.getInitialValue(), nLSSubstitution.getValueNonEmpty()};
        TextChangeCompatibility.addTextEdit(textChange, Messages.format(NLSMessages.NLSSourceModifier_replace_value, objectArray), (TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), String.valueOf('\"') + this.unwindEscapeChars(nLSSubstitution.getValueNonEmpty()) + '\"'));
    }

    private void deleteAccessor(NLSSubstitution nLSSubstitution, TextChange textChange, ICompilationUnit iCompilationUnit) throws CoreException {
        AccessorClassReference accessorClassReference = nLSSubstitution.getAccessorClassReference();
        if (accessorClassReference != null) {
            Region region = accessorClassReference.getRegion();
            Object[] objectArray = new String[]{nLSSubstitution.getValueNonEmpty(), nLSSubstitution.getKey()};
            String string = Messages.format(NLSMessages.NLSSourceModifier_remove_accessor, objectArray);
            String string2 = String.valueOf('\"') + this.unwindEscapeChars(nLSSubstitution.getValueNonEmpty()) + '\"';
            TextChangeCompatibility.addTextEdit(textChange, string, (TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), string2));
            if (this.fIsEclipseNLS && nLSSubstitution.getState() != 2) {
                Region region2 = nLSSubstitution.getNLSElement().getPosition();
                int n = this.getLineStart(iCompilationUnit.getBuffer(), region2.getOffset());
                int n2 = this.getLineEnd(iCompilationUnit.getBuffer(), region2.getOffset());
                String string3 = iCompilationUnit.getBuffer().getText(n, n2 - n);
                StringBuffer stringBuffer = new StringBuffer(string3);
                stringBuffer.replace(region.getOffset() - n, region.getOffset() + region.getLength() - n, string2);
                try {
                    NLSLine[] nLSLineArray = NLSScanner.scan(stringBuffer.toString());
                    NLSLine nLSLine = nLSLineArray[0];
                    NLSElement nLSElement = NLSSourceModifier.findElement(nLSLine, region2.getOffset() - n - accessorClassReference.getName().length() - 1);
                    if (nLSElement == null || nLSElement.hasTag()) {
                        return;
                    }
                    NLSElement[] nLSElementArray = nLSLine.getElements();
                    int n3 = Arrays.asList(nLSElementArray).indexOf(nLSElement);
                    String string4 = String.valueOf(' ') + NLSElement.createTagText(n3 + 1);
                    TextChangeCompatibility.addTextEdit(textChange, string, (TextEdit)new InsertEdit(n2, string4));
                }
                catch (InvalidInputException invalidInputException) {}
            }
        }
    }

    private int getLineEnd(IBuffer iBuffer, int n) {
        int n2 = n;
        int n3 = iBuffer.getLength();
        while (n2 < n3 && !this.isDelemiter(iBuffer.getChar(n2))) {
            ++n2;
        }
        return n2;
    }

    private int getLineStart(IBuffer iBuffer, int n) {
        int n2 = n;
        while (n2 >= 0 && !this.isDelemiter(iBuffer.getChar(n2))) {
            --n2;
        }
        return n2 + 1;
    }

    private boolean isDelemiter(char c) {
        String[] stringArray = TextUtilities.DELIMITERS;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() == 1 && c == stringArray[n].charAt(0)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean isPositionInElement(NLSElement nLSElement, int n) {
        Region region = nLSElement.getPosition();
        return region.getOffset() <= n && n <= region.getOffset() + region.getLength();
    }

    private static NLSElement findElement(NLSLine nLSLine, int n) {
        NLSElement[] nLSElementArray = nLSLine.getElements();
        int n2 = 0;
        while (n2 < nLSElementArray.length) {
            NLSElement nLSElement = nLSElementArray[n2];
            if (NLSSourceModifier.isPositionInElement(nLSElement, n)) {
                return nLSElement;
            }
            ++n2;
        }
        return null;
    }

    private String unwindEscapeChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            stringBuffer.append(this.getUnwoundString(c));
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String getUnwoundString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    private void deleteTag(NLSSubstitution nLSSubstitution, TextChange textChange) {
        Region region = nLSSubstitution.getNLSElement().getTagPosition();
        TextChangeCompatibility.addTextEdit(textChange, NLSMessages.NLSSourceModifier_remove_tag, (TextEdit)new DeleteEdit(region.getOffset(), region.getLength()));
    }

    private String createImportForAccessor(MultiTextEdit multiTextEdit, String string, IPackageFragment iPackageFragment, ICompilationUnit iCompilationUnit) throws CoreException {
        IType iType = iPackageFragment.getCompilationUnit(String.valueOf(string) + ".js").getType(string);
        String string2 = iType.getFullyQualifiedName();
        ImportRewrite importRewrite = StubUtility.createImportRewrite(iCompilationUnit, true);
        String string3 = importRewrite.addImport(string2);
        TextEdit textEdit = importRewrite.rewriteImports(null);
        multiTextEdit.addChild(textEdit);
        return string3;
    }

    private void addNLS(NLSSubstitution nLSSubstitution, TextChange textChange, String string) {
        if (nLSSubstitution.getState() == 2) {
            return;
        }
        NLSElement nLSElement = nLSSubstitution.getNLSElement();
        this.addAccessor(nLSSubstitution, textChange, string);
        if (!this.fIsEclipseNLS || nLSSubstitution.getState() == 1) {
            String string2 = nLSSubstitution.getState() == 0 ? nLSSubstitution.getKey() : nLSSubstitution.getValueNonEmpty();
            String string3 = Messages.format(NLSMessages.NLSSourceModifier_add_tag, string2);
            TextChangeCompatibility.addTextEdit(textChange, string3, this.createAddTagChange(nLSElement));
        }
    }

    private void addAccessor(NLSSubstitution nLSSubstitution, TextChange textChange, String string) {
        if (nLSSubstitution.getState() == 0) {
            NLSElement nLSElement = nLSSubstitution.getNLSElement();
            Region region = nLSElement.getPosition();
            Object[] objectArray = new String[]{nLSSubstitution.getValueNonEmpty(), nLSSubstitution.getKey()};
            String string2 = Messages.format(NLSMessages.NLSSourceModifier_externalize, objectArray);
            String string3 = this.createResourceGetter(nLSSubstitution.getKey(), string);
            ReplaceEdit replaceEdit = new ReplaceEdit(region.getOffset(), region.getLength(), string3);
            if (this.fIsEclipseNLS && nLSElement.getTagPosition() != null) {
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                multiTextEdit.addChild((TextEdit)replaceEdit);
                Region region2 = nLSElement.getTagPosition();
                multiTextEdit.addChild((TextEdit)new DeleteEdit(region2.getOffset(), region2.getLength()));
                replaceEdit = multiTextEdit;
            }
            TextChangeCompatibility.addTextEdit(textChange, string2, (TextEdit)replaceEdit);
        }
    }

    private TextEdit createAddTagChange(NLSElement nLSElement) {
        int n = nLSElement.getTagPosition().getOffset();
        String string = String.valueOf(' ') + nLSElement.getTagText();
        return new InsertEdit(n, string);
    }

    private String createResourceGetter(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append('.');
        if (this.fIsEclipseNLS) {
            stringBuffer.append(string);
        } else {
            int n = this.fSubstitutionPattern.indexOf("${key}");
            if (n != -1) {
                stringBuffer.append(this.fSubstitutionPattern.substring(0, n));
                stringBuffer.append('\"').append(string).append('\"');
                stringBuffer.append(this.fSubstitutionPattern.substring(n + "${key}".length()));
            }
        }
        return stringBuffer.toString();
    }
}

