/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.refactoring.IJavaElementMapper;
import org.eclipse.wst.jsdt.core.refactoring.RenameTypeArguments;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameResourceDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public final class RenameCompilationUnitProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating,
ISimilarDeclarationUpdating,
IResourceMapper,
IJavaElementMapper {
    private RenameTypeProcessor fRenameTypeProcessor = null;
    private boolean fWillRenameType = false;
    private ICompilationUnit fCu;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameCompilationUnitProcessor";

    public RenameCompilationUnitProcessor(ICompilationUnit iCompilationUnit) throws CoreException {
        this.fCu = iCompilationUnit;
        if (this.fCu != null) {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(this.fCu.getElementName());
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fCu);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameCompilationUnitRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fCu);
    }

    public Object[] getElements() {
        return new Object[]{this.fCu};
    }

    protected RenameModifications computeRenameModifications() {
        RenameModifications renameModifications = new RenameModifications();
        renameModifications.rename(this.fCu, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        if (this.fRenameTypeProcessor != null) {
            String string = RenameCompilationUnitProcessor.removeFileNameExtension(this.getNewElementName());
            RenameTypeArguments renameTypeArguments = new RenameTypeArguments(string, this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements());
            renameModifications.rename(this.fRenameTypeProcessor.getType(), renameTypeArguments, this.getUpdateSimilarDeclarations() ? new RenameTypeProcessor.ParticipantDescriptorFilter() : null);
        }
        return renameModifications;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        IFile iFile;
        if (!this.fWillRenameType && (iFile = ResourceUtil.getFile(this.fCu)) != null) {
            return new IFile[]{iFile};
        }
        return new IFile[0];
    }

    public int getSaveMode() {
        return 3;
    }

    public String getCurrentElementName() {
        return this.getSimpleCUName();
    }

    public String getCurrentElementQualifier() {
        IPackageFragment iPackageFragment = (IPackageFragment)this.fCu.getParent();
        return iPackageFragment.getElementName();
    }

    public RefactoringStatus checkNewElementName(String string) throws CoreException {
        Assert.isNotNull((Object)string, (String)"new name");
        String string2 = RenameCompilationUnitProcessor.removeFileNameExtension(string);
        RefactoringStatus refactoringStatus = Checks.checkCompilationUnitName(string);
        if (this.fWillRenameType) {
            refactoringStatus.merge(this.fRenameTypeProcessor.checkNewElementName(string2));
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fCu, string)) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.RenameCompilationUnitRefactoring_same_name);
        }
        return refactoringStatus;
    }

    public void setNewElementName(String string) {
        super.setNewElementName(string);
        if (this.fWillRenameType) {
            this.fRenameTypeProcessor.setNewElementName(RenameCompilationUnitProcessor.removeFileNameExtension(string));
        }
    }

    public Object getNewElement() {
        IJavaElement iJavaElement = this.fCu.getParent();
        if (iJavaElement.getElementType() != 4) {
            return this.fCu;
        }
        IPackageFragment iPackageFragment = (IPackageFragment)iJavaElement;
        if (JavaConventions.validateCompilationUnitName((String)this.getNewElementName()).getSeverity() == 4) {
            return this.fCu;
        }
        return iPackageFragment.getCompilationUnit(this.getNewElementName());
    }

    public boolean canEnableTextUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    public boolean getUpdateTextualMatches() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateTextualMatches();
    }

    public void setUpdateTextualMatches(boolean bl) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateTextualMatches(bl);
        }
    }

    public boolean canEnableUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    public void setUpdateReferences(boolean bl) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateReferences(bl);
        }
    }

    public boolean getUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateReferences();
    }

    public boolean canEnableQualifiedNameUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableQualifiedNameUpdating();
    }

    public boolean getUpdateQualifiedNames() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateQualifiedNames();
    }

    public void setUpdateQualifiedNames(boolean bl) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateQualifiedNames(bl);
    }

    public String getFilePatterns() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getFilePatterns();
    }

    public void setFilePatterns(String string) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setFilePatterns(string);
    }

    public boolean canEnableSimilarDeclarationUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableSimilarDeclarationUpdating();
    }

    public void setUpdateSimilarDeclarations(boolean bl) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateSimilarDeclarations(bl);
    }

    public boolean getUpdateSimilarDeclarations() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateSimilarDeclarations();
    }

    public int getMatchStrategy() {
        if (this.fRenameTypeProcessor == null) {
            return 1;
        }
        return this.fRenameTypeProcessor.getMatchStrategy();
    }

    public void setMatchStrategy(int n) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setMatchStrategy(n);
    }

    public IJavaElement[] getSimilarElements() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getSimilarElements();
    }

    public IResource getRefactoredResource(IResource iResource) {
        if (this.fRenameTypeProcessor == null) {
            return iResource;
        }
        return this.fRenameTypeProcessor.getRefactoredResource(iResource);
    }

    public IJavaElement getRefactoredJavaElement(IJavaElement iJavaElement) {
        if (this.fRenameTypeProcessor == null) {
            return iJavaElement;
        }
        return this.fRenameTypeProcessor.getRefactoredJavaElement(iJavaElement);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fRenameTypeProcessor != null && !this.fCu.isStructureKnown()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        if (this.fWillRenameType && this.fRenameTypeProcessor != null && !this.fRenameTypeProcessor.getType().exists()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        return new RefactoringStatus();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        block6: {
            RefactoringStatus refactoringStatus;
            try {
                if (this.fWillRenameType && !this.fCu.isStructureKnown()) {
                    RefactoringStatus refactoringStatus2 = new RefactoringStatus();
                    RefactoringStatus refactoringStatus3 = new RefactoringStatus();
                    refactoringStatus3.merge(Checks.checkCompilationUnitNewName(this.fCu, this.getNewElementName()));
                    if (refactoringStatus3.hasFatalError()) {
                        refactoringStatus2.addError(Messages.format(RefactoringCoreMessages.RenameCompilationUnitRefactoring_not_parsed_1, this.fCu.getElementName()));
                    } else {
                        refactoringStatus2.addError(Messages.format(RefactoringCoreMessages.RenameCompilationUnitRefactoring_not_parsed, this.fCu.getElementName()));
                    }
                    refactoringStatus2.merge(refactoringStatus3);
                }
                if (!this.fWillRenameType) break block6;
                refactoringStatus = this.fRenameTypeProcessor.checkFinalConditions(iProgressMonitor, checkConditionsContext);
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = Checks.checkCompilationUnitNewName(this.fCu, this.getNewElementName());
        Object var5_8 = null;
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private void computeRenameTypeRefactoring() throws CoreException {
        if (this.getSimpleCUName().indexOf(".") != -1) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return;
        }
        IType iType = this.getTypeWithTheSameName();
        this.fRenameTypeProcessor = iType != null ? new RenameTypeProcessor(iType) : null;
        this.fWillRenameType = this.fRenameTypeProcessor != null && this.fCu.isStructureKnown();
    }

    private IType getTypeWithTheSameName() {
        try {
            IType[] iTypeArray = this.fCu.getTypes();
            String string = this.getSimpleCUName();
            int n = 0;
            while (n < iTypeArray.length) {
                if (string.equals(iTypeArray[n].getElementName())) {
                    return iTypeArray[n];
                }
                ++n;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private String getSimpleCUName() {
        return RenameCompilationUnitProcessor.removeFileNameExtension(this.fCu.getElementName());
    }

    private static String removeFileNameExtension(String string) {
        if (string.lastIndexOf(".") == -1) {
            return string;
        }
        return string.substring(0, string.lastIndexOf("."));
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.createChange(iProgressMonitor);
        }
        this.fRenameTypeProcessor = null;
        String string = this.getNewElementName();
        IResource iResource = this.fCu.getResource();
        if (iResource != null && iResource.isLinked()) {
            IProject iProject = iResource.getProject();
            String string2 = iProject.getName();
            String string3 = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description_short, iResource.getName());
            String string4 = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description, new String[]{iResource.getFullPath().toString(), string});
            String string5 = new JDTRefactoringDescriptorComment(string2, this, string4).asString();
            RenameResourceDescriptor renameResourceDescriptor = new RenameResourceDescriptor();
            renameResourceDescriptor.setProject(string2);
            renameResourceDescriptor.setDescription(string3);
            renameResourceDescriptor.setComment(string5);
            renameResourceDescriptor.setFlags(2);
            renameResourceDescriptor.setResource(iResource);
            renameResourceDescriptor.setNewName(string);
            return new DynamicValidationStateChange(new RenameResourceChange((RefactoringDescriptor)renameResourceDescriptor, iResource, string, string5));
        }
        String string6 = null;
        IPackageFragment iPackageFragment = (IPackageFragment)this.fCu.getParent();
        string6 = !iPackageFragment.isDefaultPackage() ? String.valueOf(iPackageFragment.getElementName()) + "." + this.fCu.getElementName() : this.fCu.getElementName();
        String string7 = this.fCu.getJavaProject().getElementName();
        String string8 = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description_short, this.fCu.getElementName());
        String string9 = Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description, new String[]{string6, string});
        String string10 = new JDTRefactoringDescriptorComment(string7, this, string9).asString();
        RenameJavaElementDescriptor renameJavaElementDescriptor = new RenameJavaElementDescriptor("org.eclipse.wst.jsdt.ui.rename.compilationunit");
        renameJavaElementDescriptor.setProject(string7);
        renameJavaElementDescriptor.setDescription(string8);
        renameJavaElementDescriptor.setComment(string10);
        renameJavaElementDescriptor.setFlags(2);
        renameJavaElementDescriptor.setJavaElement((IJavaElement)this.fCu);
        renameJavaElementDescriptor.setNewName(string);
        return new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)renameJavaElementDescriptor, RefactoringCoreMessages.RenameCompilationUnitRefactoring_name, new Change[]{new RenameCompilationUnitChange(this.fCu, string)});
    }

    public Change postCreateChange(Change[] changeArray, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.postCreateChange(changeArray, iProgressMonitor);
        }
        return super.postCreateChange(changeArray, iProgressMonitor);
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        if (!(refactoringArguments instanceof JavaRefactoringArguments)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
        String string = javaRefactoringArguments.getAttribute("input");
        if (string == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
        if (iJavaElement == null || !iJavaElement.exists() || iJavaElement.getElementType() != 5) {
            return ScriptableRefactoring.createInputFatalStatus(iJavaElement, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.compilationunit");
        }
        String string2 = javaRefactoringArguments.getAttribute("name");
        if (string2 == null || string2.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.fCu = (ICompilationUnit)iJavaElement;
        try {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(string2);
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
            return ScriptableRefactoring.createInputFatalStatus(iJavaElement, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.compilationunit");
        }
        return new RefactoringStatus();
    }

    public RenameTypeProcessor getRenameTypeProcessor() {
        return this.fRenameTypeProcessor;
    }

    public boolean isWillRenameType() {
        return this.fWillRenameType;
    }
}

