/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.search.MethodDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class RenameNonVirtualMethodProcessor
extends RenameMethodProcessor {
    RenameNonVirtualMethodProcessor(IMethod iMethod, TextChangeManager textChangeManager, GroupCategorySet groupCategorySet) {
        super(iMethod, textChangeManager, groupCategorySet);
    }

    public RenameNonVirtualMethodProcessor(IMethod iMethod) {
        super(iMethod);
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameNonVirtualMethodAvailable(this.getMethod());
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus refactoringStatus2;
        block7: {
            iProgressMonitor.beginTask("", 3);
            refactoringStatus2 = new RefactoringStatus();
            refactoringStatus2.merge(super.doCheckFinalConditions((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), checkConditionsContext));
            if (!refactoringStatus2.hasFatalError()) break block7;
            RefactoringStatus refactoringStatus3 = refactoringStatus2;
            Object var12_6 = null;
            iProgressMonitor.done();
            return refactoringStatus3;
        }
        try {
            IMethod iMethod = this.getMethod();
            IType iType = iMethod.getDeclaringType();
            String string = this.getNewElementName();
            if (iType != null) {
                IMethod[] iMethodArray = RenameNonVirtualMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iType.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)), iMethod, string);
                int n = 0;
                while (n < iMethodArray.length) {
                    String string2;
                    IMethod iMethod2 = iMethodArray[n];
                    RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((IMember)iMethod2);
                    if (Checks.compareParamTypes(iMethod.getParameterTypes(), iMethod2.getParameterTypes())) {
                        string2 = Messages.format(RefactoringCoreMessages.RenamePrivateMethodRefactoring_hierarchy_defines, new String[]{JavaModelUtil.getFullyQualifiedName(iType), string});
                        refactoringStatus2.addError(string2, refactoringStatusContext);
                    } else {
                        string2 = Messages.format(RefactoringCoreMessages.RenamePrivateMethodRefactoring_hierarchy_defines2, new String[]{JavaModelUtil.getFullyQualifiedName(iType), string});
                        refactoringStatus2.addWarning(string2, refactoringStatusContext);
                    }
                    ++n;
                }
            }
            refactoringStatus = refactoringStatus2;
            Object var12_7 = null;
        }
        catch (Throwable throwable) {
            Object var12_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    protected SearchResultGroup[] getOccurrences(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        iProgressMonitor.beginTask("", 2);
        SearchPattern searchPattern = this.createReferenceSearchPattern();
        SearchResultGroup[] searchResultGroupArray = RefactoringSearchEngine.search(searchPattern, this.createRefactoringScope(), new MethodOccurenceCollector(this.getMethod().getElementName()), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            if (iCompilationUnit.equals(this.getDeclaringCU())) {
                IResource iResource = searchResultGroup.getResource();
                int n2 = this.getMethod().getNameRange().getOffset();
                int n3 = this.getMethod().getNameRange().getLength();
                MethodDeclarationMatch methodDeclarationMatch = new MethodDeclarationMatch((IJavaElement)this.getMethod(), 0, n2, n3, SearchEngine.getDefaultSearchParticipant(), iResource);
                searchResultGroup.add((SearchMatch)methodDeclarationMatch);
                break;
            }
            ++n;
        }
        return searchResultGroupArray;
    }

    void addOccurrences(TextChangeManager textChangeManager, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        iProgressMonitor.beginTask("", 1);
        this.addDeclarationUpdate(textChangeManager);
        if (this.getUpdateReferences()) {
            this.addReferenceUpdates(textChangeManager, iProgressMonitor, refactoringStatus);
        }
        iProgressMonitor.worked(1);
    }

    private ICompilationUnit getDeclaringCU() {
        return this.getMethod().getCompilationUnit();
    }

    SearchPattern createOccurrenceSearchPattern(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("", 1);
        SearchPattern searchPattern = SearchPattern.createPattern((IJavaElement)this.getMethod(), (int)3, (int)24);
        iProgressMonitor.done();
        return searchPattern;
    }

    private SearchPattern createReferenceSearchPattern() {
        return SearchPattern.createPattern((IJavaElement)this.getMethod(), (int)2, (int)24);
    }

    final void addDeclarationUpdate(TextChangeManager textChangeManager) throws CoreException {
        Object object;
        ISourceRange iSourceRange;
        Object object2;
        if (this.getDelegateUpdating()) {
            object2 = new CompilationUnitRewrite(this.getDeclaringCU());
            ((CompilationUnitRewrite)object2).setResolveBindings(true);
            iSourceRange = ASTNodeSearchUtil.getMethodDeclarationNode(this.getMethod(), ((CompilationUnitRewrite)object2).getRoot());
            object = new DelegateMethodCreator();
            ((DelegateCreator)object).setDeclaration((BodyDeclaration)iSourceRange);
            ((DelegateCreator)object).setDeclareDeprecated(this.getDeprecateDelegates());
            ((DelegateCreator)object).setSourceRewrite((CompilationUnitRewrite)object2);
            ((DelegateCreator)object).setCopy(true);
            ((DelegateCreator)object).setNewElementName(this.getNewElementName());
            ((DelegateCreator)object).prepareDelegate();
            ((DelegateCreator)object).createEdit();
            CompilationUnitChange compilationUnitChange = ((CompilationUnitRewrite)object2).createChange();
            if (compilationUnitChange != null) {
                compilationUnitChange.setKeepPreviewEdits(true);
                textChangeManager.manage(this.getDeclaringCU(), (TextChange)compilationUnitChange);
            }
        }
        object2 = RefactoringCoreMessages.RenameMethodRefactoring_update_declaration;
        iSourceRange = this.getMethod().getNameRange();
        object = new ReplaceEdit(iSourceRange.getOffset(), iSourceRange.getLength(), this.getNewElementName());
        this.addTextEdit(textChangeManager.get(this.getDeclaringCU()), (String)object2, (ReplaceEdit)object);
    }

    private void addReferenceUpdates(TextChangeManager textChangeManager, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        SearchResultGroup[] searchResultGroupArray = this.getReferences(iProgressMonitor, refactoringStatus);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            TextChange textChange = textChangeManager.get(iCompilationUnit);
            int n2 = 0;
            while (n2 < searchMatchArray.length) {
                String string = RefactoringCoreMessages.RenamePrivateMethodRefactoring_update;
                ReplaceEdit replaceEdit = this.createReplaceEdit(searchMatchArray[n2], iCompilationUnit);
                this.addTextEdit(textChange, string, replaceEdit);
                ++n2;
            }
            ++n;
        }
    }

    private SearchResultGroup[] getReferences(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        iProgressMonitor.beginTask("", 2);
        SearchPattern searchPattern = this.createReferenceSearchPattern();
        return RefactoringSearchEngine.search(searchPattern, this.createRefactoringScope(), new MethodOccurenceCollector(this.getMethod().getElementName()), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
    }

    public String getDelegateUpdatingTitle(boolean bl) {
        if (bl) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_singular;
    }
}

