/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class RenameVirtualMethodProcessor
extends RenameMethodProcessor {
    private IMethod fOriginalMethod = this.getMethod();
    private boolean fActivationChecked;
    private ITypeHierarchy fCachedHierarchy = null;

    public RenameVirtualMethodProcessor(IMethod iMethod) {
        super(iMethod);
    }

    RenameVirtualMethodProcessor(IMethod iMethod, IMethod[] iMethodArray, TextChangeManager textChangeManager, ITypeHierarchy iTypeHierarchy, GroupCategorySet groupCategorySet) {
        super(iMethod, textChangeManager, groupCategorySet);
        this.fActivationChecked = true;
        this.fCachedHierarchy = iTypeHierarchy;
        this.setMethodsToRename(iMethodArray);
    }

    public IMethod getOriginalMethod() {
        return this.fOriginalMethod;
    }

    private ITypeHierarchy getCachedHierarchy(IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        if (this.fCachedHierarchy != null && iType.equals(this.fCachedHierarchy.getType())) {
            return this.fCachedHierarchy;
        }
        this.fCachedHierarchy = iType.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        return this.fCachedHierarchy;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameVirtualMethodAvailable(this.getMethod());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = super.checkInitialConditions(iProgressMonitor);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        try {
            iProgressMonitor.beginTask("", 3);
            if (!this.fActivationChecked) {
                IMethod iMethod;
                IMethod iMethod2;
                this.fOriginalMethod = iMethod2 = this.getMethod();
                ITypeHierarchy iTypeHierarchy = null;
                IType iType = iMethod2.getDeclaringType();
                if (iType != null && !iType.isInterface()) {
                    iTypeHierarchy = this.getCachedHierarchy(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                if (MethodChecks.isVirtual(iMethod = this.getMethod())) {
                    iMethod = MethodChecks.getTopmostMethod(this.getMethod(), iTypeHierarchy, iProgressMonitor);
                }
                if (iMethod != null) {
                    this.initialize(iMethod);
                }
                this.fActivationChecked = true;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus refactoringStatus2;
        block11: {
            iProgressMonitor.beginTask("", 9);
            refactoringStatus2 = new RefactoringStatus();
            refactoringStatus2.merge(super.doCheckFinalConditions((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 7), checkConditionsContext));
            if (!refactoringStatus2.hasFatalError()) break block11;
            RefactoringStatus refactoringStatus3 = refactoringStatus2;
            Object var12_6 = null;
            iProgressMonitor.done();
            return refactoringStatus3;
        }
        try {
            IMethod iMethod = this.getMethod();
            IType iType = iMethod.getDeclaringType();
            ITypeHierarchy iTypeHierarchy = this.getCachedHierarchy(iType, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            String string = this.getNewElementName();
            if (iType.isInterface()) {
                if (this.isSpecialCase()) {
                    refactoringStatus2.addError(RefactoringCoreMessages.RenameMethodInInterfaceRefactoring_special_case);
                }
                iProgressMonitor.worked(1);
                IMethod[] iMethodArray = this.relatedTypeDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iMethod, string);
                int n = 0;
                while (n < iMethodArray.length) {
                    IMethod iMethod2 = iMethodArray[n];
                    RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((IMember)iMethod2);
                    refactoringStatus2.addError(RefactoringCoreMessages.RenameMethodInInterfaceRefactoring_already_defined, refactoringStatusContext);
                    ++n;
                }
            } else {
                if (this.classesDeclareOverridingNativeMethod(iTypeHierarchy.getAllSubtypes(iType))) {
                    refactoringStatus2.addError(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_requieres_renaming_native, new String[]{iMethod.getElementName(), "UnsatisfiedLinkError"}));
                }
                IMethod[] iMethodArray = RenameVirtualMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iTypeHierarchy, iMethod, string);
                int n = 0;
                while (n < iMethodArray.length) {
                    IMethod iMethod3 = iMethodArray[n];
                    RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((IMember)iMethod3);
                    if (Checks.compareParamTypes(iMethod.getParameterTypes(), iMethod3.getParameterTypes())) {
                        refactoringStatus2.addError(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_hierarchy_declares2, string), refactoringStatusContext);
                    } else {
                        refactoringStatus2.addWarning(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_hierarchy_declares1, string), refactoringStatusContext);
                    }
                    ++n;
                }
            }
            this.fCachedHierarchy = null;
            refactoringStatus = refactoringStatus2;
            Object var12_7 = null;
        }
        catch (Throwable throwable) {
            Object var12_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private IMethod[] relatedTypeDeclaresMethodName(IProgressMonitor iProgressMonitor, IMethod iMethod, String string) throws CoreException {
        IMethod[] iMethodArray;
        try {
            HashSet<IMethod> hashSet = new HashSet<IMethod>();
            Set set = this.getRelatedTypes();
            iProgressMonitor.beginTask("", set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                IMethod iMethod2 = Checks.findMethod(iMethod, (IType)iterator.next());
                IType iType = iMethod2.getDeclaringType();
                hashSet.addAll(Arrays.asList(RenameVirtualMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iType.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)), iMethod2, string)));
            }
            iMethodArray = hashSet.toArray(new IMethod[hashSet.size()]);
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return iMethodArray;
    }

    private boolean isSpecialCase() throws CoreException {
        String[] stringArray = new String[]{};
        String[] stringArray2 = new String[]{"toString", "toString", "toString", "toString", "equals", "equals", "getClass", "getClass", "hashCode", "notify", "notifyAll", "wait", "wait", "wait"};
        String[][] stringArrayArray = new String[][]{stringArray, stringArray, stringArray, stringArray, {"QObject;"}, {"Qjava.lang.Object;"}, stringArray, stringArray, stringArray, stringArray, stringArray, {"J", "I"}, {"J"}, stringArray};
        String[] stringArray3 = new String[]{"QString;", "QString;", "Qjava.lang.String;", "Qjava.lang.String;", "Z", "Z", "QClass;", "Qjava.lang.Class;", "I", "V", "V", "V", "V", "V"};
        Assert.isTrue((stringArray2.length == stringArrayArray.length && stringArrayArray.length == stringArray3.length ? 1 : 0) != 0);
        int n = 0;
        while (n < stringArray2.length) {
            if (stringArray2[n].equals(this.getNewElementName()) && Checks.compareParamTypes(this.getMethod().getParameterTypes(), stringArrayArray[n]) && !stringArray3[n].equals(this.getMethod().getReturnType())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Set getRelatedTypes() {
        Set set = this.getMethodsToRename();
        HashSet<IType> hashSet = new HashSet<IType>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.add(((IMethod)iterator.next()).getDeclaringType());
        }
        return hashSet;
    }

    private boolean classesDeclareOverridingNativeMethod(IType[] iTypeArray) throws CoreException {
        int n = 0;
        while (n < iTypeArray.length) {
            IMethod[] iMethodArray = iTypeArray[n].getMethods();
            int n2 = 0;
            while (n2 < iMethodArray.length) {
                if (!iMethodArray[n2].equals(this.getMethod()) && JdtFlags.isNative((IMember)iMethodArray[n2]) && Checks.findSimilarMethod(this.getMethod(), new IMethod[]{iMethodArray[n2]}) != null) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        RefactoringStatus refactoringStatus = super.initialize(refactoringArguments);
        this.fOriginalMethod = this.getMethod();
        return refactoringStatus;
    }

    public String getDelegateUpdatingTitle(boolean bl) {
        if (bl) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_singular;
    }
}

