/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.TypeReferenceMatch;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class MoveCuUpdateCreator {
    private final String fNewPackage;
    private ICompilationUnit[] fCus;
    private IPackageFragment fDestination;
    private Map fImportRewrites;

    public MoveCuUpdateCreator(ICompilationUnit iCompilationUnit, IPackageFragment iPackageFragment) {
        this(new ICompilationUnit[]{iCompilationUnit}, iPackageFragment);
    }

    public MoveCuUpdateCreator(ICompilationUnit[] iCompilationUnitArray, IPackageFragment iPackageFragment) {
        Assert.isNotNull((Object)iCompilationUnitArray);
        Assert.isNotNull((Object)iPackageFragment);
        this.fCus = iCompilationUnitArray;
        this.fDestination = iPackageFragment;
        this.fImportRewrites = new HashMap();
        this.fNewPackage = this.fDestination.isDefaultPackage() ? "" : String.valueOf(this.fDestination.getElementName()) + '.';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextChangeManager createChangeManager(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        TextChangeManager textChangeManager;
        iProgressMonitor.beginTask("", 5);
        try {
            try {
                TextChangeManager textChangeManager2 = new TextChangeManager();
                this.addUpdates(textChangeManager2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4), refactoringStatus);
                this.addImportRewriteUpdates(textChangeManager2);
                textChangeManager = textChangeManager2;
                Object var4_7 = null;
            }
            catch (JavaModelException javaModelException) {
                throw javaModelException;
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return textChangeManager;
    }

    private void addImportRewriteUpdates(TextChangeManager textChangeManager) throws CoreException {
        Iterator iterator = this.fImportRewrites.keySet().iterator();
        while (iterator.hasNext()) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iterator.next();
            ImportRewrite importRewrite = (ImportRewrite)this.fImportRewrites.get(iCompilationUnit);
            if (importRewrite == null || !importRewrite.hasRecordedChanges()) continue;
            TextChangeCompatibility.addTextEdit(textChangeManager.get(iCompilationUnit), RefactoringCoreMessages.MoveCuUpdateCreator_update_imports, importRewrite.rewriteImports(null));
        }
    }

    private void addUpdates(TextChangeManager textChangeManager, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        iProgressMonitor.beginTask("", this.fCus.length);
        int n = 0;
        while (n < this.fCus.length) {
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addUpdates(textChangeManager, this.fCus[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addUpdates(TextChangeManager textChangeManager, ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        block5: {
            block4: {
                try {
                    iProgressMonitor.beginTask("", 3);
                    iProgressMonitor.subTask(Messages.format(RefactoringCoreMessages.MoveCuUpdateCreator_searching, iCompilationUnit.getElementName()));
                    if (MoveCuUpdateCreator.isInAnotherFragmentOfSamePackage(iCompilationUnit, this.fDestination)) {
                        iProgressMonitor.worked(3);
                        Object var5_5 = null;
                        break block4;
                    }
                    this.addImportToSourcePackageTypes(iCompilationUnit, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    this.removeImportsToDestinationPackageTypes(iCompilationUnit);
                    this.addReferenceUpdates(textChangeManager, iCompilationUnit, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2), refactoringStatus);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return;
        }
        Object var5_7 = null;
        iProgressMonitor.done();
    }

    private void addReferenceUpdates(TextChangeManager textChangeManager, ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException, CoreException {
        List<ICompilationUnit> list = Arrays.asList(this.fCus);
        SearchResultGroup[] searchResultGroupArray = MoveCuUpdateCreator.getReferences(iCompilationUnit, iProgressMonitor, refactoringStatus);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            ICompilationUnit iCompilationUnit2 = searchResultGroup.getCompilationUnit();
            if (iCompilationUnit2 != null) {
                boolean bl = this.simpleReferencesNeedNewImport(iCompilationUnit, iCompilationUnit2, list);
                SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
                int n2 = 0;
                while (n2 < searchMatchArray.length) {
                    String string;
                    ImportRewrite importRewrite;
                    TypeReference typeReference = (TypeReference)searchMatchArray[n2];
                    if (typeReference.isImportDeclaration()) {
                        importRewrite = this.getImportRewrite(iCompilationUnit2);
                        string = (IImportDeclaration)SearchUtils.getEnclosingJavaElement(searchMatchArray[n2]);
                        if (Flags.isStatic((int)string.getFlags())) {
                            importRewrite.removeStaticImport(string.getElementName());
                            this.addStaticImport(iCompilationUnit, (IImportDeclaration)string, importRewrite);
                        } else {
                            importRewrite.removeImport(string.getElementName());
                            importRewrite.addImport(this.createStringForNewImport(iCompilationUnit, (IImportDeclaration)string));
                        }
                    } else if (typeReference.isQualified()) {
                        importRewrite = textChangeManager.get(iCompilationUnit2);
                        string = RefactoringCoreMessages.MoveCuUpdateCreator_update_references;
                        ReplaceEdit replaceEdit = new ReplaceEdit(typeReference.getOffset(), typeReference.getSimpleNameStart() - typeReference.getOffset(), this.fNewPackage);
                        TextChangeCompatibility.addTextEdit((TextChange)importRewrite, string, (TextEdit)replaceEdit);
                    } else if (bl) {
                        importRewrite = this.getImportRewrite(iCompilationUnit2);
                        string = typeReference.getSimpleName();
                        importRewrite.addImport(this.getQualifiedType(this.fDestination.getElementName(), string));
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void addStaticImport(ICompilationUnit iCompilationUnit, IImportDeclaration iImportDeclaration, ImportRewrite importRewrite) {
        String string = iImportDeclaration.getElementName();
        int n = iCompilationUnit.getParent().getElementName().length();
        StringBuffer stringBuffer = new StringBuffer(this.fDestination.getElementName());
        if (n == 0) {
            stringBuffer.append('.').append(string);
        } else if (stringBuffer.length() == 0) {
            stringBuffer.append(string.substring(n + 1));
        } else {
            stringBuffer.append(string.substring(n));
        }
        int n2 = stringBuffer.lastIndexOf(".");
        if (n2 > 0 && n2 < stringBuffer.length() - 1) {
            importRewrite.addStaticImport(stringBuffer.substring(0, n2), stringBuffer.substring(n2 + 1, stringBuffer.length()), true);
        }
    }

    private String getQualifiedType(String string, String string2) {
        if (string.length() == 0) {
            return string2;
        }
        return String.valueOf(string) + '.' + string2;
    }

    private String createStringForNewImport(ICompilationUnit iCompilationUnit, IImportDeclaration iImportDeclaration) {
        String string = iImportDeclaration.getElementName();
        int n = iCompilationUnit.getParent().getElementName().length();
        StringBuffer stringBuffer = new StringBuffer(this.fDestination.getElementName());
        if (n == 0) {
            stringBuffer.append('.').append(string);
        } else if (stringBuffer.length() == 0) {
            stringBuffer.append(string.substring(n + 1));
        } else {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private void removeImportsToDestinationPackageTypes(ICompilationUnit iCompilationUnit) throws CoreException {
        ImportRewrite importRewrite = this.getImportRewrite(iCompilationUnit);
        IType[] iTypeArray = this.getDestinationPackageTypes();
        int n = 0;
        while (n < iTypeArray.length) {
            importRewrite.removeImport(JavaModelUtil.getFullyQualifiedName(iTypeArray[n]));
            ++n;
        }
    }

    private IType[] getDestinationPackageTypes() throws JavaModelException {
        ArrayList<IType> arrayList = new ArrayList<IType>();
        if (this.fDestination.exists()) {
            ICompilationUnit[] iCompilationUnitArray = this.fDestination.getCompilationUnits();
            int n = 0;
            while (n < iCompilationUnitArray.length) {
                arrayList.addAll(Arrays.asList(iCompilationUnitArray[n].getAllTypes()));
                ++n;
            }
        }
        return arrayList.toArray(new IType[arrayList.size()]);
    }

    private void addImportToSourcePackageTypes(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor) throws CoreException {
        List<ICompilationUnit> list = Arrays.asList(this.fCus);
        IType[] iTypeArray = iCompilationUnit.getAllTypes();
        IType[] iTypeArray2 = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])iTypeArray, iProgressMonitor);
        ImportRewrite importRewrite = this.getImportRewrite(iCompilationUnit);
        importRewrite.setFilterImplicitImports(false);
        IPackageFragment iPackageFragment = (IPackageFragment)iCompilationUnit.getParent();
        int n = 0;
        while (n < iTypeArray2.length) {
            IType iType = iTypeArray2[n];
            if (iType.exists() && iType.getPackageFragment().equals(iPackageFragment) && !list.contains(iType.getCompilationUnit())) {
                importRewrite.addImport(JavaModelUtil.getFullyQualifiedName(iType));
            }
            ++n;
        }
    }

    private ImportRewrite getImportRewrite(ICompilationUnit iCompilationUnit) throws CoreException {
        if (this.fImportRewrites.containsKey(iCompilationUnit)) {
            return (ImportRewrite)this.fImportRewrites.get(iCompilationUnit);
        }
        ImportRewrite importRewrite = StubUtility.createImportRewrite(iCompilationUnit, true);
        this.fImportRewrites.put(iCompilationUnit, importRewrite);
        return importRewrite;
    }

    private boolean simpleReferencesNeedNewImport(ICompilationUnit iCompilationUnit, ICompilationUnit iCompilationUnit2, List list) {
        if (iCompilationUnit2.equals(iCompilationUnit)) {
            return false;
        }
        if (list.contains(iCompilationUnit2)) {
            return false;
        }
        if (this.isReferenceInAnotherFragmentOfSamePackage(iCompilationUnit2, iCompilationUnit)) {
            return true;
        }
        if (iCompilationUnit2.getImport(String.valueOf(iCompilationUnit.getParent().getElementName()) + ".*").exists()) {
            return true;
        }
        return iCompilationUnit2.getParent().equals(iCompilationUnit.getParent());
    }

    private boolean isReferenceInAnotherFragmentOfSamePackage(ICompilationUnit iCompilationUnit, ICompilationUnit iCompilationUnit2) {
        if (iCompilationUnit == null) {
            return false;
        }
        if (!(iCompilationUnit.getParent() instanceof IPackageFragment)) {
            return false;
        }
        IPackageFragment iPackageFragment = (IPackageFragment)iCompilationUnit.getParent();
        return MoveCuUpdateCreator.isInAnotherFragmentOfSamePackage(iCompilationUnit2, iPackageFragment);
    }

    private static boolean isInAnotherFragmentOfSamePackage(ICompilationUnit iCompilationUnit, IPackageFragment iPackageFragment) {
        if (!(iCompilationUnit.getParent() instanceof IPackageFragment)) {
            return false;
        }
        IPackageFragment iPackageFragment2 = (IPackageFragment)iCompilationUnit.getParent();
        return !iPackageFragment2.equals(iPackageFragment) && JavaModelUtil.isSamePackage(iPackageFragment2, iPackageFragment);
    }

    private static SearchResultGroup[] getReferences(ICompilationUnit iCompilationUnit, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        SearchPattern searchPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])iCompilationUnit.getTypes(), 2);
        if (searchPattern != null) {
            return RefactoringSearchEngine.search(searchPattern, RefactoringScopeFactory.create((IJavaElement)iCompilationUnit), new Collector((IPackageFragment)iCompilationUnit.getParent()), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
        }
        return new SearchResultGroup[0];
    }

    private static final class Collector
    extends CollectingSearchRequestor {
        private IPackageFragment fSource;
        private IScanner fScanner;

        public Collector(IPackageFragment iPackageFragment) {
            this.fSource = iPackageFragment;
            this.fScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        }

        public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
            IJavaElement iJavaElement = SearchUtils.getEnclosingJavaElement(searchMatch);
            int n = searchMatch.getAccuracy();
            int n2 = searchMatch.getOffset();
            int n3 = searchMatch.getLength();
            boolean bl = searchMatch.isInsideDocComment();
            IResource iResource = searchMatch.getResource();
            if (iJavaElement.getAncestor(13) != null) {
                super.acceptSearchMatch((SearchMatch)TypeReference.createImportReference(iJavaElement, n, n2, n3, bl, iResource));
            } else {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getAncestor(5);
                if (iCompilationUnit != null) {
                    IBuffer iBuffer = iCompilationUnit.getBuffer();
                    String string = iBuffer.getText(n2, n3);
                    if (this.fSource.isDefaultPackage()) {
                        super.acceptSearchMatch((SearchMatch)TypeReference.createSimpleReference(iJavaElement, n, n2, n3, bl, iResource, string));
                    } else {
                        int n4 = this.getLastSimpleNameStart(string);
                        if (n4 != 0) {
                            super.acceptSearchMatch((SearchMatch)TypeReference.createQualifiedReference(iJavaElement, n, n2, n3, bl, iResource, n2 + n4));
                        } else {
                            super.acceptSearchMatch((SearchMatch)TypeReference.createSimpleReference(iJavaElement, n, n2, n3, bl, iResource, string));
                        }
                    }
                }
            }
        }

        private int getLastSimpleNameStart(String string) {
            this.fScanner.setSource(string.toCharArray());
            int n = -1;
            try {
                int n2 = this.fScanner.getNextToken();
                while (n2 != 158) {
                    if (n2 == 5) {
                        n = this.fScanner.getCurrentTokenStartPosition();
                    }
                    n2 = this.fScanner.getNextToken();
                }
            }
            catch (InvalidInputException invalidInputException) {
                JavaPlugin.log(invalidInputException);
            }
            return n;
        }
    }

    private static final class TypeReference
    extends TypeReferenceMatch {
        private String fSimpleTypeName;
        private int fSimpleNameStart;

        private TypeReference(IJavaElement iJavaElement, int n, int n2, int n3, boolean bl, IResource iResource, int n4, String string) {
            super(iJavaElement, n, n2, n3, bl, SearchEngine.getDefaultSearchParticipant(), iResource);
            this.fSimpleNameStart = n4;
            this.fSimpleTypeName = string;
        }

        public static TypeReference createQualifiedReference(IJavaElement iJavaElement, int n, int n2, int n3, boolean bl, IResource iResource, int n4) {
            Assert.isTrue((n2 < n4 && n4 < n2 + n3 ? 1 : 0) != 0);
            return new TypeReference(iJavaElement, n, n2, n3, bl, iResource, n4, null);
        }

        public static TypeReference createImportReference(IJavaElement iJavaElement, int n, int n2, int n3, boolean bl, IResource iResource) {
            return new TypeReference(iJavaElement, n, n2, n3, bl, iResource, -1, null);
        }

        public static TypeReference createSimpleReference(IJavaElement iJavaElement, int n, int n2, int n3, boolean bl, IResource iResource, String string) {
            return new TypeReference(iJavaElement, n, n2, n3, bl, iResource, -1, string);
        }

        public boolean isImportDeclaration() {
            return SearchUtils.getEnclosingJavaElement((SearchMatch)this).getAncestor(13) != null;
        }

        public boolean isQualified() {
            return this.fSimpleNameStart != -1;
        }

        public boolean isSimpleReference() {
            return this.fSimpleTypeName != null;
        }

        public int getSimpleNameStart() {
            return this.fSimpleNameStart;
        }

        public String getSimpleName() {
            return this.fSimpleTypeName;
        }
    }
}

