/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTFlattener;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;

class MoveStaticMemberAnalyzer
extends ASTVisitor {
    protected RefactoringStatus fStatus = new RefactoringStatus();
    protected ITypeBinding fSource;
    protected ITypeBinding fTarget;
    protected CompilationUnitRewrite fCuRewrite;
    protected IBinding[] fMembers;
    protected boolean fNeedsImport;
    protected Set fProcessed;
    protected static final String REFERENCE_UPDATE = RefactoringCoreMessages.MoveMembersRefactoring_referenceUpdate;

    public MoveStaticMemberAnalyzer(CompilationUnitRewrite compilationUnitRewrite, IBinding[] iBindingArray, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        super(true);
        this.fCuRewrite = compilationUnitRewrite;
        this.fMembers = iBindingArray;
        this.fSource = iTypeBinding;
        this.fTarget = iTypeBinding2;
        this.fProcessed = new HashSet();
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    protected boolean isProcessed(ASTNode aSTNode) {
        return this.fProcessed.contains(aSTNode);
    }

    protected void rewrite(SimpleName simpleName, ITypeBinding iTypeBinding) {
        AST aST = simpleName.getAST();
        Type type = this.fCuRewrite.getImportRewrite().addImport(iTypeBinding, this.fCuRewrite.getAST());
        this.fCuRewrite.getImportRemover().registerAddedImport(iTypeBinding.getQualifiedName());
        Name name = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)type));
        QualifiedName qualifiedName = aST.newQualifiedName(name, aST.newSimpleName(simpleName.getIdentifier()));
        this.fCuRewrite.getASTRewrite().replace((ASTNode)simpleName, (ASTNode)qualifiedName, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
        this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)simpleName);
        this.fProcessed.add(simpleName);
        this.fNeedsImport = true;
    }

    protected void rewrite(QualifiedName qualifiedName, ITypeBinding iTypeBinding) {
        this.rewriteName(qualifiedName.getQualifier(), iTypeBinding);
        this.fProcessed.add(qualifiedName.getName());
    }

    protected void rewrite(FieldAccess fieldAccess, ITypeBinding iTypeBinding) {
        Expression expression = fieldAccess.getExpression();
        if (expression == null) {
            Type type = this.fCuRewrite.getImportRewrite().addImport(iTypeBinding, this.fCuRewrite.getAST());
            this.fCuRewrite.getImportRemover().registerAddedImport(iTypeBinding.getQualifiedName());
            expression = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)type));
            this.fCuRewrite.getASTRewrite().set((ASTNode)fieldAccess, (StructuralPropertyDescriptor)FieldAccess.EXPRESSION_PROPERTY, (Object)expression, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fNeedsImport = true;
        } else if (expression instanceof Name) {
            this.rewriteName((Name)expression, iTypeBinding);
        } else {
            this.rewriteExpression((ASTNode)fieldAccess, expression, iTypeBinding);
        }
        this.fProcessed.add(fieldAccess.getName());
    }

    protected void rewrite(MethodInvocation methodInvocation, ITypeBinding iTypeBinding) {
        Expression expression = methodInvocation.getExpression();
        if (expression == null) {
            Type type = this.fCuRewrite.getImportRewrite().addImport(iTypeBinding, this.fCuRewrite.getAST());
            this.fCuRewrite.getImportRemover().registerAddedImport(iTypeBinding.getQualifiedName());
            expression = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)type));
            this.fCuRewrite.getASTRewrite().set((ASTNode)methodInvocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)expression, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fNeedsImport = true;
        } else if (expression instanceof Name) {
            this.rewriteName((Name)expression, iTypeBinding);
        } else {
            this.rewriteExpression((ASTNode)methodInvocation, expression, iTypeBinding);
        }
        this.fProcessed.add(methodInvocation.getName());
    }

    protected void rewrite(MemberRef memberRef, ITypeBinding iTypeBinding) {
        Name name = memberRef.getQualifier();
        if (name == null) {
            Type type = this.fCuRewrite.getImportRewrite().addImport(iTypeBinding, this.fCuRewrite.getAST());
            this.fCuRewrite.getImportRemover().registerAddedImport(iTypeBinding.getQualifiedName());
            name = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)type));
            this.fCuRewrite.getASTRewrite().set((ASTNode)memberRef, (StructuralPropertyDescriptor)MemberRef.QUALIFIER_PROPERTY, (Object)name, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fNeedsImport = true;
        } else {
            this.rewriteName(name, iTypeBinding);
        }
        this.fProcessed.add(memberRef.getName());
    }

    protected void rewrite(MethodRef methodRef, ITypeBinding iTypeBinding) {
        Name name = methodRef.getQualifier();
        if (name == null) {
            Type type = this.fCuRewrite.getImportRewrite().addImport(iTypeBinding, this.fCuRewrite.getAST());
            this.fCuRewrite.getImportRemover().registerAddedImport(iTypeBinding.getQualifiedName());
            name = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)type));
            this.fCuRewrite.getASTRewrite().set((ASTNode)methodRef, (StructuralPropertyDescriptor)MethodRef.QUALIFIER_PROPERTY, (Object)name, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fNeedsImport = true;
        } else {
            this.rewriteName(name, iTypeBinding);
        }
        this.fProcessed.add(methodRef.getName());
    }

    private void rewriteName(Name name, ITypeBinding iTypeBinding) {
        SimpleName simpleName;
        AST aST = name.getAST();
        boolean bl = false;
        if (name instanceof QualifiedName && (simpleName = ASTNodes.getLeftMostSimpleName(name)).resolveBinding() instanceof IPackageBinding) {
            bl = true;
        }
        if (bl) {
            this.fCuRewrite.getASTRewrite().replace((ASTNode)name, (ASTNode)ASTNodeFactory.newName(aST, iTypeBinding.getQualifiedName()), this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
        } else {
            simpleName = this.fCuRewrite.getImportRewrite().addImport(iTypeBinding, this.fCuRewrite.getAST());
            this.fCuRewrite.getImportRemover().registerAddedImport(iTypeBinding.getQualifiedName());
            Name name2 = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)simpleName));
            this.fCuRewrite.getASTRewrite().replace((ASTNode)name, (ASTNode)name2, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
            this.fNeedsImport = true;
        }
    }

    private void rewriteExpression(ASTNode aSTNode, Expression expression, ITypeBinding iTypeBinding) {
        this.fCuRewrite.getASTRewrite().replace((ASTNode)expression, (ASTNode)this.fCuRewrite.getImportRewrite().addImport(iTypeBinding, this.fCuRewrite.getAST()), this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
        this.fCuRewrite.getImportRemover().registerAddedImport(iTypeBinding.getQualifiedName());
        this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
        this.fNeedsImport = true;
        this.nonStaticAccess(aSTNode);
    }

    protected void nonStaticAccess(ASTNode aSTNode) {
        this.fStatus.addWarning(RefactoringCoreMessages.MoveStaticMemberAnalyzer_nonStatic, JavaStatusContext.create((ITypeRoot)this.fCuRewrite.getCu(), aSTNode));
    }

    protected boolean isStaticAccess(Expression expression, ITypeBinding iTypeBinding) {
        if (!(expression instanceof Name)) {
            return false;
        }
        return Bindings.equals((IBinding)iTypeBinding, ((Name)expression).resolveBinding());
    }

    protected boolean isMovedMember(IBinding iBinding) {
        if (iBinding == null) {
            return false;
        }
        int n = 0;
        while (n < this.fMembers.length) {
            if (Bindings.equals(this.fMembers[n], iBinding)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

