/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveStaticMemberAnalyzer;

class MovedMemberAnalyzer
extends MoveStaticMemberAnalyzer {
    public MovedMemberAnalyzer(CompilationUnitRewrite compilationUnitRewrite, IBinding[] iBindingArray, ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2) {
        super(compilationUnitRewrite, iBindingArray, iTypeBinding, iTypeBinding2);
    }

    public boolean targetNeedsSourceImport() {
        return this.fNeedsImport;
    }

    public boolean visit(SimpleName simpleName) {
        if (simpleName.isDeclaration() || this.isProcessed((ASTNode)simpleName)) {
            return super.visit(simpleName);
        }
        IBinding iBinding = simpleName.resolveBinding();
        if (this.isMovedMember(iBinding)) {
            return super.visit(simpleName);
        }
        if (this.isSourceAccess(iBinding)) {
            this.rewrite(simpleName, this.fSource);
        }
        return super.visit(simpleName);
    }

    public boolean visit(QualifiedName qualifiedName) {
        IBinding iBinding = qualifiedName.resolveBinding();
        if (this.isSourceAccess(iBinding)) {
            if (this.isMovedMember(iBinding)) {
                this.rewrite(qualifiedName, this.fTarget);
                return false;
            }
            this.rewrite(qualifiedName, this.fSource);
            return false;
        }
        if (this.isTargetAccess(iBinding)) {
            SimpleName simpleName = (SimpleName)this.fCuRewrite.getASTRewrite().createCopyTarget((ASTNode)qualifiedName.getName());
            this.fCuRewrite.getASTRewrite().replace((ASTNode)qualifiedName, (ASTNode)simpleName, null);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)qualifiedName);
            return false;
        }
        return super.visit(qualifiedName);
    }

    public boolean visit(FieldAccess fieldAccess) {
        IVariableBinding iVariableBinding = fieldAccess.resolveFieldBinding();
        if (this.isSourceAccess((IBinding)iVariableBinding)) {
            if (this.isMovedMember((IBinding)iVariableBinding)) {
                if (fieldAccess.getExpression() != null) {
                    this.rewrite(fieldAccess, this.fTarget);
                }
            } else {
                this.rewrite(fieldAccess, this.fSource);
            }
        } else if (this.isTargetAccess((IBinding)iVariableBinding)) {
            this.fCuRewrite.getASTRewrite().remove((ASTNode)fieldAccess.getExpression(), null);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)fieldAccess.getExpression());
        }
        return super.visit(fieldAccess);
    }

    public boolean visit(MethodInvocation methodInvocation) {
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        if (this.isSourceAccess((IBinding)iMethodBinding)) {
            if (this.isMovedMember((IBinding)iMethodBinding)) {
                if (methodInvocation.getExpression() != null) {
                    this.rewrite(methodInvocation, this.fTarget);
                }
            } else {
                this.rewrite(methodInvocation, this.fSource);
            }
        } else if (this.isTargetAccess((IBinding)iMethodBinding) && methodInvocation.getExpression() != null) {
            this.fCuRewrite.getASTRewrite().remove((ASTNode)methodInvocation.getExpression(), null);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)methodInvocation.getExpression());
        }
        return super.visit(methodInvocation);
    }

    public boolean visit(MemberRef memberRef) {
        IBinding iBinding = memberRef.resolveBinding();
        if (this.isSourceAccess(iBinding)) {
            if (this.isMovedMember(iBinding)) {
                if (memberRef.getQualifier() != null) {
                    this.rewrite(memberRef, this.fTarget);
                }
            } else {
                this.rewrite(memberRef, this.fSource);
            }
        } else if (this.isTargetAccess(iBinding)) {
            SimpleName simpleName = (SimpleName)this.fCuRewrite.getASTRewrite().createCopyTarget((ASTNode)memberRef.getName());
            this.fCuRewrite.getASTRewrite().replace((ASTNode)memberRef, (ASTNode)simpleName, null);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)memberRef);
        }
        return super.visit(memberRef);
    }

    public boolean visit(MethodRef methodRef) {
        IBinding iBinding = methodRef.resolveBinding();
        if (this.isSourceAccess(iBinding)) {
            if (this.isMovedMember(iBinding)) {
                if (methodRef.getQualifier() != null) {
                    this.rewrite(methodRef, this.fTarget);
                }
            } else {
                this.rewrite(methodRef, this.fSource);
            }
        } else if (this.isTargetAccess(iBinding)) {
            SimpleName simpleName = (SimpleName)this.fCuRewrite.getASTRewrite().createCopyTarget((ASTNode)methodRef.getName());
            this.fCuRewrite.getASTRewrite().replace((ASTNode)methodRef, (ASTNode)simpleName, null);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)methodRef);
        }
        return super.visit(methodRef);
    }

    private boolean isSourceAccess(IBinding iBinding) {
        if (iBinding instanceof IMethodBinding) {
            IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
            return Modifier.isStatic((int)iMethodBinding.getModifiers()) && Bindings.equals((IBinding)this.fSource, (IBinding)iMethodBinding.getDeclaringClass());
        }
        if (iBinding instanceof ITypeBinding) {
            ITypeBinding iTypeBinding = (ITypeBinding)iBinding;
            return Modifier.isStatic((int)iTypeBinding.getModifiers()) && Bindings.equals((IBinding)this.fSource, (IBinding)iTypeBinding.getDeclaringClass());
        }
        if (iBinding instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            return iVariableBinding.isField() && Modifier.isStatic((int)iVariableBinding.getModifiers()) && Bindings.equals((IBinding)this.fSource, (IBinding)iVariableBinding.getDeclaringClass());
        }
        return false;
    }

    private boolean isTargetAccess(IBinding iBinding) {
        if (iBinding instanceof IMethodBinding) {
            IMethodBinding iMethodBinding = (IMethodBinding)iBinding;
            return Modifier.isStatic((int)iMethodBinding.getModifiers()) && Bindings.equals((IBinding)this.fTarget, (IBinding)iMethodBinding.getDeclaringClass());
        }
        if (iBinding instanceof ITypeBinding) {
            ITypeBinding iTypeBinding = (ITypeBinding)iBinding;
            return Modifier.isStatic((int)iTypeBinding.getModifiers()) && Bindings.equals((IBinding)this.fTarget, (IBinding)iTypeBinding.getDeclaringClass());
        }
        if (iBinding instanceof IVariableBinding) {
            IVariableBinding iVariableBinding = (IVariableBinding)iBinding;
            return iVariableBinding.isField() && Modifier.isStatic((int)iVariableBinding.getModifiers()) && Bindings.equals((IBinding)this.fTarget, (IBinding)iVariableBinding.getDeclaringClass());
        }
        return false;
    }
}

