/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeSet;

public abstract class SuperTypeSet
implements ITypeSet {
    private static final ITypeSet fgEmpty = new SuperTypeEmptySet();
    private static final ITypeSet fgUniverse = new SuperTypeUniverse();

    public static ITypeSet createTypeSet(TType tType) {
        if (tType == null) {
            return fgUniverse;
        }
        return new SuperTypeSingletonSet(tType);
    }

    public static ITypeSet createTypeSet(TType tType, TType tType2) {
        if (tType == null || tType2 == null) {
            return fgUniverse;
        }
        return new SuperTypeTuple(tType, tType2);
    }

    public static ITypeSet getEmpty() {
        return fgEmpty;
    }

    public static ITypeSet getUniverse() {
        return fgUniverse;
    }

    private static class SuperTypeEmptySet
    extends SuperTypeSet {
        private SuperTypeEmptySet() {
        }

        public final TType chooseSingleType() {
            return null;
        }

        public final boolean isEmpty() {
            return true;
        }

        public final ITypeSet restrictedTo(ITypeSet iTypeSet) {
            return this;
        }

        public final String toString() {
            return "EMPTY";
        }
    }

    private static class SuperTypeSingletonSet
    extends SuperTypeSet {
        private final TType fType;

        private SuperTypeSingletonSet(TType tType) {
            this.fType = tType;
        }

        public final TType chooseSingleType() {
            return this.fType;
        }

        public final boolean isEmpty() {
            return false;
        }

        public final ITypeSet restrictedTo(ITypeSet iTypeSet) {
            TType tType = this.fType.getErasure();
            if (iTypeSet instanceof SuperTypeUniverse) {
                return this;
            }
            if (iTypeSet instanceof SuperTypeSingletonSet) {
                if (this == iTypeSet) {
                    return this;
                }
                if (this.fType.isNullType()) {
                    return this;
                }
                SuperTypeSingletonSet superTypeSingletonSet = (SuperTypeSingletonSet)iTypeSet;
                TType tType2 = superTypeSingletonSet.fType.getErasure();
                if ((tType.isGenericType() || tType2.isGenericType()) && (tType2.equals(tType) || ((HierarchyType)tType).isSubType((HierarchyType)tType2))) {
                    return this;
                }
                if (tType2.isJavaLangObject()) {
                    return this;
                }
                if (tType.canAssignTo(tType2)) {
                    return this;
                }
                return SuperTypeSet.getEmpty();
            }
            if (iTypeSet instanceof SuperTypeTuple) {
                if (this.fType.isNullType()) {
                    return this;
                }
                SuperTypeTuple superTypeTuple = (SuperTypeTuple)iTypeSet;
                TType tType3 = superTypeTuple.fSuperType.getErasure();
                if ((tType.isGenericType() || tType3.isGenericType()) && (tType3.equals(tType) || ((HierarchyType)tType).isSubType((HierarchyType)tType3))) {
                    return this;
                }
                if (tType3.isJavaLangObject()) {
                    return this;
                }
                if (tType.canAssignTo(tType3)) {
                    return this;
                }
                return SuperTypeSet.createTypeSet(superTypeTuple.fSubType);
            }
            if (iTypeSet instanceof SuperTypeEmptySet) {
                return iTypeSet;
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public final String toString() {
            return this.fType.getPrettySignature();
        }
    }

    private static class SuperTypeTuple
    extends SuperTypeSet {
        private final TType fSubType;
        private final TType fSuperType;

        private SuperTypeTuple(TType tType, TType tType2) {
            this.fSubType = tType;
            this.fSuperType = tType2;
        }

        public final TType chooseSingleType() {
            return this.fSuperType;
        }

        public final boolean isEmpty() {
            return false;
        }

        public final ITypeSet restrictedTo(ITypeSet iTypeSet) {
            if (iTypeSet instanceof SuperTypeUniverse) {
                return this;
            }
            if (iTypeSet instanceof SuperTypeSingletonSet) {
                SuperTypeSingletonSet superTypeSingletonSet = (SuperTypeSingletonSet)iTypeSet;
                TType tType = superTypeSingletonSet.fType.getErasure();
                TType tType2 = this.fSubType.getErasure();
                TType tType3 = this.fSuperType.getErasure();
                if ((tType2.isGenericType() || tType3.isGenericType() || tType.isGenericType()) && (tType.equals(tType2) || ((HierarchyType)tType2).isSubType((HierarchyType)tType)) && (tType.equals(tType3) || ((HierarchyType)tType3).isSubType((HierarchyType)tType))) {
                    return this;
                }
                if (tType.isJavaLangObject()) {
                    return this;
                }
                if (tType2.canAssignTo(tType) && tType3.canAssignTo(tType)) {
                    return this;
                }
                return SuperTypeSet.createTypeSet(this.fSubType);
            }
            if (iTypeSet instanceof SuperTypeTuple) {
                return this;
            }
            if (iTypeSet instanceof SuperTypeEmptySet) {
                return iTypeSet;
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public final String toString() {
            return "[" + this.fSubType.getPrettySignature() + ", " + this.fSuperType.getPrettySignature() + "]";
        }
    }

    private static class SuperTypeUniverse
    extends SuperTypeSet {
        private SuperTypeUniverse() {
        }

        public final TType chooseSingleType() {
            return null;
        }

        public final boolean isEmpty() {
            return false;
        }

        public final ITypeSet restrictedTo(ITypeSet iTypeSet) {
            return iTypeSet;
        }

        public final String toString() {
            return "UNIVERSE";
        }
    }
}

