/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;

public final class CompilationUnitRange {
    private final ICompilationUnit fCompilationUnit;
    private final ISourceRange fSourceRange;

    public CompilationUnitRange(ICompilationUnit iCompilationUnit, ISourceRange iSourceRange) {
        Assert.isNotNull((Object)iCompilationUnit);
        Assert.isNotNull((Object)iSourceRange);
        this.fCompilationUnit = iCompilationUnit;
        this.fSourceRange = iSourceRange;
    }

    public CompilationUnitRange(ICompilationUnit iCompilationUnit, ASTNode aSTNode) {
        this(iCompilationUnit, new SourceRange(aSTNode));
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public ISourceRange getSourceRange() {
        return this.fSourceRange;
    }

    public ASTNode getNode(CompilationUnit compilationUnit) {
        NodeFinder nodeFinder = new NodeFinder(this.fSourceRange.getOffset(), this.fSourceRange.getLength());
        compilationUnit.accept((ASTVisitor)nodeFinder);
        ASTNode aSTNode = nodeFinder.getCoveringNode();
        if (aSTNode != null) {
            return aSTNode;
        }
        return nodeFinder.getCoveredNode();
    }

    public String toString() {
        return "(" + this.fSourceRange.toString() + " in " + this.fCompilationUnit.getElementName() + ")";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompilationUnitRange)) {
            return false;
        }
        CompilationUnitRange compilationUnitRange = (CompilationUnitRange)object;
        return this.fCompilationUnit.equals(compilationUnitRange.fCompilationUnit) && this.fSourceRange.equals(compilationUnitRange.fSourceRange);
    }

    public int hashCode() {
        return 37 * this.fCompilationUnit.hashCode() ^ this.fSourceRange.hashCode();
    }
}

